// Generated by delombok at Thu Apr 10 13:10:53 UTC 2025
package io.weaviate.client.v1.data.model;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import io.weaviate.client.v1.graphql.query.util.Serializer;

public class WeaviateObject {
  private String id;
  @SerializedName("class")
  private String className;
  private Long creationTimeUnix;
  private Long lastUpdateTimeUnix;
  private Map<String, Object> properties;
  private Map<String, Object> additional;
  /**
   * Unnamed (default) vector.
   * <p>
   * This field will be deprecated in later versions.
   * Prefer using {@link #vectors} for collections storing a single vector only.
   */
  private Float[] vector;
  /**
   * Named vectors.
   */
  private Map<String, Float[]> vectors;
  /**
   * Named multivectors.
   */
  private transient Map<String, Float[][]> multiVectors;
  private Object vectorWeights;
  private String tenant;


  public static class Adapter implements JsonSerializer<WeaviateObject>, JsonDeserializer<WeaviateObject> {
    public static final Adapter INSTANCE = new Adapter();
    /**
     * This Gson instance does not have the {@link Adapter} registerred allowing us
     * to deserialize remaining {@link WeaviateObject} fields in a standard manner
     * without causing an infinite recursion.
     *
     * Mimicking {@link Serializer}, we disable HTML escaping to produce identical
     * results. Thankfully, its configuration is not too involved, so we can
     * tolerate this duplication. In the future, {@link Adapter} should be rewritten
     * to implement {@link TypeAdapterFactory}, so that the singleton instance can
     * be re-used in this context too.
     */
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();

    @Override
    public JsonElement serialize(WeaviateObject src, Type typeOfSrc, JsonSerializationContext ctx) {
      JsonObject result = gson.toJsonTree(src).getAsJsonObject();
      // Add multi-vectors to the named vectors map.
      if (src.multiVectors != null) {
        if (!result.has("vectors")) {
          result.add("vectors", new JsonObject());
        }
        JsonObject vectors = result.getAsJsonObject("vectors");
        for (Entry<String, Float[][]> entry : src.multiVectors.entrySet()) {
          String name = entry.getKey();
          JsonElement vector = gson.toJsonTree(entry.getValue());
          vectors.add(name, vector);
        }
      }
      return result;
    }

    @Override
    public WeaviateObject deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
      JsonObject jsonObject = json.getAsJsonObject();
      // Handle polymorphic "vectors" separately from the rest of the fields.
      Map<String, JsonElement> vectorsMap = new HashMap<>();
      if (jsonObject.has("vectors")) {
        vectorsMap = jsonObject.remove("vectors").getAsJsonObject().asMap();
      }
      WeaviateObject result = gson.fromJson(jsonObject, WeaviateObject.class);
      if (result.vectors == null) {
        result.vectors = new HashMap<>();
      }
      if (result.multiVectors == null) {
        result.multiVectors = new HashMap<>();
      }
      for (Entry<String, JsonElement> entry : vectorsMap.entrySet()) {
        String name = entry.getKey();
        JsonElement el = entry.getValue();
        if (el.isJsonArray()) {
          JsonArray array = el.getAsJsonArray();
          if (array.size() > 0 && array.get(0).isJsonArray()) {
            result.multiVectors.put(name, ctx.deserialize(array, Float[][].class));
          } else {
            result.vectors.put(name, ctx.deserialize(array, Float[].class));
          }
        }
      }
      return result;
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static Map<String, Float[]> $default$vectors() {
    return new HashMap<>();
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static Map<String, Float[][]> $default$multiVectors() {
    return new HashMap<>();
  }

  /**
   * Creates a new {@code WeaviateObject} instance.
   *
   * @param id
   * @param className
   * @param creationTimeUnix
   * @param lastUpdateTimeUnix
   * @param properties
   * @param additional
   * @param vector Unnamed (default) vector.
   * <p>
   * This field will be deprecated in later versions.
   * Prefer using {@link #vectors} for collections storing a single vector only.
   * @param vectors Named vectors.
   * @param multiVectors Named multivectors.
   * @param vectorWeights
   * @param tenant
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  WeaviateObject(final String id, final String className, final Long creationTimeUnix, final Long lastUpdateTimeUnix, final Map<String, Object> properties, final Map<String, Object> additional, final Float[] vector, final Map<String, Float[]> vectors, final Map<String, Float[][]> multiVectors, final Object vectorWeights, final String tenant) {
    this.id = id;
    this.className = className;
    this.creationTimeUnix = creationTimeUnix;
    this.lastUpdateTimeUnix = lastUpdateTimeUnix;
    this.properties = properties;
    this.additional = additional;
    this.vector = vector;
    this.vectors = vectors;
    this.multiVectors = multiVectors;
    this.vectorWeights = vectorWeights;
    this.tenant = tenant;
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static class WeaviateObjectBuilder {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String id;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String className;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Long creationTimeUnix;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Long lastUpdateTimeUnix;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Map<String, Object> properties;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Map<String, Object> additional;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Float[] vector;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private boolean vectors$set;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Map<String, Float[]> vectors$value;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private boolean multiVectors$set;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Map<String, Float[][]> multiVectors$value;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Object vectorWeights;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String tenant;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    WeaviateObjectBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WeaviateObject.WeaviateObjectBuilder id(final String id) {
      this.id = id;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WeaviateObject.WeaviateObjectBuilder className(final String className) {
      this.className = className;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WeaviateObject.WeaviateObjectBuilder creationTimeUnix(final Long creationTimeUnix) {
      this.creationTimeUnix = creationTimeUnix;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WeaviateObject.WeaviateObjectBuilder lastUpdateTimeUnix(final Long lastUpdateTimeUnix) {
      this.lastUpdateTimeUnix = lastUpdateTimeUnix;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WeaviateObject.WeaviateObjectBuilder properties(final Map<String, Object> properties) {
      this.properties = properties;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WeaviateObject.WeaviateObjectBuilder additional(final Map<String, Object> additional) {
      this.additional = additional;
      return this;
    }

    /**
     * Unnamed (default) vector.
     * <p>
     * This field will be deprecated in later versions.
     * Prefer using {@link #vectors} for collections storing a single vector only.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WeaviateObject.WeaviateObjectBuilder vector(final Float[] vector) {
      this.vector = vector;
      return this;
    }

    /**
     * Named vectors.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WeaviateObject.WeaviateObjectBuilder vectors(final Map<String, Float[]> vectors) {
      this.vectors$value = vectors;
      vectors$set = true;
      return this;
    }

    /**
     * Named multivectors.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WeaviateObject.WeaviateObjectBuilder multiVectors(final Map<String, Float[][]> multiVectors) {
      this.multiVectors$value = multiVectors;
      multiVectors$set = true;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WeaviateObject.WeaviateObjectBuilder vectorWeights(final Object vectorWeights) {
      this.vectorWeights = vectorWeights;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WeaviateObject.WeaviateObjectBuilder tenant(final String tenant) {
      this.tenant = tenant;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WeaviateObject build() {
      Map<String, Float[]> vectors$value = this.vectors$value;
      if (!this.vectors$set) vectors$value = WeaviateObject.$default$vectors();
      Map<String, Float[][]> multiVectors$value = this.multiVectors$value;
      if (!this.multiVectors$set) multiVectors$value = WeaviateObject.$default$multiVectors();
      return new WeaviateObject(this.id, this.className, this.creationTimeUnix, this.lastUpdateTimeUnix, this.properties, this.additional, this.vector, vectors$value, multiVectors$value, this.vectorWeights, this.tenant);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "WeaviateObject.WeaviateObjectBuilder(id=" + this.id + ", className=" + this.className + ", creationTimeUnix=" + this.creationTimeUnix + ", lastUpdateTimeUnix=" + this.lastUpdateTimeUnix + ", properties=" + this.properties + ", additional=" + this.additional + ", vector=" + java.util.Arrays.deepToString(this.vector) + ", vectors$value=" + this.vectors$value + ", multiVectors$value=" + this.multiVectors$value + ", vectorWeights=" + this.vectorWeights + ", tenant=" + this.tenant + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static WeaviateObject.WeaviateObjectBuilder builder() {
    return new WeaviateObject.WeaviateObjectBuilder();
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getClassName() {
    return this.className;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getCreationTimeUnix() {
    return this.creationTimeUnix;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getLastUpdateTimeUnix() {
    return this.lastUpdateTimeUnix;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, Object> getProperties() {
    return this.properties;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, Object> getAdditional() {
    return this.additional;
  }

  /**
   * Unnamed (default) vector.
   * <p>
   * This field will be deprecated in later versions.
   * Prefer using {@link #vectors} for collections storing a single vector only.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Float[] getVector() {
    return this.vector;
  }

  /**
   * Named vectors.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, Float[]> getVectors() {
    return this.vectors;
  }

  /**
   * Named multivectors.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, Float[][]> getMultiVectors() {
    return this.multiVectors;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Object getVectorWeights() {
    return this.vectorWeights;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getTenant() {
    return this.tenant;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setClassName(final String className) {
    this.className = className;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCreationTimeUnix(final Long creationTimeUnix) {
    this.creationTimeUnix = creationTimeUnix;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLastUpdateTimeUnix(final Long lastUpdateTimeUnix) {
    this.lastUpdateTimeUnix = lastUpdateTimeUnix;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setProperties(final Map<String, Object> properties) {
    this.properties = properties;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAdditional(final Map<String, Object> additional) {
    this.additional = additional;
  }

  /**
   * Unnamed (default) vector.
   * <p>
   * This field will be deprecated in later versions.
   * Prefer using {@link #vectors} for collections storing a single vector only.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVector(final Float[] vector) {
    this.vector = vector;
  }

  /**
   * Named vectors.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVectors(final Map<String, Float[]> vectors) {
    this.vectors = vectors;
  }

  /**
   * Named multivectors.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMultiVectors(final Map<String, Float[][]> multiVectors) {
    this.multiVectors = multiVectors;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVectorWeights(final Object vectorWeights) {
    this.vectorWeights = vectorWeights;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTenant(final String tenant) {
    this.tenant = tenant;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "WeaviateObject(id=" + this.getId() + ", className=" + this.getClassName() + ", creationTimeUnix=" + this.getCreationTimeUnix() + ", lastUpdateTimeUnix=" + this.getLastUpdateTimeUnix() + ", properties=" + this.getProperties() + ", additional=" + this.getAdditional() + ", vector=" + java.util.Arrays.deepToString(this.getVector()) + ", vectors=" + this.getVectors() + ", multiVectors=" + this.getMultiVectors() + ", vectorWeights=" + this.getVectorWeights() + ", tenant=" + this.getTenant() + ")";
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof WeaviateObject)) return false;
    final WeaviateObject other = (WeaviateObject) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$creationTimeUnix = this.getCreationTimeUnix();
    final java.lang.Object other$creationTimeUnix = other.getCreationTimeUnix();
    if (this$creationTimeUnix == null ? other$creationTimeUnix != null : !this$creationTimeUnix.equals(other$creationTimeUnix)) return false;
    final java.lang.Object this$lastUpdateTimeUnix = this.getLastUpdateTimeUnix();
    final java.lang.Object other$lastUpdateTimeUnix = other.getLastUpdateTimeUnix();
    if (this$lastUpdateTimeUnix == null ? other$lastUpdateTimeUnix != null : !this$lastUpdateTimeUnix.equals(other$lastUpdateTimeUnix)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$className = this.getClassName();
    final java.lang.Object other$className = other.getClassName();
    if (this$className == null ? other$className != null : !this$className.equals(other$className)) return false;
    final java.lang.Object this$properties = this.getProperties();
    final java.lang.Object other$properties = other.getProperties();
    if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) return false;
    final java.lang.Object this$additional = this.getAdditional();
    final java.lang.Object other$additional = other.getAdditional();
    if (this$additional == null ? other$additional != null : !this$additional.equals(other$additional)) return false;
    if (!java.util.Arrays.deepEquals(this.getVector(), other.getVector())) return false;
    final java.lang.Object this$vectors = this.getVectors();
    final java.lang.Object other$vectors = other.getVectors();
    if (this$vectors == null ? other$vectors != null : !this$vectors.equals(other$vectors)) return false;
    final java.lang.Object this$vectorWeights = this.getVectorWeights();
    final java.lang.Object other$vectorWeights = other.getVectorWeights();
    if (this$vectorWeights == null ? other$vectorWeights != null : !this$vectorWeights.equals(other$vectorWeights)) return false;
    final java.lang.Object this$tenant = this.getTenant();
    final java.lang.Object other$tenant = other.getTenant();
    if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof WeaviateObject;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $creationTimeUnix = this.getCreationTimeUnix();
    result = result * PRIME + ($creationTimeUnix == null ? 43 : $creationTimeUnix.hashCode());
    final java.lang.Object $lastUpdateTimeUnix = this.getLastUpdateTimeUnix();
    result = result * PRIME + ($lastUpdateTimeUnix == null ? 43 : $lastUpdateTimeUnix.hashCode());
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $className = this.getClassName();
    result = result * PRIME + ($className == null ? 43 : $className.hashCode());
    final java.lang.Object $properties = this.getProperties();
    result = result * PRIME + ($properties == null ? 43 : $properties.hashCode());
    final java.lang.Object $additional = this.getAdditional();
    result = result * PRIME + ($additional == null ? 43 : $additional.hashCode());
    result = result * PRIME + java.util.Arrays.deepHashCode(this.getVector());
    final java.lang.Object $vectors = this.getVectors();
    result = result * PRIME + ($vectors == null ? 43 : $vectors.hashCode());
    final java.lang.Object $vectorWeights = this.getVectorWeights();
    result = result * PRIME + ($vectorWeights == null ? 43 : $vectorWeights.hashCode());
    final java.lang.Object $tenant = this.getTenant();
    result = result * PRIME + ($tenant == null ? 43 : $tenant.hashCode());
    return result;
  }
}
