// Generated by delombok at Thu Apr 10 13:10:53 UTC 2025
package io.weaviate.client.v1.data.util;

import io.weaviate.client.base.util.DbVersionSupport;
import io.weaviate.client.base.util.TriConsumer;
import io.weaviate.client.base.util.UrlEncoder;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ObjectsPath {
  private final DbVersionSupport support;

  public ObjectsPath(DbVersionSupport support) {
    this.support = support;
  }

  public String buildCreate(Params params) {
    return build(params, this::addQueryConsistencyLevel);
  }

  public String buildDelete(Params params) {
    return build(params, this::addPathClassNameWithDeprecatedNotSupportedCheck, this::addPathId, this::addQueryConsistencyLevel, this::addQueryTenant);
  }

  public String buildUpdate(Params params) {
    return build(params, this::addPathClassNameWithDeprecatedCheck, this::addPathId, this::addQueryConsistencyLevel, this::addQueryTenant);
  }

  public String buildCheck(Params params) {
    return build(params, this::addPathClassNameWithDeprecatedNotSupportedCheck, this::addPathId, this::addQueryTenant);
  }

  public String buildGet(Params params) {
    return build(params, this::addQueryClassNameWithDeprecatedCheck, this::addQueryAdditionals, this::addQueryLimit, this::addQueryOffset, this::addQueryAfter, this::addQueryTenant);
  }

  public String buildGetOne(Params params) {
    return build(params, this::addPathClassNameWithDeprecatedNotSupportedCheck, this::addPathId, this::addQueryAdditionals, this::addQueryConsistencyLevel, this::addQueryNodeName, this::addQueryTenant);
  }

  @SafeVarargs
  private final String build(Params params, TriConsumer<Params, List<String>, List<String>>... appenders) {
    Objects.requireNonNull(params);
    List<String> pathParams = new ArrayList<>();
    List<String> queryParams = new ArrayList<>();
    pathParams.add("/objects");
    Arrays.stream(appenders).forEach(consumer -> consumer.accept(params, pathParams, queryParams));
    String path = String.join("/", pathParams);
    if (!queryParams.isEmpty()) {
      return path + "?" + String.join("&", queryParams);
    }
    return path;
  }

  private void addPathClassNameWithDeprecatedNotSupportedCheck(Params params, List<String> pathParams, List<String> queryParams) {
    if (support.supportsClassNameNamespacedEndpoints()) {
      if (StringUtils.isNotBlank(params.className)) {
        pathParams.add(UrlEncoder.encodePathParam(params.className));
      } else {
        support.warnDeprecatedNonClassNameNamespacedEndpointsForObjects();
      }
    } else if (StringUtils.isNotBlank(params.className)) {
      support.warnNotSupportedClassNamespacedEndpointsForObjects();
    }
  }

  private void addPathClassNameWithDeprecatedCheck(Params params, List<String> pathParams, List<String> queryParams) {
    if (support.supportsClassNameNamespacedEndpoints()) {
      if (StringUtils.isNotBlank(params.className)) {
        pathParams.add(UrlEncoder.encodePathParam(params.className));
      } else {
        support.warnDeprecatedNonClassNameNamespacedEndpointsForObjects();
      }
    }
  }

  private void addPathId(Params params, List<String> pathParams, List<String> queryParams) {
    if (StringUtils.isNotBlank(params.id)) {
      pathParams.add(UrlEncoder.encodePathParam(params.id));
    }
  }

  private void addQueryClassNameWithDeprecatedCheck(Params params, List<String> pathParams, List<String> queryParams) {
    if (StringUtils.isBlank(params.id) && StringUtils.isNotBlank(params.className)) {
      if (support.supportsClassNameNamespacedEndpoints()) {
        queryParams.add(UrlEncoder.encodeQueryParam("class", params.className));
      } else {
        support.warnNotSupportedClassParameterInEndpointsForObjects();
      }
    }
  }

  private void addQueryAdditionals(Params params, List<String> pathParams, List<String> queryParams) {
    if (ObjectUtils.isNotEmpty(params.additional)) {
      String include = Arrays.stream(params.additional).map(UrlEncoder::encodePathParam).filter(StringUtils::isNotBlank).collect(Collectors.joining(","));
      if (StringUtils.isNotBlank(include)) {
        queryParams.add(String.format("%s=%s", "include", include));
      }
    }
  }

  private void addQueryLimit(Params params, List<String> pathParams, List<String> queryParams) {
    if (params.limit != null) {
      queryParams.add(UrlEncoder.encodeQueryParam("limit", Integer.toString(params.limit)));
    }
  }

  private void addQueryOffset(Params params, List<String> pathParams, List<String> queryParams) {
    if (params.offset != null) {
      queryParams.add(UrlEncoder.encodeQueryParam("offset", Integer.toString(params.offset)));
    }
  }

  private void addQueryAfter(Params params, List<String> pathParams, List<String> queryParams) {
    if (StringUtils.isNotBlank(params.after)) {
      queryParams.add(UrlEncoder.encodeQueryParam("after", params.after));
    }
  }

  private void addQueryConsistencyLevel(Params params, List<String> pathParams, List<String> queryParams) {
    if (StringUtils.isNotBlank(params.consistencyLevel)) {
      queryParams.add(UrlEncoder.encodeQueryParam("consistency_level", params.consistencyLevel));
    }
  }

  private void addQueryNodeName(Params params, List<String> pathParams, List<String> queryParams) {
    if (StringUtils.isNotBlank(params.nodeName)) {
      queryParams.add(UrlEncoder.encodeQueryParam("node_name", params.nodeName));
    }
  }

  private void addQueryTenant(Params params, List<String> pathParams, List<String> queryParams) {
    if (StringUtils.isNotBlank(params.tenant)) {
      queryParams.add(UrlEncoder.encodeQueryParam("tenant", params.tenant));
    }
  }


  public static class Params {
    private final String id;
    private final String className;
    private final Integer limit;
    private final Integer offset;
    private final String after;
    private final String[] additional;
    private final String consistencyLevel;
    private final String nodeName;
    private final String tenant;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    Params(final String id, final String className, final Integer limit, final Integer offset, final String after, final String[] additional, final String consistencyLevel, final String nodeName, final String tenant) {
      this.id = id;
      this.className = className;
      this.limit = limit;
      this.offset = offset;
      this.after = after;
      this.additional = additional;
      this.consistencyLevel = consistencyLevel;
      this.nodeName = nodeName;
      this.tenant = tenant;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static class ParamsBuilder {
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private String id;
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private String className;
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private Integer limit;
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private Integer offset;
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private String after;
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private String[] additional;
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private String consistencyLevel;
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private String nodeName;
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private String tenant;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      ParamsBuilder() {
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public ObjectsPath.Params.ParamsBuilder id(final String id) {
        this.id = id;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public ObjectsPath.Params.ParamsBuilder className(final String className) {
        this.className = className;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public ObjectsPath.Params.ParamsBuilder limit(final Integer limit) {
        this.limit = limit;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public ObjectsPath.Params.ParamsBuilder offset(final Integer offset) {
        this.offset = offset;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public ObjectsPath.Params.ParamsBuilder after(final String after) {
        this.after = after;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public ObjectsPath.Params.ParamsBuilder additional(final String[] additional) {
        this.additional = additional;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public ObjectsPath.Params.ParamsBuilder consistencyLevel(final String consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public ObjectsPath.Params.ParamsBuilder nodeName(final String nodeName) {
        this.nodeName = nodeName;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public ObjectsPath.Params.ParamsBuilder tenant(final String tenant) {
        this.tenant = tenant;
        return this;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public ObjectsPath.Params build() {
        return new ObjectsPath.Params(this.id, this.className, this.limit, this.offset, this.after, this.additional, this.consistencyLevel, this.nodeName, this.tenant);
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public java.lang.String toString() {
        return "ObjectsPath.Params.ParamsBuilder(id=" + this.id + ", className=" + this.className + ", limit=" + this.limit + ", offset=" + this.offset + ", after=" + this.after + ", additional=" + java.util.Arrays.deepToString(this.additional) + ", consistencyLevel=" + this.consistencyLevel + ", nodeName=" + this.nodeName + ", tenant=" + this.tenant + ")";
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static ObjectsPath.Params.ParamsBuilder builder() {
      return new ObjectsPath.Params.ParamsBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "ObjectsPath.Params(id=" + this.id + ", className=" + this.className + ", limit=" + this.limit + ", offset=" + this.offset + ", after=" + this.after + ", additional=" + java.util.Arrays.deepToString(this.additional) + ", consistencyLevel=" + this.consistencyLevel + ", nodeName=" + this.nodeName + ", tenant=" + this.tenant + ")";
    }
  }
}
