// Generated by delombok at Thu Apr 10 13:10:53 UTC 2025
package io.weaviate.client.v1.data.util;

import io.weaviate.client.base.util.DbVersionSupport;
import io.weaviate.client.base.util.TriConsumer;
import io.weaviate.client.base.util.UrlEncoder;
import org.apache.commons.lang3.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ReferencesPath {
  private final DbVersionSupport support;

  public ReferencesPath(DbVersionSupport support) {
    this.support = support;
  }

  public String buildCreate(Params params) {
    return commonBuild(params);
  }

  public String buildDelete(Params params) {
    return commonBuild(params);
  }

  public String buildReplace(Params params) {
    return commonBuild(params);
  }

  private String commonBuild(Params params) {
    return build(params, this::addPathClassNameWithDeprecatedNotSupportedCheck, this::addPathId, this::addPathReferences, this::addPathProperty, this::addQueryConsistencyLevel, this::addQueryTenant);
  }

  @SafeVarargs
  private final String build(Params params, TriConsumer<Params, List<String>, List<String>>... appenders) {
    Objects.requireNonNull(params);
    List<String> pathParams = new ArrayList<>();
    List<String> queryParams = new ArrayList<>();
    pathParams.add("/objects");
    Arrays.stream(appenders).forEach(consumer -> consumer.accept(params, pathParams, queryParams));
    String path = String.join("/", pathParams);
    if (!queryParams.isEmpty()) {
      return path + "?" + String.join("&", queryParams);
    }
    return path;
  }

  private void addPathClassNameWithDeprecatedNotSupportedCheck(Params params, List<String> pathParams, List<String> queryParams) {
    if (support.supportsClassNameNamespacedEndpoints()) {
      if (StringUtils.isNotBlank(params.className)) {
        pathParams.add(UrlEncoder.encodePathParam(params.className));
      } else {
        support.warnDeprecatedNonClassNameNamespacedEndpointsForObjects();
      }
    } else if (StringUtils.isNotBlank(params.className)) {
      support.warnNotSupportedClassNamespacedEndpointsForObjects();
    }
  }

  private void addPathId(Params params, List<String> pathParams, List<String> queryParams) {
    if (StringUtils.isNotBlank(params.id)) {
      pathParams.add(UrlEncoder.encodePathParam(params.id));
    }
  }

  private void addPathReferences(Params params, List<String> pathParams, List<String> queryParams) {
    pathParams.add("references");
  }

  private void addPathProperty(Params params, List<String> pathParams, List<String> queryParams) {
    if (StringUtils.isNotBlank(params.property)) {
      pathParams.add(UrlEncoder.encodePathParam(params.property));
    }
  }

  private void addQueryConsistencyLevel(Params params, List<String> pathParams, List<String> queryParams) {
    if (StringUtils.isNotBlank(params.consistencyLevel)) {
      queryParams.add(UrlEncoder.encodeQueryParam("consistency_level", params.consistencyLevel));
    }
  }

  private void addQueryTenant(Params params, List<String> pathParams, List<String> queryParams) {
    if (StringUtils.isNotBlank(params.tenant)) {
      queryParams.add(UrlEncoder.encodeQueryParam("tenant", params.tenant));
    }
  }


  public static class Params {
    private final String id;
    private final String className;
    private final String consistencyLevel;
    private final String tenant;
    private final String property;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    Params(final String id, final String className, final String consistencyLevel, final String tenant, final String property) {
      this.id = id;
      this.className = className;
      this.consistencyLevel = consistencyLevel;
      this.tenant = tenant;
      this.property = property;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static class ParamsBuilder {
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private String id;
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private String className;
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private String consistencyLevel;
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private String tenant;
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private String property;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      ParamsBuilder() {
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public ReferencesPath.Params.ParamsBuilder id(final String id) {
        this.id = id;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public ReferencesPath.Params.ParamsBuilder className(final String className) {
        this.className = className;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public ReferencesPath.Params.ParamsBuilder consistencyLevel(final String consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public ReferencesPath.Params.ParamsBuilder tenant(final String tenant) {
        this.tenant = tenant;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public ReferencesPath.Params.ParamsBuilder property(final String property) {
        this.property = property;
        return this;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public ReferencesPath.Params build() {
        return new ReferencesPath.Params(this.id, this.className, this.consistencyLevel, this.tenant, this.property);
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public java.lang.String toString() {
        return "ReferencesPath.Params.ParamsBuilder(id=" + this.id + ", className=" + this.className + ", consistencyLevel=" + this.consistencyLevel + ", tenant=" + this.tenant + ", property=" + this.property + ")";
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static ReferencesPath.Params.ParamsBuilder builder() {
      return new ReferencesPath.Params.ParamsBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "ReferencesPath.Params(id=" + this.id + ", className=" + this.className + ", consistencyLevel=" + this.consistencyLevel + ", tenant=" + this.tenant + ", property=" + this.property + ")";
    }
  }
}
