// Generated by delombok at Thu Apr 10 13:10:53 UTC 2025
package io.weaviate.client.v1.graphql.query.argument;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import io.weaviate.client.v1.graphql.query.util.Serializer;

public class HybridArgument implements Argument {
  private final String query;
  private final Float alpha;
  private final Float maxVectorDistance;
  private final Float[] vector;
  private final String fusionType;
  private final String[] properties;
  private final String[] targetVectors;
  private final Searches searches;
  private final Targets targets;

  @Override
  public String build() {
    Set<String> arg = new LinkedHashSet<>();
    arg.add(String.format("query:%s", Serializer.quote(query)));
    if (vector != null) {
      arg.add(String.format("vector:%s", Serializer.array(vector)));
    }
    if (alpha != null) {
      arg.add(String.format("alpha:%s", alpha));
    }
    if (maxVectorDistance != null) {
      arg.add(String.format("maxVectorDistance:%s", maxVectorDistance));
    }
    if (ArrayUtils.isNotEmpty(properties)) {
      arg.add(String.format("properties:%s", Serializer.arrayWithQuotes(properties)));
    }
    if (StringUtils.isNotBlank(fusionType)) {
      arg.add(String.format("fusionType:%s", fusionType));
    }
    if (ArrayUtils.isNotEmpty(targetVectors)) {
      arg.add(String.format("targetVectors:%s", Serializer.arrayWithQuotes(targetVectors)));
    }
    if (searches != null && (searches.nearVector != null || searches.nearText != null)) {
      Set<String> searchesArgs = new LinkedHashSet<>();
      if (searches.nearVector != null) {
        searchesArgs.add(searches.nearVector.build());
      }
      if (searches.nearText != null) {
        searchesArgs.add(searches.nearText.build());
      }
      arg.add(String.format("searches:{%s}", String.join(" ", searchesArgs)));
    }
    if (targets != null) {
      arg.add(String.format("%s", targets.build()));
    }
    return String.format("hybrid:{%s}", String.join(" ", arg));
  }


  public static class Searches {
    private final NearVectorArgument nearVector;
    private final NearTextArgument nearText;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    Searches(final NearVectorArgument nearVector, final NearTextArgument nearText) {
      this.nearVector = nearVector;
      this.nearText = nearText;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static class SearchesBuilder {
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private NearVectorArgument nearVector;
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private NearTextArgument nearText;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      SearchesBuilder() {
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public HybridArgument.Searches.SearchesBuilder nearVector(final NearVectorArgument nearVector) {
        this.nearVector = nearVector;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public HybridArgument.Searches.SearchesBuilder nearText(final NearTextArgument nearText) {
        this.nearText = nearText;
        return this;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public HybridArgument.Searches build() {
        return new HybridArgument.Searches(this.nearVector, this.nearText);
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public java.lang.String toString() {
        return "HybridArgument.Searches.SearchesBuilder(nearVector=" + this.nearVector + ", nearText=" + this.nearText + ")";
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static HybridArgument.Searches.SearchesBuilder builder() {
      return new HybridArgument.Searches.SearchesBuilder();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NearVectorArgument getNearVector() {
      return this.nearVector;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public NearTextArgument getNearText() {
      return this.nearText;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "HybridArgument.Searches(nearVector=" + this.getNearVector() + ", nearText=" + this.getNearText() + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  HybridArgument(final String query, final Float alpha, final Float maxVectorDistance, final Float[] vector, final String fusionType, final String[] properties, final String[] targetVectors, final Searches searches, final Targets targets) {
    this.query = query;
    this.alpha = alpha;
    this.maxVectorDistance = maxVectorDistance;
    this.vector = vector;
    this.fusionType = fusionType;
    this.properties = properties;
    this.targetVectors = targetVectors;
    this.searches = searches;
    this.targets = targets;
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static class HybridArgumentBuilder {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String query;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Float alpha;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Float maxVectorDistance;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Float[] vector;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String fusionType;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String[] properties;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String[] targetVectors;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Searches searches;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Targets targets;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    HybridArgumentBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HybridArgument.HybridArgumentBuilder query(final String query) {
      this.query = query;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HybridArgument.HybridArgumentBuilder alpha(final Float alpha) {
      this.alpha = alpha;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HybridArgument.HybridArgumentBuilder maxVectorDistance(final Float maxVectorDistance) {
      this.maxVectorDistance = maxVectorDistance;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HybridArgument.HybridArgumentBuilder vector(final Float[] vector) {
      this.vector = vector;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HybridArgument.HybridArgumentBuilder fusionType(final String fusionType) {
      this.fusionType = fusionType;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HybridArgument.HybridArgumentBuilder properties(final String[] properties) {
      this.properties = properties;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HybridArgument.HybridArgumentBuilder targetVectors(final String[] targetVectors) {
      this.targetVectors = targetVectors;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HybridArgument.HybridArgumentBuilder searches(final Searches searches) {
      this.searches = searches;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HybridArgument.HybridArgumentBuilder targets(final Targets targets) {
      this.targets = targets;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HybridArgument build() {
      return new HybridArgument(this.query, this.alpha, this.maxVectorDistance, this.vector, this.fusionType, this.properties, this.targetVectors, this.searches, this.targets);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "HybridArgument.HybridArgumentBuilder(query=" + this.query + ", alpha=" + this.alpha + ", maxVectorDistance=" + this.maxVectorDistance + ", vector=" + java.util.Arrays.deepToString(this.vector) + ", fusionType=" + this.fusionType + ", properties=" + java.util.Arrays.deepToString(this.properties) + ", targetVectors=" + java.util.Arrays.deepToString(this.targetVectors) + ", searches=" + this.searches + ", targets=" + this.targets + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static HybridArgument.HybridArgumentBuilder builder() {
    return new HybridArgument.HybridArgumentBuilder();
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getQuery() {
    return this.query;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Float getAlpha() {
    return this.alpha;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Float getMaxVectorDistance() {
    return this.maxVectorDistance;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Float[] getVector() {
    return this.vector;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getFusionType() {
    return this.fusionType;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String[] getProperties() {
    return this.properties;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String[] getTargetVectors() {
    return this.targetVectors;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Searches getSearches() {
    return this.searches;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Targets getTargets() {
    return this.targets;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "HybridArgument(query=" + this.getQuery() + ", alpha=" + this.getAlpha() + ", maxVectorDistance=" + this.getMaxVectorDistance() + ", vector=" + java.util.Arrays.deepToString(this.getVector()) + ", fusionType=" + this.getFusionType() + ", properties=" + java.util.Arrays.deepToString(this.getProperties()) + ", targetVectors=" + java.util.Arrays.deepToString(this.getTargetVectors()) + ", searches=" + this.getSearches() + ", targets=" + this.getTargets() + ")";
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof HybridArgument)) return false;
    final HybridArgument other = (HybridArgument) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$alpha = this.getAlpha();
    final java.lang.Object other$alpha = other.getAlpha();
    if (this$alpha == null ? other$alpha != null : !this$alpha.equals(other$alpha)) return false;
    final java.lang.Object this$maxVectorDistance = this.getMaxVectorDistance();
    final java.lang.Object other$maxVectorDistance = other.getMaxVectorDistance();
    if (this$maxVectorDistance == null ? other$maxVectorDistance != null : !this$maxVectorDistance.equals(other$maxVectorDistance)) return false;
    final java.lang.Object this$query = this.getQuery();
    final java.lang.Object other$query = other.getQuery();
    if (this$query == null ? other$query != null : !this$query.equals(other$query)) return false;
    if (!java.util.Arrays.deepEquals(this.getVector(), other.getVector())) return false;
    final java.lang.Object this$fusionType = this.getFusionType();
    final java.lang.Object other$fusionType = other.getFusionType();
    if (this$fusionType == null ? other$fusionType != null : !this$fusionType.equals(other$fusionType)) return false;
    if (!java.util.Arrays.deepEquals(this.getProperties(), other.getProperties())) return false;
    if (!java.util.Arrays.deepEquals(this.getTargetVectors(), other.getTargetVectors())) return false;
    final java.lang.Object this$searches = this.getSearches();
    final java.lang.Object other$searches = other.getSearches();
    if (this$searches == null ? other$searches != null : !this$searches.equals(other$searches)) return false;
    final java.lang.Object this$targets = this.getTargets();
    final java.lang.Object other$targets = other.getTargets();
    if (this$targets == null ? other$targets != null : !this$targets.equals(other$targets)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof HybridArgument;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $alpha = this.getAlpha();
    result = result * PRIME + ($alpha == null ? 43 : $alpha.hashCode());
    final java.lang.Object $maxVectorDistance = this.getMaxVectorDistance();
    result = result * PRIME + ($maxVectorDistance == null ? 43 : $maxVectorDistance.hashCode());
    final java.lang.Object $query = this.getQuery();
    result = result * PRIME + ($query == null ? 43 : $query.hashCode());
    result = result * PRIME + java.util.Arrays.deepHashCode(this.getVector());
    final java.lang.Object $fusionType = this.getFusionType();
    result = result * PRIME + ($fusionType == null ? 43 : $fusionType.hashCode());
    result = result * PRIME + java.util.Arrays.deepHashCode(this.getProperties());
    result = result * PRIME + java.util.Arrays.deepHashCode(this.getTargetVectors());
    final java.lang.Object $searches = this.getSearches();
    result = result * PRIME + ($searches == null ? 43 : $searches.hashCode());
    final java.lang.Object $targets = this.getTargets();
    result = result * PRIME + ($targets == null ? 43 : $targets.hashCode());
    return result;
  }
}
