// Generated by delombok at Thu Apr 10 13:10:53 UTC 2025
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.util.Serializer;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;

public class Targets {
  private final CombinationMethod combinationMethod;
  private final String[] targetVectors;
  private final Map<String, Float[]> weights;


  public enum CombinationMethod {
    minimum("minimum"), average("average"), sum("sum"), manualWeights("manualWeights"), relativeScore("relativeScore");
    private final String type;

    CombinationMethod(String type) {
      this.type = type;
    }

    @Override
    public String toString() {
      return type;
    }
  }

  String build() {
    Set<String> arg = new LinkedHashSet<>();
    if (combinationMethod != null) {
      arg.add(String.format("combinationMethod:%s", combinationMethod.name()));
    }
    if (ArrayUtils.isNotEmpty(targetVectors)) {
      arg.add(String.format("targetVectors:%s", Serializer.arrayWithQuotes(targetVectors)));
    }
    if (weights != null && !weights.isEmpty()) {
      Set<String> weightsArg = new LinkedHashSet<>();
      for (Map.Entry<String, Float[]> e : weights.entrySet()) {
        Float[] weightsPerTarget = e.getValue();
        String target = e.getKey();
        String weight = Serializer.array(weightsPerTarget);
        if (weightsPerTarget.length == 1) {
          weight = weightsPerTarget[0].toString();
        }
        weightsArg.add(String.format("%s:%s", target, weight));
      }
      arg.add(String.format("weights:{%s}", String.join(" ", weightsArg)));
    }
    return String.format("targets:{%s}", String.join(" ", arg));
  }

  // Extend lombok's builder to overload some methods.
  public static class TargetsBuilder {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private CombinationMethod combinationMethod;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String[] targetVectors;
    Map<String, Float[]> weights = new LinkedHashMap<>();

    public TargetsBuilder weights(Map<String, Float> weights) {
      this.weights.clear(); // Overwrite the existing entries each time this is called.
      for (Map.Entry<String, Float> e : weights.entrySet()) {
        this.weights.put(e.getKey(), new Float[] {e.getValue()});
      }
      return this;
    }

    public TargetsBuilder weightsMulti(Map<String, Float[]> weights) {
      this.weights = weights;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    TargetsBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Targets.TargetsBuilder combinationMethod(final CombinationMethod combinationMethod) {
      this.combinationMethod = combinationMethod;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Targets.TargetsBuilder targetVectors(final String[] targetVectors) {
      this.targetVectors = targetVectors;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Targets build() {
      return new Targets(this.combinationMethod, this.targetVectors, this.weights);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "Targets.TargetsBuilder(combinationMethod=" + this.combinationMethod + ", targetVectors=" + java.util.Arrays.deepToString(this.targetVectors) + ", weights=" + this.weights + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  Targets(final CombinationMethod combinationMethod, final String[] targetVectors, final Map<String, Float[]> weights) {
    this.combinationMethod = combinationMethod;
    this.targetVectors = targetVectors;
    this.weights = weights;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static Targets.TargetsBuilder builder() {
    return new Targets.TargetsBuilder();
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CombinationMethod getCombinationMethod() {
    return this.combinationMethod;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String[] getTargetVectors() {
    return this.targetVectors;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, Float[]> getWeights() {
    return this.weights;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "Targets(combinationMethod=" + this.getCombinationMethod() + ", targetVectors=" + java.util.Arrays.deepToString(this.getTargetVectors()) + ", weights=" + this.getWeights() + ")";
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Targets)) return false;
    final Targets other = (Targets) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$combinationMethod = this.getCombinationMethod();
    final java.lang.Object other$combinationMethod = other.getCombinationMethod();
    if (this$combinationMethod == null ? other$combinationMethod != null : !this$combinationMethod.equals(other$combinationMethod)) return false;
    if (!java.util.Arrays.deepEquals(this.getTargetVectors(), other.getTargetVectors())) return false;
    final java.lang.Object this$weights = this.getWeights();
    final java.lang.Object other$weights = other.getWeights();
    if (this$weights == null ? other$weights != null : !this$weights.equals(other$weights)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Targets;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $combinationMethod = this.getCombinationMethod();
    result = result * PRIME + ($combinationMethod == null ? 43 : $combinationMethod.hashCode());
    result = result * PRIME + java.util.Arrays.deepHashCode(this.getTargetVectors());
    final java.lang.Object $weights = this.getWeights();
    result = result * PRIME + ($weights == null ? 43 : $weights.hashCode());
    return result;
  }
}
