// Generated by delombok at Thu Apr 10 13:10:53 UTC 2025
package io.weaviate.client.v1.rbac.api;

import java.util.ArrayList;
import java.util.List;
import io.weaviate.client.v1.rbac.model.BackupsPermission;
import io.weaviate.client.v1.rbac.model.CollectionsPermission;
import io.weaviate.client.v1.rbac.model.DataPermission;
import io.weaviate.client.v1.rbac.model.NodesPermission;
import io.weaviate.client.v1.rbac.model.Permission;
import io.weaviate.client.v1.rbac.model.RolesPermission;
import io.weaviate.client.v1.rbac.model.TenantsPermission;
import io.weaviate.client.v1.rbac.model.UsersPermission;

/**
 * API model for serializing/deserializing permissions.
 */
public class WeaviatePermission {
  String action;
  BackupsPermission backups;
  CollectionsPermission collections;
  DataPermission data;
  NodesPermission nodes;
  RolesPermission roles;
  TenantsPermission tenants;
  UsersPermission users;

  public WeaviatePermission(String action) {
    this.action = action;
  }

  public <P extends Permission<P>> WeaviatePermission(String action, Permission<P> perm) {
    this.action = action;
    if (perm instanceof BackupsPermission) {
      this.backups = (BackupsPermission) perm;
    } else if (perm instanceof CollectionsPermission) {
      this.collections = (CollectionsPermission) perm;
    } else if (perm instanceof DataPermission) {
      this.data = (DataPermission) perm;
    } else if (perm instanceof NodesPermission) {
      this.nodes = (NodesPermission) perm;
    } else if (perm instanceof RolesPermission) {
      this.roles = (RolesPermission) perm;
    } else if (perm instanceof TenantsPermission) {
      this.tenants = (TenantsPermission) perm;
    } else if (perm instanceof UsersPermission) {
      this.users = (UsersPermission) perm;
    }
  }

  public static List<WeaviatePermission> mergePermissions(List<Permission<?>> permissions) {
    List<WeaviatePermission> merged = new ArrayList<>();
    for (Permission<?> perm : permissions) {
      merged.addAll(perm.toWeaviate());
    }
    return merged;
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static class WeaviatePermissionBuilder {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String action;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BackupsPermission backups;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private CollectionsPermission collections;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private DataPermission data;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private NodesPermission nodes;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private RolesPermission roles;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private TenantsPermission tenants;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private UsersPermission users;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    WeaviatePermissionBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WeaviatePermission.WeaviatePermissionBuilder action(final String action) {
      this.action = action;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WeaviatePermission.WeaviatePermissionBuilder backups(final BackupsPermission backups) {
      this.backups = backups;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WeaviatePermission.WeaviatePermissionBuilder collections(final CollectionsPermission collections) {
      this.collections = collections;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WeaviatePermission.WeaviatePermissionBuilder data(final DataPermission data) {
      this.data = data;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WeaviatePermission.WeaviatePermissionBuilder nodes(final NodesPermission nodes) {
      this.nodes = nodes;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WeaviatePermission.WeaviatePermissionBuilder roles(final RolesPermission roles) {
      this.roles = roles;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WeaviatePermission.WeaviatePermissionBuilder tenants(final TenantsPermission tenants) {
      this.tenants = tenants;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WeaviatePermission.WeaviatePermissionBuilder users(final UsersPermission users) {
      this.users = users;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WeaviatePermission build() {
      return new WeaviatePermission(this.action, this.backups, this.collections, this.data, this.nodes, this.roles, this.tenants, this.users);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "WeaviatePermission.WeaviatePermissionBuilder(action=" + this.action + ", backups=" + this.backups + ", collections=" + this.collections + ", data=" + this.data + ", nodes=" + this.nodes + ", roles=" + this.roles + ", tenants=" + this.tenants + ", users=" + this.users + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static WeaviatePermission.WeaviatePermissionBuilder builder() {
    return new WeaviatePermission.WeaviatePermissionBuilder();
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getAction() {
    return this.action;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BackupsPermission getBackups() {
    return this.backups;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CollectionsPermission getCollections() {
    return this.collections;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DataPermission getData() {
    return this.data;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public NodesPermission getNodes() {
    return this.nodes;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public RolesPermission getRoles() {
    return this.roles;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public TenantsPermission getTenants() {
    return this.tenants;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public UsersPermission getUsers() {
    return this.users;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public WeaviatePermission(final String action, final BackupsPermission backups, final CollectionsPermission collections, final DataPermission data, final NodesPermission nodes, final RolesPermission roles, final TenantsPermission tenants, final UsersPermission users) {
    this.action = action;
    this.backups = backups;
    this.collections = collections;
    this.data = data;
    this.nodes = nodes;
    this.roles = roles;
    this.tenants = tenants;
    this.users = users;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof WeaviatePermission)) return false;
    final WeaviatePermission other = (WeaviatePermission) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$action = this.getAction();
    final java.lang.Object other$action = other.getAction();
    if (this$action == null ? other$action != null : !this$action.equals(other$action)) return false;
    final java.lang.Object this$backups = this.getBackups();
    final java.lang.Object other$backups = other.getBackups();
    if (this$backups == null ? other$backups != null : !this$backups.equals(other$backups)) return false;
    final java.lang.Object this$collections = this.getCollections();
    final java.lang.Object other$collections = other.getCollections();
    if (this$collections == null ? other$collections != null : !this$collections.equals(other$collections)) return false;
    final java.lang.Object this$data = this.getData();
    final java.lang.Object other$data = other.getData();
    if (this$data == null ? other$data != null : !this$data.equals(other$data)) return false;
    final java.lang.Object this$nodes = this.getNodes();
    final java.lang.Object other$nodes = other.getNodes();
    if (this$nodes == null ? other$nodes != null : !this$nodes.equals(other$nodes)) return false;
    final java.lang.Object this$roles = this.getRoles();
    final java.lang.Object other$roles = other.getRoles();
    if (this$roles == null ? other$roles != null : !this$roles.equals(other$roles)) return false;
    final java.lang.Object this$tenants = this.getTenants();
    final java.lang.Object other$tenants = other.getTenants();
    if (this$tenants == null ? other$tenants != null : !this$tenants.equals(other$tenants)) return false;
    final java.lang.Object this$users = this.getUsers();
    final java.lang.Object other$users = other.getUsers();
    if (this$users == null ? other$users != null : !this$users.equals(other$users)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof WeaviatePermission;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $action = this.getAction();
    result = result * PRIME + ($action == null ? 43 : $action.hashCode());
    final java.lang.Object $backups = this.getBackups();
    result = result * PRIME + ($backups == null ? 43 : $backups.hashCode());
    final java.lang.Object $collections = this.getCollections();
    result = result * PRIME + ($collections == null ? 43 : $collections.hashCode());
    final java.lang.Object $data = this.getData();
    result = result * PRIME + ($data == null ? 43 : $data.hashCode());
    final java.lang.Object $nodes = this.getNodes();
    result = result * PRIME + ($nodes == null ? 43 : $nodes.hashCode());
    final java.lang.Object $roles = this.getRoles();
    result = result * PRIME + ($roles == null ? 43 : $roles.hashCode());
    final java.lang.Object $tenants = this.getTenants();
    result = result * PRIME + ($tenants == null ? 43 : $tenants.hashCode());
    final java.lang.Object $users = this.getUsers();
    result = result * PRIME + ($users == null ? 43 : $users.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "WeaviatePermission(action=" + this.getAction() + ", backups=" + this.getBackups() + ", collections=" + this.getCollections() + ", data=" + this.getData() + ", nodes=" + this.getNodes() + ", roles=" + this.getRoles() + ", tenants=" + this.getTenants() + ", users=" + this.getUsers() + ")";
  }
}
