/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class Config {
    private static final int DEFAULT_TIMEOUT_SECONDS = 60;
    private final String scheme;
    private final String host;
    private final String version;
    private final Map<String, String> headers = new HashMap<String, String>();
    private final int connectionTimeout;
    private final int connectionRequestTimeout;
    private final int socketTimeout;
    private String proxyHost;
    private int proxyPort;
    private String proxyScheme;
    private boolean gRPCSecured;
    private String gRPCHost;

    public Config(String scheme, String host) {
        this(scheme, host, null, 60, 60, 60);
    }

    public Config(String scheme, String host, boolean gRPCSecured, String gRPCHost) {
        this(scheme, host, null, 60, gRPCSecured, gRPCHost);
    }

    public Config(String scheme, String host, Map<String, String> headers) {
        this(scheme, host, headers, 60, 60, 60);
    }

    public Config(String scheme, String host, boolean gRPCSecured, String gRPCHost, Map<String, String> headers) {
        this(scheme, host, headers, 60, gRPCSecured, gRPCHost);
    }

    public Config(String scheme, String host, Map<String, String> headers, int connectionTimeout, int connectionRequestTimeout, int socketTimeout) {
        this.scheme = scheme;
        this.host = host;
        this.version = "v1";
        this.setHeaders(headers);
        this.connectionTimeout = connectionTimeout;
        this.connectionRequestTimeout = connectionRequestTimeout;
        this.socketTimeout = socketTimeout;
    }

    public Config(String scheme, String host, Map<String, String> headers, int timeout) {
        this(scheme, host, headers, timeout, false, null);
    }

    public Config(String scheme, String host, Map<String, String> headers, int timeout, boolean gRPCSecured, String gRPCHost) {
        this.scheme = scheme;
        this.host = host;
        this.version = "v1";
        this.setHeaders(headers);
        this.connectionTimeout = timeout;
        this.connectionRequestTimeout = timeout;
        this.socketTimeout = timeout;
        this.gRPCSecured = gRPCSecured;
        this.gRPCHost = gRPCHost;
    }

    public String getBaseURL() {
        return this.scheme + "://" + this.host + "/" + this.version;
    }

    public void setProxy(String proxyHost, int proxyPort, String proxyScheme) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyScheme = proxyScheme;
    }

    public boolean useGRPC() {
        return this.gRPCHost != null && !this.gRPCHost.trim().isEmpty();
    }

    void setHeader(String key, String value) {
        this.headers.put(key, value);
    }

    void setHeaders(Map<String, String> headers) {
        if (headers != null) {
            this.headers.putAll(headers);
        }
    }

    @Generated
    public String getScheme() {
        return this.scheme;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Generated
    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    @Generated
    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    @Generated
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Generated
    public int getProxyPort() {
        return this.proxyPort;
    }

    @Generated
    public String getProxyScheme() {
        return this.proxyScheme;
    }

    @Generated
    public boolean isGRPCSecured() {
        return this.gRPCSecured;
    }

    @Generated
    public void setGRPCSecured(boolean gRPCSecured) {
        this.gRPCSecured = gRPCSecured;
    }

    @Generated
    public String getGRPCHost() {
        return this.gRPCHost;
    }

    @Generated
    public void setGRPCHost(String gRPCHost) {
        this.gRPCHost = gRPCHost;
    }
}

