/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.async.classifications.api;

import io.weaviate.client.Config;
import io.weaviate.client.base.AsyncBaseClient;
import io.weaviate.client.base.AsyncClientResult;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.util.Futures;
import io.weaviate.client.v1.async.classifications.api.Getter;
import io.weaviate.client.v1.auth.provider.AccessTokenProvider;
import io.weaviate.client.v1.classifications.model.Classification;
import io.weaviate.client.v1.classifications.model.ClassificationFilters;
import io.weaviate.client.v1.filters.WhereFilter;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;

public class Scheduler
extends AsyncBaseClient<Classification>
implements AsyncClientResult<Classification> {
    private static final long WAIT_INTERVAL = 2000L;
    private String classificationType;
    private String className;
    private String[] classifyProperties;
    private String[] basedOnProperties;
    private WhereFilter sourceWhereFilter;
    private WhereFilter trainingSetWhereFilter;
    private WhereFilter targetWhereFilter;
    private boolean waitForCompletion;
    private Object settings;
    private final Getter getter;
    private final Executor executor;

    public Scheduler(CloseableHttpAsyncClient client, Config config, AccessTokenProvider tokenProvider, Getter getter, Executor executor) {
        super(client, config, tokenProvider);
        this.getter = getter;
        this.executor = executor;
    }

    public Scheduler withType(String classificationType) {
        this.classificationType = classificationType;
        return this;
    }

    public Scheduler withClassName(String className) {
        this.className = className;
        return this;
    }

    public Scheduler withClassifyProperties(String[] classifyProperties) {
        this.classifyProperties = classifyProperties;
        return this;
    }

    public Scheduler withBasedOnProperties(String[] basedOnProperties) {
        this.basedOnProperties = basedOnProperties;
        return this;
    }

    public Scheduler withSourceWhereFilter(WhereFilter whereFilter) {
        this.sourceWhereFilter = whereFilter;
        return this;
    }

    public Scheduler withTrainingSetWhereFilter(WhereFilter whereFilter) {
        this.trainingSetWhereFilter = whereFilter;
        return this;
    }

    public Scheduler withTargetWhereFilter(WhereFilter whereFilter) {
        this.targetWhereFilter = whereFilter;
        return this;
    }

    public Scheduler withSettings(Object settings) {
        this.settings = settings;
        return this;
    }

    public Scheduler withWaitForCompletion() {
        this.waitForCompletion = true;
        return this;
    }

    @Override
    public Future<Result<Classification>> run(FutureCallback<Result<Classification>> callback) {
        if (this.waitForCompletion) {
            return this.scheduleAndWaitForCompletion(callback);
        }
        return this.schedule(callback);
    }

    private Future<Result<Classification>> schedule(FutureCallback<Result<Classification>> callback) {
        Classification config = Classification.builder().basedOnProperties(this.basedOnProperties).className(this.className).classifyProperties(this.classifyProperties).type(this.classificationType).settings(this.settings).filters(this.getClassificationFilters(this.sourceWhereFilter, this.targetWhereFilter, this.trainingSetWhereFilter)).build();
        return this.sendPostRequest("/classifications", (Object)config, Classification.class, callback);
    }

    private Future<Result<Classification>> scheduleAndWaitForCompletion(final FutureCallback<Result<Classification>> callback) {
        final CompletableFuture future = new CompletableFuture();
        FutureCallback<Result<Classification>> internalCallback = new FutureCallback<Result<Classification>>(){

            public void completed(Result<Classification> classificationResult) {
                future.complete(classificationResult);
            }

            public void failed(Exception e) {
                future.completeExceptionally(e);
            }

            public void cancelled() {
                future.cancel(true);
                if (callback != null) {
                    callback.cancelled();
                }
            }
        };
        this.schedule(internalCallback);
        return ((CompletableFuture)future.thenCompose(classificationResult -> {
            if (classificationResult.hasErrors()) {
                return CompletableFuture.completedFuture(classificationResult);
            }
            return this.getByIdRecursively(((Classification)classificationResult.getResult()).getId());
        })).whenComplete((classificationResult, throwable) -> {
            if (callback != null) {
                if (throwable != null) {
                    callback.failed((Exception)throwable);
                } else {
                    callback.completed(classificationResult);
                }
            }
        });
    }

    private CompletableFuture<Result<Classification>> getById(String id) {
        final CompletableFuture<Result<Classification>> future = new CompletableFuture<Result<Classification>>();
        this.getter.withID(id).run(new FutureCallback<Result<Classification>>(){

            public void completed(Result<Classification> classificationResult) {
                future.complete(classificationResult);
            }

            public void failed(Exception e) {
                future.completeExceptionally(e);
            }

            public void cancelled() {
            }
        });
        return future;
    }

    private CompletableFuture<Result<Classification>> getByIdRecursively(String id) {
        return Futures.thenComposeAsync(this.getById(id), classificationResult -> {
            boolean isRunning = Optional.ofNullable(classificationResult).map(Result::getResult).map(Classification::getStatus).filter(status -> status.equals("running")).isPresent();
            if (isRunning) {
                try {
                    return Futures.supplyDelayed(() -> this.getByIdRecursively(id), 2000L, this.executor);
                }
                catch (InterruptedException e) {
                    throw new CompletionException(e);
                }
            }
            return CompletableFuture.completedFuture(classificationResult);
        }, this.executor);
    }

    private ClassificationFilters getClassificationFilters(WhereFilter sourceWhere, WhereFilter targetWhere, WhereFilter trainingSetWhere) {
        if (ObjectUtils.anyNotNull((Object[])new Object[]{sourceWhere, targetWhere, trainingSetWhere})) {
            return ClassificationFilters.builder().sourceWhere(sourceWhere).targetWhere(targetWhere).trainingSetWhere(trainingSetWhere).build();
        }
        return null;
    }
}

