/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.schema.api;

import io.weaviate.client.base.Result;
import io.weaviate.client.base.WeaviateErrorMessage;
import io.weaviate.client.base.WeaviateErrorResponse;
import io.weaviate.client.v1.schema.api.ClassDeleter;
import io.weaviate.client.v1.schema.api.SchemaGetter;
import io.weaviate.client.v1.schema.model.Schema;
import io.weaviate.client.v1.schema.model.WeaviateClass;
import java.util.List;
import java.util.stream.Collectors;

public class SchemaDeleter {
    private SchemaGetter schemaGetter;
    private ClassDeleter classDeleter;

    public SchemaDeleter(SchemaGetter schemaGetter, ClassDeleter classDeleter) {
        this.schemaGetter = schemaGetter;
        this.classDeleter = classDeleter;
    }

    public Result<Boolean> run() {
        Result<Schema> schema = this.schemaGetter.run();
        if (schema.getError() != null) {
            List<WeaviateErrorMessage> errorMessages = schema.getError().getMessages().stream().map(err -> WeaviateErrorMessage.builder().message(err.getMessage()).build()).collect(Collectors.toList());
            WeaviateErrorResponse errors = WeaviateErrorResponse.builder().error(errorMessages).build();
            return new Result<Boolean>(schema.getError().getStatusCode(), false, errors);
        }
        if (schema.getError() == null) {
            List<WeaviateClass> weaviateClasses = schema.getResult().getClasses();
            for (WeaviateClass clazz : weaviateClasses) {
                Result<Boolean> result = this.classDeleter.withClassName(clazz.getClassName()).run();
                if (result.getError() == null) continue;
                return result;
            }
        }
        return new Result<Boolean>(200, true, null);
    }
}

