/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.base;

import io.weaviate.client.base.Response;
import io.weaviate.client.base.WeaviateError;
import io.weaviate.client.base.WeaviateErrorMessage;
import io.weaviate.client.base.WeaviateErrorResponse;
import io.weaviate.client.base.http.async.ResponseParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpResponse;

public class Result<T> {
    private final T result;
    private final WeaviateError error;

    public Result(Response<T> response) {
        this(response.getStatusCode(), response.getBody(), response.getErrors());
    }

    public Result(Response<?> response, T body) {
        this(response.getStatusCode(), body, response.getErrors());
    }

    public Result(int statusCode, T body, WeaviateErrorResponse errors) {
        if (errors != null && errors.getError() != null) {
            List<WeaviateErrorMessage> items = errors.getError().stream().filter(Objects::nonNull).collect(Collectors.toList());
            this.error = new WeaviateError(statusCode, items);
            this.result = body;
        } else if (errors != null && errors.getMessage() != null) {
            this.error = new WeaviateError(statusCode, Collections.singletonList(WeaviateErrorMessage.builder().message(errors.getMessage()).build()));
            this.result = body;
        } else {
            this.result = body;
            this.error = null;
        }
    }

    public boolean hasErrors() {
        return this.error != null;
    }

    public <C> Result<C> toErrorResult() {
        return new Result<Object>(this.error.getStatusCode(), null, WeaviateErrorResponse.builder().error(this.error.getMessages()).build());
    }

    public static <T, R> Result<R> map(Response<T> response, Function<T, R> map) {
        T body = response.getBody() != null ? (T)map.apply(response.getBody()) : null;
        return new Result<Object>(response, body);
    }

    public static <T, R> ResponseParser<R> mapParser(final Class<T> cls, final Function<T, R> map) {
        return new ResponseParser<R>(){

            @Override
            public Result<R> parse(HttpResponse response, String body, ContentType contentType) {
                Response resp = this.serializer.toResponse(response.getCode(), body, cls);
                return Result.map(resp, map);
            }
        };
    }

    public static <T> Result<List<T>> toList(Response<T[]> response) {
        return new Result<List<T>>(response, Arrays.asList(response.getBody()));
    }

    public static <T> ResponseParser<List<T>> toListParser(final Class<T[]> cls) {
        return new ResponseParser<List<T>>(){

            @Override
            public Result<List<T>> parse(HttpResponse response, String body, ContentType contentType) {
                Response<T[]> resp = this.serializer.toResponse(response.getCode(), body, cls);
                return Result.toList(resp);
            }
        };
    }

    public static Result<Boolean> voidToBoolean(Response<Void> response) {
        int status;
        return new Result<Boolean>(status, (status = response.getStatusCode()) <= 299, response.getErrors());
    }

    public static Result<Boolean> voidToBoolean(Response<Void> response, int ... allowCodes) {
        Integer status = response.getStatusCode();
        boolean isCodeAllowed = Arrays.stream(allowCodes).anyMatch(status::equals);
        if (status <= 299) {
            return new Result<Boolean>(status, true, null);
        }
        return new Result<Boolean>(status, false, isCodeAllowed ? null : response.getErrors());
    }

    public static ResponseParser<Boolean> voidToBooleanParser() {
        return new ResponseParser<Boolean>(){

            @Override
            public Result<Boolean> parse(HttpResponse response, String body, ContentType contentType) {
                Response<Void> resp = this.serializer.toResponse(response.getCode(), body, Void.class);
                return Result.voidToBoolean(resp);
            }
        };
    }

    public static ResponseParser<Boolean> voidToBooleanParser(final int ... allowCodes) {
        return new ResponseParser<Boolean>(){

            @Override
            public Result<Boolean> parse(HttpResponse response, String body, ContentType contentType) {
                Response<Void> resp = this.serializer.toResponse(response.getCode(), body, Void.class);
                return Result.voidToBoolean(resp, allowCodes);
            }
        };
    }

    public static <T> ResponseParser<List<T>> arrayToListParser(Class<T[]> cls) {
        return Result.arrayToListParser(cls, Function.identity());
    }

    public static <T, R> ResponseParser<List<R>> arrayToListParser(final Class<T[]> cls, final Function<? super T, ? extends R> mapper) {
        return new ResponseParser<List<R>>(){

            @Override
            public Result<List<R>> parse(HttpResponse response, String body, ContentType contentType) {
                Response resp = this.serializer.toResponse(response.getCode(), body, cls);
                List roles = ((List)Optional.ofNullable((Object[])resp.getBody()).map(Arrays::asList).orElse(new ArrayList())).stream().map(mapper).collect(Collectors.toList());
                return new Result(resp.getStatusCode(), roles, resp.getErrors());
            }
        };
    }

    @Generated
    public T getResult() {
        return this.result;
    }

    @Generated
    public WeaviateError getError() {
        return this.error;
    }

    @Generated
    public String toString() {
        return "Result(result=" + this.getResult() + ", error=" + this.getError() + ")";
    }
}

