/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.async.aliases.api;

import io.weaviate.client.Config;
import io.weaviate.client.base.AsyncBaseClient;
import io.weaviate.client.base.AsyncClientResult;
import io.weaviate.client.base.Response;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.http.async.ResponseParser;
import io.weaviate.client.v1.aliases.model.Alias;
import io.weaviate.client.v1.auth.provider.AccessTokenProvider;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpResponse;

public class AliasAllGetter
extends AsyncBaseClient<Map<String, Alias>>
implements AsyncClientResult<Map<String, Alias>> {
    private String className;

    public AliasAllGetter(CloseableHttpAsyncClient httpClient, Config config, AccessTokenProvider tokenProvider) {
        super(httpClient, config, tokenProvider);
    }

    public AliasAllGetter withClassName(String className) {
        this.className = className;
        return this;
    }

    @Override
    public Future<Result<Map<String, Alias>>> run(FutureCallback<Result<Map<String, Alias>>> callback) {
        String path = "/aliases" + (this.className != null ? "?class=" + this.className : "");
        return this.sendGetRequest(path, callback, new ResponseParser<Map<String, Alias>>(){

            @Override
            public Result<Map<String, Alias>> parse(HttpResponse response, String body, ContentType contentType) {
                Response<ResponseBody> resp = this.serializer.toResponse(response.getCode(), body, ResponseBody.class);
                if (resp.getErrors() != null) {
                    return new Result<Object>(resp, null);
                }
                Map aliases = resp.getBody().aliases.stream().collect(Collectors.toMap(Alias::getAlias, Function.identity()));
                return new Result<Map<String, Alias>>(resp, aliases);
            }

            class ResponseBody {
                List<Alias> aliases;

                ResponseBody() {
                }
            }
        });
    }
}

