/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.cluster.api;

import com.google.gson.annotations.SerializedName;
import io.weaviate.client.Config;
import io.weaviate.client.base.BaseClient;
import io.weaviate.client.base.ClientResult;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.http.HttpClient;
import io.weaviate.client.v1.cluster.model.ReplicationType;
import lombok.Generated;

public class Replicator
extends BaseClient<ResponseBody>
implements ClientResult<String> {
    private String className;
    private String shard;
    private String sourceNode;
    private String targetNode;
    private ReplicationType replicationType;

    public Replicator(HttpClient httpClient, Config config) {
        super(httpClient, config);
    }

    public Replicator withClassName(String className) {
        this.className = className;
        return this;
    }

    public Replicator withShard(String shard) {
        this.shard = shard;
        return this;
    }

    public Replicator withSourceNode(String sourceNode) {
        this.sourceNode = sourceNode;
        return this;
    }

    public Replicator withTargetNode(String targetNode) {
        this.targetNode = targetNode;
        return this;
    }

    public Replicator withReplicationType(ReplicationType replicationType) {
        this.replicationType = replicationType;
        return this;
    }

    @Override
    public Result<String> run() {
        return Result.map(this.sendPostRequest("/replication/replicate", new RequestBody(), ResponseBody.class), ResponseBody::getReplicationId);
    }

    class RequestBody {
        @SerializedName(value="collection")
        String className;
        @SerializedName(value="shard")
        String shard;
        @SerializedName(value="sourceNode")
        String sourceNode;
        @SerializedName(value="targetNode")
        String targetNode;
        @SerializedName(value="type")
        ReplicationType replicationType;

        RequestBody() {
            this.className = Replicator.this.className;
            this.shard = Replicator.this.shard;
            this.sourceNode = Replicator.this.sourceNode;
            this.targetNode = Replicator.this.targetNode;
            this.replicationType = Replicator.this.replicationType;
        }
    }

    static class ResponseBody {
        @SerializedName(value="id")
        String replicationId;

        ResponseBody() {
        }

        @Generated
        public String getReplicationId() {
            return this.replicationId;
        }
    }
}

