/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.async.backup.api;

import com.google.gson.annotations.SerializedName;
import io.weaviate.client.Config;
import io.weaviate.client.base.AsyncBaseClient;
import io.weaviate.client.base.AsyncClientResult;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.WeaviateError;
import io.weaviate.client.base.WeaviateErrorMessage;
import io.weaviate.client.base.WeaviateErrorResponse;
import io.weaviate.client.base.util.Futures;
import io.weaviate.client.base.util.UrlEncoder;
import io.weaviate.client.v1.async.backup.api.BackupRestoreStatusGetter;
import io.weaviate.client.v1.auth.provider.AccessTokenProvider;
import io.weaviate.client.v1.backup.model.BackupRestoreResponse;
import io.weaviate.client.v1.backup.model.BackupRestoreStatusResponse;
import io.weaviate.client.v1.backup.model.RbacRestoreOption;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import lombok.Generated;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;

public class BackupRestorer
extends AsyncBaseClient<BackupRestoreResponse>
implements AsyncClientResult<BackupRestoreResponse> {
    private static final long WAIT_INTERVAL = 1000L;
    private final BackupRestoreStatusGetter statusGetter;
    private String[] includeClassNames;
    private String[] excludeClassNames;
    private String backend;
    private String backupId;
    private Boolean overwriteAlias;
    private BackupRestoreConfig config;
    private boolean waitForCompletion;
    private final Executor executor;

    public BackupRestorer(CloseableHttpAsyncClient client, Config config, AccessTokenProvider tokenProvider, BackupRestoreStatusGetter statusGetter, Executor executor) {
        super(client, config, tokenProvider);
        this.statusGetter = statusGetter;
        this.executor = executor;
    }

    public BackupRestorer withIncludeClassNames(String ... classNames) {
        this.includeClassNames = classNames;
        return this;
    }

    public BackupRestorer withExcludeClassNames(String ... classNames) {
        this.excludeClassNames = classNames;
        return this;
    }

    public BackupRestorer withBackend(String backend) {
        this.backend = backend;
        return this;
    }

    public BackupRestorer withConfig(BackupRestoreConfig config) {
        this.config = config;
        return this;
    }

    public BackupRestorer withBackupId(String backupId) {
        this.backupId = backupId;
        return this;
    }

    public BackupRestorer withWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    public BackupRestorer withOverwriteAlias(boolean overwriteAlias) {
        this.overwriteAlias = overwriteAlias;
        return this;
    }

    @Override
    public Future<Result<BackupRestoreResponse>> run(FutureCallback<Result<BackupRestoreResponse>> callback) {
        if (this.waitForCompletion) {
            return this.restoreAndWaitForCompletion(callback);
        }
        return this.restore(callback);
    }

    private Future<Result<BackupRestoreResponse>> restore(FutureCallback<Result<BackupRestoreResponse>> callback) {
        BackupRestore payload = BackupRestore.builder().config(BackupRestoreConfig.builder().build()).include(this.includeClassNames).exclude(this.excludeClassNames).overwriteAlias(this.overwriteAlias).config(this.config).build();
        String path = String.format("/backups/%s/%s/restore", UrlEncoder.encodePathParam(this.backend), UrlEncoder.encodePathParam(this.backupId));
        return this.sendPostRequest(path, (Object)payload, BackupRestoreResponse.class, callback);
    }

    private Future<Result<BackupRestoreResponse>> restoreAndWaitForCompletion(final FutureCallback<Result<BackupRestoreResponse>> callback) {
        final CompletableFuture future = new CompletableFuture();
        FutureCallback<Result<BackupRestoreResponse>> internalCallback = new FutureCallback<Result<BackupRestoreResponse>>(){

            public void completed(Result<BackupRestoreResponse> backupRestoreResult) {
                future.complete(backupRestoreResult);
            }

            public void failed(Exception e) {
                future.completeExceptionally(e);
            }

            public void cancelled() {
                future.cancel(true);
                if (callback != null) {
                    callback.cancelled();
                }
            }
        };
        this.restore(internalCallback);
        return ((CompletableFuture)future.thenCompose(restoreResult -> {
            if (restoreResult.hasErrors()) {
                return CompletableFuture.completedFuture(restoreResult);
            }
            return this.getStatusRecursively(this.backend, this.backupId, (Result<BackupRestoreResponse>)restoreResult);
        })).whenComplete((restoreResult, throwable) -> {
            if (callback != null) {
                if (throwable != null) {
                    callback.failed((Exception)throwable);
                } else {
                    callback.completed(restoreResult);
                }
            }
        });
    }

    private CompletableFuture<Result<BackupRestoreStatusResponse>> getStatus(String backend, String backupId) {
        final CompletableFuture<Result<BackupRestoreStatusResponse>> future = new CompletableFuture<Result<BackupRestoreStatusResponse>>();
        this.statusGetter.withBackend(backend).withBackupId(backupId).run(new FutureCallback<Result<BackupRestoreStatusResponse>>(){

            public void completed(Result<BackupRestoreStatusResponse> createStatusResult) {
                future.complete(createStatusResult);
            }

            public void failed(Exception e) {
                future.completeExceptionally(e);
            }

            public void cancelled() {
            }
        });
        return future;
    }

    private CompletableFuture<Result<BackupRestoreResponse>> getStatusRecursively(String backend, String backupId, Result<BackupRestoreResponse> restoreResult) {
        return Futures.thenComposeAsync(this.getStatus(backend, backupId), restoreStatusResult -> {
            boolean isRunning = Optional.of(restoreStatusResult).filter(r -> !r.hasErrors()).map(Result::getResult).map(BackupRestoreStatusResponse::getStatus).filter(status -> {
                switch (status) {
                    case "SUCCESS": 
                    case "FAILED": {
                        return false;
                    }
                }
                return true;
            }).isPresent();
            if (isRunning) {
                try {
                    return Futures.supplyDelayed(() -> this.getStatusRecursively(backend, backupId, restoreResult), 1000L, this.executor);
                }
                catch (InterruptedException e) {
                    throw new CompletionException(e);
                }
            }
            return CompletableFuture.completedFuture(this.merge((Result<BackupRestoreStatusResponse>)restoreStatusResult, restoreResult));
        }, this.executor);
    }

    private Result<BackupRestoreResponse> merge(Result<BackupRestoreStatusResponse> restoreStatusResult, Result<BackupRestoreResponse> restoreResult) {
        BackupRestoreStatusResponse restoreStatusResponse = restoreStatusResult.getResult();
        BackupRestoreResponse restoreResponse = restoreResult.getResult();
        BackupRestoreResponse merged = null;
        int statusCode = 200;
        WeaviateErrorResponse errorResponse = null;
        if (restoreStatusResponse != null) {
            merged = new BackupRestoreResponse();
            merged.setId(restoreStatusResponse.getId());
            merged.setBackend(restoreStatusResponse.getBackend());
            merged.setPath(restoreStatusResponse.getPath());
            merged.setStatus(restoreStatusResponse.getStatus());
            merged.setError(restoreStatusResponse.getError());
            merged.setClassNames(restoreResponse.getClassNames());
        }
        if (restoreStatusResult.hasErrors()) {
            WeaviateError error = restoreStatusResult.getError();
            statusCode = error.getStatusCode();
            List<WeaviateErrorMessage> messages = error.getMessages();
            errorResponse = WeaviateErrorResponse.builder().code(statusCode).error(messages).build();
        }
        return new Result<BackupRestoreResponse>(statusCode, merged, errorResponse);
    }

    public static class BackupRestoreConfig {
        @SerializedName(value="CPUPercentage")
        Integer cpuPercentage;
        @SerializedName(value="Bucket")
        String bucket;
        @SerializedName(value="Path")
        String path;
        @SerializedName(value="usersOptions")
        RbacRestoreOption usersRestore;
        @SerializedName(value="rolesOptions")
        RbacRestoreOption rolesRestore;

        @Generated
        BackupRestoreConfig(Integer cpuPercentage, String bucket, String path, RbacRestoreOption usersRestore, RbacRestoreOption rolesRestore) {
            this.cpuPercentage = cpuPercentage;
            this.bucket = bucket;
            this.path = path;
            this.usersRestore = usersRestore;
            this.rolesRestore = rolesRestore;
        }

        @Generated
        public static BackupRestoreConfigBuilder builder() {
            return new BackupRestoreConfigBuilder();
        }

        @Generated
        public Integer getCpuPercentage() {
            return this.cpuPercentage;
        }

        @Generated
        public String getBucket() {
            return this.bucket;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public RbacRestoreOption getUsersRestore() {
            return this.usersRestore;
        }

        @Generated
        public RbacRestoreOption getRolesRestore() {
            return this.rolesRestore;
        }

        @Generated
        public static class BackupRestoreConfigBuilder {
            @Generated
            private Integer cpuPercentage;
            @Generated
            private String bucket;
            @Generated
            private String path;
            @Generated
            private RbacRestoreOption usersRestore;
            @Generated
            private RbacRestoreOption rolesRestore;

            @Generated
            BackupRestoreConfigBuilder() {
            }

            @Generated
            public BackupRestoreConfigBuilder cpuPercentage(Integer cpuPercentage) {
                this.cpuPercentage = cpuPercentage;
                return this;
            }

            @Generated
            public BackupRestoreConfigBuilder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            @Generated
            public BackupRestoreConfigBuilder path(String path) {
                this.path = path;
                return this;
            }

            @Generated
            public BackupRestoreConfigBuilder usersRestore(RbacRestoreOption usersRestore) {
                this.usersRestore = usersRestore;
                return this;
            }

            @Generated
            public BackupRestoreConfigBuilder rolesRestore(RbacRestoreOption rolesRestore) {
                this.rolesRestore = rolesRestore;
                return this;
            }

            @Generated
            public BackupRestoreConfig build() {
                return new BackupRestoreConfig(this.cpuPercentage, this.bucket, this.path, this.usersRestore, this.rolesRestore);
            }

            @Generated
            public String toString() {
                return "BackupRestorer.BackupRestoreConfig.BackupRestoreConfigBuilder(cpuPercentage=" + this.cpuPercentage + ", bucket=" + this.bucket + ", path=" + this.path + ", usersRestore=" + (Object)((Object)this.usersRestore) + ", rolesRestore=" + (Object)((Object)this.rolesRestore) + ")";
            }
        }
    }

    private static class BackupRestore {
        @SerializedName(value="config")
        BackupRestoreConfig config;
        @SerializedName(value="include")
        String[] include;
        @SerializedName(value="exclude")
        String[] exclude;
        @SerializedName(value="overwriteAlias")
        Boolean overwriteAlias;

        @Generated
        BackupRestore(BackupRestoreConfig config, String[] include, String[] exclude, Boolean overwriteAlias) {
            this.config = config;
            this.include = include;
            this.exclude = exclude;
            this.overwriteAlias = overwriteAlias;
        }

        @Generated
        public static BackupRestoreBuilder builder() {
            return new BackupRestoreBuilder();
        }

        @Generated
        public BackupRestoreConfig getConfig() {
            return this.config;
        }

        @Generated
        public String[] getInclude() {
            return this.include;
        }

        @Generated
        public String[] getExclude() {
            return this.exclude;
        }

        @Generated
        public Boolean getOverwriteAlias() {
            return this.overwriteAlias;
        }

        @Generated
        public static class BackupRestoreBuilder {
            @Generated
            private BackupRestoreConfig config;
            @Generated
            private String[] include;
            @Generated
            private String[] exclude;
            @Generated
            private Boolean overwriteAlias;

            @Generated
            BackupRestoreBuilder() {
            }

            @Generated
            public BackupRestoreBuilder config(BackupRestoreConfig config) {
                this.config = config;
                return this;
            }

            @Generated
            public BackupRestoreBuilder include(String[] include) {
                this.include = include;
                return this;
            }

            @Generated
            public BackupRestoreBuilder exclude(String[] exclude) {
                this.exclude = exclude;
                return this;
            }

            @Generated
            public BackupRestoreBuilder overwriteAlias(Boolean overwriteAlias) {
                this.overwriteAlias = overwriteAlias;
                return this;
            }

            @Generated
            public BackupRestore build() {
                return new BackupRestore(this.config, this.include, this.exclude, this.overwriteAlias);
            }

            @Generated
            public String toString() {
                return "BackupRestorer.BackupRestore.BackupRestoreBuilder(config=" + this.config + ", include=" + Arrays.deepToString(this.include) + ", exclude=" + Arrays.deepToString(this.exclude) + ", overwriteAlias=" + this.overwriteAlias + ")";
            }
        }
    }
}

