/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.async.groups.api.oidc;

import com.google.gson.annotations.SerializedName;
import io.weaviate.client.Config;
import io.weaviate.client.base.AsyncBaseClient;
import io.weaviate.client.base.AsyncClientResult;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.util.UrlEncoder;
import io.weaviate.client.v1.auth.provider.AccessTokenProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import lombok.Generated;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;

public class RoleRevoker
extends AsyncBaseClient<Boolean>
implements AsyncClientResult<Boolean> {
    private String groupId;
    private List<String> roles = new ArrayList<String>();

    public RoleRevoker(CloseableHttpAsyncClient httpClient, Config config, AccessTokenProvider tokenProvider) {
        super(httpClient, config, tokenProvider);
    }

    public RoleRevoker withGroupId(String id) {
        this.groupId = id;
        return this;
    }

    public RoleRevoker witRoles(String ... roles) {
        this.roles = Arrays.asList(roles);
        return this;
    }

    private String encodeGroupId() {
        return UrlEncoder.encode(this.groupId);
    }

    @Override
    public Future<Result<Boolean>> run(FutureCallback<Result<Boolean>> callback) {
        return this.sendPostRequest(this.path(), (Object)new Body(this.roles), callback, Result.voidToBooleanParser());
    }

    private String path() {
        return String.format("/authz/groups/%s/revoke", this.encodeGroupId());
    }

    private class Body {
        @SerializedName(value="roles")
        final List<String> roles;
        @SerializedName(value="groupType")
        final String groupType = "oidc";

        @Generated
        public Body(List<String> roles) {
            this.roles = roles;
        }
    }
}

