/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.backup.api;

import com.google.gson.annotations.SerializedName;
import io.weaviate.client.Config;
import io.weaviate.client.base.BaseClient;
import io.weaviate.client.base.ClientResult;
import io.weaviate.client.base.Response;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.http.HttpClient;
import io.weaviate.client.v1.backup.api.BackupRestoreStatusGetter;
import io.weaviate.client.v1.backup.model.BackupRestoreResponse;
import io.weaviate.client.v1.backup.model.BackupRestoreStatusResponse;
import io.weaviate.client.v1.backup.model.RbacRestoreOption;
import java.util.Arrays;
import lombok.Generated;

public class BackupRestorer
extends BaseClient<BackupRestoreResponse>
implements ClientResult<BackupRestoreResponse> {
    private static final long WAIT_INTERVAL = 1000L;
    private final BackupRestoreStatusGetter statusGetter;
    private String[] includeClassNames;
    private String[] excludeClassNames;
    private String backend;
    private String backupId;
    private Boolean overwriteAlias;
    private BackupRestoreConfig config;
    private boolean waitForCompletion;

    public BackupRestorer(HttpClient httpClient, Config config, BackupRestoreStatusGetter statusGetter) {
        super(httpClient, config);
        this.statusGetter = statusGetter;
    }

    public BackupRestorer withIncludeClassNames(String ... classNames) {
        this.includeClassNames = classNames;
        return this;
    }

    public BackupRestorer withExcludeClassNames(String ... classNames) {
        this.excludeClassNames = classNames;
        return this;
    }

    public BackupRestorer withBackend(String backend) {
        this.backend = backend;
        return this;
    }

    public BackupRestorer withOverwriteAlias(Boolean overwriteAlias) {
        this.overwriteAlias = overwriteAlias;
        return this;
    }

    public BackupRestorer withConfig(BackupRestoreConfig config) {
        this.config = config;
        return this;
    }

    @Deprecated
    public BackupRestorer backend(String backend) {
        return this.withBackend(backend);
    }

    public BackupRestorer withBackupId(String backupId) {
        this.backupId = backupId;
        return this;
    }

    public BackupRestorer withWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    @Override
    public Result<BackupRestoreResponse> run() {
        BackupRestore payload = BackupRestore.builder().include(this.includeClassNames).exclude(this.excludeClassNames).overwriteAlias(this.overwriteAlias).config(this.config).build();
        if (this.waitForCompletion) {
            return this.restoreAndWaitForCompletion(payload);
        }
        return this.restore(payload);
    }

    private Result<BackupRestoreResponse> restore(BackupRestore payload) {
        Response<BackupRestoreResponse> response = this.sendPostRequest(this.path(), payload, BackupRestoreResponse.class);
        return new Result<BackupRestoreResponse>(response);
    }

    private Result<BackupRestoreResponse> restoreAndWaitForCompletion(BackupRestore payload) {
        Result<BackupRestoreResponse> result = this.restore(payload);
        if (result.hasErrors()) {
            return result;
        }
        this.statusGetter.withBackend(this.backend).withBackupId(this.backupId);
        Response<BackupRestoreStatusResponse> statusResponse;
        while (!new Result<BackupRestoreStatusResponse>(statusResponse = this.statusGetter.statusRestore()).hasErrors()) {
            switch (statusResponse.getBody().getStatus()) {
                case "SUCCESS": 
                case "FAILED": {
                    return this.merge(statusResponse, result);
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return this.merge(statusResponse, result);
            }
        }
        return this.merge(statusResponse, result);
    }

    private String path() {
        return String.format("/backups/%s/%s/restore", this.backend, this.backupId);
    }

    private Result<BackupRestoreResponse> merge(Response<BackupRestoreStatusResponse> response, Result<BackupRestoreResponse> result) {
        BackupRestoreStatusResponse statusRestoreResponse = response.getBody();
        BackupRestoreResponse restoreResponse = result.getResult();
        BackupRestoreResponse merged = null;
        if (statusRestoreResponse != null) {
            merged = new BackupRestoreResponse();
            merged.setId(statusRestoreResponse.getId());
            merged.setBackend(statusRestoreResponse.getBackend());
            merged.setPath(statusRestoreResponse.getPath());
            merged.setStatus(statusRestoreResponse.getStatus());
            merged.setError(statusRestoreResponse.getError());
            merged.setClassNames(restoreResponse.getClassNames());
        }
        return new Result<BackupRestoreResponse>(response.getStatusCode(), merged, response.getErrors());
    }

    public static class BackupRestoreConfig {
        @SerializedName(value="CPUPercentage")
        Integer cpuPercentage;
        @SerializedName(value="Bucket")
        String bucket;
        @SerializedName(value="Path")
        String path;
        @SerializedName(value="usersOptions")
        RbacRestoreOption usersRestore;
        @SerializedName(value="rolesOptions")
        RbacRestoreOption rolesRestore;

        @Generated
        BackupRestoreConfig(Integer cpuPercentage, String bucket, String path, RbacRestoreOption usersRestore, RbacRestoreOption rolesRestore) {
            this.cpuPercentage = cpuPercentage;
            this.bucket = bucket;
            this.path = path;
            this.usersRestore = usersRestore;
            this.rolesRestore = rolesRestore;
        }

        @Generated
        public static BackupRestoreConfigBuilder builder() {
            return new BackupRestoreConfigBuilder();
        }

        @Generated
        public Integer getCpuPercentage() {
            return this.cpuPercentage;
        }

        @Generated
        public String getBucket() {
            return this.bucket;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public RbacRestoreOption getUsersRestore() {
            return this.usersRestore;
        }

        @Generated
        public RbacRestoreOption getRolesRestore() {
            return this.rolesRestore;
        }

        @Generated
        public static class BackupRestoreConfigBuilder {
            @Generated
            private Integer cpuPercentage;
            @Generated
            private String bucket;
            @Generated
            private String path;
            @Generated
            private RbacRestoreOption usersRestore;
            @Generated
            private RbacRestoreOption rolesRestore;

            @Generated
            BackupRestoreConfigBuilder() {
            }

            @Generated
            public BackupRestoreConfigBuilder cpuPercentage(Integer cpuPercentage) {
                this.cpuPercentage = cpuPercentage;
                return this;
            }

            @Generated
            public BackupRestoreConfigBuilder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            @Generated
            public BackupRestoreConfigBuilder path(String path) {
                this.path = path;
                return this;
            }

            @Generated
            public BackupRestoreConfigBuilder usersRestore(RbacRestoreOption usersRestore) {
                this.usersRestore = usersRestore;
                return this;
            }

            @Generated
            public BackupRestoreConfigBuilder rolesRestore(RbacRestoreOption rolesRestore) {
                this.rolesRestore = rolesRestore;
                return this;
            }

            @Generated
            public BackupRestoreConfig build() {
                return new BackupRestoreConfig(this.cpuPercentage, this.bucket, this.path, this.usersRestore, this.rolesRestore);
            }

            @Generated
            public String toString() {
                return "BackupRestorer.BackupRestoreConfig.BackupRestoreConfigBuilder(cpuPercentage=" + this.cpuPercentage + ", bucket=" + this.bucket + ", path=" + this.path + ", usersRestore=" + (Object)((Object)this.usersRestore) + ", rolesRestore=" + (Object)((Object)this.rolesRestore) + ")";
            }
        }
    }

    private static class BackupRestore {
        @SerializedName(value="config")
        BackupRestoreConfig config;
        @SerializedName(value="include")
        String[] include;
        @SerializedName(value="exclude")
        String[] exclude;
        @SerializedName(value="overwriteAlias")
        Boolean overwriteAlias;

        @Generated
        BackupRestore(BackupRestoreConfig config, String[] include, String[] exclude, Boolean overwriteAlias) {
            this.config = config;
            this.include = include;
            this.exclude = exclude;
            this.overwriteAlias = overwriteAlias;
        }

        @Generated
        public static BackupRestoreBuilder builder() {
            return new BackupRestoreBuilder();
        }

        @Generated
        public BackupRestoreConfig getConfig() {
            return this.config;
        }

        @Generated
        public String[] getInclude() {
            return this.include;
        }

        @Generated
        public String[] getExclude() {
            return this.exclude;
        }

        @Generated
        public Boolean getOverwriteAlias() {
            return this.overwriteAlias;
        }

        @Generated
        public static class BackupRestoreBuilder {
            @Generated
            private BackupRestoreConfig config;
            @Generated
            private String[] include;
            @Generated
            private String[] exclude;
            @Generated
            private Boolean overwriteAlias;

            @Generated
            BackupRestoreBuilder() {
            }

            @Generated
            public BackupRestoreBuilder config(BackupRestoreConfig config) {
                this.config = config;
                return this;
            }

            @Generated
            public BackupRestoreBuilder include(String[] include) {
                this.include = include;
                return this;
            }

            @Generated
            public BackupRestoreBuilder exclude(String[] exclude) {
                this.exclude = exclude;
                return this;
            }

            @Generated
            public BackupRestoreBuilder overwriteAlias(Boolean overwriteAlias) {
                this.overwriteAlias = overwriteAlias;
                return this;
            }

            @Generated
            public BackupRestore build() {
                return new BackupRestore(this.config, this.include, this.exclude, this.overwriteAlias);
            }

            @Generated
            public String toString() {
                return "BackupRestorer.BackupRestore.BackupRestoreBuilder(config=" + this.config + ", include=" + Arrays.deepToString(this.include) + ", exclude=" + Arrays.deepToString(this.exclude) + ", overwriteAlias=" + this.overwriteAlias + ")";
            }
        }
    }
}

