/*
 * Decompiled with CFR 0.152.
 */
package com.wepin.android.commonlib;

import com.wepin.android.commonlib.error.WepinError;
import com.wepin.android.commonlib.types.KeyType;
import java.math.BigInteger;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/wepin/android/commonlib/WepinCommon;", "", "()V", "Companion", "commonLib_release"})
public final class WepinCommon {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final Map<String, String> getWepinSdkUrl(@NotNull String appKey) {
        return Companion.getWepinSdkUrl(appKey);
    }

    @JvmStatic
    @NotNull
    public static final String getBalanceWithDecimal(@NotNull String balance, int decimals) {
        return Companion.getBalanceWithDecimal(balance, decimals);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001c\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\n\u001a\u00020\u0004H\u0007\u00a8\u0006\u000b"}, d2={"Lcom/wepin/android/commonlib/WepinCommon$Companion;", "", "()V", "getBalanceWithDecimal", "", "balance", "decimals", "", "getWepinSdkUrl", "", "appKey", "commonLib_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Map<String, String> getWepinSdkUrl(@NotNull String appKey) {
            Map map;
            Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
            KeyType keyType = KeyType.Companion.fromAppKey(appKey);
            switch (keyType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[keyType.ordinal()]) {
                case 1: {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"wepinWebview", (Object)"https://dev-v1-widget.wepin.io/"), TuplesKt.to((Object)"sdkBackend", (Object)"https://dev-sdk.wepin.io/v1/"), TuplesKt.to((Object)"wallet", (Object)"https://dev-app.wepin.io/")};
                    map = MapsKt.mapOf((Pair[])pairArray);
                    break;
                }
                case 2: {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"wepinWebview", (Object)"https://stage-v1-widget.wepin.io/"), TuplesKt.to((Object)"sdkBackend", (Object)"https://stage-sdk.wepin.io/v1/"), TuplesKt.to((Object)"wallet", (Object)"https://stage-app.wepin.io/")};
                    map = MapsKt.mapOf((Pair[])pairArray);
                    break;
                }
                case 3: {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"wepinWebview", (Object)"https://v1-widget.wepin.io/"), TuplesKt.to((Object)"sdkBackend", (Object)"https://sdk.wepin.io/v1/"), TuplesKt.to((Object)"wallet", (Object)"https://app.wepin.io/")};
                    map = MapsKt.mapOf((Pair[])pairArray);
                    break;
                }
                default: {
                    throw WepinError.Companion.getINVALID_APP_KEY();
                }
            }
            return map;
        }

        @JvmStatic
        @NotNull
        public final String getBalanceWithDecimal(@NotNull String balance, int decimals) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)balance, (String)"balance");
            if (decimals == 0 || ((CharSequence)balance).length() == 0) {
                return "0";
            }
            BigInteger balanceValue = new BigInteger(balance);
            BigInteger divisor = BigInteger.TEN.pow(decimals);
            BigInteger wholePart = balanceValue.divide(divisor);
            BigInteger fractionalPart = balanceValue.mod(divisor);
            int fractionalPartLength = divisor.toString().length() - 1;
            String string = fractionalPart.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            CharSequence charSequence2 = StringsKt.padStart((String)string, (int)fractionalPartLength, (char)'0');
            int n = 0;
            String string2 = charSequence2.substring(n, fractionalPartLength);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String fractionalPartString = string2;
            charSequence2 = fractionalPartString;
            Regex regex = new Regex("0+$");
            String string3 = "";
            fractionalPartString = regex.replace(charSequence2, string3);
            if (((CharSequence)fractionalPartString).length() == 0) {
                charSequence2 = wholePart.toString();
                Intrinsics.checkNotNull((Object)charSequence2);
                charSequence = charSequence2;
            } else {
                charSequence = wholePart + '.' + fractionalPartString;
            }
            return charSequence;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[KeyType.values().length];
                try {
                    nArray[KeyType.DEV.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[KeyType.STAGE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[KeyType.PROD.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

