package com.wepin.android.commonlib.types

import com.wepin.android.commonlib.error.WepinError

data class WepinUser(
    val status: String,
    val userInfo: WepinUserInfo?,
    val walletId: String?,
    val userStatus: WepinUserStatus?,
    val token: WepinToken?,
)

data class WepinUserInfo(
    val userId: String,
    val email: String,
    val provider: Providers,
    val use2FA: Boolean?,
)

data class WepinUserStatus(
    val loginStatus: WepinLoginStatus,
    val pinRequired: Boolean?,
)

data class WepinToken(
    val accessToken: String,
    val refreshToken: String,
)

enum class WepinLoginStatus(val value: String) {
    COMPLETE("complete"),
    PIN_REQUIRED("pinRequired"),
    REGISTER_REQUIRED("registerRequired");

    companion object {
        fun fromValue(value: String): WepinLoginStatus {
            return WepinLoginStatus.entries.find { it.value == value }
                ?: throw WepinError.generalUnKnownEx("Invalid Login Status : $value")
        }
    }
}