package com.wepin.android.commonlib

import com.wepin.android.commonlib.error.WepinError
import com.wepin.android.commonlib.types.KeyType
import java.math.BigInteger

class WepinCommon {

    companion object {
        @JvmStatic
        fun getWepinSdkUrl(appKey: String): Map<String, String> {
            return when (KeyType.fromAppKey(appKey)) {
                KeyType.DEV -> mapOf(
                    "wepinWebview" to "https://dev-v1-widget.wepin.io/",
                    "sdkBackend" to "https://dev-sdk.wepin.io/v1/",
                    "wallet" to "https://dev-app.wepin.io/"
                )

                KeyType.STAGE -> mapOf(
                    "wepinWebview" to "https://stage-v1-widget.wepin.io/",
                    "sdkBackend" to "https://stage-sdk.wepin.io/v1/",
                    "wallet" to "https://stage-app.wepin.io/"
                )

                KeyType.PROD -> mapOf(
                    "wepinWebview" to "https://v1-widget.wepin.io/",
                    "sdkBackend" to "https://sdk.wepin.io/v1/",
                    "wallet" to "https://app.wepin.io/"
                )

                else -> throw WepinError.INVALID_APP_KEY
            }
        }

        @JvmStatic
        fun getBalanceWithDecimal(balance: String, decimals: Int): String {
            if (decimals == 0 || balance.isEmpty()) return "0"

            val balanceValue = BigInteger(balance)
            val divisor = BigInteger.TEN.pow(decimals)

            val wholePart = balanceValue.divide(divisor)
            val fractionalPart = balanceValue.mod(divisor)

            // 필요한 만큼 소수 자릿수를 제한하거나 조정할 수 있습니다.
            val fractionalPartLength = divisor.toString().length - 1
            var fractionalPartString = fractionalPart.toString().padStart(fractionalPartLength, '0').substring(0, fractionalPartLength)

            // 소수점 이하의 값이 0인 경우 제거
            fractionalPartString = fractionalPartString.replace(Regex("0+$"), "")

            return if (fractionalPartString.isEmpty()) {
                wholePart.toString()
            } else {
                "$wholePart.$fractionalPartString"
            }
        }
    }
}