/*
 * Decompiled with CFR 0.152.
 */
package com.wepin.cm.loginlib;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import androidx.activity.ComponentActivity;
import androidx.annotation.RequiresApi;
import androidx.compose.runtime.internal.StabilityInferred;
import com.wepin.cm.loginlib.R;
import com.wepin.cm.loginlib.appAuth.LoginHelper;
import com.wepin.cm.loginlib.error.OauthErrorKt;
import com.wepin.cm.loginlib.error.WepinError;
import com.wepin.cm.loginlib.manager.WepinLoginManager;
import com.wepin.cm.loginlib.manager.WepinLoginResultManager;
import com.wepin.cm.loginlib.types.ErrorCode;
import com.wepin.cm.loginlib.types.LoginOauthResult;
import com.wepin.cm.loginlib.types.OAuthProviderInfo;
import com.wepin.cm.loginlib.types.OauthTokenParam;
import com.wepin.cm.loginlib.types.WepinLoginError;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import net.openid.appauth.AuthState;
import net.openid.appauth.AuthorizationException;
import net.openid.appauth.AuthorizationRequest;
import net.openid.appauth.AuthorizationResponse;
import net.openid.appauth.AuthorizationService;
import net.openid.appauth.AuthorizationServiceConfiguration;
import net.openid.appauth.TokenRequest;
import net.openid.appauth.TokenResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J \u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0015J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0003J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/wepin/cm/loginlib/WepinLoginMainActivity;", "Landroidx/activity/ComponentActivity;", "<init>", "()V", "RC_AUTH", "", "authService", "Lnet/openid/appauth/AuthorizationService;", "authState", "Lnet/openid/appauth/AuthState;", "wepinLoginManager", "Lcom/wepin/cm/loginlib/manager/WepinLoginManager;", "redirectUri", "Landroid/net/Uri;", "provider", "", "clientId", "token", "providerInfo", "Lcom/wepin/cm/loginlib/types/OAuthProviderInfo;", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "processLoginOauth2", "loginAppauth", "serviceConfig", "Lnet/openid/appauth/AuthorizationServiceConfiguration;", "onActivityResult", "requestCode", "resultCode", "data", "Landroid/content/Intent;", "getOauthToken", "resp", "Lnet/openid/appauth/AuthorizationResponse;", "getOauthTokenWithAppAuth", "tokenExchangeRequest", "Lnet/openid/appauth/TokenRequest;", "lib_release"})
@StabilityInferred(parameters=0)
public final class WepinLoginMainActivity
extends ComponentActivity {
    private final int RC_AUTH;
    @Nullable
    private AuthorizationService authService;
    @Nullable
    private AuthState authState;
    @NotNull
    private final WepinLoginManager wepinLoginManager = WepinLoginManager.Companion.getInstance();
    @Nullable
    private Uri redirectUri;
    @Nullable
    private String provider;
    @Nullable
    private String clientId;
    @Nullable
    private String token;
    @Nullable
    private OAuthProviderInfo providerInfo;
    public static final int $stable = 8;

    public WepinLoginMainActivity() {
        this.RC_AUTH = 100;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        try {
            Bundle bundle;
            Log.d((String)"WepinLoginMainActivity", (String)"onCreate");
            super.onCreate(savedInstanceState);
            this.getWindow().setBackgroundDrawableResource(17170445);
            this.setContentView(R.layout.activity_wepin_login_main);
            Bundle bundle2 = bundle = this.getIntent().getExtras();
            String string = this.provider = String.valueOf(bundle2 != null ? bundle2.getString("provider") : null);
            Intrinsics.checkNotNull((Object)string);
            this.providerInfo = this.wepinLoginManager.getOAuthProviderInfo(string);
            Bundle bundle3 = bundle;
            this.clientId = String.valueOf(bundle3 != null ? bundle3.getString("clientId") : null);
            this.redirectUri = Uri.parse((String)this.wepinLoginManager.getAppAuthRedirectUrl$lib_release());
            String string2 = this.provider;
            Intrinsics.checkNotNull((Object)string2);
            String string3 = this.clientId;
            Intrinsics.checkNotNull((Object)string3);
            this.processLoginOauth2(string2, string3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void processLoginOauth2(String provider, String clientId) {
        OAuthProviderInfo oAuthProviderInfo = this.providerInfo;
        Intrinsics.checkNotNull((Object)oAuthProviderInfo);
        Uri authUri = Uri.parse((String)oAuthProviderInfo.getAuthorizationEndpoint());
        OAuthProviderInfo oAuthProviderInfo2 = this.providerInfo;
        Intrinsics.checkNotNull((Object)oAuthProviderInfo2);
        Uri tokenUri = Uri.parse((String)oAuthProviderInfo2.getTokenEndpoint());
        AuthorizationServiceConfiguration serviceConfig = new AuthorizationServiceConfiguration(authUri, tokenUri);
        this.authState = new AuthState(serviceConfig);
        this.loginAppauth(serviceConfig, clientId, provider);
    }

    private final void loginAppauth(AuthorizationServiceConfiguration serviceConfig, String clientId, String provider) {
        if (this.redirectUri == null) {
            WepinLoginResultManager wepinLoginResultManager = this.wepinLoginManager.getLoginResultManager$lib_release();
            Intrinsics.checkNotNull((Object)wepinLoginResultManager);
            wepinLoginResultManager.getLoginOauthCompletableFuture$lib_release().completeExceptionally(WepinError.Companion.generalUnKnownEx("invalid rediract uri"));
        }
        Uri uri = this.redirectUri;
        Intrinsics.checkNotNull((Object)uri);
        AuthorizationRequest.Builder builder = new AuthorizationRequest.Builder(serviceConfig, clientId, "code", uri);
        if (Intrinsics.areEqual((Object)provider, (Object)"apple")) {
            builder.setResponseMode("form_post");
        }
        builder.setPrompt("select_account");
        AuthorizationRequest authorizationRequest = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)authorizationRequest, (String)"build(...)");
        AuthorizationRequest authRequest = authorizationRequest;
        AuthorizationService authorizationService = this.authService = new AuthorizationService((Context)this);
        Intrinsics.checkNotNull((Object)authorizationService);
        Intent authIntent = authorizationService.getAuthorizationRequestIntent(authRequest);
        if (authIntent != null) {
            this.startActivityForResult(authIntent, this.RC_AUTH);
        }
    }

    @Deprecated(message="Deprecated in Java")
    @RequiresApi(value=31)
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        AuthorizationService authorizationService;
        super.onActivityResult(requestCode, resultCode, data);
        Log.d((String)"WepinLoginMainActivity", (String)"WepinLoginMainActivity - onActivityResult ");
        Log.d((String)"WepinLoginMainActivity", (String)("resCode " + requestCode));
        if (requestCode == this.RC_AUTH) {
            Intent intent = data;
            Intrinsics.checkNotNull((Object)intent);
            AuthorizationResponse resp = AuthorizationResponse.fromIntent((Intent)intent);
            AuthorizationException ex = AuthorizationException.fromIntent((Intent)data);
            Log.d((String)"WepinLoginMainActivity", (String)("WepinLoginMainActivity - onActivityResult - resp " + resp));
            AuthorizationResponse authorizationResponse = resp;
            Log.d((String)"WepinLoginMainActivity", (String)("WepinLoginMainActivity - onActivityResult - resp " + (authorizationResponse != null ? authorizationResponse.authorizationCode : null)));
            Log.d((String)"WepinLoginMainActivity", (String)("WepinLoginMainActivity - onActivityResult - ex " + ex));
            this.authState = new AuthState(resp, ex);
            if (ex != null) {
                Log.d((String)"WepinLoginMainActivity", (String)("provider exception = " + ex.getMessage()));
                String code = OauthErrorKt.getOauthErrorCode(ex, "authorization_fail");
                String message = OauthErrorKt.getOauthErrorMessage(ex);
                WepinLoginResultManager wepinLoginResultManager = this.wepinLoginManager.getLoginResultManager$lib_release();
                Intrinsics.checkNotNull((Object)wepinLoginResultManager);
                wepinLoginResultManager.getLoginOauthCompletableFuture$lib_release().completeExceptionally(new WepinError(WepinError.Companion.getFAILED_LOGIN().getCode(), code + " - " + message));
            } else if (resp == null) {
                WepinLoginResultManager wepinLoginResultManager = this.wepinLoginManager.getLoginResultManager$lib_release();
                Intrinsics.checkNotNull((Object)wepinLoginResultManager);
                wepinLoginResultManager.getLoginOauthCompletableFuture$lib_release().completeExceptionally(new WepinError(WepinLoginError.getError$default(WepinLoginError.INSTANCE, ErrorCode.FAILED_LOGIN, null, 2, null)));
            } else {
                this.getOauthToken(resp);
            }
        }
        if ((authorizationService = this.authService) != null && (authorizationService = authorizationService.getCustomTabManager()) != null) {
            authorizationService.dispose();
        }
        this.finish();
    }

    @RequiresApi(value=31)
    private final void getOauthToken(AuthorizationResponse resp) {
        TokenRequest tokenRequest = resp.createTokenExchangeRequest();
        Intrinsics.checkNotNullExpressionValue((Object)tokenRequest, (String)"createTokenExchangeRequest(...)");
        TokenRequest tokenExchangeRequest = tokenRequest;
        if (Intrinsics.areEqual((Object)this.provider, (Object)"discord")) {
            this.getOauthTokenWithAppAuth(tokenExchangeRequest);
        } else {
            String string = this.provider;
            Intrinsics.checkNotNull((Object)string);
            String string2 = this.clientId;
            Intrinsics.checkNotNull((Object)string2);
            String string3 = tokenExchangeRequest.codeVerifier;
            String string4 = resp.authorizationCode;
            Intrinsics.checkNotNull((Object)string4);
            OauthTokenParam param = new OauthTokenParam(string, string2, string3, string4, resp.state);
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, param, null){
                int label;
                final /* synthetic */ WepinLoginMainActivity this$0;
                final /* synthetic */ OauthTokenParam $param;
                {
                    this.this$0 = $receiver;
                    this.$param = $param;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    block5: {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                v0 = WepinLoginMainActivity.access$getWepinLoginManager$p(this.this$0).getLoginHelper$lib_release();
                                if (v0 == null) break;
                                this.label = 1;
                                v1 = v0.getOauthTokenWithWepin(this.$param, (Continuation<? super LoginOauthResult>)((Continuation)this));
                                if (v1 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl15
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl15:
                                // 2 sources

                                v2 = (LoginOauthResult)v1;
                                break block5;
                            }
                        }
                        v2 = null;
                    }
                    result = v2;
                    v3 = WepinLoginMainActivity.access$getWepinLoginManager$p(this.this$0).getLoginResultManager$lib_release();
                    Intrinsics.checkNotNull((Object)v3);
                    v3.getLoginOauthCompletableFuture$lib_release().complete(result);
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    private final void getOauthTokenWithAppAuth(TokenRequest tokenExchangeRequest) {
        block0: {
            Log.d((String)"WepinLoginMainActivity", (String)("WepinLoginMainActivity - onActivityResult - tokenExchangeRequest " + tokenExchangeRequest));
            AuthorizationService authorizationService = this.authService;
            if (authorizationService == null) break block0;
            authorizationService.performTokenRequest(tokenExchangeRequest, (arg_0, arg_1) -> WepinLoginMainActivity.getOauthTokenWithAppAuth$lambda$2(this, arg_0, arg_1));
        }
    }

    private static final void getOauthTokenWithAppAuth$lambda$2(WepinLoginMainActivity this$0, TokenResponse response, AuthorizationException exception) {
        block19: {
            LoginOauthResult loginOauthResult;
            block20: {
                TokenResponse tokenResponse = response;
                Log.d((String)"WepinLoginMainActivity", (String)("onActivityResult - response-accessToken " + (tokenResponse != null ? tokenResponse.accessToken : null)));
                TokenResponse tokenResponse2 = response;
                Log.d((String)"WepinLoginMainActivity", (String)("onActivityResult - response-idToken " + (tokenResponse2 != null ? tokenResponse2.idToken : null)));
                if (exception != null) {
                    Log.d((String)"WepinLoginMainActivity", (String)("provider exception = " + exception.getMessage()));
                    String code = OauthErrorKt.getOauthErrorCode(exception, "token_auth_error");
                    String message = OauthErrorKt.getOauthErrorMessage(exception);
                    throw new WepinError(WepinError.Companion.getFAILED_LOGIN().getCode(), code + " - " + message);
                }
                if (response == null) break block19;
                Log.d((String)"WepinLoginMainActivity", (String)("provider = " + this$0.provider));
                String code = this$0.provider;
                if (code == null) break block20;
                int n = -1;
                switch (code.hashCode()) {
                    case 93029210: {
                        if (code.equals("apple")) {
                            n = 1;
                        }
                        break;
                    }
                    case 1671380268: {
                        if (code.equals("discord")) {
                            n = 2;
                        }
                        break;
                    }
                    case -1240244679: {
                        if (code.equals("google")) {
                            n = 1;
                        }
                        break;
                    }
                    case 104593680: {
                        if (code.equals("naver")) {
                            n = 2;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        this$0.token = response.idToken;
                        break;
                    }
                    case 2: {
                        this$0.token = response.accessToken;
                    }
                }
            }
            String string = this$0.token;
            if (string != null) {
                String it = string;
                boolean bl = false;
                String string2 = this$0.provider;
                if (string2 != null) {
                    String it1 = string2;
                    boolean bl2 = false;
                    LoginHelper loginHelper = this$0.wepinLoginManager.getLoginHelper$lib_release();
                    loginOauthResult = loginHelper != null ? loginHelper.onWepinOauthLoginResult(it1, it) : null;
                } else {
                    loginOauthResult = null;
                }
            } else {
                loginOauthResult = null;
            }
            LoginOauthResult result2 = loginOauthResult;
            AuthState authState = this$0.authState;
            Intrinsics.checkNotNull((Object)authState);
            authState.update(response, null);
            WepinLoginResultManager wepinLoginResultManager = this$0.wepinLoginManager.getLoginResultManager$lib_release();
            Intrinsics.checkNotNull((Object)wepinLoginResultManager);
            wepinLoginResultManager.getLoginOauthCompletableFuture$lib_release().complete(result2);
        }
    }

    public static final /* synthetic */ WepinLoginManager access$getWepinLoginManager$p(WepinLoginMainActivity $this) {
        return $this.wepinLoginManager;
    }
}

