/*
 * Decompiled with CFR 0.152.
 */
package com.wepin.cm.loginlib.error;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.openid.appauth.AuthorizationException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0003\u00a8\u0006\u0007"}, d2={"getOauthErrorCode", "", "error", "Lnet/openid/appauth/AuthorizationException;", "defaultCode", "getOauthErrorMessage", "exception", "lib_release"})
public final class OauthErrorKt {
    @NotNull
    public static final String getOauthErrorCode(@NotNull AuthorizationException error, @NotNull String defaultCode) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)defaultCode, (String)"defaultCode");
        return switch (error.type) {
            case 0 -> {
                int var2_2 = error.code;
                if (var2_2 == AuthorizationException.GeneralErrors.NETWORK_ERROR.code) {
                    yield "network_error";
                }
                if (var2_2 == AuthorizationException.GeneralErrors.ID_TOKEN_PARSING_ERROR.code) {
                    yield "id_token_parsing_error";
                }
                if (var2_2 == AuthorizationException.GeneralErrors.JSON_DESERIALIZATION_ERROR.code) {
                    yield "json_deserialization_error";
                }
                if (var2_2 == AuthorizationException.GeneralErrors.SERVER_ERROR.code) {
                    yield "server_error";
                }
                if (var2_2 == AuthorizationException.GeneralErrors.ID_TOKEN_VALIDATION_ERROR.code) {
                    yield "id_token_validation_error";
                }
                if (var2_2 == AuthorizationException.GeneralErrors.INVALID_DISCOVERY_DOCUMENT.code) {
                    yield "invalid_discovery_document";
                }
                if (var2_2 == AuthorizationException.GeneralErrors.INVALID_REGISTRATION_RESPONSE.code) {
                    yield "invalid_registration_response";
                }
                if (var2_2 == AuthorizationException.GeneralErrors.PROGRAM_CANCELED_AUTH_FLOW.code) {
                    yield "user_canceled";
                }
                if (var2_2 == AuthorizationException.GeneralErrors.INVALID_REGISTRATION_RESPONSE.code) {
                    yield "invalid_registration_response";
                }
                if (var2_2 == AuthorizationException.GeneralErrors.TOKEN_RESPONSE_CONSTRUCTION_ERROR.code) {
                    yield "token_response_construction_error";
                }
                if (var2_2 == AuthorizationException.GeneralErrors.USER_CANCELED_AUTH_FLOW.code) {
                    yield "user_canceled";
                }
                yield defaultCode;
            }
            case 1 -> {
                int var2_3 = error.code;
                if (var2_3 == AuthorizationException.AuthorizationRequestErrors.SERVER_ERROR.code) {
                    yield "server_error";
                }
                if (var2_3 == AuthorizationException.AuthorizationRequestErrors.CLIENT_ERROR.code) {
                    yield "client_error";
                }
                if (var2_3 == AuthorizationException.AuthorizationRequestErrors.INVALID_REQUEST.code) {
                    yield "invalid_request";
                }
                if (var2_3 == AuthorizationException.AuthorizationRequestErrors.ACCESS_DENIED.code) {
                    yield "access_denied";
                }
                if (var2_3 == AuthorizationException.AuthorizationRequestErrors.INVALID_SCOPE.code) {
                    yield "invalid_scope";
                }
                if (var2_3 == AuthorizationException.AuthorizationRequestErrors.STATE_MISMATCH.code) {
                    yield "state_mismatch";
                }
                if (var2_3 == AuthorizationException.AuthorizationRequestErrors.TEMPORARILY_UNAVAILABLE.code) {
                    yield "temporarily_unavailable";
                }
                if (var2_3 == AuthorizationException.AuthorizationRequestErrors.UNAUTHORIZED_CLIENT.code) {
                    yield "unauthorized_client";
                }
                if (var2_3 == AuthorizationException.AuthorizationRequestErrors.UNSUPPORTED_RESPONSE_TYPE.code) {
                    yield "unsupported_response_type";
                }
                yield defaultCode;
            }
            case 2 -> {
                int var2_4 = error.code;
                if (var2_4 == AuthorizationException.TokenRequestErrors.CLIENT_ERROR.code) {
                    yield "client_error";
                }
                if (var2_4 == AuthorizationException.TokenRequestErrors.INVALID_REQUEST.code) {
                    yield "invalid_request";
                }
                if (var2_4 == AuthorizationException.TokenRequestErrors.INVALID_SCOPE.code) {
                    yield "invalid_scope";
                }
                if (var2_4 == AuthorizationException.TokenRequestErrors.UNAUTHORIZED_CLIENT.code) {
                    yield "unauthorized_client";
                }
                if (var2_4 == AuthorizationException.TokenRequestErrors.INVALID_CLIENT.code) {
                    yield "invalid_client";
                }
                if (var2_4 == AuthorizationException.TokenRequestErrors.INVALID_GRANT.code) {
                    yield "invalid_grant";
                }
                if (var2_4 == AuthorizationException.TokenRequestErrors.UNSUPPORTED_GRANT_TYPE.code) {
                    yield "unsupported_grant_type";
                }
                yield defaultCode;
            }
            case 4 -> {
                int var2_5 = error.code;
                if (var2_5 == AuthorizationException.RegistrationRequestErrors.CLIENT_ERROR.code) {
                    yield "client_error";
                }
                if (var2_5 == AuthorizationException.RegistrationRequestErrors.INVALID_REQUEST.code) {
                    yield "invalid_request";
                }
                if (var2_5 == AuthorizationException.RegistrationRequestErrors.INVALID_REDIRECT_URI.code) {
                    yield "invalid_redirect_url";
                }
                if (var2_5 == AuthorizationException.RegistrationRequestErrors.INVALID_CLIENT_METADATA.code) {
                    yield "invalid_client_metadata";
                }
                yield defaultCode;
            }
            case 3 -> "resource_server_authorization_error";
            default -> defaultCode;
        };
    }

    @NotNull
    public static final String getOauthErrorMessage(@NotNull AuthorizationException exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        String string = exception.getLocalizedMessage();
        if (string == null) {
            string = "Unknown error";
        }
        return string;
    }
}

