/*
 * Decompiled with CFR 0.152.
 */
package com.wepin.cm.loginlib.storage;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKey;
import com.wepin.cm.loginlib.storage.KeyStoreHelper;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0003\b\u0001\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0002J \u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u0001J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fJ\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fJ\u0006\u0010\u0016\u001a\u00020\tJ\u001c\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00182\u0006\u0010\u0010\u001a\u00020\u000fJ\"\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000f2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/wepin/cm/loginlib/storage/StorageManager;", "", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "sharedPreferences", "Landroidx/security/crypto/EncryptedSharedPreferences;", "initializeStorage", "", "isCorruptError", "", "throwable", "", "formatKey", "", "appId", "key", "write", "data", "read", "delete", "deleteAll", "readAll", "", "writeAll", "Companion", "lib_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nStorageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageManager.kt\ncom/wepin/cm/loginlib/storage/StorageManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,119:1\n1#2:120\n216#3,2:121\n*S KotlinDebug\n*F\n+ 1 StorageManager.kt\ncom/wepin/cm/loginlib/storage/StorageManager\n*L\n114#1:121,2\n*E\n"})
public final class StorageManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private EncryptedSharedPreferences sharedPreferences;
    public static final int $stable = 8;
    @NotNull
    private static final String PREFERENCE_NAME = "wepin_encrypted_preferences_v1";

    public StorageManager(@NotNull Context context) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (KeyStoreHelper.INSTANCE.initializeKeystore(context)) {
            context.getSharedPreferences(PREFERENCE_NAME, 0).edit().clear().apply();
        }
        try {
            this.initializeStorage(context);
        }
        catch (Exception error) {
            context.getSharedPreferences(PREFERENCE_NAME, 0).edit().clear().apply();
            this.initializeStorage(context);
        }
        Object object2 = this;
        try {
            StorageManager $this$_init__u24lambda_u240 = object2;
            boolean bl = false;
            EncryptedSharedPreferences encryptedSharedPreferences = $this$_init__u24lambda_u240.sharedPreferences;
            if (encryptedSharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
                encryptedSharedPreferences = null;
            }
            Map map = encryptedSharedPreferences.getAll();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getAll(...)");
            object = Result.constructor-impl((Object)map);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = Result.exceptionOrNull-impl((Object)object2);
        if (object != null) {
            Object object3 = object2;
            try {
                Object throwable = object;
                boolean bl = false;
                if (this.isCorruptError((Throwable)throwable)) {
                    this.deleteAll();
                }
                Object object4 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                Object object5 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
    }

    private final void initializeStorage(Context context) {
        MasterKey masterKey = new MasterKey.Builder(context).setKeyScheme(MasterKey.KeyScheme.AES256_GCM).build();
        Intrinsics.checkNotNullExpressionValue((Object)masterKey, (String)"build(...)");
        MasterKey masterKey2 = masterKey;
        SharedPreferences sharedPreferences = EncryptedSharedPreferences.create((Context)context, (String)PREFERENCE_NAME, (MasterKey)masterKey2, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
        Intrinsics.checkNotNull((Object)sharedPreferences, (String)"null cannot be cast to non-null type androidx.security.crypto.EncryptedSharedPreferences");
        this.sharedPreferences = (EncryptedSharedPreferences)sharedPreferences;
    }

    private final boolean isCorruptError(Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null) {
            return false;
        }
        String message = string;
        return Intrinsics.areEqual((Object)throwable.getClass().getSimpleName(), (Object)"InvalidProtocolBufferException") || StringsKt.contains((CharSequence)message, (CharSequence)"InvalidProtocolBufferException", (boolean)true) || StringsKt.contains((CharSequence)message, (CharSequence)"SharedPreferences corruption detected", (boolean)true) || StringsKt.contains((CharSequence)message, (CharSequence)"corrupt", (boolean)true);
    }

    private final String formatKey(String appId, String key) {
        String string = key;
        if (string == null) {
            string = "";
        }
        return appId + "_" + string;
    }

    public final void write(@NotNull String appId, @Nullable String key, @NotNull Object data) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String formattedKey = this.formatKey(appId, key);
        EncryptedSharedPreferences encryptedSharedPreferences = this.sharedPreferences;
        if (encryptedSharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            encryptedSharedPreferences = null;
        }
        encryptedSharedPreferences.edit().putString(formattedKey, data.toString()).apply();
    }

    @Nullable
    public final String read(@NotNull String appId, @Nullable String key) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Object object3 = this;
        try {
            StorageManager $this$read_u24lambda_u242 = object3;
            boolean bl = false;
            EncryptedSharedPreferences encryptedSharedPreferences = $this$read_u24lambda_u242.sharedPreferences;
            if (encryptedSharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
                encryptedSharedPreferences = null;
            }
            object2 = Result.constructor-impl((Object)encryptedSharedPreferences.getString($this$read_u24lambda_u242.formatKey(appId, key), null));
        }
        catch (Throwable throwable) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object3 = object2;
        object2 = Result.exceptionOrNull-impl((Object)object3);
        if (object2 == null) {
            object = object3;
        } else {
            Object object4;
            Object object5 = object3;
            try {
                Object throwable = object2;
                boolean bl = false;
                if (this.isCorruptError((Throwable)throwable)) {
                    this.deleteAll();
                }
                object4 = Result.constructor-impl(null);
            }
            catch (Throwable throwable) {
                object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object = object4;
        }
        object3 = object;
        return (String)(Result.isFailure-impl((Object)object3) ? null : object3);
    }

    public final void delete(@NotNull String appId, @Nullable String key) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        EncryptedSharedPreferences encryptedSharedPreferences = this.sharedPreferences;
        if (encryptedSharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            encryptedSharedPreferences = null;
        }
        encryptedSharedPreferences.edit().remove(this.formatKey(appId, key)).apply();
    }

    public final void deleteAll() {
        EncryptedSharedPreferences encryptedSharedPreferences = this.sharedPreferences;
        if (encryptedSharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            encryptedSharedPreferences = null;
        }
        encryptedSharedPreferences.edit().clear().apply();
    }

    @NotNull
    public final Map<String, String> readAll(@NotNull String appId) {
        Object object;
        Object object2;
        Object $this$readAll_u24lambda_u244;
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Object object3 = this;
        try {
            $this$readAll_u24lambda_u244 = object3;
            boolean bl = false;
            Map all = new LinkedHashMap();
            EncryptedSharedPreferences encryptedSharedPreferences = ((StorageManager)$this$readAll_u24lambda_u244).sharedPreferences;
            if (encryptedSharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
                encryptedSharedPreferences = null;
            }
            for (Map.Entry entry : encryptedSharedPreferences.getAll().entrySet()) {
                String keyWithPrefix = (String)entry.getKey();
                Intrinsics.checkNotNull((Object)keyWithPrefix);
                if (!StringsKt.startsWith$default((String)keyWithPrefix, (String)appId, (boolean)false, (int)2, null)) continue;
                String key = StringsKt.replaceFirst$default((String)keyWithPrefix, (String)(appId + "_"), (String)"", (boolean)false, (int)4, null);
                Map map = all;
                Object v = entry.getValue();
                String string = v != null ? v.toString() : null;
                map.put(key, string);
            }
            $this$readAll_u24lambda_u244 = Result.constructor-impl((Object)all);
        }
        catch (Throwable bl) {
            $this$readAll_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object3 = $this$readAll_u24lambda_u244;
        $this$readAll_u24lambda_u244 = Result.exceptionOrNull-impl((Object)object3);
        if ($this$readAll_u24lambda_u244 == null) {
            object2 = object3;
        } else {
            Object object4;
            Object bl = object3;
            try {
                Object throwable = $this$readAll_u24lambda_u244;
                boolean bl2 = false;
                if (this.isCorruptError((Throwable)throwable)) {
                    this.deleteAll();
                }
                object4 = Result.constructor-impl((Object)MapsKt.emptyMap());
            }
            catch (Throwable throwable) {
                object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object4;
        }
        object3 = object2;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
        if (throwable == null) {
            object = object3;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = MapsKt.emptyMap();
        }
        return (Map)object;
    }

    public final void writeAll(@NotNull String appId, @NotNull Map<String, ? extends Object> data) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        EncryptedSharedPreferences encryptedSharedPreferences = this.sharedPreferences;
        if (encryptedSharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferences");
            encryptedSharedPreferences = null;
        }
        SharedPreferences.Editor editor = encryptedSharedPreferences.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"edit(...)");
        SharedPreferences.Editor editor2 = editor;
        Map<String, ? extends Object> $this$forEach$iv = data;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends Object> element$iv;
            Map.Entry<String, ? extends Object> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            Object value = entry.getValue();
            editor2.putString(this.formatKey(appId, key), value.toString());
        }
        editor2.apply();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/wepin/cm/loginlib/storage/StorageManager$Companion;", "", "<init>", "()V", "PREFERENCE_NAME", "", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

