/*
 * Decompiled with CFR 0.152.
 */
package com.wepin.cm.loginlib.storage;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKey;
import com.wepin.cm.loginlib.storage.StorageManager;
import com.wepin.cm.loginlib.types.LoginResult;
import com.wepin.cm.loginlib.types.Providers;
import com.wepin.cm.loginlib.types.StorageDataType;
import com.wepin.cm.loginlib.types.Token;
import com.wepin.cm.loginlib.types.UserInfo;
import com.wepin.cm.loginlib.types.UserInfoDetails;
import com.wepin.cm.loginlib.types.UserStatus;
import com.wepin.cm.loginlib.types.WepinLoginStatus;
import com.wepin.cm.loginlib.types.WepinUser;
import com.wepin.cm.loginlib.types.network.LoginResponse;
import com.wepin.cm.loginlib.utils.UtilKt;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0005J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\fH\u0002J\u0019\u0010\u0012\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0014\u001a\u0002H\u0013\u00a2\u0006\u0002\u0010\u0015J\u001b\u0010\u0016\u001a\u0004\u0018\u0001H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010\u0018\u001a\u00020\fJ\u001e\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\b\u0010#\u001a\u0004\u0018\u00010$J!\u0010%\u001a\u00020\f\"\u0004\b\u0000\u0010\u00132\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u0002H\u0013\u00a2\u0006\u0002\u0010(J\u001b\u0010)\u001a\u0004\u0018\u0001H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010&\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010*\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010+J\u001a\u0010,\u001a\u00020\f2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010+J\u0018\u0010-\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010+H\u0002J\b\u0010.\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/wepin/cm/loginlib/storage/WepinStorageManager;", "", "<init>", "()V", "_appId", "", "PREV_PREFERENCE_NAME", "_prevStorage", "Landroidx/security/crypto/EncryptedSharedPreferences;", "_storage", "Lcom/wepin/cm/loginlib/storage/StorageManager;", "init", "", "context", "appId", "initializePrevStorage", "Landroid/content/Context;", "migrationOldStorage", "_encodeValue", "T", "value", "(Ljava/lang/Object;)Ljava/lang/String;", "_parseValue", "(Ljava/lang/String;)Ljava/lang/Object;", "deleteAllStorage", "setFirebaseUser", "idToken", "refreshToken", "providers", "Lcom/wepin/cm/loginlib/types/Providers;", "setWepinUser", "request", "Lcom/wepin/cm/loginlib/types/LoginResult;", "response", "Lcom/wepin/cm/loginlib/types/network/LoginResponse;", "getWepinUser", "Lcom/wepin/cm/loginlib/types/WepinUser;", "setStorage", "key", "data", "(Ljava/lang/String;Ljava/lang/Object;)V", "getStorage", "getAllStorage", "", "setAllStorage", "_prevStorageReadAll", "_prevDeleteAll", "lib_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nWepinStorageManager.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WepinStorageManager.android.kt\ncom/wepin/cm/loginlib/storage/WepinStorageManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,453:1\n216#2,2:454\n216#2,2:457\n1#3:456\n487#4,7:459\n477#4:466\n423#4:467\n1246#5,4:468\n*S KotlinDebug\n*F\n+ 1 WepinStorageManager.android.kt\ncom/wepin/cm/loginlib/storage/WepinStorageManager\n*L\n61#1:454,2\n330#1:457,2\n437#1:459,7\n438#1:466\n438#1:467\n438#1:468,4\n*E\n"})
public final class WepinStorageManager {
    @NotNull
    public static final WepinStorageManager INSTANCE = new WepinStorageManager();
    @NotNull
    private static String _appId = "";
    @NotNull
    private static final String PREV_PREFERENCE_NAME = "wepin_encrypted_preferences";
    private static EncryptedSharedPreferences _prevStorage;
    private static StorageManager _storage;
    public static final int $stable;

    private WepinStorageManager() {
    }

    public final void init(@NotNull Object context, @NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        _appId = appId;
        try {
            this.initializePrevStorage((Context)context);
        }
        catch (Exception error) {
            ((Context)context).getSharedPreferences(PREV_PREFERENCE_NAME + _appId, 0).edit().clear().apply();
            this.initializePrevStorage((Context)context);
        }
        _storage = new StorageManager((Context)context);
        this.migrationOldStorage();
    }

    private final void initializePrevStorage(Context context) {
        MasterKey masterKey = new MasterKey.Builder(context).setKeyScheme(MasterKey.KeyScheme.AES256_GCM).build();
        Intrinsics.checkNotNullExpressionValue((Object)masterKey, (String)"build(...)");
        MasterKey masterKey2 = masterKey;
        SharedPreferences sharedPreferences = EncryptedSharedPreferences.create((Context)context, (String)(PREV_PREFERENCE_NAME + _appId), (MasterKey)masterKey2, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
        Intrinsics.checkNotNull((Object)sharedPreferences, (String)"null cannot be cast to non-null type androidx.security.crypto.EncryptedSharedPreferences");
        _prevStorage = (EncryptedSharedPreferences)sharedPreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void migrationOldStorage() {
        try {
            Map<String, Object> oldStorage;
            Boolean migrationState = (Boolean)this.getStorage("migration");
            if (Intrinsics.areEqual((Object)migrationState, (Object)true)) {
                return;
            }
            Map<String, Object> map = oldStorage = this._prevStorageReadAll();
            if (map != null) {
                Map<String, Object> $this$forEach$iv = map;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, Object>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Object> element$iv;
                    Map.Entry<String, Object> entry = element$iv = iterator.next();
                    boolean bl = false;
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    INSTANCE.setStorage(key, value);
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.setStorage("migration", true);
            this._prevDeleteAll();
        }
    }

    @NotNull
    public final <T> String _encodeValue(T value) {
        String string;
        T t = value;
        if (t instanceof String || t instanceof Integer || t instanceof Double || t instanceof Boolean) {
            string = value.toString();
        } else if (t instanceof StorageDataType) {
            string = UtilKt.convertLocalStorageDataToJson((StorageDataType)value);
        } else {
            throw new IllegalArgumentException("Unsupported data type");
        }
        return string;
    }

    @Nullable
    public final <T> T _parseValue(@NotNull String value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Boolean primitiveValue = StringsKt.equals((String)value, (String)"true", (boolean)true) ? Boolean.valueOf(true) : (StringsKt.equals((String)value, (String)"false", (boolean)true) ? (Serializable)Boolean.valueOf(false) : (Serializable)(StringsKt.toIntOrNull((String)value) != null ? (Number)Integer.parseInt(value) : (Number)(StringsKt.toDoubleOrNull((String)value) != null ? Double.valueOf(Double.parseDouble(value)) : null)));
        try {
            Object object2;
            if (primitiveValue != null) {
                object2 = primitiveValue;
            } else {
                Object object3 = UtilKt.convertJsonToLocalStorageData(value);
                if (object3 == null) {
                    object3 = object2 = null;
                }
                if (object3 == null) {
                    object2 = value instanceof Object ? value : null;
                }
            }
            object = object2;
        }
        catch (Exception e) {
            object = value instanceof Object ? value : null;
        }
        return (T)object;
    }

    public final void deleteAllStorage() {
        StorageManager storageManager = _storage;
        if (storageManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_storage");
            storageManager = null;
        }
        storageManager.deleteAll();
        this.setStorage("migration", true);
    }

    public final void setFirebaseUser(@NotNull String idToken, @NotNull String refreshToken, @NotNull Providers providers) {
        Intrinsics.checkNotNullParameter((Object)idToken, (String)"idToken");
        Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
        Intrinsics.checkNotNullParameter((Object)((Object)providers), (String)"providers");
        this.deleteAllStorage();
        String string = providers.getValue();
        this.setStorage("firebase:wepin", new StorageDataType.FirebaseWepin(string, idToken, refreshToken));
    }

    public final void setWepinUser(@NotNull LoginResult request, @NotNull LoginResponse response) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.deleteAllStorage();
        String string = request.getToken().getIdToken();
        String string2 = request.getToken().getRefreshToken();
        String string3 = request.getProvider().getValue();
        this.setStorage("firebase:wepin", new StorageDataType.FirebaseWepin(string3, string, string2));
        this.setStorage("wepin:connectUser", new StorageDataType.WepinToken(response.getToken().getAccess(), response.getToken().getRefresh()));
        this.setStorage("user_id", response.getUserInfo().getUserId());
        this.setStorage("user_status", new StorageDataType.UserStatus(response.getLoginStatus(), Intrinsics.areEqual((Object)response.getLoginStatus(), (Object)"registerRequired") ? response.getPinRequired() : Boolean.valueOf(false)));
        if (!Intrinsics.areEqual((Object)response.getLoginStatus(), (Object)"pinRequired") && response.getWalletId() != null) {
            this.setStorage("wallet_id", response.getWalletId());
            String walletId = (String)this.getStorage("wallet_id");
            this.setStorage("user_info", new StorageDataType.UserInfo("success", new UserInfoDetails(response.getUserInfo().getUserId(), response.getUserInfo().getEmail(), request.getProvider().getValue(), response.getUserInfo().getUse2FA() >= 2), walletId));
        } else {
            StorageDataType.UserInfo userInfo = new StorageDataType.UserInfo("success", new UserInfoDetails(response.getUserInfo().getUserId(), response.getUserInfo().getEmail(), request.getProvider().getValue(), response.getUserInfo().getUse2FA() >= 2), null, 4, null);
            this.setStorage("user_info", userInfo);
        }
        this.setStorage("oauth_provider_pending", request.getProvider().getValue());
    }

    @Nullable
    public final WepinUser getWepinUser() {
        String walletId = (String)this.getStorage("wallet_id");
        StorageDataType userInfo = (StorageDataType)this.getStorage("user_info");
        StorageDataType wepinToken = (StorageDataType)this.getStorage("wepin:connectUser");
        StorageDataType userStatus = (StorageDataType)this.getStorage("user_status");
        if (userInfo == null || wepinToken == null || userStatus == null) {
            return null;
        }
        String wepinWallet = null;
        if (walletId != null) {
            wepinWallet = walletId;
        }
        UserInfoDetails userInfoDetails = ((StorageDataType.UserInfo)userInfo).getUserInfo();
        Intrinsics.checkNotNull((Object)userInfoDetails);
        String string = userInfoDetails.getUserId();
        UserInfoDetails userInfoDetails2 = ((StorageDataType.UserInfo)userInfo).getUserInfo();
        Intrinsics.checkNotNull((Object)userInfoDetails2);
        String string2 = userInfoDetails2.getEmail();
        UserInfoDetails userInfoDetails3 = ((StorageDataType.UserInfo)userInfo).getUserInfo();
        Intrinsics.checkNotNull((Object)userInfoDetails3);
        Providers providers = Providers.Companion.fromValue(userInfoDetails3.getProvider().toString());
        Intrinsics.checkNotNull((Object)((Object)providers));
        UserInfoDetails userInfoDetails4 = ((StorageDataType.UserInfo)userInfo).getUserInfo();
        Intrinsics.checkNotNull((Object)userInfoDetails4);
        UserInfo userInfo2 = new UserInfo(string, string2, providers, userInfoDetails4.getUse2FA());
        WepinLoginStatus wepinLoginStatus = WepinLoginStatus.Companion.fromValue(((StorageDataType.UserStatus)userStatus).getLoginStatus().toString());
        Intrinsics.checkNotNull((Object)((Object)wepinLoginStatus));
        UserStatus userStatus2 = new UserStatus(wepinLoginStatus, ((StorageDataType.UserStatus)userStatus).getPinRequired());
        String string3 = wepinWallet;
        Token token = new Token(((StorageDataType.WepinToken)wepinToken).getAccessToken(), ((StorageDataType.WepinToken)wepinToken).getRefreshToken());
        WepinUser wepinUser = new WepinUser("success", userInfo2, string3, userStatus2, token);
        return wepinUser;
    }

    public final <T> void setStorage(@NotNull String key, T data) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            try {
                String stringValue = this._encodeValue(data);
                StorageManager storageManager = _storage;
                if (storageManager == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"_storage");
                    storageManager = null;
                }
                storageManager.write(_appId, key, stringValue);
            }
            catch (Exception e) {
                if (StringsKt.contains$default((CharSequence)String.valueOf(e.getMessage()), (CharSequence)"already exists", (boolean)false, (int)2, null)) break block3;
                throw e;
            }
        }
    }

    @Nullable
    public final <T> T getStorage(@NotNull String key) {
        Object var2_4;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            Object v2;
            StorageManager storageManager = _storage;
            if (storageManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"_storage");
                storageManager = null;
            }
            String string = storageManager.read(_appId, key);
            if (string != null) {
                String it = string;
                boolean bl = false;
                v2 = INSTANCE._parseValue(it);
            } else {
                v2 = null;
            }
            var2_4 = v2;
        }
        catch (Exception e) {
            var2_4 = null;
        }
        return var2_4;
    }

    @Nullable
    public final Map<String, Object> getAllStorage() {
        try {
            StorageManager storageManager = _storage;
            if (storageManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"_storage");
                storageManager = null;
            }
            Map<String, String> allData = storageManager.readAll(_appId);
            Map filteredData = new LinkedHashMap();
            for (String key : allData.keySet()) {
                String storageKey = StringsKt.replaceFirst$default((String)key, (String)(_appId + "_"), (String)"", (boolean)false, (int)4, null);
                try {
                    String string = allData.get(key);
                    if (string == null) {
                        string = "";
                    }
                    StorageDataType jsonValue = (StorageDataType)this._parseValue(string);
                    filteredData.put(storageKey, jsonValue);
                }
                catch (Exception e) {
                    filteredData.put(storageKey, allData.get(key));
                }
            }
            return filteredData.isEmpty() ? null : filteredData;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setAllStorage(@NotNull Map<String, ? extends Object> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Map<String, ? extends Object> $this$forEach$iv = data;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends Object>> iterator = $this$forEach$iv.entrySet().iterator();
        block10: while (iterator.hasNext()) {
            Object v;
            Object value;
            String key;
            block35: {
                block37: {
                    block39: {
                        block36: {
                            block34: {
                                block38: {
                                    Map.Entry<String, ? extends Object> element$iv;
                                    Map.Entry<String, ? extends Object> entry = element$iv = iterator.next();
                                    boolean bl = false;
                                    key = entry.getKey();
                                    value = entry.getValue();
                                    String string = key;
                                    switch (string.hashCode()) {
                                        case -150530330: {
                                            if (!string.equals("user_status")) {
                                                throw new IllegalArgumentException("Unsupported key: " + key);
                                            }
                                            break block34;
                                        }
                                        case -1816715338: {
                                            if (!string.equals("app_language")) {
                                                throw new IllegalArgumentException("Unsupported key: " + key);
                                            }
                                            break block35;
                                        }
                                        case 1465085729: {
                                            if (!string.equals("wallet_id")) {
                                                throw new IllegalArgumentException("Unsupported key: " + key);
                                            }
                                            break block36;
                                        }
                                        case -1576719887: {
                                            if (!string.equals("oauth_provider_pending")) {
                                                throw new IllegalArgumentException("Unsupported key: " + key);
                                            }
                                            break block37;
                                        }
                                        case 315064546: {
                                            if (string.equals("wepin:connectUser")) break;
                                            throw new IllegalArgumentException("Unsupported key: " + key);
                                        }
                                        case -147132913: {
                                            if (!string.equals("user_id")) {
                                                throw new IllegalArgumentException("Unsupported key: " + key);
                                            }
                                            break block38;
                                        }
                                        case 339204258: {
                                            if (!string.equals("user_info")) {
                                                throw new IllegalArgumentException("Unsupported key: " + key);
                                            }
                                            break block39;
                                        }
                                        case -1573933868: {
                                            if (!string.equals("firebase:wepin")) throw new IllegalArgumentException("Unsupported key: " + key);
                                            if (value instanceof Map) {
                                                Object v2;
                                                String string2;
                                                String refreshToken;
                                                String string3;
                                                String idToken;
                                                Object v3 = ((Map)value).get("idToken");
                                                String string4 = v3 instanceof String ? (String)v3 : null;
                                                if (string4 == null) {
                                                    string4 = idToken = "";
                                                }
                                                if ((string3 = (v = ((Map)value).get("refreshToken")) instanceof String ? (String)v : null) == null) {
                                                    string3 = refreshToken = "";
                                                }
                                                if ((string2 = (v2 = ((Map)value).get("provider")) instanceof String ? (String)v2 : null) == null) {
                                                    string2 = "";
                                                }
                                                String string5 = string2;
                                                INSTANCE.setStorage(key, new StorageDataType.FirebaseWepin(string5, idToken, refreshToken));
                                                continue block10;
                                            }
                                            if (!(value instanceof StorageDataType)) continue block10;
                                            INSTANCE.setStorage(key, value);
                                            continue block10;
                                        }
                                    }
                                    if (value instanceof Map) {
                                        String string6;
                                        String accessToken;
                                        Object v4 = ((Map)value).get("accessToken");
                                        String string7 = v4 instanceof String ? (String)v4 : null;
                                        if (string7 == null) {
                                            string7 = accessToken = "";
                                        }
                                        if ((string6 = (v = ((Map)value).get("refreshToken")) instanceof String ? (String)v : null) == null) {
                                            string6 = "";
                                        }
                                        String refreshToken = string6;
                                        INSTANCE.setStorage(key, new StorageDataType.WepinToken(accessToken, refreshToken));
                                        continue;
                                    }
                                    if (!(value instanceof StorageDataType)) continue;
                                    INSTANCE.setStorage(key, value);
                                    continue;
                                }
                                if (!(value instanceof String)) continue;
                                INSTANCE.setStorage(key, value);
                                continue;
                            }
                            if (value instanceof Map) {
                                Object v5 = ((Map)value).get("loginStatus");
                                String string = v5 instanceof String ? (String)v5 : null;
                                if (string == null) {
                                    string = "";
                                }
                                String loginStatus = string;
                                v = ((Map)value).get("pinRequired");
                                Boolean bl = v instanceof Boolean ? (Boolean)v : null;
                                boolean pinRequired = bl != null ? bl : false;
                                INSTANCE.setStorage(key, new StorageDataType.UserStatus(loginStatus, pinRequired));
                                continue;
                            }
                            if (!(value instanceof StorageDataType)) continue;
                            INSTANCE.setStorage(key, value);
                            continue;
                        }
                        if (!(value instanceof String)) continue;
                        INSTANCE.setStorage(key, value);
                        continue;
                    }
                    if (value instanceof Map) {
                        Map userInfoMap;
                        Object v6 = ((Map)value).get("status");
                        String string = v6 instanceof String ? (String)v6 : null;
                        if (string == null) {
                            string = "success";
                        }
                        String status = string;
                        Object v7 = ((Map)value).get("userInfo");
                        Map map = userInfoMap = v7 instanceof Map ? (Map)v7 : null;
                        Object object = map != null ? map.get("userId") : null;
                        String string8 = object instanceof String ? (String)object : null;
                        if (string8 == null) {
                            string8 = "";
                        }
                        String string9 = string8;
                        Map map2 = userInfoMap;
                        Object object2 = map2 != null ? map2.get("email") : null;
                        String string10 = object2 instanceof String ? (String)object2 : null;
                        if (string10 == null) {
                            string10 = "";
                        }
                        String email = string10;
                        Map map3 = userInfoMap;
                        Object object3 = map3 != null ? map3.get("provider") : null;
                        String string11 = object3 instanceof String ? (String)object3 : null;
                        if (string11 == null) {
                            string11 = "";
                        }
                        String string12 = string11;
                        Map map4 = userInfoMap;
                        Object v8 = map4 != null ? map4.get("use2FA") : null;
                        Boolean bl = v8 instanceof Boolean ? (Boolean)v8 : null;
                        boolean bl2 = bl != null ? bl : false;
                        v8 = ((Map)value).get("walletId");
                        String string13 = v8 instanceof String ? (String)v8 : null;
                        UserInfoDetails userInfo = new UserInfoDetails(string9, email, string12, bl2);
                        INSTANCE.setStorage(key, new StorageDataType.UserInfo(status, userInfo, string13));
                        continue;
                    }
                    if (!(value instanceof StorageDataType)) continue;
                    INSTANCE.setStorage(key, value);
                    continue;
                }
                if (!(value instanceof String)) continue;
                INSTANCE.setStorage(key, value);
                continue;
            }
            if (value instanceof Map) {
                String string;
                String locale;
                Object v9 = ((Map)value).get("locale");
                String string14 = v9 instanceof String ? (String)v9 : null;
                if (string14 == null) {
                    string14 = locale = "";
                }
                if ((string = (v = ((Map)value).get("currency")) instanceof String ? (String)v : null) == null) {
                    string = "";
                }
                String currency = string;
                INSTANCE.setStorage(key, new StorageDataType.AppLanguage(locale, currency));
                continue;
            }
            if (!(value instanceof StorageDataType)) continue;
            INSTANCE.setStorage(key, value);
            continue;
            throw new IllegalArgumentException("Unsupported key: " + key);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> _prevStorageReadAll() {
        Map map;
        try {
            void $this$mapKeysTo$iv$iv;
            EncryptedSharedPreferences encryptedSharedPreferences = _prevStorage;
            if (encryptedSharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"_prevStorage");
                encryptedSharedPreferences = null;
            }
            Map map2 = encryptedSharedPreferences.getAll();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getAll(...)");
            Map $this$filterKeys$iv = map2;
            boolean $i$f$filterKeys = false;
            Map result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                String it = (String)entry$iv.getKey();
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!StringsKt.startsWith$default((String)it, (String)_appId, (boolean)false, (int)2, null)) continue;
                ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map $this$mapKeys$iv = result$iv;
            boolean $i$f$mapKeys = false;
            result$iv = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void it;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Object k = it.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                String string = StringsKt.removePrefix((String)((String)k), (CharSequence)(_appId + "_"));
                Map map4 = map3;
                boolean bl2 = false;
                entry = it$iv$iv.getValue();
                map4.put(string, entry);
            }
            map = destination$iv$iv;
        }
        catch (Exception e) {
            this._prevDeleteAll();
            map = null;
        }
        return map;
    }

    private final void _prevDeleteAll() {
        try {
            EncryptedSharedPreferences encryptedSharedPreferences = _prevStorage;
            if (encryptedSharedPreferences == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"_prevStorage");
                encryptedSharedPreferences = null;
            }
            encryptedSharedPreferences.edit().clear().apply();
        }
        catch (Exception e) {
            return;
        }
    }

    static {
        $stable = 8;
    }
}

