/*
 * Decompiled with CFR 0.152.
 */
package com.wepin.cm.loginlib.utils;

import java.math.BigInteger;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mindrot.jbcrypt.BCrypt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0016\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"hashPassword", "", "password", "urlEncoder", "url", "charset", "bigIntegerToByteArrayTrimmed", "", "value", "Ljava/math/BigInteger;", "lib_release"})
public final class Util_androidKt {
    @NotNull
    public static final String hashPassword(@NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        String BCRYPT_SALT = "$2a$10$QCJoWqnN.acrjPIgKYCthu";
        String string = BCrypt.hashpw((String)password, (String)BCRYPT_SALT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"hashpw(...)");
        return string;
    }

    @NotNull
    public static final String urlEncoder(@NotNull String url, @NotNull String charset) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        if (Intrinsics.areEqual((Object)charset, (Object)"UTF-8")) {
            String string = URLEncoder.encode(url, StandardCharsets.UTF_8.toString());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
            return string;
        }
        return "";
    }

    @NotNull
    public static final byte[] bigIntegerToByteArrayTrimmed(@NotNull BigInteger value) {
        byte[] byteArray;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String hexChars = "0123456789ABCDEF";
        byte[] byArray = byteArray = value.toByteArray();
        Intrinsics.checkNotNull((Object)byArray);
        if (!(byArray.length == 0) && byteArray[0] == 0 && byteArray[1] < 0) {
            byArray = byteArray;
            Intrinsics.checkNotNull((Object)byArray);
            int n = 1;
            int n2 = byteArray.length;
            byteArray = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
        }
        byArray = byteArray;
        Intrinsics.checkNotNull((Object)byArray);
        return byArray;
    }
}

