/*
 * Decompiled with CFR 0.152.
 */
package com.wepin.cm.widgetlib.webview;

import androidx.compose.runtime.internal.StabilityInferred;
import com.wepin.cm.widgetlib.error.WepinError;
import com.wepin.cm.widgetlib.types.ErrorCode;
import com.wepin.cm.widgetlib.types.JSResponse;
import com.wepin.cm.widgetlib.webview.PinAuthResponse;
import com.wepin.cm.widgetlib.webview.SDKRequest;
import com.wepin.cm.widgetlib.webview.WebViewResponseManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/wepin/cm/widgetlib/webview/NativeResponseProcessor;", "", "()V", "dispatcher", "", "requestCode", "", "response", "Lcom/wepin/cm/widgetlib/types/JSResponse;", "lib_release"})
@StabilityInferred(parameters=1)
public final class NativeResponseProcessor {
    public static final int $stable;

    public final void dispatcher(int requestCode, @NotNull JSResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String command = response.getBody().getCommand();
        SDKRequest.INSTANCE.setNullRequest();
        switch (command) {
            case "register_wepin": {
                if (!Intrinsics.areEqual((Object)response.getBody().getState(), (Object)"SUCCESS")) {
                    CompletableDeferred<JSResponse.JSResponseBody.JSRegisterResponseBodyData> completableDeferred = WebViewResponseManager.INSTANCE.getRegisterDeferred();
                    if (completableDeferred != null) {
                        completableDeferred.completeExceptionally((Throwable)WepinError.Companion.generateExWithMessage(ErrorCode.FAILED_REGISTER, String.valueOf(response.getBody().getData())));
                    }
                } else if (response.getBody().getData() instanceof JSResponse.JSResponseBody.JSRegisterResponseBodyData) {
                    CompletableDeferred<JSResponse.JSResponseBody.JSRegisterResponseBodyData> completableDeferred = WebViewResponseManager.INSTANCE.getRegisterDeferred();
                    if (completableDeferred != null) {
                        completableDeferred.complete((Object)response.getBody().getData());
                    }
                } else {
                    CompletableDeferred<JSResponse.JSResponseBody.JSRegisterResponseBodyData> completableDeferred = WebViewResponseManager.INSTANCE.getRegisterDeferred();
                    if (completableDeferred != null) {
                        completableDeferred.completeExceptionally((Throwable)WepinError.Companion.generateExWithMessage(ErrorCode.FAILED_REGISTER, String.valueOf(response.getBody().getData())));
                    }
                }
                break;
            }
            case "send_transaction_without_provider": {
                if (!Intrinsics.areEqual((Object)response.getBody().getState(), (Object)"SUCCESS")) {
                    CompletableDeferred<String> completableDeferred = WebViewResponseManager.INSTANCE.getSendDeferred();
                    if (completableDeferred != null) {
                        completableDeferred.completeExceptionally((Throwable)WepinError.Companion.generateExWithMessage(ErrorCode.FAILED_SEND, String.valueOf(response.getBody().getData())));
                    }
                } else if (response.getBody().getData() instanceof JSResponse.JSResponseBody.JSStringResponse) {
                    CompletableDeferred<String> completableDeferred = WebViewResponseManager.INSTANCE.getSendDeferred();
                    if (completableDeferred != null) {
                        completableDeferred.complete((Object)((JSResponse.JSResponseBody.JSStringResponse)response.getBody().getData()).getData());
                    }
                } else {
                    CompletableDeferred<String> completableDeferred = WebViewResponseManager.INSTANCE.getSendDeferred();
                    if (completableDeferred != null) {
                        completableDeferred.completeExceptionally((Throwable)WepinError.Companion.generateExWithMessage(ErrorCode.FAILED_SEND, String.valueOf(response.getBody().getData())));
                    }
                }
                break;
            }
            case "pin_auth": {
                if (!Intrinsics.areEqual((Object)response.getBody().getState(), (Object)"SUCCESS")) {
                    JSResponse.JSResponseBody.JSResponseBodyData jSResponseBodyData = response.getBody().getData();
                    Intrinsics.checkNotNull((Object)jSResponseBodyData, (String)"null cannot be cast to non-null type com.wepin.cm.widgetlib.types.JSResponse.JSResponseBody.JSStringResponse");
                    if (Intrinsics.areEqual((Object)((JSResponse.JSResponseBody.JSStringResponse)jSResponseBodyData).getData(), (Object)"User Cancel")) {
                        CompletableDeferred<PinAuthResponse> completableDeferred = WebViewResponseManager.INSTANCE.getPinDeferred();
                        if (completableDeferred != null) {
                            completableDeferred.complete((Object)new PinAuthResponse.StringValue(((JSResponse.JSResponseBody.JSStringResponse)response.getBody().getData()).getData()));
                        }
                    } else {
                        CompletableDeferred<PinAuthResponse> completableDeferred = WebViewResponseManager.INSTANCE.getPinDeferred();
                        if (completableDeferred != null) {
                            completableDeferred.completeExceptionally((Throwable)WepinError.Companion.generateExWithMessage(ErrorCode.FAILED_PIN_VERIFIED, String.valueOf(response.getBody().getData())));
                        }
                    }
                } else if (response.getBody().getData() instanceof JSResponse.JSResponseBody.JSPinAuthResponseBodyData) {
                    CompletableDeferred<PinAuthResponse> completableDeferred = WebViewResponseManager.INSTANCE.getPinDeferred();
                    if (completableDeferred != null) {
                        completableDeferred.complete((Object)new PinAuthResponse.Data((JSResponse.JSResponseBody.JSPinAuthResponseBodyData)response.getBody().getData()));
                    }
                } else {
                    CompletableDeferred<PinAuthResponse> completableDeferred = WebViewResponseManager.INSTANCE.getPinDeferred();
                    if (completableDeferred != null) {
                        completableDeferred.completeExceptionally((Throwable)WepinError.Companion.generalUnKnownEx(String.valueOf(response.getBody().getData())));
                    }
                }
                break;
            }
            case "receive_account": {
                if (!Intrinsics.areEqual((Object)response.getBody().getState(), (Object)"SUCCESS")) {
                    JSResponse.JSResponseBody.JSResponseBodyData jSResponseBodyData = response.getBody().getData();
                    Intrinsics.checkNotNull((Object)jSResponseBodyData, (String)"null cannot be cast to non-null type com.wepin.cm.widgetlib.types.JSResponse.JSResponseBody.JSStringResponse");
                    if (Intrinsics.areEqual((Object)((JSResponse.JSResponseBody.JSStringResponse)jSResponseBodyData).getData(), (Object)"User Cancel")) {
                        CompletableDeferred<String> completableDeferred = WebViewResponseManager.INSTANCE.getReceiveDeferred();
                        if (completableDeferred != null) {
                            completableDeferred.complete((Object)((JSResponse.JSResponseBody.JSStringResponse)response.getBody().getData()).getData());
                        }
                    } else {
                        CompletableDeferred<String> completableDeferred = WebViewResponseManager.INSTANCE.getReceiveDeferred();
                        if (completableDeferred != null) {
                            completableDeferred.completeExceptionally((Throwable)WepinError.Companion.generateExWithMessage(ErrorCode.FAILED_RECEIVE, String.valueOf(response.getBody().getData())));
                        }
                    }
                } else {
                    CompletableDeferred<String> completableDeferred = WebViewResponseManager.INSTANCE.getReceiveDeferred();
                    if (completableDeferred != null) {
                        completableDeferred.complete((Object)response.getBody().getState());
                    }
                }
                break;
            }
            case "show_account_detail": {
                if (!Intrinsics.areEqual((Object)response.getBody().getState(), (Object)"SUCCESS")) {
                    JSResponse.JSResponseBody.JSResponseBodyData jSResponseBodyData = response.getBody().getData();
                    Intrinsics.checkNotNull((Object)jSResponseBodyData, (String)"null cannot be cast to non-null type com.wepin.cm.widgetlib.types.JSResponse.JSResponseBody.JSStringResponse");
                    if (Intrinsics.areEqual((Object)((JSResponse.JSResponseBody.JSStringResponse)jSResponseBodyData).getData(), (Object)"User Cancel")) {
                        CompletableDeferred<String> completableDeferred = WebViewResponseManager.INSTANCE.getViewAccountDetailDeferred();
                        if (completableDeferred != null) {
                            completableDeferred.complete((Object)((JSResponse.JSResponseBody.JSStringResponse)response.getBody().getData()).getData());
                        }
                    } else {
                        CompletableDeferred<String> completableDeferred = WebViewResponseManager.INSTANCE.getViewAccountDetailDeferred();
                        if (completableDeferred != null) {
                            completableDeferred.completeExceptionally((Throwable)WepinError.Companion.generateExWithMessage(ErrorCode.FAILED_ACCOUNT_DETAIL, String.valueOf(response.getBody().getData())));
                        }
                    }
                } else {
                    CompletableDeferred<String> completableDeferred = WebViewResponseManager.INSTANCE.getViewAccountDetailDeferred();
                    if (completableDeferred != null) {
                        completableDeferred.complete((Object)response.getBody().getState());
                    }
                }
                break;
            }
            default: {
                throw new Error("It's invalid command");
            }
        }
    }
}

