/*
 * Decompiled with CFR 0.152.
 */
package io.whelk.asciidoc;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="build", defaultPhase=LifecyclePhase.PACKAGE)
public class TemplateMojo
extends AbstractMojo {
    private static final String TAG = "tag";
    private static final String TAG_END = "end";
    @Parameter(property="templateDirectory")
    String templateDirectory;
    @Parameter(property="templateFile")
    String templateFile;
    @Parameter(property="outputDirectory")
    String outputDirectory;
    @Parameter(property="outputFile")
    String outputFile;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    Map<String, String> vars = Map.of();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.setDefaultConfiguration();
        List<String> lines = this.readLines(this.templateDirectory, this.templateFile);
        this.vars = this.loadVars(lines);
        List<String> updatedLines = this.updateLines(lines);
        Files.write(Paths.get(this.outputDirectory, this.outputFile), updatedLines, new OpenOption[0]);
    }

    private List<String> readLines(String first, String ... more) {
        return new ArrayList<String>(Files.readAllLines(Paths.get(first, more)));
    }

    Map<String, String> loadVars(List<String> strings) {
        String varRegex = "^:[\\w\\-]+:";
        Pattern compile = Pattern.compile(varRegex);
        return strings.stream().map(x -> {
            Matcher matcher = compile.matcher((CharSequence)x);
            if (matcher.find()) {
                int end = matcher.end();
                String varName = matcher.group().trim();
                String trimMarkers = varName.substring(1, varName.length() - 1).trim();
                String value = x.substring(end).trim();
                return List.of(trimMarkers, value);
            }
            return List.of();
        }).filter(x -> x.size() == 2).collect(Collectors.toMap(x -> (String)x.get(0), x -> (String)x.get(1), (first, second) -> second));
    }

    private List<String> updateLines(List<String> lines) {
        return lines.stream().map(this::updateLine).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<String> updateLine(String line) {
        if (this.matchesIncludeLine(line)) {
            return this.updateIncludeLine(line);
        }
        return List.of(line);
    }

    private boolean matchesIncludeLine(String line) {
        return line.startsWith("include::") && line.endsWith("]");
    }

    List<String> updateIncludeLine(String line) {
        PathAndOptions pathAndOptions = this.extractPathAndOptions(line);
        if (pathAndOptions.optionMap.containsKey(TAG)) {
            return this.readTaggedLines(this.templateDirectory, pathAndOptions);
        }
        return this.readLines(this.templateDirectory, pathAndOptions.path);
    }

    private List<String> readTaggedLines(String templateDirectory, PathAndOptions path) {
        ArrayList<String> lines = new ArrayList<String>(Files.readAllLines(Paths.get(templateDirectory, path.path)));
        String tag = path.optionMap.get(TAG);
        AtomicReference<Boolean> startHasBeenReached = new AtomicReference<Boolean>(false);
        AtomicReference<Boolean> endHasBeenReached = new AtomicReference<Boolean>(false);
        List<String> taggedLines = lines.stream().filter(x -> {
            boolean foundStart = false;
            boolean foundEnd = false;
            if (!((Boolean)startHasBeenReached.get()).booleanValue()) {
                foundStart = x.contains("tag::" + tag);
                startHasBeenReached.set(foundStart);
            }
            if (((Boolean)startHasBeenReached.get()).booleanValue() && !((Boolean)endHasBeenReached.get()).booleanValue()) {
                foundEnd = x.contains("end::" + tag);
                endHasBeenReached.set(foundEnd);
            }
            boolean thisIsATagLine = foundStart || foundEnd;
            return !thisIsATagLine && (Boolean)startHasBeenReached.get() != false && (Boolean)endHasBeenReached.get() == false;
        }).collect(Collectors.toList());
        return taggedLines;
    }

    PathAndOptions extractPathAndOptions(String line) {
        int pathStart = 9;
        Pattern pattern = Pattern.compile("\\[.*\\]$");
        Matcher matcher = pattern.matcher(line);
        matcher.find();
        String[] allOptions = matcher.group().replaceAll("[\\[\\]]", "").split(",");
        Map<String, String> optionMap = Arrays.asList(allOptions).stream().filter(x -> x.trim().length() > 0).map(x -> x.split("=")).collect(Collectors.toMap(x -> x[0], x -> x[1]));
        int pathEnd = matcher.start();
        String path = line.substring(pathStart, pathEnd);
        for (Map.Entry<String, String> variable : this.vars.entrySet()) {
            String needle = "\\{" + variable.getKey() + "\\}";
            path = path.replaceAll(needle, variable.getValue());
        }
        return new PathAndOptions(path, optionMap);
    }

    private void setDefaultConfiguration() {
        if (this.templateDirectory == null || this.templateDirectory.isBlank()) {
            this.templateDirectory = "src/docs";
        }
        if (this.templateFile == null || this.templateFile.isBlank()) {
            this.templateFile = "README-template.adoc";
        }
        if (this.outputDirectory == null || this.outputDirectory.isBlank()) {
            this.outputDirectory = "./";
        }
        if (this.outputFile == null || this.outputFile.isBlank()) {
            this.outputFile = this.templateFile.replace("-template", "");
        }
    }

    static final class PathAndOptions {
        private final String path;
        private final Map<String, String> optionMap;

        public PathAndOptions(String path, Map<String, String> optionMap) {
            this.path = path;
            this.optionMap = optionMap;
        }

        public String getPath() {
            return this.path;
        }

        public Map<String, String> getOptionMap() {
            return this.optionMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PathAndOptions)) {
                return false;
            }
            PathAndOptions other = (PathAndOptions)o;
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            Map<String, String> this$optionMap = this.getOptionMap();
            Map<String, String> other$optionMap = other.getOptionMap();
            return !(this$optionMap == null ? other$optionMap != null : !((Object)this$optionMap).equals(other$optionMap));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            Map<String, String> $optionMap = this.getOptionMap();
            result = result * 59 + ($optionMap == null ? 43 : ((Object)$optionMap).hashCode());
            return result;
        }

        public String toString() {
            return "TemplateMojo.PathAndOptions(path=" + this.getPath() + ", optionMap=" + this.getOptionMap() + ")";
        }
    }
}

