/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref;

import edu.stanford.nlp.coref.CorefProperties;
import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.coref.data.Document;
import edu.stanford.nlp.coref.fastneural.FastNeuralCorefAlgorithm;
import edu.stanford.nlp.coref.hybrid.HybridCorefSystem;
import edu.stanford.nlp.coref.neural.NeuralCorefAlgorithm;
import edu.stanford.nlp.coref.statistical.ClusteringCorefAlgorithm;
import edu.stanford.nlp.coref.statistical.StatisticalCorefAlgorithm;
import edu.stanford.nlp.util.PropertiesUtils;
import java.util.Properties;

public interface CorefAlgorithm {
    public void runCoref(Document var1);

    public static CorefAlgorithm fromProps(Properties props, Dictionaries dictionaries) {
        CorefProperties.CorefAlgorithmType algorithm = CorefProperties.algorithm(props);
        if (algorithm == CorefProperties.CorefAlgorithmType.CLUSTERING) {
            return new ClusteringCorefAlgorithm(props, dictionaries);
        }
        if (algorithm == CorefProperties.CorefAlgorithmType.STATISTICAL) {
            return new StatisticalCorefAlgorithm(props, dictionaries);
        }
        if (algorithm == CorefProperties.CorefAlgorithmType.NEURAL) {
            return new NeuralCorefAlgorithm(props, dictionaries);
        }
        if (algorithm == CorefProperties.CorefAlgorithmType.FASTNEURAL) {
            return new FastNeuralCorefAlgorithm(props, dictionaries);
        }
        if (algorithm == CorefProperties.CorefAlgorithmType.CUSTOM) {
            String classname = PropertiesUtils.getString(props, "coref.algorithm.class", null);
            try {
                if (classname != null) {
                    Class<?> clazz = Class.forName(classname);
                    return (CorefAlgorithm)clazz.getConstructor(Properties.class, Dictionaries.class).newInstance(props, dictionaries);
                }
                throw new RuntimeException("Please specify coref.algorithm.class");
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating custom coref system", e);
            }
        }
        try {
            return new HybridCorefSystem(props, dictionaries);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating hybrid coref system", e);
        }
    }
}

