/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref.data;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.CorefProperties;
import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.coref.data.Document;
import edu.stanford.nlp.coref.data.DocumentPreprocessor;
import edu.stanford.nlp.coref.data.InputDoc;
import edu.stanford.nlp.coref.data.Mention;
import edu.stanford.nlp.coref.docreader.CoNLLDocumentReader;
import edu.stanford.nlp.coref.docreader.CoreNLPDocumentReader;
import edu.stanford.nlp.coref.docreader.DocReader;
import edu.stanford.nlp.coref.md.CorefMentionFinder;
import edu.stanford.nlp.coref.md.DependencyCorefMentionFinder;
import edu.stanford.nlp.coref.md.RuleBasedCorefMentionFinder;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

public class DocumentMaker {
    private final Properties props;
    private final DocReader reader;
    private final HeadFinder headFinder;
    private final Dictionaries dict;
    private final CorefMentionFinder md;
    private StanfordCoreNLP coreNLP;

    public DocumentMaker(Properties props, Dictionaries dictionaries) throws ClassNotFoundException, IOException {
        this.props = props;
        this.dict = dictionaries;
        this.reader = DocumentMaker.getDocumentReader(props);
        this.headFinder = CorefProperties.getHeadFinder(props);
        this.md = CorefProperties.useGoldMentions(props) ? new RuleBasedCorefMentionFinder(this.headFinder, props) : null;
    }

    private static DocReader getDocumentReader(Properties props) {
        String corpusPath = CorefProperties.getInputPath(props);
        if (corpusPath == null) {
            return null;
        }
        if ("corenlp".equalsIgnoreCase(props.getProperty("coref.reader"))) {
            CoreNLPDocumentReader.Options options = new CoreNLPDocumentReader.Options();
            options.filterCorefMentions = CorefProperties.getCorefMentionFilter(props);
            options.lang = CorefProperties.getLanguage(props);
            return new CoreNLPDocumentReader(corpusPath, options);
        }
        CoNLLDocumentReader.Options options = new CoNLLDocumentReader.Options();
        if (!PropertiesUtils.getBool(props, "coref.printConLLLoadingMessage", true)) {
            options.printConLLLoadingMessage = false;
        }
        options.annotateTokenCoref = false;
        String conllFileFilter = props.getProperty("coref.conllFileFilter", ".*_auto_conll$");
        options.setFilter(conllFileFilter);
        options.lang = CorefProperties.getLanguage(props);
        return new CoNLLDocumentReader(corpusPath, options);
    }

    public Document makeDocument(Annotation anno) throws Exception {
        return this.makeDocument(new InputDoc(anno, null, null));
    }

    public Document makeDocument(InputDoc input) throws Exception {
        ArrayList<List<Mention>> mentions = new ArrayList<List<Mention>>();
        if (CorefProperties.useGoldMentions(this.props)) {
            List sentences = (List)input.annotation.get(CoreAnnotations.SentencesAnnotation.class);
            for (int i = 0; i < sentences.size(); ++i) {
                CoreMap sentence = (CoreMap)sentences.get(i);
                List sentenceWords = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                ArrayList<Mention> sentenceMentions = new ArrayList<Mention>();
                mentions.add(sentenceMentions);
                for (Mention g : input.goldMentions.get(i)) {
                    sentenceMentions.add(new Mention(-1, g.startIndex, g.endIndex, sentenceWords, null, null, new ArrayList<CoreLabel>(sentenceWords.subList(g.startIndex, g.endIndex))));
                }
                this.md.findHead(sentence, sentenceMentions);
            }
        } else {
            for (CoreMap sentence : (List)input.annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                mentions.add((List<Mention>)sentence.get(CorefCoreAnnotations.CorefMentionsAnnotation.class));
            }
        }
        Document doc = new Document(input, mentions);
        if (input.goldMentions != null) {
            DocumentMaker.findGoldMentionHeads(doc);
        }
        DocumentPreprocessor.preprocess(doc, this.dict, null, this.headFinder);
        return doc;
    }

    private static void findGoldMentionHeads(Document doc) {
        List sentences = (List)doc.annotation.get(CoreAnnotations.SentencesAnnotation.class);
        for (int i = 0; i < sentences.size(); ++i) {
            DependencyCorefMentionFinder.findHeadInDependency((CoreMap)sentences.get(i), doc.goldMentions.get(i));
        }
    }

    private synchronized StanfordCoreNLP getStanfordCoreNLP(Properties props) {
        if (this.coreNLP != null) {
            return this.coreNLP;
        }
        Properties pipelineProps = new Properties(props);
        if (CorefProperties.conll(props)) {
            pipelineProps.setProperty("annotators", (CorefProperties.getLanguage(props) == Locale.CHINESE ? "lemma, ner" : "lemma") + (CorefProperties.useGoldMentions(props) ? "" : ", coref.mention"));
            pipelineProps.setProperty("ner.applyFineGrained", "false");
            this.coreNLP = new StanfordCoreNLP(pipelineProps, false);
        } else {
            Set<Class<? extends CoreAnnotation>> requirements;
            pipelineProps.setProperty("annotators", (CorefProperties.useConstituencyParse(props) ? "parse" : "pos") + ", lemma, ner " + (CorefProperties.useConstituencyParse(props) ? "" : ", depparse") + (CorefProperties.useGoldMentions(props) ? "" : ", coref.mention"));
            pipelineProps.setProperty("ner.applyFineGrained", "false");
            this.coreNLP = new StanfordCoreNLP(pipelineProps, false);
            if (CorefProperties.useConstituencyParse(props) && (requirements = this.coreNLP.requires()).contains(CoreAnnotations.PartOfSpeechAnnotation.class)) {
                pipelineProps.setProperty("annotators", "pos, " + pipelineProps.getProperty("annotators"));
                this.coreNLP = new StanfordCoreNLP(pipelineProps, false);
            }
        }
        return this.coreNLP;
    }

    public Document nextDoc() throws Exception {
        InputDoc input = this.reader.nextDoc();
        if (input == null) {
            return null;
        }
        if (!CorefProperties.useConstituencyParse(this.props)) {
            for (CoreMap sentence : (List)input.annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                sentence.remove(TreeCoreAnnotations.TreeAnnotation.class);
            }
        } else if (!CorefProperties.conll(this.props)) {
            for (CoreMap sentence : (List)input.annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                for (CoreLabel token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                    token.remove(CoreAnnotations.PartOfSpeechAnnotation.class);
                }
            }
        }
        this.getStanfordCoreNLP(this.props).annotate(input.annotation);
        if (CorefProperties.conll(this.props)) {
            input.annotation.set(CoreAnnotations.UseMarkedDiscourseAnnotation.class, true);
        }
        return this.makeDocument(input);
    }

    public void resetDocs() {
        this.reader.reset();
    }
}

