/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref.data;

import edu.stanford.nlp.classify.LogisticClassifier;
import edu.stanford.nlp.coref.CorefRules;
import edu.stanford.nlp.coref.CorefUtils;
import edu.stanford.nlp.coref.data.CorefCluster;
import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.coref.data.Document;
import edu.stanford.nlp.coref.data.Mention;
import edu.stanford.nlp.coref.data.SpeakerInfo;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.math.NumberMatchingRegex;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.UniversalEnglishGrammaticalRelations;
import edu.stanford.nlp.util.CollectionValuedMap;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.IntTuple;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DocumentPreprocessor {
    private static final Redwood.RedwoodChannels log = Redwood.channels(DocumentPreprocessor.class);

    private DocumentPreprocessor() {
    }

    public static void preprocess(Document doc, Dictionaries dict, LogisticClassifier<String, String> singletonPredictor, HeadFinder headFinder) throws Exception {
        DocumentPreprocessor.initializeMentions(doc, dict, singletonPredictor, headFinder);
        DocumentPreprocessor.mentionReordering(doc, headFinder);
        DocumentPreprocessor.fillSyntacticInfo(doc);
        DocumentPreprocessor.setParagraphAnnotation(doc);
        DocumentPreprocessor.processDiscourse(doc, dict);
        DocumentPreprocessor.initializeClusters(doc);
        if (doc.goldMentions != null) {
            DocumentPreprocessor.extractGoldClusters(doc);
            int foundGoldCount = 0;
            for (Mention g : doc.goldMentionsByID.values()) {
                if (!g.hasTwin) continue;
                ++foundGoldCount;
            }
            Redwood.log("debug-md", "# of found gold mentions: " + foundGoldCount + " / # of gold mentions: " + doc.goldMentionsByID.size());
        }
        DocumentPreprocessor.assignMentionNumbers(doc);
    }

    public static void extractGoldClusters(Document doc) {
        doc.goldCorefClusters = Generics.newHashMap();
        for (List<Mention> mentions : doc.goldMentions) {
            for (Mention m : mentions) {
                int id = m.goldCorefClusterID;
                if (id == -1) {
                    throw new RuntimeException("No gold info");
                }
                CorefCluster c = doc.goldCorefClusters.get(id);
                if (c == null) {
                    c = new CorefCluster(id);
                    doc.goldCorefClusters.put(id, c);
                }
                c.corefMentions.add(m);
            }
        }
    }

    private static void assignMentionNumbers(Document document) {
        List<Mention> mentionsList = CorefUtils.getSortedMentions(document);
        for (int i = 0; i < mentionsList.size(); ++i) {
            mentionsList.get((int)i).mentionNum = i;
        }
    }

    private static void mentionReordering(Document doc, HeadFinder headFinder) throws Exception {
        List<List<Mention>> mentions = doc.predictedMentions;
        List sentences = (List)doc.annotation.get(CoreAnnotations.SentencesAnnotation.class);
        for (int i = 0; i < sentences.size(); ++i) {
            List<Mention> mentionsInSent = mentions.get(i);
            mentions.set(i, DocumentPreprocessor.mentionReorderingBySpan(mentionsInSent));
        }
    }

    protected static int getHeadIndex(Tree t, HeadFinder headFinder) {
        Tree ht = t.headTerminal(headFinder);
        if (ht == null) {
            return -1;
        }
        CoreLabel l = (CoreLabel)ht.label();
        return (Integer)l.get(CoreAnnotations.IndexAnnotation.class);
    }

    private static List<Mention> mentionReorderingBySpan(List<Mention> mentionsInSent) {
        TreeSet<Mention> ordering = new TreeSet<Mention>(new Comparator<Mention>(){

            @Override
            public int compare(Mention m1, Mention m2) {
                return m1.appearEarlierThan(m2) ? -1 : (m2.appearEarlierThan(m1) ? 1 : 0);
            }
        });
        ordering.addAll(mentionsInSent);
        ArrayList<Mention> orderedMentions = Generics.newArrayList(ordering);
        return orderedMentions;
    }

    private static void fillSyntacticInfo(Document doc) {
        List<List<Mention>> mentions = doc.predictedMentions;
        List sentences = (List)doc.annotation.get(CoreAnnotations.SentencesAnnotation.class);
        for (int i = 0; i < sentences.size(); ++i) {
            List<Mention> mentionsInSent = mentions.get(i);
            DocumentPreprocessor.findSyntacticRelationsFromDependency(mentionsInSent);
        }
    }

    private static void initializeMentions(Document doc, Dictionaries dict, LogisticClassifier<String, String> singletonPredictor, HeadFinder headFinder) throws Exception {
        boolean hasGold = doc.goldMentions != null;
        DocumentPreprocessor.assignMentionIDs(doc);
        if (hasGold) {
            DocumentPreprocessor.findTwinMentions(doc, true);
        }
        DocumentPreprocessor.fillMentionInfo(doc, dict, singletonPredictor, headFinder);
        doc.allPositions = Generics.newHashMap(doc.positions);
    }

    private static void assignMentionIDs(Document doc) {
        boolean hasGold = doc.goldMentions != null;
        int maxID = 0;
        if (hasGold) {
            for (List<Mention> golds : doc.goldMentions) {
                for (Mention g : golds) {
                    g.mentionID = maxID++;
                }
            }
        }
        for (List<Mention> predicted : doc.predictedMentions) {
            for (Mention p : predicted) {
                p.mentionID = maxID++;
            }
        }
    }

    protected static void findTwinMentions(Document doc, boolean strict) {
        if (strict) {
            DocumentPreprocessor.findTwinMentionsStrict(doc);
        } else {
            DocumentPreprocessor.findTwinMentionsRelaxed(doc);
        }
    }

    private static void findTwinMentionsStrict(Document doc) {
        for (int sentNum = 0; sentNum < doc.goldMentions.size(); ++sentNum) {
            List<Mention> golds = doc.goldMentions.get(sentNum);
            List<Mention> predicts = doc.predictedMentions.get(sentNum);
            CollectionValuedMap<IntPair, Mention> goldMentionPositions = new CollectionValuedMap<IntPair, Mention>();
            for (Mention g : golds) {
                IntPair ip = new IntPair(g.startIndex, g.endIndex);
                if (goldMentionPositions.containsKey(ip)) {
                    StringBuilder existingMentions = new StringBuilder();
                    Iterator iterator = goldMentionPositions.get(ip).iterator();
                    while (iterator.hasNext()) {
                        Mention eg = (Mention)iterator.next();
                        if (existingMentions.length() > 0) {
                            existingMentions.append(",");
                        }
                        existingMentions.append(eg.mentionID);
                    }
                    Redwood.log("debug-preprocessor", "WARNING: gold mentions with the same offsets: " + ip + " mentions=" + g.mentionID + "," + existingMentions + ", " + g.spanToString());
                }
                goldMentionPositions.add(new IntPair(g.startIndex, g.endIndex), g);
            }
            for (Mention p : predicts) {
                IntPair pos = new IntPair(p.startIndex, p.endIndex);
                if (!goldMentionPositions.containsKey(pos)) continue;
                Object cm = goldMentionPositions.get(pos);
                int minId = Integer.MAX_VALUE;
                Mention g = null;
                Iterator iterator = cm.iterator();
                while (iterator.hasNext()) {
                    Mention m = (Mention)iterator.next();
                    if (m.mentionID >= minId) continue;
                    g = m;
                    minId = m.mentionID;
                }
                if (cm.size() == 1) {
                    goldMentionPositions.remove(pos);
                } else {
                    cm.remove(g);
                }
                p.mentionID = g.mentionID;
                p.hasTwin = true;
                g.hasTwin = true;
            }
        }
    }

    private static void findTwinMentionsRelaxed(Document doc) {
        for (int sentNum = 0; sentNum < doc.goldMentions.size(); ++sentNum) {
            List<Mention> golds = doc.goldMentions.get(sentNum);
            List<Mention> predicts = doc.predictedMentions.get(sentNum);
            Map<IntPair, Mention> goldMentionPositions = Generics.newHashMap();
            Map goldMentionHeadPositions = Generics.newHashMap();
            for (Mention g : golds) {
                goldMentionPositions.put(new IntPair(g.startIndex, g.endIndex), g);
                if (!goldMentionHeadPositions.containsKey(g.headIndex)) {
                    goldMentionHeadPositions.put(g.headIndex, new LinkedList());
                }
                ((LinkedList)goldMentionHeadPositions.get(g.headIndex)).add(g);
            }
            ArrayList<Mention> remains = new ArrayList<Mention>();
            for (Mention p : predicts) {
                IntPair pos = new IntPair(p.startIndex, p.endIndex);
                if (goldMentionPositions.containsKey(pos)) {
                    Mention g = (Mention)goldMentionPositions.get(pos);
                    p.mentionID = g.mentionID;
                    p.hasTwin = true;
                    g.hasTwin = true;
                    ((LinkedList)goldMentionHeadPositions.get(g.headIndex)).remove(g);
                    if (!((LinkedList)goldMentionHeadPositions.get(g.headIndex)).isEmpty()) continue;
                    goldMentionHeadPositions.remove(g.headIndex);
                    continue;
                }
                remains.add(p);
            }
            for (Mention r : remains) {
                if (!goldMentionHeadPositions.containsKey(r.headIndex)) continue;
                Mention g = (Mention)((LinkedList)goldMentionHeadPositions.get(r.headIndex)).poll();
                r.mentionID = g.mentionID;
                r.hasTwin = true;
                g.hasTwin = true;
                if (!((LinkedList)goldMentionHeadPositions.get(g.headIndex)).isEmpty()) continue;
                goldMentionHeadPositions.remove(g.headIndex);
            }
        }
    }

    private static void fillMentionInfo(Document doc, Dictionaries dict, LogisticClassifier<String, String> singletonPredictor, HeadFinder headFinder) throws Exception {
        boolean hasGold;
        List sentences = (List)doc.annotation.get(CoreAnnotations.SentencesAnnotation.class);
        for (int i = 0; i < doc.predictedMentions.size(); ++i) {
            CoreMap sentence = (CoreMap)sentences.get(i);
            for (int j = 0; j < doc.predictedMentions.get(i).size(); ++j) {
                Mention m = doc.predictedMentions.get(i).get(j);
                doc.predictedMentionsByID.put(m.mentionID, m);
                IntTuple pos = new IntTuple(2);
                pos.set(0, i);
                pos.set(1, j);
                doc.positions.put(m, pos);
                m.sentNum = i;
                IntTuple headPosition = new IntTuple(2);
                headPosition.set(0, i);
                headPosition.set(1, m.headIndex);
                doc.mentionheadPositions.put(headPosition, m);
                m.contextParseTree = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
                m.basicDependency = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
                m.enhancedDependency = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class);
                if (m.enhancedDependency == null) {
                    m.enhancedDependency = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
                }
                if (m.contextParseTree != null) {
                    Tree headTree = (Tree)m.contextParseTree.getLeaves().get(m.headIndex);
                    if (headTree == null) {
                        throw new RuntimeException("Missing head tree for a mention!");
                    }
                    Tree t = headTree;
                    while ((t = t.parent(m.contextParseTree)) != null) {
                        if (t.headTerminal(headFinder) == headTree && t.value().equals("NP")) {
                            m.mentionSubTree = t;
                            continue;
                        }
                        if (m.mentionSubTree == null) continue;
                    }
                    if (m.mentionSubTree == null) {
                        m.mentionSubTree = headTree;
                    }
                }
                m.process(dict, null, singletonPredictor);
            }
        }
        boolean bl = hasGold = doc.goldMentions != null;
        if (hasGold) {
            doc.goldMentionsByID = Generics.newHashMap();
            int sentNum = 0;
            for (List<Mention> golds : doc.goldMentions) {
                for (Mention g : golds) {
                    doc.goldMentionsByID.put(g.mentionID, g);
                    g.sentNum = sentNum;
                }
                ++sentNum;
            }
        }
    }

    private static void findSyntacticRelationsFromDependency(List<Mention> orderedMentions) {
        if (orderedMentions.size() == 0) {
            return;
        }
        DocumentPreprocessor.markListMemberRelation(orderedMentions);
        SemanticGraph dependency = orderedMentions.get((int)0).enhancedDependency;
        Set<Pair<Integer, Integer>> appos = Generics.newHashSet();
        List<SemanticGraphEdge> appositions = dependency.findAllRelns(UniversalEnglishGrammaticalRelations.APPOSITIONAL_MODIFIER);
        for (SemanticGraphEdge edge : appositions) {
            int sIdx = edge.getSource().index() - 1;
            int tIdx = edge.getTarget().index() - 1;
            appos.add(Pair.makePair(sIdx, tIdx));
        }
        DocumentPreprocessor.markMentionRelation(orderedMentions, appos, "APPOSITION");
        Set<Pair<Integer, Integer>> preNomi = Generics.newHashSet();
        List<SemanticGraphEdge> copula = dependency.findAllRelns(UniversalEnglishGrammaticalRelations.COPULA);
        for (SemanticGraphEdge edge : copula) {
            IndexedWord parent;
            IndexedWord source = edge.getSource();
            IndexedWord target = dependency.getChildWithReln(source, UniversalEnglishGrammaticalRelations.NOMINAL_SUBJECT);
            if (target == null) {
                target = dependency.getChildWithReln(source, UniversalEnglishGrammaticalRelations.CLAUSAL_SUBJECT);
            }
            if (target == null) continue;
            if (target.tag().startsWith("W") && (parent = dependency.getParent(source)) != null && dependency.reln(parent, source).equals(UniversalEnglishGrammaticalRelations.RELATIVE_CLAUSE_MODIFIER)) {
                target = parent;
            }
            int sIdx = source.index() - 1;
            int tIdx = target.index() - 1;
            preNomi.add(Pair.makePair(tIdx, sIdx));
        }
        DocumentPreprocessor.markMentionRelation(orderedMentions, preNomi, "PREDICATE_NOMINATIVE");
        Set<Pair<Integer, Integer>> relativePronounPairs = Generics.newHashSet();
        DocumentPreprocessor.markMentionRelation(orderedMentions, relativePronounPairs, "RELATIVE_PRONOUN");
    }

    private static void initializeClusters(Document doc) {
        boolean hasGold;
        for (List<Mention> predicted : doc.predictedMentions) {
            for (Mention p : predicted) {
                doc.corefClusters.put(p.mentionID, new CorefCluster(p.mentionID, Generics.newHashSet(Arrays.asList(p))));
                p.corefClusterID = p.mentionID;
            }
        }
        boolean bl = hasGold = doc.goldMentions != null;
        if (hasGold) {
            for (List<Mention> golds : doc.goldMentions) {
                for (Mention g : golds) {
                    doc.goldMentionsByID.put(g.mentionID, g);
                }
            }
        }
    }

    private static Document.DocType findDocType(Document doc) {
        boolean speakerChange = false;
        for (CoreMap sent : (List)doc.annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreLabel w : (List)sent.get(CoreAnnotations.TokensAnnotation.class)) {
                int utterIndex = (Integer)w.get(CoreAnnotations.UtteranceAnnotation.class);
                if (utterIndex != 0) {
                    speakerChange = true;
                }
                if (speakerChange && utterIndex == 0) {
                    return Document.DocType.ARTICLE;
                }
                if (doc.maxUtter >= utterIndex) continue;
                doc.maxUtter = utterIndex;
            }
        }
        if (!speakerChange) {
            return Document.DocType.ARTICLE;
        }
        return Document.DocType.CONVERSATION;
    }

    private static void setParagraphAnnotation(Document doc) {
        int paragraphIndex = 0;
        int previousOffset = -10;
        for (CoreMap coreMap : (List)doc.annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreLabel w : (List)coreMap.get(CoreAnnotations.TokensAnnotation.class)) {
                if (w.containsKey(CoreAnnotations.CharacterOffsetBeginAnnotation.class)) {
                    if ((Integer)w.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class) > previousOffset + 2) {
                        ++paragraphIndex;
                    }
                    w.set(CoreAnnotations.ParagraphAnnotation.class, paragraphIndex);
                    previousOffset = (Integer)w.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
                    continue;
                }
                w.set(CoreAnnotations.ParagraphAnnotation.class, -1);
            }
        }
        for (List list : doc.predictedMentions) {
            for (Mention m : list) {
                m.paragraph = (Integer)m.headWord.get(CoreAnnotations.ParagraphAnnotation.class);
            }
        }
        doc.numParagraph = paragraphIndex;
    }

    protected static void processDiscourse(Document doc, Dictionaries dict) {
        SpeakerInfo speakerInfo;
        Boolean useMarkedDiscourse = (Boolean)doc.annotation.get(CoreAnnotations.UseMarkedDiscourseAnnotation.class);
        if (useMarkedDiscourse == null || !useMarkedDiscourse.booleanValue()) {
            for (CoreLabel coreLabel : (List)doc.annotation.get(CoreAnnotations.TokensAnnotation.class)) {
                coreLabel.remove(CoreAnnotations.SpeakerAnnotation.class);
                coreLabel.remove(CoreAnnotations.UtteranceAnnotation.class);
            }
        }
        DocumentPreprocessor.setUtteranceAndSpeakerAnnotation(doc);
        for (Mention mention : doc.predictedMentionsByID.values()) {
            mention.utter = (Integer)mention.headWord.get(CoreAnnotations.UtteranceAnnotation.class);
        }
        doc.docType = DocumentPreprocessor.findDocType(doc);
        DocumentPreprocessor.findSpeakers(doc, dict);
        boolean debug = false;
        if (debug) {
            for (CoreMap sent : (List)doc.annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                for (CoreLabel cl : (List)sent.get(CoreAnnotations.TokensAnnotation.class)) {
                    log.info("   " + cl.word() + "-" + cl.get(CoreAnnotations.UtteranceAnnotation.class) + "-" + (String)cl.get(CoreAnnotations.SpeakerAnnotation.class));
                }
            }
            for (Integer utter : doc.speakers.keySet()) {
                String speakerID = doc.speakers.get(utter);
                log.info("utterance: " + utter);
                log.info("speakers value: " + speakerID);
                log.info("mention for it: " + (NumberMatchingRegex.isDecimalInteger(speakerID) ? (Serializable)doc.predictedMentionsByID.get(Integer.parseInt(doc.speakers.get(utter))) : "no mention for this speaker yet"));
            }
            log.info("AA SPEAKERS: " + doc.speakers);
        }
        for (Integer utter : doc.speakers.keySet()) {
            String speaker = doc.speakers.get(utter);
            speakerInfo = doc.speakerInfoMap.get(speaker);
            if (speakerInfo != null) continue;
            speakerInfo = new SpeakerInfo(speaker);
            doc.speakerInfoMap.put(speaker, speakerInfo);
        }
        if (debug) {
            log.info("BB SPEAKER INFO MAP: " + doc.speakerInfoMap);
        }
        Map<String, Integer> map = Generics.newHashMap();
        block6: for (String speaker : doc.speakerInfoMap.keySet()) {
            speakerInfo = doc.speakerInfoMap.get(speaker);
            if (!speakerInfo.hasRealSpeakerName()) continue;
            boolean found = false;
            for (Mention m : doc.predictedMentionsByID.values()) {
                if (!CorefRules.mentionMatchesSpeaker(m, speakerInfo, true)) continue;
                map.put(speaker, m.mentionID);
                found = true;
                break;
            }
            if (found) continue;
            for (Mention m : doc.predictedMentionsByID.values()) {
                if (!CorefRules.mentionMatchesSpeaker(m, speakerInfo, false)) continue;
                map.put(speaker, m.mentionID);
                continue block6;
            }
        }
        if (debug) {
            log.info("CC speaker conversion: " + map);
        }
        for (Integer utter : doc.speakers.keySet()) {
            String speaker = doc.speakers.get(utter);
            if (!map.containsKey(speaker)) continue;
            int speakerID = (Integer)map.get(speaker);
            doc.speakers.put(utter, Integer.toString(speakerID));
        }
        for (String speaker : map.keySet()) {
            doc.speakerInfoMap.put(Integer.toString((Integer)map.get(speaker)), doc.speakerInfoMap.get(speaker));
            doc.speakerInfoMap.remove(speaker);
        }
        for (CoreLabel cl : (List)doc.annotation.get(CoreAnnotations.TokensAnnotation.class)) {
            int utter = (Integer)cl.get(CoreAnnotations.UtteranceAnnotation.class);
            if (!doc.speakers.containsKey(utter)) continue;
            cl.set(CoreAnnotations.SpeakerAnnotation.class, doc.speakers.get(utter));
        }
        for (Mention m : doc.predictedMentionsByID.values()) {
            String speaker = (String)m.headWord.get(CoreAnnotations.SpeakerAnnotation.class);
            if (debug) {
                log.info("DD: " + speaker);
            }
            if (doc.conllDoc == null || !NumberMatchingRegex.isDecimalInteger(speaker)) continue;
            int speakerMentionID = Integer.parseInt(speaker);
            doc.speakerPairs.add(new Pair<Integer, Integer>(m.mentionID, speakerMentionID));
        }
        if (debug) {
            log.info("==========================================================================");
            for (Integer utter : doc.speakers.keySet()) {
                String speakerID = doc.speakers.get(utter);
                log.info("utterance: " + utter);
                log.info("speakers value: " + speakerID);
                log.info("mention for it: " + (NumberMatchingRegex.isDecimalInteger(speakerID) ? (Serializable)doc.predictedMentionsByID.get(Integer.parseInt(doc.speakers.get(utter))) : "no mention for this speaker yet"));
            }
            log.info(doc.speakers);
        }
    }

    private static void setUtteranceAndSpeakerAnnotation(Document doc) {
        doc.speakerInfoGiven = false;
        int utterance = 0;
        int outsideQuoteUtterance = 0;
        boolean insideQuotation = false;
        List tokens = (List)doc.annotation.get(CoreAnnotations.TokensAnnotation.class);
        String preSpeaker = tokens.size() > 0 ? (String)((CoreLabel)tokens.get(0)).get(CoreAnnotations.SpeakerAnnotation.class) : null;
        for (CoreLabel l : tokens) {
            boolean noSpeakerInfo;
            boolean quoteEnd;
            String curSpeaker = (String)l.get(CoreAnnotations.SpeakerAnnotation.class);
            String w = (String)l.get(CoreAnnotations.TextAnnotation.class);
            if (curSpeaker != null && !curSpeaker.equals("-")) {
                doc.speakerInfoGiven = true;
            }
            boolean speakerChange = doc.speakerInfoGiven && curSpeaker != null && !curSpeaker.equals(preSpeaker);
            boolean quoteStart = w.equals("``") || !insideQuotation && w.equals("\"");
            boolean bl = quoteEnd = w.equals("''") || insideQuotation && w.equals("\"");
            if (speakerChange) {
                if (quoteStart) {
                    utterance = doc.maxUtter + 1;
                    outsideQuoteUtterance = utterance + 1;
                } else {
                    outsideQuoteUtterance = utterance = doc.maxUtter + 1;
                }
                preSpeaker = curSpeaker;
            } else if (quoteStart) {
                utterance = doc.maxUtter + 1;
            }
            if (quoteEnd) {
                utterance = outsideQuoteUtterance;
                insideQuotation = false;
            }
            if (doc.maxUtter < utterance) {
                doc.maxUtter = utterance;
            }
            l.set(CoreAnnotations.UtteranceAnnotation.class, utterance);
            if (quoteStart) {
                l.set(CoreAnnotations.UtteranceAnnotation.class, outsideQuoteUtterance);
            }
            boolean bl2 = noSpeakerInfo = !l.containsKey(CoreAnnotations.SpeakerAnnotation.class) || ((String)l.get(CoreAnnotations.SpeakerAnnotation.class)).equals("") || ((String)l.get(CoreAnnotations.SpeakerAnnotation.class)).startsWith("PER");
            if (noSpeakerInfo || insideQuotation) {
                l.set(CoreAnnotations.SpeakerAnnotation.class, "PER" + utterance);
            }
            if (!quoteStart) continue;
            insideQuotation = true;
        }
    }

    private static void findSpeakers(Document doc, Dictionaries dict) {
        boolean useMarkedDiscourse;
        Boolean useMarkedDiscourseBoolean = (Boolean)doc.annotation.get(CoreAnnotations.UseMarkedDiscourseAnnotation.class);
        boolean bl = useMarkedDiscourse = useMarkedDiscourseBoolean != null ? useMarkedDiscourseBoolean : false;
        if (!useMarkedDiscourse) {
            if (doc.docType == Document.DocType.CONVERSATION) {
                DocumentPreprocessor.findSpeakersInConversation(doc, dict);
            } else if (doc.docType == Document.DocType.ARTICLE) {
                DocumentPreprocessor.findSpeakersInArticle(doc, dict);
            }
        }
        for (CoreMap sent : (List)doc.annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreLabel w : (List)sent.get(CoreAnnotations.TokensAnnotation.class)) {
                int utterIndex = (Integer)w.get(CoreAnnotations.UtteranceAnnotation.class);
                if (doc.speakers.containsKey(utterIndex)) continue;
                doc.speakers.put(utterIndex, (String)w.get(CoreAnnotations.SpeakerAnnotation.class));
            }
        }
    }

    private static void findSpeakersInArticle(Document doc, Dictionaries dict) {
        List sentences = (List)doc.annotation.get(CoreAnnotations.SentencesAnnotation.class);
        IntPair beginQuotation = null;
        IntPair endQuotation = null;
        boolean insideQuotation = false;
        int utterNum = -1;
        for (int i = 0; i < sentences.size(); ++i) {
            List sent = (List)((CoreMap)sentences.get(i)).get(CoreAnnotations.TokensAnnotation.class);
            for (int j = 0; j < sent.size(); ++j) {
                int utterIndex = (Integer)((CoreLabel)sent.get(j)).get(CoreAnnotations.UtteranceAnnotation.class);
                if (utterIndex != 0 && !insideQuotation) {
                    utterNum = utterIndex;
                    insideQuotation = true;
                    beginQuotation = new IntPair(i, j);
                    continue;
                }
                if (utterIndex != 0 || !insideQuotation) continue;
                insideQuotation = false;
                endQuotation = new IntPair(i, j);
                DocumentPreprocessor.findQuotationSpeaker(doc, utterNum, sentences, beginQuotation, endQuotation, dict);
            }
        }
        if (insideQuotation) {
            endQuotation = new IntPair(sentences.size() - 1, ((List)((CoreMap)sentences.get(sentences.size() - 1)).get(CoreAnnotations.TokensAnnotation.class)).size() - 1);
            DocumentPreprocessor.findQuotationSpeaker(doc, utterNum, sentences, beginQuotation, endQuotation, dict);
        }
    }

    private static void findQuotationSpeaker(Document doc, int utterNum, List<CoreMap> sentences, IntPair beginQuotation, IntPair endQuotation, Dictionaries dict) {
        if (DocumentPreprocessor.findSpeaker(doc, utterNum, beginQuotation.get(0), sentences, 0, beginQuotation.get(1), dict)) {
            return;
        }
        if (DocumentPreprocessor.findSpeaker(doc, utterNum, endQuotation.get(0), sentences, endQuotation.get(1), ((List)sentences.get(endQuotation.get(0)).get(CoreAnnotations.TokensAnnotation.class)).size(), dict)) {
            return;
        }
        if (beginQuotation.get(1) <= 1 && beginQuotation.get(0) > 0 && DocumentPreprocessor.findSpeaker(doc, utterNum, beginQuotation.get(0) - 1, sentences, 0, ((List)sentences.get(beginQuotation.get(0) - 1).get(CoreAnnotations.TokensAnnotation.class)).size(), dict)) {
            return;
        }
        if (endQuotation.get(1) >= sentences.get(endQuotation.get(0)).size() - 2 && sentences.size() > endQuotation.get(0) + 1 && DocumentPreprocessor.findSpeaker(doc, utterNum, endQuotation.get(0) + 1, sentences, 0, ((List)sentences.get(endQuotation.get(0) + 1).get(CoreAnnotations.TokensAnnotation.class)).size(), dict)) {
            return;
        }
    }

    private static boolean findSpeaker(Document doc, int utterNum, int sentNum, List<CoreMap> sentences, int startIndex, int endIndex, Dictionaries dict) {
        List sent = (List)sentences.get(sentNum).get(CoreAnnotations.TokensAnnotation.class);
        for (int i = startIndex; i < endIndex; ++i) {
            IndexedWord w;
            CoreLabel cl = (CoreLabel)sent.get(i);
            if ((Integer)cl.get(CoreAnnotations.UtteranceAnnotation.class) != 0) continue;
            String lemma = cl.lemma();
            String word = cl.word();
            if (!dict.reportVerb.contains(lemma) || !cl.tag().startsWith("V")) continue;
            SemanticGraph dependency = (SemanticGraph)sentences.get(sentNum).get(SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class);
            if (dependency == null) {
                dependency = (SemanticGraph)sentences.get(sentNum).get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
            }
            if ((w = dependency.getNodeByWordPattern(word)) != null) {
                if (DocumentPreprocessor.findSubject(doc, dependency, w, sentNum, utterNum)) {
                    return true;
                }
                for (IndexedWord p : dependency.getPathToRoot(w)) {
                    if (!p.tag().startsWith("V") && !p.tag().startsWith("MD")) break;
                    if (!DocumentPreprocessor.findSubject(doc, dependency, p, sentNum, utterNum)) continue;
                    return true;
                }
                continue;
            }
            Redwood.log("debug-preprocessor", "Cannot find node in dependency for word " + word);
        }
        return false;
    }

    private static boolean findSubject(Document doc, SemanticGraph dependency, IndexedWord w, int sentNum, int utterNum) {
        for (Pair<GrammaticalRelation, IndexedWord> child : dependency.childPairs(w)) {
            if (!child.first().getShortName().equals("nsubj")) continue;
            String subjectString = child.second().word();
            int subjectIndex = child.second().index();
            IntTuple headPosition = new IntTuple(2);
            headPosition.set(0, sentNum);
            headPosition.set(1, subjectIndex - 1);
            String speaker = doc.mentionheadPositions.containsKey(headPosition) ? Integer.toString(doc.mentionheadPositions.get((Object)headPosition).mentionID) : subjectString;
            doc.speakers.put(utterNum, speaker);
            return true;
        }
        return false;
    }

    private static void findSpeakersInConversation(Document doc, Dictionaries dict) {
        for (List<Mention> l : doc.predictedMentions) {
            for (Mention m : l) {
                if (m.predicateNominatives == null) continue;
                for (Mention a : m.predicateNominatives) {
                    if (!a.spanToString().toLowerCase().equals("i")) continue;
                    doc.speakers.put((Integer)m.headWord.get(CoreAnnotations.UtteranceAnnotation.class), Integer.toString(m.mentionID));
                }
            }
        }
        ArrayList<CoreMap> paragraph = new ArrayList<CoreMap>();
        int paragraphUtterIndex = 0;
        String nextParagraphSpeaker = "";
        int paragraphOffset = 0;
        for (CoreMap sent : (List)doc.annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            paragraph.add(sent);
            int currentUtter = (Integer)((CoreLabel)((List)sent.get(CoreAnnotations.TokensAnnotation.class)).get(0)).get(CoreAnnotations.UtteranceAnnotation.class);
            if (paragraphUtterIndex == currentUtter) continue;
            nextParagraphSpeaker = DocumentPreprocessor.findParagraphSpeaker(doc, paragraph, paragraphUtterIndex, nextParagraphSpeaker, paragraphOffset, dict);
            paragraphUtterIndex = currentUtter;
            paragraphOffset += paragraph.size();
            paragraph = new ArrayList();
        }
        DocumentPreprocessor.findParagraphSpeaker(doc, paragraph, paragraphUtterIndex, nextParagraphSpeaker, paragraphOffset, dict);
    }

    private static String findParagraphSpeaker(Document doc, List<CoreMap> paragraph, int paragraphUtterIndex, String nextParagraphSpeaker, int paragraphOffset, Dictionaries dict) {
        if (!doc.speakers.containsKey(paragraphUtterIndex)) {
            if (!nextParagraphSpeaker.isEmpty()) {
                doc.speakers.put(paragraphUtterIndex, nextParagraphSpeaker);
            } else {
                if (paragraph.isEmpty()) {
                    Redwood.log("debug-preprocessor", "Empty paragraph; skipping findParagraphSpeaker");
                    return "";
                }
                CoreMap lastSent = paragraph.get(paragraph.size() - 1);
                String speaker = "";
                boolean hasVerb = false;
                for (int i = 0; i < ((List)lastSent.get(CoreAnnotations.TokensAnnotation.class)).size(); ++i) {
                    CoreLabel w = (CoreLabel)((List)lastSent.get(CoreAnnotations.TokensAnnotation.class)).get(i);
                    String pos = (String)w.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                    String ner = (String)w.get(CoreAnnotations.NamedEntityTagAnnotation.class);
                    if (pos.startsWith("V")) {
                        hasVerb = true;
                        break;
                    }
                    if (!ner.startsWith("PER")) continue;
                    IntTuple headPosition = new IntTuple(2);
                    headPosition.set(0, paragraph.size() - 1 + paragraphOffset);
                    headPosition.set(1, i);
                    if (!doc.mentionheadPositions.containsKey(headPosition)) continue;
                    speaker = Integer.toString(doc.mentionheadPositions.get((Object)headPosition).mentionID);
                }
                if (!hasVerb && !speaker.equals("")) {
                    doc.speakers.put(paragraphUtterIndex, speaker);
                }
            }
        }
        return DocumentPreprocessor.findNextParagraphSpeaker(doc, paragraph, paragraphOffset, dict);
    }

    private static String findNextParagraphSpeaker(Document doc, List<CoreMap> paragraph, int paragraphOffset, Dictionaries dict) {
        if (paragraph.isEmpty()) {
            return "";
        }
        CoreMap lastSent = paragraph.get(paragraph.size() - 1);
        String speaker = "";
        for (CoreLabel w : (List)lastSent.get(CoreAnnotations.TokensAnnotation.class)) {
            if (!((String)w.get(CoreAnnotations.LemmaAnnotation.class)).equals("report") && !((String)w.get(CoreAnnotations.LemmaAnnotation.class)).equals("say")) continue;
            String word = (String)w.get(CoreAnnotations.TextAnnotation.class);
            SemanticGraph dependency = (SemanticGraph)lastSent.get(SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class);
            if (dependency == null) {
                dependency = (SemanticGraph)lastSent.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
            }
            IndexedWord t = dependency.getNodeByWordPattern(word);
            for (Pair<GrammaticalRelation, IndexedWord> child : dependency.childPairs(t)) {
                if (!child.first().getShortName().equals("nsubj")) continue;
                int subjectIndex = child.second().index();
                IntTuple headPosition = new IntTuple(2);
                headPosition.set(0, paragraph.size() - 1 + paragraphOffset);
                headPosition.set(1, subjectIndex - 1);
                if (!doc.mentionheadPositions.containsKey(headPosition) || !doc.mentionheadPositions.get((Object)headPosition).nerString.startsWith("PER")) continue;
                speaker = Integer.toString(doc.mentionheadPositions.get((Object)headPosition).mentionID);
            }
        }
        return speaker;
    }

    public static boolean isSpeaker(Mention m, Mention ant, Dictionaries dict) {
        if (!dict.firstPersonPronouns.contains(ant.spanToString().toLowerCase()) || ant.number == Dictionaries.Number.PLURAL || ant.sentNum != m.sentNum) {
            return false;
        }
        int countQuotationMark = 0;
        for (int i = Math.min(m.headIndex, ant.headIndex) + 1; i < Math.max(m.headIndex, ant.headIndex); ++i) {
            String word = (String)m.sentenceWords.get(i).get(CoreAnnotations.TextAnnotation.class);
            if (!word.equals("``") && !word.equals("''")) continue;
            ++countQuotationMark;
        }
        if (countQuotationMark != 1) {
            return false;
        }
        IndexedWord w = m.enhancedDependency.getNodeByWordPattern((String)m.sentenceWords.get(m.headIndex).get(CoreAnnotations.TextAnnotation.class));
        if (w == null) {
            return false;
        }
        for (Pair<GrammaticalRelation, IndexedWord> parent : m.enhancedDependency.parentPairs(w)) {
            if (!parent.first().getShortName().equals("nsubj") || !dict.reportVerb.contains(parent.second().get(CoreAnnotations.LemmaAnnotation.class))) continue;
            return true;
        }
        return false;
    }

    private static void markListMemberRelation(List<Mention> orderedMentions) {
        for (Mention m1 : orderedMentions) {
            for (Mention m2 : orderedMentions) {
                if (m1.isListMemberOf(m2)) {
                    m2.addListMember(m1);
                    m1.addBelongsToList(m2);
                    continue;
                }
                if (!m2.isListMemberOf(m1)) continue;
                m1.addListMember(m2);
                m2.addBelongsToList(m1);
            }
        }
    }

    private static void markMentionRelation(List<Mention> orderedMentions, Set<Pair<Integer, Integer>> foundPairs, String flag) {
        for (Mention m1 : orderedMentions) {
            for (Mention m2 : orderedMentions) {
                if (m1 == m2 || m1.isListMemberOf(m2) || m2.isListMemberOf(m1) || m1.isMemberOfSameList(m2)) continue;
                for (Pair<Integer, Integer> foundPair : foundPairs) {
                    if (foundPair.first() != m1.headIndex || foundPair.second() != m2.headIndex) continue;
                    if (flag.equals("APPOSITION")) {
                        if (foundPair.first().equals(foundPair.second()) && !m2.insideIn(m1)) continue;
                        m2.addApposition(m1);
                        continue;
                    }
                    if (flag.equals("PREDICATE_NOMINATIVE")) {
                        m2.addPredicateNominatives(m1);
                        continue;
                    }
                    if (flag.equals("RELATIVE_PRONOUN")) {
                        m2.addRelativePronoun(m1);
                        continue;
                    }
                    throw new RuntimeException("check flag in markMentionRelation (dcoref/MentionExtractor.java)");
                }
            }
        }
    }
}

