/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref.docreader;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.CorefUtils;
import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.coref.data.InputDoc;
import edu.stanford.nlp.coref.data.Mention;
import edu.stanford.nlp.coref.docreader.DocReader;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationIterator;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Triple;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CoreNLPDocumentReader
implements DocReader {
    protected static final Redwood.RedwoodChannels logger = Redwood.channels(CoreNLPDocumentReader.class);
    private AnnotationIterator docIterator;
    protected final List<File> fileList;
    private int curFileIndex;
    private final Options options;
    private final Predicate<Pair<CorefChain.CorefMention, List<CoreLabel>>> filterCorefMentions;

    public CoreNLPDocumentReader(String filepath) {
        this(filepath, new Options());
    }

    public CoreNLPDocumentReader(String filepath, Options options) {
        this.fileList = filepath != null && new File(filepath).exists() ? CoreNLPDocumentReader.getFiles(filepath, options.filePattern) : Collections.EMPTY_LIST;
        this.options = options;
        this.filterCorefMentions = options.filterCorefMentions;
        if (options.sortFiles) {
            Collections.sort(this.fileList);
        }
        this.curFileIndex = 0;
        if (filepath != null && new File(filepath).exists() && options.printLoadingMessage) {
            logger.info("Reading " + this.fileList.size() + " CoreNLP files from " + filepath);
        }
    }

    private static List<File> getFiles(String filepath, Pattern filter) {
        Iterable<File> iter = IOUtils.iterFilesRecursive(new File(filepath), filter);
        ArrayList<File> fileList = new ArrayList<File>();
        for (File f : iter) {
            fileList.add(f);
        }
        Collections.sort(fileList);
        return fileList;
    }

    public Annotation getNextDocument() {
        try {
            if (this.curFileIndex >= this.fileList.size()) {
                return null;
            }
            File curFile = this.fileList.get(this.curFileIndex);
            if (this.docIterator == null) {
                this.docIterator = new AnnotationIterator(curFile.getAbsolutePath());
            }
            while (!this.docIterator.hasNext()) {
                Redwood.log("debug-docreader", "Processed " + this.docIterator.getDocCnt() + " documents in " + curFile.getAbsolutePath());
                this.docIterator.close();
                ++this.curFileIndex;
                if (this.curFileIndex >= this.fileList.size()) {
                    return null;
                }
                curFile = this.fileList.get(this.curFileIndex);
                this.docIterator = new AnnotationIterator(curFile.getAbsolutePath());
            }
            Annotation next = this.docIterator.next();
            Redwood.log("debug-docreader", "Reading document: " + (String)next.get(CoreAnnotations.DocIDAnnotation.class));
            return next;
        }
        catch (IOException ex) {
            throw new RuntimeIOException(ex);
        }
    }

    @Override
    public InputDoc nextDoc() {
        Annotation annotation = this.getNextDocument();
        if (annotation == null) {
            return null;
        }
        Set<Triple<Integer, Integer, Integer>> filterMentionSpans = null;
        if (this.filterCorefMentions != null) {
            Set<Triple<Integer, Integer, Integer>> f = filterMentionSpans = CorefUtils.getMatchingSpans(annotation);
            Map<Integer, CorefChain> filtered = ((Map)annotation.get(CorefCoreAnnotations.CorefChainAnnotation.class)).values().stream().filter(x -> CorefUtils.filterCorefChainWithMentionSpans(x, f)).collect(Collectors.toMap(x -> x.getChainID(), x -> x));
            annotation.set(CorefCoreAnnotations.CorefChainAnnotation.class, filtered);
        }
        Map<String, String> docInfo = CoreNLPDocumentReader.makeDocInfo(annotation);
        List<List<Mention>> allGoldMentions = this.extractGoldMentions(annotation);
        InputDoc doc = new InputDoc(annotation, docInfo, allGoldMentions, null);
        doc.filterMentionSet = filterMentionSpans;
        return doc;
    }

    public List<List<Mention>> extractGoldMentions(Annotation annotation) {
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        Map corefChains = (Map)annotation.get(CorefCoreAnnotations.CorefChainAnnotation.class);
        ArrayList<List<Mention>> mentionsBySentence = new ArrayList<List<Mention>>();
        for (int i = 0; i < sentences.size(); ++i) {
            mentionsBySentence.add(new ArrayList());
        }
        for (CorefChain chain : corefChains.values()) {
            for (CorefChain.CorefMention mention : chain.getMentionsInTextualOrder()) {
                Mention m = this.toMention(mention, sentences);
                ((List)mentionsBySentence.get(m.sentNum)).add(m);
            }
        }
        return mentionsBySentence;
    }

    public Mention toMention(CorefChain.CorefMention cm, List<CoreMap> sentences) {
        Mention m = new Mention();
        m.goldCorefClusterID = cm.corefClusterID;
        m.startIndex = cm.startIndex - 1;
        m.endIndex = cm.endIndex - 1;
        m.sentNum = cm.sentNum - 1;
        CoreMap sent = sentences.get(m.sentNum);
        m.originalSpan = ((List)sent.get(CoreAnnotations.TokensAnnotation.class)).subList(m.startIndex, m.endIndex);
        return m;
    }

    private static Map<String, String> makeDocInfo(Annotation annotation) {
        Map<String, String> docInfo = Generics.newHashMap();
        docInfo.put("DOC_ID", (String)annotation.get(CoreAnnotations.DocIDAnnotation.class));
        return docInfo;
    }

    @Override
    public void reset() {
        this.curFileIndex = 0;
        if (this.docIterator != null) {
            this.docIterator.close();
            this.docIterator = null;
        }
    }

    public static class Options {
        public boolean printLoadingMessage = true;
        public Locale lang = Locale.ENGLISH;
        public Predicate<Pair<CorefChain.CorefMention, List<CoreLabel>>> filterCorefMentions;
        protected String fileFilter;
        protected Pattern filePattern;
        protected boolean sortFiles;

        public Options() {
            this(".json$");
        }

        public Options(String filter) {
            this.fileFilter = filter;
            this.filePattern = Pattern.compile(this.fileFilter);
        }

        public void setFilter(String filter) {
            this.fileFilter = filter;
            this.filePattern = Pattern.compile(this.fileFilter);
        }
    }
}

