/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref.statistical;

import edu.stanford.nlp.coref.statistical.ClustererDataLoader;
import edu.stanford.nlp.coref.statistical.CompressedFeatureVector;
import edu.stanford.nlp.coref.statistical.Compressor;
import edu.stanford.nlp.coref.statistical.EvalUtils;
import edu.stanford.nlp.coref.statistical.SimpleLinearClassifier;
import edu.stanford.nlp.coref.statistical.StatisticalCorefTrainer;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class Clusterer {
    private static final boolean USE_CLASSIFICATION = true;
    private static final boolean USE_RANKING = true;
    private static final boolean LEFT_TO_RIGHT = false;
    private static final boolean EXACT_LOSS = false;
    private static final double MUC_WEIGHT = 0.25;
    private static final double EXPERT_DECAY = 0.0;
    private static final double LEARNING_RATE = 0.05;
    private static final int BUFFER_SIZE_MULTIPLIER = 20;
    private static final int MAX_DOCS = 1000;
    private static final int RETRAIN_ITERATIONS = 100;
    private static final int NUM_EPOCHS = 15;
    private static final int EVAL_FREQUENCY = 1;
    private static final int MIN_PAIRS = 10;
    private static final double MIN_PAIRWISE_SCORE = 0.15;
    private static final int EARLY_STOP_THRESHOLD = 1000;
    private static final double EARLY_STOP_VAL = 7500.0;
    public static int currentDocId = 0;
    public static int isTraining = 1;
    private final ClustererClassifier classifier;
    private final Random random = new Random(0L);
    private static int featuresCacheHits;
    private static int featuresCacheMisses;
    private static Map<MergeKey, CompressedFeatureVector> featuresCache;
    private static Compressor<String> compressor;

    public Clusterer() {
        this.classifier = new ClustererClassifier(0.05);
    }

    public Clusterer(String modelPath) {
        this.classifier = new ClustererClassifier(modelPath, 0.05);
    }

    public List<Pair<Integer, Integer>> getClusterMerges(ClustererDataLoader.ClustererDoc doc) {
        ArrayList<Pair<Integer, Integer>> merges = new ArrayList<Pair<Integer, Integer>>();
        State currentState = new State(doc);
        while (!currentState.isComplete()) {
            Pair currentPair = (Pair)currentState.mentionPairs.get(currentState.currentIndex);
            if (!currentState.doBestAction(this.classifier)) continue;
            merges.add(currentPair);
        }
        return merges;
    }

    public void doTraining(String modelName) {
        List<ClustererDataLoader.ClustererDoc> trainDocs;
        PrintWriter progressWriter;
        this.classifier.setWeight("bias", -0.3);
        this.classifier.setWeight("anaphorSeen", -1.0);
        this.classifier.setWeight("max-ranking", 1.0);
        this.classifier.setWeight("bias-single", -0.3);
        this.classifier.setWeight("anaphorSeen-single", -1.0);
        this.classifier.setWeight("max-ranking-single", 1.0);
        String outputPath = StatisticalCorefTrainer.clusteringModelsPath + modelName + "/";
        File outDir = new File(outputPath);
        if (!outDir.exists()) {
            outDir.mkdir();
        }
        try {
            PrintWriter configWriter = new PrintWriter(outputPath + "config", "UTF-8");
            configWriter.print(StatisticalCorefTrainer.fieldValues(this));
            configWriter.close();
            progressWriter = new PrintWriter(outputPath + "progress", "UTF-8");
            Redwood.log("scoref.train", "Loading training data");
            StatisticalCorefTrainer.setDataPath("dev");
            trainDocs = ClustererDataLoader.loadDocuments(1000);
        }
        catch (Exception e) {
            throw new RuntimeException("Error setting up training", e);
        }
        double bestTrainScore = 0.0;
        ArrayList<List<Pair<CandidateAction, CandidateAction>>> examples = new ArrayList();
        for (int iteration = 0; iteration < 100; ++iteration) {
            Redwood.log("scoref.train", "ITERATION " + iteration);
            this.classifier.printWeightVector(null);
            Redwood.log("scoref.train", "");
            try {
                this.classifier.writeWeights(outputPath + "model");
                this.classifier.printWeightVector(IOUtils.getPrintWriter(outputPath + "weights"));
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
            long start = System.currentTimeMillis();
            Collections.shuffle(trainDocs, this.random);
            examples = examples.subList(Math.max(0, examples.size() - 20 * trainDocs.size()), examples.size());
            this.trainPolicy(examples);
            if (iteration % 1 == 0) {
                double trainScore = this.evaluatePolicy(trainDocs, true);
                if (trainScore > bestTrainScore) {
                    bestTrainScore = trainScore;
                    this.writeModel("best", outputPath);
                }
                if (iteration % 10 == 0) {
                    this.writeModel("iter_" + iteration, outputPath);
                }
                this.writeModel("last", outputPath);
                double timeElapsed = (double)(System.currentTimeMillis() - start) / 1000.0;
                double ffhr = (double)State.ffHits / (double)(State.ffHits + State.ffMisses);
                double shr = (double)State.sHits / (double)(State.sHits + State.sMisses);
                double fhr = (double)featuresCacheHits / (double)(featuresCacheHits + featuresCacheMisses);
                Redwood.log("scoref.train", modelName);
                Redwood.log("scoref.train", String.format("Best train: %.4f", bestTrainScore));
                Redwood.log("scoref.train", String.format("Time elapsed: %.2f", timeElapsed));
                Redwood.log("scoref.train", String.format("Cost hit rate: %.4f", ffhr));
                Redwood.log("scoref.train", String.format("Score hit rate: %.4f", shr));
                Redwood.log("scoref.train", String.format("Features hit rate: %.4f", fhr));
                Redwood.log("scoref.train", "");
                progressWriter.write(iteration + " " + trainScore + "  " + timeElapsed + " " + ffhr + " " + shr + " " + fhr + "\n");
                progressWriter.flush();
            }
            for (ClustererDataLoader.ClustererDoc trainDoc : trainDocs) {
                examples.add(this.runPolicy(trainDoc, Math.pow(0.0, iteration + 1)));
            }
        }
        progressWriter.close();
    }

    private void writeModel(String name, String modelPath) {
        try {
            this.classifier.writeWeights(modelPath + name + "_model.ser");
            this.classifier.printWeightVector(IOUtils.getPrintWriter(modelPath + name + "_weights"));
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    private void trainPolicy(List<List<Pair<CandidateAction, CandidateAction>>> examples) {
        ArrayList flattenedExamples = new ArrayList();
        examples.stream().forEach(flattenedExamples::addAll);
        for (int epoch = 0; epoch < 15; ++epoch) {
            Collections.shuffle(flattenedExamples, this.random);
            flattenedExamples.forEach(this.classifier::learn);
        }
        double totalCost = flattenedExamples.stream().mapToDouble(e -> this.classifier.bestAction((Pair<CandidateAction, CandidateAction>)e).cost).sum();
        Redwood.log("scoref.train", String.format("Training cost: %.4f", 100.0 * totalCost / (double)flattenedExamples.size()));
    }

    private double evaluatePolicy(List<ClustererDataLoader.ClustererDoc> docs, boolean training) {
        isTraining = 0;
        EvalUtils.B3Evaluator evaluator = new EvalUtils.B3Evaluator();
        for (ClustererDataLoader.ClustererDoc doc : docs) {
            State currentState = new State(doc);
            while (!currentState.isComplete()) {
                currentState.doBestAction(this.classifier);
            }
            currentState.updateEvaluator(evaluator);
        }
        isTraining = 1;
        double score = evaluator.getF1();
        Redwood.log("scoref.train", String.format("B3 F1 score on %s: %.4f", training ? "train" : "validate", score));
        return score;
    }

    private List<Pair<CandidateAction, CandidateAction>> runPolicy(ClustererDataLoader.ClustererDoc doc, double beta) {
        ArrayList<Pair<CandidateAction, CandidateAction>> examples = new ArrayList<Pair<CandidateAction, CandidateAction>>();
        State currentState = new State(doc);
        while (!currentState.isComplete()) {
            Pair<CandidateAction, CandidateAction> actions = currentState.getActions(this.classifier);
            if (actions == null) continue;
            examples.add(actions);
            boolean useExpert = this.random.nextDouble() < beta;
            double action1Score = useExpert ? -((CandidateAction)actions.first).cost : this.classifier.weightFeatureProduct(((CandidateAction)actions.first).features);
            double action2Score = useExpert ? -((CandidateAction)actions.second).cost : this.classifier.weightFeatureProduct(((CandidateAction)actions.second).features);
            currentState.doAction(action1Score >= action2Score);
        }
        return examples;
    }

    private static Counter<String> getFeatures(ClustererDataLoader.ClustererDoc doc, Pair<Integer, Integer> mentionPair, Counter<Pair<Integer, Integer>> scores) {
        ClassicCounter<String> features = new ClassicCounter<String>();
        if (!scores.containsKey(mentionPair)) {
            mentionPair = new Pair(mentionPair.second, mentionPair.first);
        }
        double score = scores.getCount(mentionPair);
        features.incrementCount("max", score);
        return features;
    }

    private static Counter<String> getFeatures(ClustererDataLoader.ClustererDoc doc, List<Pair<Integer, Integer>> mentionPairs, Counter<Pair<Integer, Integer>> scores) {
        ClassicCounter<String> features = new ClassicCounter<String>();
        double maxScore = 0.0;
        double minScore = 1.0;
        ClassicCounter<String> totals = new ClassicCounter<String>();
        ClassicCounter<String> totalsLog = new ClassicCounter<String>();
        ClassicCounter<String> counts = new ClassicCounter<String>();
        for (Pair<Integer, Integer> mentionPair : mentionPairs) {
            if (!scores.containsKey(mentionPair)) {
                mentionPair = new Pair(mentionPair.second, mentionPair.first);
            }
            double score = scores.getCount(mentionPair);
            double logScore = Clusterer.cappedLog(score);
            String mt1 = doc.mentionTypes.get(mentionPair.first);
            String mt2 = doc.mentionTypes.get(mentionPair.second);
            mt1 = mt1.equals("PRONOMINAL") ? "PRONOMINAL" : "NON_PRONOMINAL";
            mt2 = mt2.equals("PRONOMINAL") ? "PRONOMINAL" : "NON_PRONOMINAL";
            String conj = "_" + mt1 + "_" + mt2;
            maxScore = Math.max(maxScore, score);
            minScore = Math.min(minScore, score);
            totals.incrementCount("", score);
            totalsLog.incrementCount("", logScore);
            counts.incrementCount("");
            totals.incrementCount(conj, score);
            totalsLog.incrementCount(conj, logScore);
            counts.incrementCount(conj);
        }
        features.incrementCount("max", maxScore);
        features.incrementCount("min", minScore);
        for (String key : counts.keySet()) {
            features.incrementCount("avg" + key, totals.getCount(key) / (double)mentionPairs.size());
            features.incrementCount("avgLog" + key, totalsLog.getCount(key) / (double)mentionPairs.size());
        }
        return features;
    }

    private static int earliestMention(Cluster c, ClustererDataLoader.ClustererDoc doc) {
        int earliest = -1;
        for (int m : c.mentions) {
            int pos = doc.mentionIndices.get(m);
            if (earliest != -1 && pos >= doc.mentionIndices.get(earliest)) continue;
            earliest = m;
        }
        return earliest;
    }

    private static Counter<String> getFeatures(ClustererDataLoader.ClustererDoc doc, Cluster c1, Cluster c2, GlobalFeatures gf) {
        Counter<String> features;
        MergeKey key = new MergeKey(c1, c2, gf.currentIndex);
        CompressedFeatureVector cfv = featuresCache.get(key);
        Counter<String> counter = features = cfv == null ? null : compressor.uncompress(cfv);
        if (features != null) {
            featuresCacheHits += isTraining;
            return features;
        }
        featuresCacheMisses += isTraining;
        features = new ClassicCounter<String>();
        if (gf.anaphorSeen) {
            features.incrementCount("anaphorSeen");
        }
        features.incrementCount("docSize", gf.docSize);
        features.incrementCount("percentComplete", (double)gf.currentIndex / (double)gf.size);
        features.incrementCount("bias", 1.0);
        int earliest1 = Clusterer.earliestMention(c1, doc);
        int earliest2 = Clusterer.earliestMention(c2, doc);
        if (doc.mentionIndices.get(earliest1) > doc.mentionIndices.get(earliest2)) {
            int tmp = earliest1;
            earliest1 = earliest2;
            earliest2 = tmp;
        }
        features.incrementCount("anaphoricity", doc.anaphoricityScores.getCount(earliest2));
        if (c1.mentions.size() == 1 && c2.mentions.size() == 1) {
            Pair<Integer, Integer> mentionPair = new Pair<Integer, Integer>(c1.mentions.get(0), c2.mentions.get(0));
            features.addAll(Clusterer.addSuffix(Clusterer.getFeatures(doc, mentionPair, doc.classificationScores), "-classification"));
            features.addAll(Clusterer.addSuffix(Clusterer.getFeatures(doc, mentionPair, doc.rankingScores), "-ranking"));
            features = Clusterer.addSuffix(features, "-single");
        } else {
            ArrayList<Pair<Integer, Integer>> between = new ArrayList<Pair<Integer, Integer>>();
            for (int m1 : c1.mentions) {
                for (int m2 : c2.mentions) {
                    between.add(new Pair<Integer, Integer>(m1, m2));
                }
            }
            features.addAll(Clusterer.addSuffix(Clusterer.getFeatures(doc, between, doc.classificationScores), "-classification"));
            features.addAll(Clusterer.addSuffix(Clusterer.getFeatures(doc, between, doc.rankingScores), "-ranking"));
        }
        featuresCache.put(key, compressor.compress(features));
        return features;
    }

    private static Counter<String> addSuffix(Counter<String> features, String suffix) {
        ClassicCounter<String> withSuffix = new ClassicCounter<String>();
        for (Map.Entry<String, Double> e : features.entrySet()) {
            withSuffix.incrementCount(e.getKey() + suffix, e.getValue());
        }
        return withSuffix;
    }

    private static double cappedLog(double x) {
        return Math.log(Math.max(x, 1.0E-8));
    }

    static {
        featuresCache = new HashMap<MergeKey, CompressedFeatureVector>();
        compressor = new Compressor();
    }

    private static class CandidateAction {
        public final Counter<String> features;
        public final double cost;

        public CandidateAction(Counter<String> features, double cost) {
            this.features = features;
            this.cost = cost;
        }
    }

    private static class ClustererClassifier
    extends SimpleLinearClassifier {
        public ClustererClassifier(double learningRate) {
            super(SimpleLinearClassifier.risk(), SimpleLinearClassifier.constant(learningRate), 0.0);
        }

        public ClustererClassifier(String modelFile, double learningRate) {
            super(SimpleLinearClassifier.risk(), SimpleLinearClassifier.constant(learningRate), 0.0, modelFile);
        }

        public CandidateAction bestAction(Pair<CandidateAction, CandidateAction> actions) {
            return this.weightFeatureProduct(((CandidateAction)actions.first).features) > this.weightFeatureProduct(((CandidateAction)actions.second).features) ? (CandidateAction)actions.first : (CandidateAction)actions.second;
        }

        public void learn(Pair<CandidateAction, CandidateAction> actions) {
            CandidateAction goodAction = (CandidateAction)actions.first;
            CandidateAction badAction = (CandidateAction)actions.second;
            if (badAction.cost == 0.0) {
                CandidateAction tmp = goodAction;
                goodAction = badAction;
                badAction = tmp;
            }
            ClassicCounter<String> features = new ClassicCounter<String>(goodAction.features);
            for (Map.Entry<String, Double> e : badAction.features.entrySet()) {
                features.decrementCount(e.getKey(), e.getValue());
            }
            this.learn(features, 0.0, badAction.cost);
        }
    }

    public static class Cluster {
        private static final Map<Pair<Integer, Integer>, Long> MENTION_HASHES = new HashMap<Pair<Integer, Integer>, Long>();
        private static final Random RANDOM = new Random(0L);
        public final List<Integer> mentions;
        public long hash;

        public Cluster(int m) {
            this.mentions = new ArrayList<Integer>();
            this.mentions.add(m);
            this.hash = Cluster.getMentionHash(m);
        }

        public Cluster(Cluster c) {
            this.mentions = new ArrayList<Integer>(c.mentions);
            this.hash = c.hash;
        }

        public void merge(Cluster c) {
            this.mentions.addAll(c.mentions);
            this.hash ^= c.hash;
        }

        public int size() {
            return this.mentions.size();
        }

        public long getHash() {
            return this.hash;
        }

        private static long getMentionHash(int m) {
            Pair<Integer, Integer> pair = new Pair<Integer, Integer>(m, currentDocId);
            Long hash = MENTION_HASHES.get(pair);
            if (hash == null) {
                hash = RANDOM.nextLong();
                MENTION_HASHES.put(pair, hash);
            }
            return hash;
        }
    }

    private static class MergeKey {
        private final int hash;

        public MergeKey(Cluster c1, Cluster c2, int ind) {
            this.hash = (int)(c1.hash ^ c2.hash) + 2003 * ind + currentDocId;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            return ((MergeKey)o).hash == this.hash;
        }
    }

    private static class State {
        private static int sHits;
        private static int sMisses;
        private static int ffHits;
        private static int ffMisses;
        private final Map<MergeKey, Boolean> hashedScores;
        private final Map<Long, Double> hashedCosts;
        private final ClustererDataLoader.ClustererDoc doc;
        private final List<Cluster> clusters;
        private final Map<Integer, Cluster> mentionToCluster;
        private final List<Pair<Integer, Integer>> mentionPairs;
        private final List<GlobalFeatures> globalFeatures;
        private int currentIndex;
        private Cluster c1;
        private Cluster c2;
        private long hash;

        public State(ClustererDataLoader.ClustererDoc doc) {
            double score;
            currentDocId = doc.id;
            this.doc = doc;
            this.hashedScores = new HashMap<MergeKey, Boolean>();
            this.hashedCosts = new HashMap<Long, Double>();
            this.clusters = new ArrayList<Cluster>();
            this.hash = 0L;
            this.mentionToCluster = new HashMap<Integer, Cluster>();
            for (int m : doc.mentions) {
                Cluster c = new Cluster(m);
                this.clusters.add(c);
                this.mentionToCluster.put(m, c);
                this.hash ^= c.hash * 7L;
            }
            ArrayList<Pair<Integer, Integer>> allPairs = new ArrayList<Pair<Integer, Integer>>(doc.classificationScores.keySet());
            Counter<Pair<Integer, Integer>> scores = doc.rankingScores;
            Collections.sort(allPairs, (p1, p2) -> {
                double diff = scores.getCount(p2) - scores.getCount(p1);
                return diff == 0.0 ? 0 : (int)Math.signum(diff);
            });
            int i = 0;
            for (i = 0; !(i >= allPairs.size() || (score = scores.getCount(allPairs.get(i))) < 0.15 && i > 10 || i >= 1000 && (double)i / score > 7500.0); ++i) {
            }
            this.mentionPairs = allPairs.subList(0, i);
            ClassicCounter seenAnaphors = new ClassicCounter();
            ClassicCounter seenAntecedents = new ClassicCounter();
            this.globalFeatures = new ArrayList<GlobalFeatures>();
            int j = 0;
            while (j < allPairs.size()) {
                Pair mentionPair = (Pair)allPairs.get(j);
                GlobalFeatures gf = new GlobalFeatures();
                gf.currentIndex = j++;
                gf.anaphorSeen = seenAnaphors.containsKey(mentionPair.second);
                gf.size = this.mentionPairs.size();
                gf.docSize = (double)doc.mentions.size() / 300.0;
                this.globalFeatures.add(gf);
                seenAnaphors.incrementCount(mentionPair.second);
                seenAntecedents.incrementCount(mentionPair.first);
            }
            this.currentIndex = 0;
            this.setClusters();
        }

        public State(State state) {
            this.hashedScores = state.hashedScores;
            this.hashedCosts = state.hashedCosts;
            this.doc = state.doc;
            this.hash = state.hash;
            this.mentionPairs = state.mentionPairs;
            this.currentIndex = state.currentIndex;
            this.globalFeatures = state.globalFeatures;
            this.clusters = new ArrayList<Cluster>();
            this.mentionToCluster = new HashMap<Integer, Cluster>();
            for (Cluster c : state.clusters) {
                Cluster copy = new Cluster(c);
                this.clusters.add(copy);
                for (int m : copy.mentions) {
                    this.mentionToCluster.put(m, copy);
                }
            }
            this.setClusters();
        }

        public void setClusters() {
            Pair<Integer, Integer> currentPair = this.mentionPairs.get(this.currentIndex);
            this.c1 = this.mentionToCluster.get(currentPair.first);
            this.c2 = this.mentionToCluster.get(currentPair.second);
        }

        public void doAction(boolean isMerge) {
            if (isMerge) {
                if (this.c2.size() > this.c1.size()) {
                    Cluster tmp = this.c1;
                    this.c1 = this.c2;
                    this.c2 = tmp;
                }
                this.hash ^= 7L * this.c1.hash;
                this.hash ^= 7L * this.c2.hash;
                this.c1.merge(this.c2);
                for (int m : this.c2.mentions) {
                    this.mentionToCluster.put(m, this.c1);
                }
                this.clusters.remove(this.c2);
                this.hash ^= 7L * this.c1.hash;
            }
            ++this.currentIndex;
            if (!this.isComplete()) {
                this.setClusters();
            }
            while (this.c1 == this.c2) {
                ++this.currentIndex;
                if (this.isComplete()) break;
                this.setClusters();
            }
        }

        public boolean doBestAction(ClustererClassifier classifier) {
            Boolean doMerge = this.hashedScores.get(new MergeKey(this.c1, this.c2, this.currentIndex));
            if (doMerge == null) {
                Counter features = Clusterer.getFeatures(this.doc, this.c1, this.c2, this.globalFeatures.get(this.currentIndex));
                doMerge = classifier.weightFeatureProduct(features) > 0.0;
                this.hashedScores.put(new MergeKey(this.c1, this.c2, this.currentIndex), doMerge);
                sMisses += isTraining;
            } else {
                sHits += isTraining;
            }
            this.doAction(doMerge);
            return doMerge;
        }

        public boolean isComplete() {
            return this.currentIndex >= this.mentionPairs.size();
        }

        public double getFinalCost(ClustererClassifier classifier) {
            ffMisses += isTraining;
            double cost = EvalUtils.getCombinedF1(0.25, this.doc.goldClusters, this.clusters, this.doc.mentionToGold, this.mentionToCluster);
            this.hashedCosts.put(this.hash, cost);
            return cost;
        }

        public void updateEvaluator(EvalUtils.Evaluator evaluator) {
            evaluator.update(this.doc.goldClusters, this.clusters, this.doc.mentionToGold, this.mentionToCluster);
        }

        public Pair<CandidateAction, CandidateAction> getActions(ClustererClassifier classifier) {
            Counter mergeFeatures = Clusterer.getFeatures(this.doc, this.c1, this.c2, this.globalFeatures.get(this.currentIndex));
            double mergeScore = Math.exp(classifier.weightFeatureProduct(mergeFeatures));
            this.hashedScores.put(new MergeKey(this.c1, this.c2, this.currentIndex), mergeScore > 0.5);
            State merge = new State(this);
            merge.doAction(true);
            double mergeB3 = merge.getFinalCost(classifier);
            State noMerge = new State(this);
            noMerge.doAction(false);
            double noMergeB3 = noMerge.getFinalCost(classifier);
            double weight = (double)this.doc.mentions.size() / 100.0;
            double maxB3 = Math.max(mergeB3, noMergeB3);
            return new Pair<CandidateAction, CandidateAction>(new CandidateAction(mergeFeatures, weight * (maxB3 - mergeB3)), new CandidateAction(new ClassicCounter<String>(), weight * (maxB3 - noMergeB3)));
        }

        private static /* synthetic */ int lambda$new$1(Counter scores, ClustererDataLoader.ClustererDoc doc, Pair p1, Pair p2) {
            if (((Integer)p1.second).equals(p2.second)) {
                double diff = scores.getCount(p2) - scores.getCount(p1);
                return diff == 0.0 ? 0 : (int)Math.signum(diff);
            }
            return doc.mentionIndices.get(p1.second) < doc.mentionIndices.get(p2.second) ? -1 : 1;
        }
    }

    private static class GlobalFeatures {
        public boolean anaphorSeen;
        public int currentIndex;
        public int size;
        public double docSize;

        private GlobalFeatures() {
        }
    }
}

