/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.dcoref.CoNLL2011DocumentReader;
import edu.stanford.nlp.dcoref.CorefCluster;
import edu.stanford.nlp.dcoref.Dictionaries;
import edu.stanford.nlp.dcoref.Mention;
import edu.stanford.nlp.dcoref.Rules;
import edu.stanford.nlp.dcoref.SieveCoreferenceSystem;
import edu.stanford.nlp.dcoref.SpeakerInfo;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.math.NumberMatchingRegex;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.util.CollectionValuedMap;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.IntTuple;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.TwoDimensionalMap;
import edu.stanford.nlp.util.TwoDimensionalSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Document
implements Serializable {
    private static final long serialVersionUID = -4139866807494603953L;
    public DocType docType;
    public Annotation annotation;
    public CoNLL2011DocumentReader.Document conllDoc;
    public List<List<Mention>> goldOrderedMentionsBySentence;
    public List<List<Mention>> predictedOrderedMentionsBySentence;
    public Map<Integer, CorefCluster> corefClusters;
    public Map<Integer, CorefCluster> goldCorefClusters = null;
    public Map<Integer, Mention> allPredictedMentions;
    public Map<Integer, Mention> allGoldMentions;
    public Set<Mention> roleSet;
    public Map<Mention, IntTuple> positions;
    public Map<Mention, IntTuple> allPositions;
    public final Map<IntTuple, Mention> mentionheadPositions;
    private List<Pair<IntTuple, IntTuple>> goldLinks;
    public Map<Integer, String> speakers;
    public Set<Pair<Integer, Integer>> speakerPairs;
    public int maxUtter;
    public int numParagraph;
    public int numSentences;
    private TwoDimensionalSet<Integer, Integer> incompatibles;
    private TwoDimensionalSet<Integer, Integer> incompatibleClusters;
    protected TwoDimensionalMap<Integer, Integer, Boolean> acronymCache;
    private transient Map<String, SpeakerInfo> speakerInfoMap = Generics.newHashMap();

    public List<List<Mention>> getOrderedMentions() {
        return this.predictedOrderedMentionsBySentence;
    }

    public Document() {
        this.positions = Generics.newHashMap();
        this.mentionheadPositions = Generics.newHashMap();
        this.roleSet = Generics.newHashSet();
        this.corefClusters = Generics.newHashMap();
        this.allPredictedMentions = Generics.newHashMap();
        this.allGoldMentions = Generics.newHashMap();
        this.speakers = Generics.newHashMap();
        this.speakerPairs = Generics.newHashSet();
        this.incompatibles = TwoDimensionalSet.hashSet();
        this.incompatibleClusters = TwoDimensionalSet.hashSet();
        this.acronymCache = TwoDimensionalMap.hashMap();
    }

    public Document(Annotation anno, List<List<Mention>> predictedMentions, List<List<Mention>> goldMentions, Dictionaries dict) {
        this();
        this.annotation = anno;
        this.numSentences = ((List)anno.get(CoreAnnotations.SentencesAnnotation.class)).size();
        this.predictedOrderedMentionsBySentence = predictedMentions;
        this.goldOrderedMentionsBySentence = goldMentions;
        if (goldMentions != null) {
            this.findTwinMentions(true);
            for (List<Mention> l : this.goldOrderedMentionsBySentence) {
                for (Mention g : l) {
                    this.allGoldMentions.put(g.mentionID, g);
                }
            }
        }
        this.initialize();
        this.processDiscourse(dict);
        this.printMentionDetection();
    }

    protected void processDiscourse(Dictionaries dict) {
        this.docType = this.findDocType(dict);
        this.markQuotations((List)this.annotation.get(CoreAnnotations.SentencesAnnotation.class), false);
        this.findSpeakers(dict);
        for (Mention m : this.allPredictedMentions.values()) {
            int utter = (Integer)m.headWord.get(CoreAnnotations.UtteranceAnnotation.class);
            String speaker = (String)m.headWord.get(CoreAnnotations.SpeakerAnnotation.class);
            if (speaker != null) {
                SpeakerInfo speakerInfo = this.speakerInfoMap.get(speaker);
                if (speakerInfo == null) {
                    speakerInfo = new SpeakerInfo(speaker);
                    this.speakerInfoMap.put(speaker, speakerInfo);
                    if (Rules.mentionMatchesSpeaker(m, speakerInfo, true)) {
                        m.speakerInfo = speakerInfo;
                    }
                }
                if (NumberMatchingRegex.isDecimalInteger(speaker)) {
                    try {
                        int speakerMentionID = Integer.parseInt(speaker);
                        if (utter != 0) {
                            this.speakerPairs.add(new Pair<Integer, Integer>(m.mentionID, speakerMentionID));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (this.docType == DocType.ARTICLE || m.person != Dictionaries.Person.YOU || m.endIndex >= m.sentenceWords.size() - 1 || !((String)m.sentenceWords.get(m.endIndex).get(CoreAnnotations.TextAnnotation.class)).equalsIgnoreCase("know")) continue;
            m.generic = true;
        }
        block3: for (Mention m : this.allPredictedMentions.values()) {
            if (m.speakerInfo != null) continue;
            for (SpeakerInfo speakerInfo : this.speakerInfoMap.values()) {
                if (!speakerInfo.hasRealSpeakerName() || !Rules.mentionMatchesSpeaker(m, speakerInfo, false)) continue;
                m.speakerInfo = speakerInfo;
                continue block3;
            }
        }
    }

    protected void initialize() {
        if (this.goldOrderedMentionsBySentence == null) {
            this.assignOriginalID();
        }
        this.setParagraphAnnotation();
        this.initializeCorefCluster();
        this.allPositions = Generics.newHashMap(this.positions);
    }

    private void initializeCorefCluster() {
        for (int i = 0; i < this.predictedOrderedMentionsBySentence.size(); ++i) {
            for (int j = 0; j < this.predictedOrderedMentionsBySentence.get(i).size(); ++j) {
                Mention m = this.predictedOrderedMentionsBySentence.get(i).get(j);
                if (this.allPredictedMentions.containsKey(m.mentionID)) {
                    SieveCoreferenceSystem.logger.warning("WARNING: Already contain mention " + m.mentionID);
                    Mention m1 = this.allPredictedMentions.get(m.mentionID);
                    SieveCoreferenceSystem.logger.warning("OLD mention: " + m1.spanToString() + "[" + m1.startIndex + "," + m1.endIndex + "]");
                    SieveCoreferenceSystem.logger.warning("NEW mention: " + m.spanToString() + "[" + m.startIndex + "," + m.endIndex + "]");
                }
                assert (!this.allPredictedMentions.containsKey(m.mentionID));
                this.allPredictedMentions.put(m.mentionID, m);
                IntTuple pos = new IntTuple(2);
                pos.set(0, i);
                pos.set(1, j);
                this.positions.put(m, pos);
                m.sentNum = i;
                assert (!this.corefClusters.containsKey(m.mentionID));
                this.corefClusters.put(m.mentionID, new CorefCluster(m.mentionID, Generics.newHashSet(Collections.singletonList(m))));
                m.corefClusterID = m.mentionID;
                IntTuple headPosition = new IntTuple(2);
                headPosition.set(0, i);
                headPosition.set(1, m.headIndex);
                this.mentionheadPositions.put(headPosition, m);
            }
        }
    }

    public boolean isIncompatible(CorefCluster c1, CorefCluster c2) {
        int cid1 = Math.min(c1.clusterID, c2.clusterID);
        int cid2 = Math.max(c1.clusterID, c2.clusterID);
        return this.incompatibleClusters.contains(cid1, cid2);
    }

    public void mergeIncompatibles(CorefCluster to, CorefCluster from) {
        ArrayList<Pair<Pair<Integer, Integer>, Pair<Integer, Integer>>> replacements = new ArrayList<Pair<Pair<Integer, Integer>, Pair<Integer, Integer>>>();
        for (Pair<Integer, Integer> pair : this.incompatibleClusters) {
            Integer other = null;
            if ((Integer)pair.first == from.clusterID) {
                other = (Integer)pair.second;
            } else if ((Integer)pair.second == from.clusterID) {
                other = (Integer)pair.first;
            }
            if (other == null || other == to.clusterID) continue;
            int cid1 = Math.min(other, to.clusterID);
            int cid2 = Math.max(other, to.clusterID);
            replacements.add(Pair.makePair(pair, Pair.makePair(cid1, cid2)));
        }
        for (Pair<Integer, Integer> pair : replacements) {
            this.incompatibleClusters.remove((Integer)((Pair)pair.first).first(), (Integer)((Pair)pair.first).second());
            this.incompatibleClusters.add((Integer)((Pair)pair.second).first(), (Integer)((Pair)pair.second).second());
        }
    }

    public void mergeAcronymCache(CorefCluster to, CorefCluster from) {
        TwoDimensionalSet<Integer, Integer> replacements = TwoDimensionalSet.hashSet();
        for (Integer first : this.acronymCache.firstKeySet()) {
            for (Integer second : this.acronymCache.get(first).keySet()) {
                if (!this.acronymCache.get(first, second).booleanValue()) continue;
                Integer other = null;
                if (first == from.clusterID) {
                    other = second;
                } else if (second == from.clusterID) {
                    other = first;
                }
                if (other == null || other == to.clusterID) continue;
                int cid1 = Math.min(other, to.clusterID);
                int cid2 = Math.max(other, to.clusterID);
                replacements.add(cid1, cid2);
            }
        }
        for (Integer first : replacements.firstKeySet()) {
            for (Integer second : replacements.secondKeySet(first)) {
                this.acronymCache.put(first, second, true);
            }
        }
    }

    public boolean isIncompatible(Mention m1, Mention m2) {
        int mid1 = Math.min(m1.mentionID, m2.mentionID);
        int mid2 = Math.max(m1.mentionID, m2.mentionID);
        return this.incompatibles.contains(mid1, mid2);
    }

    public void addIncompatible(Mention m1, Mention m2) {
        int mid1 = Math.min(m1.mentionID, m2.mentionID);
        int mid2 = Math.max(m1.mentionID, m2.mentionID);
        this.incompatibles.add(mid1, mid2);
        int cid1 = Math.min(m1.corefClusterID, m2.corefClusterID);
        int cid2 = Math.max(m1.corefClusterID, m2.corefClusterID);
        this.incompatibleClusters.add(cid1, cid2);
    }

    protected void findTwinMentions(boolean strict) {
        if (strict) {
            this.findTwinMentionsStrict();
        } else {
            this.findTwinMentionsRelaxed();
        }
    }

    private void findTwinMentionsStrict() {
        for (int sentNum = 0; sentNum < this.goldOrderedMentionsBySentence.size(); ++sentNum) {
            List<Mention> golds = this.goldOrderedMentionsBySentence.get(sentNum);
            List<Mention> predicts = this.predictedOrderedMentionsBySentence.get(sentNum);
            CollectionValuedMap<IntPair, Mention> goldMentionPositions = new CollectionValuedMap<IntPair, Mention>();
            for (Mention g : golds) {
                IntPair ip = new IntPair(g.startIndex, g.endIndex);
                if (goldMentionPositions.containsKey(ip)) {
                    StringBuilder existingMentions = new StringBuilder();
                    Iterator iterator = goldMentionPositions.get(ip).iterator();
                    while (iterator.hasNext()) {
                        Mention eg = (Mention)iterator.next();
                        if (existingMentions.length() > 0) {
                            existingMentions.append(",");
                        }
                        existingMentions.append(eg.mentionID);
                    }
                    SieveCoreferenceSystem.logger.warning("WARNING: gold mentions with the same offsets: " + ip + " mentions=" + g.mentionID + "," + existingMentions + ", " + g.spanToString());
                }
                goldMentionPositions.add(new IntPair(g.startIndex, g.endIndex), g);
            }
            for (Mention p : predicts) {
                IntPair pos = new IntPair(p.startIndex, p.endIndex);
                if (!goldMentionPositions.containsKey(pos)) continue;
                Object cm = goldMentionPositions.get(pos);
                Mention g = (Mention)cm.iterator().next();
                cm.remove(g);
                p.mentionID = g.mentionID;
                p.twinless = false;
                g.twinless = false;
            }
            for (Mention p : predicts) {
                if (!p.twinless) continue;
                p.mentionID += 10000;
            }
        }
    }

    private void findTwinMentionsRelaxed() {
        for (int sentNum = 0; sentNum < this.goldOrderedMentionsBySentence.size(); ++sentNum) {
            List<Mention> golds = this.goldOrderedMentionsBySentence.get(sentNum);
            List<Mention> predicts = this.predictedOrderedMentionsBySentence.get(sentNum);
            Map<IntPair, Mention> goldMentionPositions = Generics.newHashMap();
            Map goldMentionHeadPositions = Generics.newHashMap();
            for (Mention g : golds) {
                goldMentionPositions.put(new IntPair(g.startIndex, g.endIndex), g);
                if (!goldMentionHeadPositions.containsKey(g.headIndex)) {
                    goldMentionHeadPositions.put(g.headIndex, new LinkedList());
                }
                ((LinkedList)goldMentionHeadPositions.get(g.headIndex)).add(g);
            }
            ArrayList<Mention> remains = new ArrayList<Mention>();
            for (Mention p : predicts) {
                IntPair pos = new IntPair(p.startIndex, p.endIndex);
                if (goldMentionPositions.containsKey(pos)) {
                    Mention g = (Mention)goldMentionPositions.get(pos);
                    p.mentionID = g.mentionID;
                    p.twinless = false;
                    g.twinless = false;
                    ((LinkedList)goldMentionHeadPositions.get(g.headIndex)).remove(g);
                    if (!((LinkedList)goldMentionHeadPositions.get(g.headIndex)).isEmpty()) continue;
                    goldMentionHeadPositions.remove(g.headIndex);
                    continue;
                }
                remains.add(p);
            }
            for (Mention r : remains) {
                if (!goldMentionHeadPositions.containsKey(r.headIndex)) continue;
                Mention g = (Mention)((LinkedList)goldMentionHeadPositions.get(r.headIndex)).poll();
                r.mentionID = g.mentionID;
                r.twinless = false;
                g.twinless = false;
                if (!((LinkedList)goldMentionHeadPositions.get(g.headIndex)).isEmpty()) continue;
                goldMentionHeadPositions.remove(g.headIndex);
            }
        }
    }

    private void setParagraphAnnotation() {
        int paragraphIndex = 0;
        int previousOffset = -10;
        for (CoreMap coreMap : (List)this.annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreLabel w : (List)coreMap.get(CoreAnnotations.TokensAnnotation.class)) {
                if (w.containsKey(CoreAnnotations.CharacterOffsetBeginAnnotation.class)) {
                    if ((Integer)w.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class) > previousOffset + 2) {
                        ++paragraphIndex;
                    }
                    w.set(CoreAnnotations.ParagraphAnnotation.class, paragraphIndex);
                    previousOffset = (Integer)w.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
                    continue;
                }
                w.set(CoreAnnotations.ParagraphAnnotation.class, -1);
            }
        }
        for (List list : this.predictedOrderedMentionsBySentence) {
            for (Mention m : list) {
                m.paragraph = (Integer)m.headWord.get(CoreAnnotations.ParagraphAnnotation.class);
            }
        }
        this.numParagraph = paragraphIndex;
    }

    private DocType findDocType(Dictionaries dict) {
        boolean speakerChange = false;
        Set<Integer> discourseWithIorYou = Generics.newHashSet();
        for (CoreMap sent : (List)this.annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreLabel w : (List)sent.get(CoreAnnotations.TokensAnnotation.class)) {
                int utterIndex = (Integer)w.get(CoreAnnotations.UtteranceAnnotation.class);
                if (utterIndex != 0) {
                    speakerChange = true;
                }
                if (speakerChange && utterIndex == 0) {
                    return DocType.ARTICLE;
                }
                if (dict.firstPersonPronouns.contains(((String)w.get(CoreAnnotations.TextAnnotation.class)).toLowerCase()) || dict.secondPersonPronouns.contains(((String)w.get(CoreAnnotations.TextAnnotation.class)).toLowerCase())) {
                    discourseWithIorYou.add(utterIndex);
                }
                if (this.maxUtter >= utterIndex) continue;
                this.maxUtter = utterIndex;
            }
        }
        if (!speakerChange) {
            return DocType.ARTICLE;
        }
        return DocType.CONVERSATION;
    }

    protected void assignOriginalID() {
        List<List<Mention>> orderedMentionsBySentence = this.getOrderedMentions();
        boolean hasOriginalID = true;
        for (List<Mention> l : orderedMentionsBySentence) {
            if (l.size() == 0) continue;
            for (Mention m : l) {
                if (m.mentionID != -1) continue;
                hasOriginalID = false;
            }
        }
        if (!hasOriginalID) {
            int id = 0;
            for (List<Mention> l : orderedMentionsBySentence) {
                for (Mention m : l) {
                    m.mentionID = id++;
                }
            }
        }
    }

    public void extractGoldCorefClusters() {
        this.goldCorefClusters = Generics.newHashMap();
        for (List<Mention> mentions : this.goldOrderedMentionsBySentence) {
            for (Mention m : mentions) {
                int id = m.goldCorefClusterID;
                if (id == -1) {
                    throw new RuntimeException("No gold info");
                }
                CorefCluster c = this.goldCorefClusters.get(id);
                if (c == null) {
                    c = new CorefCluster(id);
                    this.goldCorefClusters.put(id, c);
                }
                c.corefMentions.add(m);
            }
        }
    }

    protected List<Pair<IntTuple, IntTuple>> getGoldLinks() {
        if (this.goldLinks == null) {
            this.extractGoldLinks();
        }
        return this.goldLinks;
    }

    protected void extractGoldLinks() {
        ArrayList<Pair<IntTuple, IntTuple>> links = new ArrayList<Pair<IntTuple, IntTuple>>();
        Map<Integer, IntTuple> positions = Generics.newHashMap();
        Map antecedents = Generics.newHashMap();
        for (int i = 0; i < this.goldOrderedMentionsBySentence.size(); ++i) {
            for (int j = 0; j < this.goldOrderedMentionsBySentence.get(i).size(); ++j) {
                Mention m = this.goldOrderedMentionsBySentence.get(i).get(j);
                int id = m.mentionID;
                IntTuple pos = new IntTuple(2);
                pos.set(0, i);
                pos.set(1, j);
                positions.put(id, pos);
                antecedents.put(id, new ArrayList());
            }
        }
        for (List<Mention> mentions : this.goldOrderedMentionsBySentence) {
            for (Mention m : mentions) {
                int id = m.mentionID;
                IntTuple src = (IntTuple)positions.get(id);
                assert (src != null);
                if (m.originalRef < 0) continue;
                IntTuple dst = (IntTuple)positions.get(m.originalRef);
                if (dst == null) {
                    throw new RuntimeException("Cannot find gold mention with ID=" + m.originalRef);
                }
                while (dst.get(0) > src.get(0) || dst.get(0) == src.get(0) && dst.get(1) > src.get(1)) {
                    Mention dstMention = this.goldOrderedMentionsBySentence.get(dst.get(0)).get(dst.get(1));
                    m.originalRef = dstMention.originalRef;
                    dstMention.originalRef = id;
                    if (m.originalRef < 0) break;
                    dst = (IntTuple)positions.get(m.originalRef);
                }
                if (m.originalRef < 0) continue;
                block5: for (int k = dst.get(0); k <= src.get(0); ++k) {
                    for (int l = 0; l < this.goldOrderedMentionsBySentence.get(k).size(); ++l) {
                        if (k == dst.get(0) && l < dst.get(1)) continue;
                        if (k == src.get(0) && l > src.get(1)) continue block5;
                        IntTuple missed = new IntTuple(2);
                        missed.set(0, k);
                        missed.set(1, l);
                        if (!links.contains(new Pair<IntTuple, IntTuple>(missed, dst))) continue;
                        ((List)antecedents.get(id)).add(missed);
                        links.add(new Pair<IntTuple, IntTuple>(src, missed));
                    }
                }
                links.add(new Pair<IntTuple, IntTuple>(src, dst));
                assert (antecedents.get(id) != null);
                ((List)antecedents.get(id)).add(dst);
                List ants = (List)antecedents.get(m.originalRef);
                assert (ants != null);
                for (IntTuple ant : ants) {
                    ((List)antecedents.get(id)).add(ant);
                    links.add(new Pair<IntTuple, IntTuple>(src, ant));
                }
            }
        }
        this.goldLinks = links;
    }

    private void markQuotations(List<CoreMap> results, boolean normalQuotationType) {
        boolean insideQuotation = false;
        for (CoreMap m : results) {
            for (CoreLabel l : (List)m.get(CoreAnnotations.TokensAnnotation.class)) {
                boolean noSpeakerInfo;
                String w = (String)l.get(CoreAnnotations.TextAnnotation.class);
                boolean bl = noSpeakerInfo = !l.containsKey(CoreAnnotations.SpeakerAnnotation.class) || ((String)l.get(CoreAnnotations.SpeakerAnnotation.class)).equals("") || ((String)l.get(CoreAnnotations.SpeakerAnnotation.class)).startsWith("PER");
                if (w.equals("``") || !insideQuotation && normalQuotationType && w.equals("\"")) {
                    insideQuotation = true;
                    ++this.maxUtter;
                    continue;
                }
                if (w.equals("''") || insideQuotation && normalQuotationType && w.equals("\"")) {
                    insideQuotation = false;
                }
                if (insideQuotation) {
                    l.set(CoreAnnotations.UtteranceAnnotation.class, this.maxUtter);
                }
                if (!noSpeakerInfo) continue;
                l.set(CoreAnnotations.SpeakerAnnotation.class, "PER" + l.get(CoreAnnotations.UtteranceAnnotation.class));
            }
        }
        if (this.maxUtter == 0 && !normalQuotationType) {
            this.markQuotations(results, true);
        }
    }

    private void findSpeakers(Dictionaries dict) {
        boolean useMarkedDiscourse;
        Boolean useMarkedDiscourseBoolean = (Boolean)this.annotation.get(CoreAnnotations.UseMarkedDiscourseAnnotation.class);
        boolean bl = useMarkedDiscourse = useMarkedDiscourseBoolean != null ? useMarkedDiscourseBoolean : false;
        if (useMarkedDiscourse) {
            for (CoreMap sent : (List)this.annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                for (CoreLabel w : (List)sent.get(CoreAnnotations.TokensAnnotation.class)) {
                    int utterIndex = (Integer)w.get(CoreAnnotations.UtteranceAnnotation.class);
                    this.speakers.put(utterIndex, (String)w.get(CoreAnnotations.SpeakerAnnotation.class));
                }
            }
        } else {
            if (this.docType == DocType.CONVERSATION) {
                this.findSpeakersInConversation(dict);
            } else if (this.docType == DocType.ARTICLE) {
                this.findSpeakersInArticle(dict);
            }
            for (CoreMap sent : (List)this.annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                for (CoreLabel w : (List)sent.get(CoreAnnotations.TokensAnnotation.class)) {
                    int utterIndex = (Integer)w.get(CoreAnnotations.UtteranceAnnotation.class);
                    if (!this.speakers.containsKey(utterIndex)) continue;
                    w.set(CoreAnnotations.SpeakerAnnotation.class, this.speakers.get(utterIndex));
                }
            }
        }
    }

    private void findSpeakersInArticle(Dictionaries dict) {
        List sentences = (List)this.annotation.get(CoreAnnotations.SentencesAnnotation.class);
        Pair<Integer, Integer> beginQuotation = new Pair<Integer, Integer>();
        Pair<Integer, Integer> endQuotation = new Pair<Integer, Integer>();
        boolean insideQuotation = false;
        int utterNum = -1;
        for (int i = 0; i < sentences.size(); ++i) {
            List sent = (List)((CoreMap)sentences.get(i)).get(CoreAnnotations.TokensAnnotation.class);
            for (int j = 0; j < sent.size(); ++j) {
                int utterIndex = (Integer)((CoreLabel)sent.get(j)).get(CoreAnnotations.UtteranceAnnotation.class);
                if (utterIndex != 0 && !insideQuotation) {
                    utterNum = utterIndex;
                    insideQuotation = true;
                    beginQuotation.setFirst(i);
                    beginQuotation.setSecond(j);
                    continue;
                }
                if (utterIndex != 0 || !insideQuotation) continue;
                insideQuotation = false;
                endQuotation.setFirst(i);
                endQuotation.setSecond(j);
                this.findQuotationSpeaker(utterNum, sentences, beginQuotation, endQuotation, dict);
            }
        }
    }

    private void findQuotationSpeaker(int utterNum, List<CoreMap> sentences, Pair<Integer, Integer> beginQuotation, Pair<Integer, Integer> endQuotation, Dictionaries dict) {
        if (this.findSpeaker(utterNum, beginQuotation.first(), sentences, 0, beginQuotation.second(), dict)) {
            return;
        }
        if (this.findSpeaker(utterNum, endQuotation.first(), sentences, endQuotation.second(), ((List)sentences.get(endQuotation.first()).get(CoreAnnotations.TokensAnnotation.class)).size(), dict)) {
            return;
        }
        if (beginQuotation.second() <= 1 && beginQuotation.first() > 0 && this.findSpeaker(utterNum, beginQuotation.first() - 1, sentences, 0, ((List)sentences.get(beginQuotation.first() - 1).get(CoreAnnotations.TokensAnnotation.class)).size(), dict)) {
            return;
        }
        if (endQuotation.second() == sentences.get(endQuotation.first()).size() - 1 && sentences.size() > endQuotation.first() + 1 && this.findSpeaker(utterNum, endQuotation.first() + 1, sentences, 0, ((List)sentences.get(endQuotation.first() + 1).get(CoreAnnotations.TokensAnnotation.class)).size(), dict)) {
            return;
        }
    }

    private boolean findSpeaker(int utterNum, int sentNum, List<CoreMap> sentences, int startIndex, int endIndex, Dictionaries dict) {
        List sent = (List)sentences.get(sentNum).get(CoreAnnotations.TokensAnnotation.class);
        for (int i = startIndex; i < endIndex; ++i) {
            if ((Integer)((CoreLabel)sent.get(i)).get(CoreAnnotations.UtteranceAnnotation.class) != 0) continue;
            String lemma = (String)((CoreLabel)sent.get(i)).get(CoreAnnotations.LemmaAnnotation.class);
            String word = (String)((CoreLabel)sent.get(i)).get(CoreAnnotations.TextAnnotation.class);
            if (!dict.reportVerb.contains(lemma)) continue;
            SemanticGraph dependency = (SemanticGraph)sentences.get(sentNum).get(SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class);
            IndexedWord w = dependency.getNodeByWordPattern(word);
            if (w != null) {
                for (Pair<GrammaticalRelation, IndexedWord> child : dependency.childPairs(w)) {
                    if (!child.first().getShortName().equals("nsubj")) continue;
                    String subjectString = child.second().word();
                    int subjectIndex = child.second().index();
                    IntTuple headPosition = new IntTuple(2);
                    headPosition.set(0, sentNum);
                    headPosition.set(1, subjectIndex - 1);
                    String speaker = this.mentionheadPositions.containsKey(headPosition) ? Integer.toString(this.mentionheadPositions.get((Object)headPosition).mentionID) : subjectString;
                    this.speakers.put(utterNum, speaker);
                    return true;
                }
                continue;
            }
            SieveCoreferenceSystem.logger.warning("Cannot find node in dependency for word " + word);
        }
        return false;
    }

    private void findSpeakersInConversation(Dictionaries dict) {
        for (List<Mention> l : this.predictedOrderedMentionsBySentence) {
            for (Mention m : l) {
                if (m.predicateNominatives == null) continue;
                for (Mention a : m.predicateNominatives) {
                    if (!a.spanToString().toLowerCase().equals("i")) continue;
                    this.speakers.put((Integer)m.headWord.get(CoreAnnotations.UtteranceAnnotation.class), Integer.toString(m.mentionID));
                }
            }
        }
        ArrayList<CoreMap> paragraph = new ArrayList<CoreMap>();
        int paragraphUtterIndex = 0;
        String nextParagraphSpeaker = "";
        int paragraphOffset = 0;
        for (CoreMap sent : (List)this.annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            int currentUtter = (Integer)((CoreLabel)((List)sent.get(CoreAnnotations.TokensAnnotation.class)).get(0)).get(CoreAnnotations.UtteranceAnnotation.class);
            if (paragraphUtterIndex != currentUtter) {
                nextParagraphSpeaker = this.findParagraphSpeaker(paragraph, paragraphUtterIndex, nextParagraphSpeaker, paragraphOffset, dict);
                paragraphUtterIndex = currentUtter;
                paragraphOffset += paragraph.size();
                paragraph = new ArrayList();
            }
            paragraph.add(sent);
        }
        this.findParagraphSpeaker(paragraph, paragraphUtterIndex, nextParagraphSpeaker, paragraphOffset, dict);
    }

    private String findParagraphSpeaker(List<CoreMap> paragraph, int paragraphUtterIndex, String nextParagraphSpeaker, int paragraphOffset, Dictionaries dict) {
        if (!this.speakers.containsKey(paragraphUtterIndex)) {
            if (!nextParagraphSpeaker.equals("")) {
                this.speakers.put(paragraphUtterIndex, nextParagraphSpeaker);
            } else {
                CoreMap lastSent = paragraph.get(paragraph.size() - 1);
                String speaker = "";
                boolean hasVerb = false;
                for (int i = 0; i < ((List)lastSent.get(CoreAnnotations.TokensAnnotation.class)).size(); ++i) {
                    CoreLabel w = (CoreLabel)((List)lastSent.get(CoreAnnotations.TokensAnnotation.class)).get(i);
                    String pos = (String)w.get(CoreAnnotations.PartOfSpeechAnnotation.class);
                    String ner = (String)w.get(CoreAnnotations.NamedEntityTagAnnotation.class);
                    if (pos.startsWith("V")) {
                        hasVerb = true;
                        break;
                    }
                    if (!ner.startsWith("PER")) continue;
                    IntTuple headPosition = new IntTuple(2);
                    headPosition.set(0, paragraph.size() - 1 + paragraphOffset);
                    headPosition.set(1, i);
                    if (!this.mentionheadPositions.containsKey(headPosition)) continue;
                    speaker = Integer.toString(this.mentionheadPositions.get((Object)headPosition).mentionID);
                }
                if (!hasVerb && !speaker.equals("")) {
                    this.speakers.put(paragraphUtterIndex, speaker);
                }
            }
        }
        return this.findNextParagraphSpeaker(paragraph, paragraphOffset, dict);
    }

    private String findNextParagraphSpeaker(List<CoreMap> paragraph, int paragraphOffset, Dictionaries dict) {
        CoreMap lastSent = paragraph.get(paragraph.size() - 1);
        String speaker = "";
        for (CoreLabel w : (List)lastSent.get(CoreAnnotations.TokensAnnotation.class)) {
            if (!((String)w.get(CoreAnnotations.LemmaAnnotation.class)).equals("report") && !((String)w.get(CoreAnnotations.LemmaAnnotation.class)).equals("say")) continue;
            String word = (String)w.get(CoreAnnotations.TextAnnotation.class);
            SemanticGraph dependency = (SemanticGraph)lastSent.get(SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class);
            IndexedWord t = dependency.getNodeByWordPattern(word);
            for (Pair<GrammaticalRelation, IndexedWord> child : dependency.childPairs(t)) {
                if (!child.first().getShortName().equals("nsubj")) continue;
                int subjectIndex = child.second().index();
                IntTuple headPosition = new IntTuple(2);
                headPosition.set(0, paragraph.size() - 1 + paragraphOffset);
                headPosition.set(1, subjectIndex - 1);
                if (!this.mentionheadPositions.containsKey(headPosition) || !this.mentionheadPositions.get((Object)headPosition).nerString.startsWith("PER")) continue;
                speaker = Integer.toString(this.mentionheadPositions.get((Object)headPosition).mentionID);
            }
        }
        return speaker;
    }

    public SpeakerInfo getSpeakerInfo(String speaker) {
        return this.speakerInfoMap.get(speaker);
    }

    public int numberOfSpeakers() {
        return this.speakerInfoMap.size();
    }

    public static boolean isSpeaker(Mention m, Mention ant, Dictionaries dict) {
        if (!dict.firstPersonPronouns.contains(ant.spanToString().toLowerCase()) || ant.number == Dictionaries.Number.PLURAL || ant.sentNum != m.sentNum) {
            return false;
        }
        int countQuotationMark = 0;
        for (int i = Math.min(m.headIndex, ant.headIndex) + 1; i < Math.max(m.headIndex, ant.headIndex); ++i) {
            String word = (String)m.sentenceWords.get(i).get(CoreAnnotations.TextAnnotation.class);
            if (!word.equals("``") && !word.equals("''")) continue;
            ++countQuotationMark;
        }
        if (countQuotationMark != 1) {
            return false;
        }
        IndexedWord w = m.dependency.getNodeByWordPattern((String)m.sentenceWords.get(m.headIndex).get(CoreAnnotations.TextAnnotation.class));
        if (w == null) {
            return false;
        }
        for (Pair<GrammaticalRelation, IndexedWord> parent : m.dependency.parentPairs(w)) {
            if (!parent.first().getShortName().equals("nsubj") || !dict.reportVerb.contains(parent.second().get(CoreAnnotations.LemmaAnnotation.class))) continue;
            return true;
        }
        return false;
    }

    protected void printMentionDetection() {
        int foundGoldCount = 0;
        for (Mention g : this.allGoldMentions.values()) {
            if (g.twinless) continue;
            ++foundGoldCount;
        }
        SieveCoreferenceSystem.logger.fine("# of found gold mentions: " + foundGoldCount + " / # of gold mentions: " + this.allGoldMentions.size());
        SieveCoreferenceSystem.logger.fine("gold mentions == ");
    }

    public static enum DocType {
        CONVERSATION,
        ARTICLE;

    }
}

