/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.ie.PresetSequenceClassifier;
import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.ie.ner.CMMClassifier;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.sequences.DocumentReaderAndWriter;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class ClassifierCombiner<IN extends CoreMap & HasWord>
extends AbstractSequenceClassifier<IN> {
    private static final Redwood.RedwoodChannels log = Redwood.channels(ClassifierCombiner.class);
    private static final boolean DEBUG = System.getProperty("ClassifierCombiner", null) != null;
    private List<AbstractSequenceClassifier<IN>> baseClassifiers;
    private static final CombinationMode DEFAULT_COMBINATION_MODE = CombinationMode.NORMAL;
    private static final String COMBINATION_MODE_PROPERTY = "ner.combinationMode";
    private final CombinationMode combinationMode;
    private final Properties initProps;
    private List<String> initLoadPaths = new ArrayList<String>();

    public ClassifierCombiner(Properties p) throws IOException {
        super(p);
        String loadPath2;
        this.combinationMode = ClassifierCombiner.extractCombinationModeSafe(p);
        ArrayList<String> paths = new ArrayList<String>();
        String loadPath1 = p.getProperty("loadClassifier1");
        if (loadPath1 != null && (loadPath2 = p.getProperty("loadClassifier2")) != null) {
            paths.add(loadPath1);
            paths.add(loadPath2);
            for (int i = 3; i <= 10; ++i) {
                String path = p.getProperty("loadClassifier" + i);
                if (path == null) continue;
                paths.add(path);
            }
            this.loadClassifiers(p, paths);
        } else {
            loadPath1 = p.getProperty("loadClassifier");
            if (loadPath1 != null && (loadPath2 = p.getProperty("loadAuxClassifier")) != null) {
                paths.add(loadPath1);
                paths.add(loadPath2);
                this.loadClassifiers(p, paths);
            } else {
                paths.add("edu/stanford/nlp/models/ner/english.all.3class.distsim.crf.ser.gz");
                paths.add("edu/stanford/nlp/models/ner/english.muc.7class.distsim.crf.ser.gz");
                this.loadClassifiers(p, paths);
            }
        }
        this.initLoadPaths = new ArrayList<String>(paths);
        this.initProps = p;
    }

    public ClassifierCombiner(Properties props, CombinationMode combinationMode, String ... loadPaths) throws IOException {
        super(props);
        this.combinationMode = combinationMode;
        ArrayList<String> paths = new ArrayList<String>(Arrays.asList(loadPaths));
        this.loadClassifiers(props, paths);
        this.initLoadPaths = new ArrayList<String>(paths);
        this.initProps = props;
    }

    public ClassifierCombiner(CombinationMode combinationMode, String ... loadPaths) throws IOException {
        this(new Properties(), combinationMode, loadPaths);
    }

    public ClassifierCombiner(String ... loadPaths) throws IOException {
        this(DEFAULT_COMBINATION_MODE, loadPaths);
    }

    @SafeVarargs
    public ClassifierCombiner(AbstractSequenceClassifier<IN> ... classifiers) {
        super(new Properties());
        this.combinationMode = DEFAULT_COMBINATION_MODE;
        this.baseClassifiers = new ArrayList<AbstractSequenceClassifier<IN>>(Arrays.asList(classifiers));
        this.flags.backgroundSymbol = this.baseClassifiers.get((int)0).flags.backgroundSymbol;
        this.initProps = new Properties();
    }

    public ClassifierCombiner(ObjectInputStream ois, Properties props) throws IOException, ClassNotFoundException, ClassCastException {
        super(PropertiesUtils.overWriteProperties((Properties)ois.readObject(), props));
        CombinationMode newCM;
        this.initProps = PropertiesUtils.overWriteProperties((Properties)ois.readObject(), props);
        this.initLoadPaths = (ArrayList)ois.readObject();
        String cm = (String)ois.readObject();
        if (props.getProperty(COMBINATION_MODE_PROPERTY) != null) {
            try {
                newCM = CombinationMode.valueOf(props.getProperty(COMBINATION_MODE_PROPERTY));
            }
            catch (IllegalArgumentException e) {
                newCM = CombinationMode.valueOf(cm);
            }
        } else {
            newCM = CombinationMode.valueOf(cm);
        }
        this.combinationMode = newCM;
        int numClassifiers = ois.readInt();
        this.baseClassifiers = new ArrayList<AbstractSequenceClassifier<IN>>();
        int i = 0;
        while (i < numClassifiers) {
            try {
                log.info("loading CRF...");
                CRFClassifier newCRF = (CRFClassifier)ErasureUtils.uncheckedCast(CRFClassifier.getClassifier(ois, props));
                this.baseClassifiers.add(newCRF);
                ++i;
            }
            catch (Exception e) {
                try {
                    log.info("loading CMM...");
                    CMMClassifier newCMM = (CMMClassifier)ErasureUtils.uncheckedCast(CMMClassifier.getClassifier(ois, props));
                    this.baseClassifiers.add(newCMM);
                    ++i;
                }
                catch (Exception ex) {
                    throw new IOException("Couldn't load classifier!", ex);
                }
            }
        }
    }

    public static CombinationMode extractCombinationMode(Properties p) {
        String mode = p.getProperty(COMBINATION_MODE_PROPERTY);
        if (mode == null) {
            return DEFAULT_COMBINATION_MODE;
        }
        return CombinationMode.valueOf(mode.toUpperCase(Locale.ROOT));
    }

    public static CombinationMode extractCombinationModeSafe(Properties p) {
        try {
            return ClassifierCombiner.extractCombinationMode(p);
        }
        catch (IllegalArgumentException e) {
            log.info("Illegal value of ner.combinationMode: " + p.getProperty(COMBINATION_MODE_PROPERTY));
            log.info("  Legal values:");
            for (CombinationMode mode : CombinationMode.values()) {
                log.info("  " + (Object)((Object)mode));
            }
            log.info(new Object[0]);
            return CombinationMode.NORMAL;
        }
    }

    private void loadClassifiers(Properties props, List<String> paths) throws IOException {
        this.baseClassifiers = new ArrayList<AbstractSequenceClassifier<IN>>();
        if (PropertiesUtils.getBool(props, "ner.usePresetNERTags", false)) {
            PresetSequenceClassifier presetASC = new PresetSequenceClassifier(props);
            this.baseClassifiers.add(presetASC);
        }
        for (String path : paths) {
            AbstractSequenceClassifier cls = ClassifierCombiner.loadClassifierFromPath(props, path);
            this.baseClassifiers.add(cls);
            if (!DEBUG) continue;
            System.err.printf("Successfully loaded classifier #%d from %s.%n", this.baseClassifiers.size(), path);
        }
        if (this.baseClassifiers.size() > 0) {
            this.flags.backgroundSymbol = this.baseClassifiers.get((int)0).flags.backgroundSymbol;
        }
    }

    public static <INN extends CoreMap & HasWord> AbstractSequenceClassifier<INN> loadClassifierFromPath(Properties props, String path) throws IOException {
        try {
            return (AbstractSequenceClassifier)ErasureUtils.uncheckedCast(CRFClassifier.getClassifier(path, props));
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                return (AbstractSequenceClassifier)ErasureUtils.uncheckedCast(CMMClassifier.getClassifier(path));
            }
            catch (Exception e2) {
                throw new IOException("Couldn't load classifier from " + path, e2);
            }
        }
    }

    @Override
    public Set<String> labels() {
        Set<String> labs = Generics.newHashSet();
        for (AbstractSequenceClassifier<IN> cls : this.baseClassifiers) {
            labs.addAll(cls.labels());
        }
        return labs;
    }

    /*
     * WARNING - void declaration
     */
    private List<IN> mergeDocuments(List<List<IN>> baseDocuments) {
        void var6_12;
        assert (!this.baseClassifiers.isEmpty() && !baseDocuments.isEmpty());
        for (int i = 1; i < baseDocuments.size(); ++i) {
            assert (baseDocuments.get(0).size() == baseDocuments.get(i).size());
        }
        String background = this.baseClassifiers.get((int)0).flags.backgroundSymbol;
        ArrayList<Set<String>> baseLabels = new ArrayList<Set<String>>();
        Set<String> seenLabels = Generics.newHashSet();
        for (AbstractSequenceClassifier<IN> abstractSequenceClassifier : this.baseClassifiers) {
            Set<String> labs = abstractSequenceClassifier.labels();
            if (this.combinationMode != CombinationMode.HIGH_RECALL) {
                labs.removeAll(seenLabels);
            } else {
                labs.remove(abstractSequenceClassifier.flags.backgroundSymbol);
                labs.remove(background);
            }
            seenLabels.addAll(labs);
            baseLabels.add(labs);
        }
        if (DEBUG) {
            int i;
            for (i = 0; i < baseLabels.size(); ++i) {
                log.info("mergeDocuments: Using classifier #" + i + " for " + baseLabels.get(i));
            }
            log.info("mergeDocuments: Background symbol is " + background);
            log.info("Base model outputs:");
            for (i = 0; i < baseDocuments.size(); ++i) {
                System.err.printf("Output of model #%d:", i);
                for (CoreMap l : baseDocuments.get(i)) {
                    log.info(Character.valueOf(' '));
                    log.info(l.get(CoreAnnotations.AnswerAnnotation.class));
                }
                log.info(new Object[0]);
            }
        }
        List<IN> mainDocument = baseDocuments.get(0);
        boolean bl = true;
        while (var6_12 < baseDocuments.size()) {
            ClassifierCombiner.mergeTwoDocuments(mainDocument, baseDocuments.get((int)var6_12), (Set)baseLabels.get((int)var6_12), background);
            ++var6_12;
        }
        if (DEBUG) {
            log.info("Output of combined model:");
            for (CoreMap l : mainDocument) {
                log.info(Character.valueOf(' '));
                log.info(l.get(CoreAnnotations.AnswerAnnotation.class));
            }
            log.info(new Object[0]);
            log.info(new Object[0]);
        }
        return mainDocument;
    }

    static <INN extends CoreMap & HasWord> void mergeTwoDocuments(List<INN> mainDocument, List<INN> auxDocument, Set<String> auxLabels, String background) {
        boolean insideAuxTag = false;
        boolean auxTagValid = true;
        String prevAnswer = background;
        Double prevAnswerProb = null;
        ArrayList<CoreMap> constituents = new ArrayList<CoreMap>();
        ListIterator<INN> auxIterator = auxDocument.listIterator();
        for (CoreMap wMain : mainDocument) {
            boolean insideMainTag;
            String mainAnswer = (String)wMain.get(CoreAnnotations.AnswerAnnotation.class);
            CoreMap wAux = (CoreMap)auxIterator.next();
            String auxAnswer = (String)wAux.get(CoreAnnotations.AnswerAnnotation.class);
            Double auxAnswerProb = (Double)wAux.get(CoreAnnotations.AnswerProbAnnotation.class);
            boolean bl = insideMainTag = !mainAnswer.equals(background);
            if (auxLabels.contains(auxAnswer)) {
                if (!prevAnswer.equals(auxAnswer) && !prevAnswer.equals(background)) {
                    if (auxTagValid) {
                        for (CoreMap wi : constituents) {
                            wi.set(CoreAnnotations.AnswerAnnotation.class, prevAnswer);
                            if (prevAnswerProb == null) continue;
                            wi.set(CoreAnnotations.AnswerProbAnnotation.class, prevAnswerProb);
                        }
                    }
                    auxTagValid = true;
                    constituents = new ArrayList();
                }
                insideAuxTag = true;
                if (insideMainTag) {
                    auxTagValid = false;
                }
                prevAnswer = auxAnswer;
                prevAnswerProb = auxAnswerProb;
                constituents.add(wMain);
                continue;
            }
            if (insideAuxTag) {
                if (auxTagValid) {
                    for (CoreMap wi : constituents) {
                        wi.set(CoreAnnotations.AnswerAnnotation.class, prevAnswer);
                        if (prevAnswerProb == null) continue;
                        wi.set(CoreAnnotations.AnswerProbAnnotation.class, prevAnswerProb);
                    }
                }
                constituents = new ArrayList();
            }
            insideAuxTag = false;
            auxTagValid = true;
            prevAnswer = background;
            prevAnswerProb = null;
        }
        if (auxTagValid) {
            for (CoreMap wi : constituents) {
                wi.set(CoreAnnotations.AnswerAnnotation.class, prevAnswer);
                if (prevAnswerProb == null) continue;
                wi.set(CoreAnnotations.AnswerProbAnnotation.class, prevAnswerProb);
            }
        }
    }

    @Override
    public List<IN> classify(List<IN> tokens) {
        int i;
        if (this.baseClassifiers.isEmpty()) {
            return tokens;
        }
        ArrayList<List<IN>> baseOutputs = new ArrayList<List<IN>>();
        List<IN> output = this.baseClassifiers.get(0).classifySentence(tokens);
        int sz = output.size();
        for (i = 0; i < sz; ++i) {
            ((CoreMap)tokens.get(i)).set(CoreAnnotations.AnswerAnnotation.class, ((CoreMap)output.get(i)).get(CoreAnnotations.AnswerAnnotation.class));
            ((CoreMap)tokens.get(i)).set(CoreAnnotations.AnswerProbAnnotation.class, ((CoreMap)output.get(i)).get(CoreAnnotations.AnswerProbAnnotation.class));
        }
        baseOutputs.add(tokens);
        sz = this.baseClassifiers.size();
        for (i = 1; i < sz; ++i) {
            output = this.baseClassifiers.get(i).classifySentence(tokens);
            baseOutputs.add(output);
        }
        assert (baseOutputs.size() == this.baseClassifiers.size());
        return this.mergeDocuments(baseOutputs);
    }

    @Override
    public void train(Collection<List<IN>> docs, DocumentReaderAndWriter<IN> readerAndWriter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void serializeClassifier(String serializePath) {
        log.info("Serializing classifier to " + serializePath + "...");
        ObjectOutputStream oos = null;
        try {
            oos = IOUtils.writeStreamFromString(serializePath);
            this.serializeClassifier(oos);
            log.info("done.");
        }
        catch (Exception e) {
            throw new RuntimeIOException("Failed to save classifier", e);
        }
        finally {
            IOUtils.closeIgnoringExceptions(oos);
        }
    }

    @Override
    public void serializeClassifier(ObjectOutputStream oos) {
        try {
            oos.writeObject(this.initProps);
            oos.writeObject(this.initProps);
            oos.writeObject(this.initLoadPaths);
            String combinationModeString = this.combinationMode.name();
            oos.writeObject(combinationModeString);
            int numClassifiers = this.baseClassifiers.size();
            oos.writeInt(numClassifiers);
            log.info("");
            for (AbstractSequenceClassifier<IN> asc : this.baseClassifiers) {
                asc.serializeClassifier(oos);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void loadClassifier(ObjectInputStream in, Properties props) throws IOException, ClassCastException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IN> classifyWithGlobalInformation(List<IN> tokenSeq, CoreMap doc, CoreMap sent) {
        return this.classify(tokenSeq);
    }

    public static ClassifierCombiner getClassifier(String loadPath, Properties props) throws IOException, ClassNotFoundException, ClassCastException {
        ObjectInputStream ois = IOUtils.readStreamFromString(loadPath);
        ClassifierCombiner returnCC = ClassifierCombiner.getClassifier(ois, props);
        IOUtils.closeIgnoringExceptions(ois);
        return returnCC;
    }

    public static ClassifierCombiner getClassifier(ObjectInputStream ois, Properties props) throws IOException, ClassCastException, ClassNotFoundException {
        return new ClassifierCombiner(ois, props);
    }

    public static void examineCRF(ClassifierCombiner cc, String crfNameOrIndex, SeqClassifierFlags flags, String testFile, String testFiles, DocumentReaderAndWriter<CoreLabel> readerAndWriter) throws Exception {
        int ci;
        try {
            ci = Integer.parseInt(crfNameOrIndex);
            if (ci < 0 || ci >= cc.baseClassifiers.size()) {
                ci = cc.initLoadPaths.indexOf(crfNameOrIndex);
            }
        }
        catch (NumberFormatException e) {
            ci = cc.initLoadPaths.indexOf(crfNameOrIndex);
        }
        CRFClassifier crf = ci >= 0 && ci < cc.baseClassifiers.size() ? (CRFClassifier)cc.baseClassifiers.get(ci) : null;
        if (crf != null) {
            if (testFile != null) {
                if (flags.searchGraphPrefix != null) {
                    crf.classifyAndWriteViterbiSearchGraph(testFile, flags.searchGraphPrefix, crf.makeReaderAndWriter());
                } else if (flags.printFirstOrderProbs) {
                    crf.printFirstOrderProbs(testFile, readerAndWriter);
                } else if (flags.printFactorTable) {
                    crf.printFactorTable(testFile, readerAndWriter);
                } else if (flags.printProbs) {
                    crf.printProbs(testFile, readerAndWriter);
                } else if (flags.useKBest) {
                    int k = flags.kBest;
                    crf.classifyAndWriteAnswersKBest(testFile, k, readerAndWriter);
                } else if (flags.printLabelValue) {
                    crf.printLabelInformation(testFile, readerAndWriter);
                } else {
                    log.info("Warning: no crf test flag was provided, running classify and write answers");
                    crf.classifyAndWriteAnswers(testFile, readerAndWriter, true);
                }
            } else if (testFiles != null) {
                List<File> files = Arrays.stream(testFiles.split(",")).map(File::new).collect(Collectors.toList());
                if (flags.printProbs) {
                    crf.printProbs(files, crf.defaultReaderAndWriter());
                } else {
                    log.info("Warning: no crf test flag was provided, running classify files and write answers");
                    crf.classifyFilesAndWriteAnswers(files, crf.defaultReaderAndWriter(), true);
                }
            }
        }
    }

    public static void showCCInfo(ClassifierCombiner cc) {
        log.info("");
        log.info("classifiers used:");
        log.info("");
        if (cc.initLoadPaths.size() == cc.baseClassifiers.size()) {
            for (int i = 0; i < cc.initLoadPaths.size(); ++i) {
                log.info("baseClassifiers index " + i + " : " + cc.initLoadPaths.get(i));
            }
        } else {
            for (int i = 0; i < cc.initLoadPaths.size(); ++i) {
                log.info("baseClassifiers index " + i);
            }
        }
        log.info("");
        log.info("combinationMode: " + (Object)((Object)cc.combinationMode));
        log.info("");
    }

    public static void main(String[] args) throws Exception {
        Properties props = StringUtils.argsToProperties(args);
        ClassifierCombiner ec = new ClassifierCombiner(props);
        log.info(ec.classifyToString("Marketing : Sony Hopes to Win Much Bigger Market For Wide Range of Small-Video Products --- By Andrew B. Cohen Staff Reporter of The Wall Street Journal"));
    }

    static enum CombinationMode {
        NORMAL,
        HIGH_RECALL;

    }
}

