/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.classify.LinearClassifier;
import edu.stanford.nlp.classify.LinearClassifierFactory;
import edu.stanford.nlp.classify.RVFDataset;
import edu.stanford.nlp.ie.KBPRelationExtractor;
import edu.stanford.nlp.ie.NumberNormalizer;
import edu.stanford.nlp.ie.machinereading.structure.Span;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Datum;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.optimization.DiffFunction;
import edu.stanford.nlp.optimization.HybridMinimizer;
import edu.stanford.nlp.optimization.Minimizer;
import edu.stanford.nlp.optimization.QNMinimizer;
import edu.stanford.nlp.optimization.SGDMinimizer;
import edu.stanford.nlp.simple.Sentence;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.Factory;
import edu.stanford.nlp.util.MetaClass;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import edu.stanford.nlp.util.logging.RedwoodConfiguration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class KBPStatisticalExtractor
implements KBPRelationExtractor,
Serializable {
    private static final long serialVersionUID = 1L;
    @ArgumentParser.Option(name="train", gloss="The dataset to train on")
    public static File TRAIN_FILE = new File("train.conll");
    @ArgumentParser.Option(name="test", gloss="The dataset to test on")
    public static File TEST_FILE = new File("test.conll");
    @ArgumentParser.Option(name="model", gloss="The dataset to test on")
    public static String MODEL_FILE = "edu/stanford/nlp/models/kbp/english/tac-re-lr.ser.gz";
    @ArgumentParser.Option(name="predictions", gloss="Dump model predictions to this file")
    public static Optional<String> PREDICTIONS = Optional.empty();
    @ArgumentParser.Option(name="minimizer", gloss="The minimizer to use for training the classifier")
    private static MinimizerType minimizer = MinimizerType.L1;
    @ArgumentParser.Option(name="feature_threshold", gloss="The minimum number of times to see a feature to count it")
    private static int FEATURE_THRESHOLD = 0;
    @ArgumentParser.Option(name="sigma", gloss="The regularizer for the classifier")
    private static double SIGMA = 1.0;
    private static final Redwood.RedwoodChannels log = Redwood.channels(KBPStatisticalExtractor.class);
    private static final Set<String> TOP_EMPLOYEE_TRIGGERS = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("executive");
            this.add("chairman");
            this.add("president");
            this.add("chief");
            this.add("head");
            this.add("general");
            this.add("ceo");
            this.add("officer");
            this.add("founder");
            this.add("found");
            this.add("leader");
            this.add("vice");
            this.add("king");
            this.add("prince");
            this.add("manager");
            this.add("host");
            this.add("minister");
            this.add("adviser");
            this.add("boss");
            this.add("chair");
            this.add("ambassador");
            this.add("shareholder");
            this.add("star");
            this.add("governor");
            this.add("investor");
            this.add("representative");
            this.add("dean");
            this.add("commissioner");
            this.add("deputy");
            this.add("commander");
            this.add("scientist");
            this.add("midfielder");
            this.add("speaker");
            this.add("researcher");
            this.add("editor");
            this.add("chancellor");
            this.add("fellow");
            this.add("leadership");
            this.add("diplomat");
            this.add("attorney");
            this.add("associate");
            this.add("striker");
            this.add("pilot");
            this.add("captain");
            this.add("banker");
            this.add("mayer");
            this.add("premier");
            this.add("producer");
            this.add("architect");
            this.add("designer");
            this.add("major");
            this.add("advisor");
            this.add("presidency");
            this.add("senator");
            this.add("specialist");
            this.add("faculty");
            this.add("monitor");
            this.add("chairwoman");
            this.add("mayor");
            this.add("columnist");
            this.add("mediator");
            this.add("prosecutor");
            this.add("entrepreneur");
            this.add("creator");
            this.add("superstar");
            this.add("commentator");
            this.add("principal");
            this.add("operative");
            this.add("businessman");
            this.add("peacekeeper");
            this.add("investigator");
            this.add("coordinator");
            this.add("knight");
            this.add("lawmaker");
            this.add("justice");
            this.add("publisher");
            this.add("playmaker");
            this.add("moderator");
            this.add("negotiator");
        }
    });
    public final Classifier<String, String> classifier;

    private static void indicator(Counter<String> features, String featureTemplate, String featureValue) {
        features.incrementCount(featureTemplate + "\u2135" + featureValue.replace(' ', '\u02d1'));
    }

    private static <E> List<E> spanBetweenMentions(KBPRelationExtractor.KBPInput input, Function<CoreLabel, E> selector) {
        int end;
        List<CoreLabel> sentence = input.sentence.asCoreLabels(Sentence::lemmas, Sentence::nerTags);
        Span subjSpan = input.subjectSpan;
        Span objSpan = input.objectSpan;
        if (Span.overlaps(subjSpan, objSpan)) {
            return Collections.emptyList();
        }
        int begin = subjSpan.end();
        if (begin > (end = objSpan.start())) {
            begin = objSpan.end();
            end = subjSpan.start();
        }
        if (begin > end) {
            throw new IllegalArgumentException("Gabor sucks at logic and he should feel bad about it: " + subjSpan + " and " + objSpan);
        }
        if (begin == end) {
            return Collections.emptyList();
        }
        ArrayList<E> rtn = new ArrayList<E>();
        for (int i = begin; i < end; ++i) {
            rtn.add(selector.apply(sentence.get(i)));
        }
        return rtn;
    }

    private static String withMentionsPositioned(KBPRelationExtractor.KBPInput input, String feature) {
        if (input.subjectSpan.isBefore(input.objectSpan)) {
            return "+__SUBJ__ " + feature + " __OBJ__";
        }
        return "__OBJ__ " + feature + " __SUBJ__";
    }

    private static void denseFeatures(KBPRelationExtractor.KBPInput input, Sentence sentence, ClassicCounter<String> feats) {
        boolean subjBeforeObj = input.subjectSpan.isBefore(input.objectSpan);
        KBPStatisticalExtractor.indicator(feats, "type_signature", (Object)((Object)input.subjectType) + "," + (Object)((Object)input.objectType));
        KBPStatisticalExtractor.indicator(feats, "subj_before_obj", subjBeforeObj ? "y" : "n");
    }

    /*
     * WARNING - void declaration
     */
    private static void surfaceFeatures(KBPRelationExtractor.KBPInput input, Sentence simpleSentence, ClassicCounter<String> feats) {
        void var8_18;
        void var8_11;
        List<String> lemmaSpan = KBPStatisticalExtractor.spanBetweenMentions(input, CoreLabel::lemma);
        List<String> nerSpan = KBPStatisticalExtractor.spanBetweenMentions(input, CoreLabel::ner);
        List<String> posSpan = KBPStatisticalExtractor.spanBetweenMentions(input, CoreLabel::tag);
        List<CoreLabel> tokens = input.sentence.asCoreLabels(Sentence::lemmas, Sentence::nerTags);
        for (CoreLabel coreLabel : tokens) {
            KBPStatisticalExtractor.indicator(feats, "sentence_unigram", coreLabel.lemma());
        }
        String lastLemma = "_^_";
        for (String lemma : lemmaSpan) {
            KBPStatisticalExtractor.indicator(feats, "lemma_bigram", KBPStatisticalExtractor.withMentionsPositioned(input, lastLemma + " " + lemma));
            KBPStatisticalExtractor.indicator(feats, "lemma_unigram", KBPStatisticalExtractor.withMentionsPositioned(input, lemma));
            lastLemma = lemma;
        }
        KBPStatisticalExtractor.indicator(feats, "lemma_bigram", KBPStatisticalExtractor.withMentionsPositioned(input, lastLemma + " _$_"));
        boolean bl = false;
        while (var8_11 < lemmaSpan.size() - 1) {
            if (!"O".equals(nerSpan.get((int)var8_11)) && "O".equals(nerSpan.get((int)(var8_11 + true))) && "IN".equals(posSpan.get((int)(var8_11 + true)))) {
                KBPStatisticalExtractor.indicator(feats, "ner/lemma_bigram", KBPStatisticalExtractor.withMentionsPositioned(input, nerSpan.get((int)var8_11) + " " + lemmaSpan.get((int)(var8_11 + true))));
            }
            if (!"O".equals(nerSpan.get((int)(var8_11 + true))) && "O".equals(nerSpan.get((int)var8_11)) && "IN".equals(posSpan.get((int)var8_11))) {
                KBPStatisticalExtractor.indicator(feats, "ner/lemma_bigram", KBPStatisticalExtractor.withMentionsPositioned(input, lemmaSpan.get((int)var8_11) + " " + nerSpan.get((int)(var8_11 + true))));
            }
            ++var8_11;
        }
        String string = ">10";
        if (lemmaSpan.size() == 0) {
            String string2 = "0";
        } else if (lemmaSpan.size() <= 3) {
            String string3 = "<=3";
        } else if (lemmaSpan.size() <= 5) {
            String string4 = "<=5";
        } else if (lemmaSpan.size() <= 10) {
            String string5 = "<=10";
        } else if (lemmaSpan.size() <= 15) {
            String string6 = "<=15";
        }
        KBPStatisticalExtractor.indicator(feats, "distance_between_entities_bucket", (String)var8_18);
        int numCommasInSpan = 0;
        int numQuotesInSpan = 0;
        int parenParity = 0;
        for (String string7 : lemmaSpan) {
            if (string7.equals(",")) {
                ++numCommasInSpan;
            }
            if (string7.equals("\"") || string7.equals("``") || string7.equals("''")) {
                ++numQuotesInSpan;
            }
            if (string7.equals("(") || string7.equals("-LRB-")) {
                ++parenParity;
            }
            if (!string7.equals(")") && !string7.equals("-RRB-")) continue;
            --parenParity;
        }
        KBPStatisticalExtractor.indicator(feats, "comma_parity", numCommasInSpan % 2 == 0 ? "even" : "odd");
        KBPStatisticalExtractor.indicator(feats, "quote_parity", numQuotesInSpan % 2 == 0 ? "even" : "odd");
        KBPStatisticalExtractor.indicator(feats, "paren_parity", "" + parenParity);
        Set intercedingNERTags = nerSpan.stream().filter(ner -> !ner.equals("O")).collect(Collectors.toSet());
        if (!intercedingNERTags.isEmpty()) {
            KBPStatisticalExtractor.indicator(feats, "has_interceding_ner", "t");
        }
        for (String ner2 : intercedingNERTags) {
            KBPStatisticalExtractor.indicator(feats, "interceding_ner", ner2);
        }
        List<CoreLabel> list = input.sentence.asCoreLabels(Sentence::nerTags);
        if (input.subjectSpan.start() == 0) {
            KBPStatisticalExtractor.indicator(feats, "subj_left", "^");
        } else {
            KBPStatisticalExtractor.indicator(feats, "subj_left", list.get(input.subjectSpan.start() - 1).lemma());
        }
        if (input.subjectSpan.end() == list.size()) {
            KBPStatisticalExtractor.indicator(feats, "subj_right", "$");
        } else {
            KBPStatisticalExtractor.indicator(feats, "subj_right", list.get(input.subjectSpan.end()).lemma());
        }
        if (input.objectSpan.start() == 0) {
            KBPStatisticalExtractor.indicator(feats, "obj_left", "^");
        } else {
            KBPStatisticalExtractor.indicator(feats, "obj_left", list.get(input.objectSpan.start() - 1).lemma());
        }
        if (input.objectSpan.end() == list.size()) {
            KBPStatisticalExtractor.indicator(feats, "obj_right", "$");
        } else {
            KBPStatisticalExtractor.indicator(feats, "obj_right", list.get(input.objectSpan.end()).lemma());
        }
        if (lemmaSpan.size() == 1 && input.subjectSpan.isBefore(input.objectSpan)) {
            String left = input.subjectSpan.start() == 0 ? "^" : list.get(input.subjectSpan.start() - 1).lemma();
            KBPStatisticalExtractor.indicator(feats, "X<subj>Y<obj>", left + "_" + lemmaSpan.get(0));
        }
    }

    private static void dependencyFeatures(KBPRelationExtractor.KBPInput input, Sentence sentence, ClassicCounter<String> feats) {
        int i;
        List<String> depparsePath;
        int subjectHead = sentence.algorithms().headOfSpan(input.subjectSpan);
        int objectHead = sentence.algorithms().headOfSpan(input.objectSpan);
        if (input.objectType.isRegexNERType) {
            KBPStatisticalExtractor.indicator(feats, "object_head", sentence.lemma(objectHead));
        }
        if ((depparsePath = sentence.algorithms().dependencyPathBetween(subjectHead, objectHead, Optional.of(Sentence::lemmas))).size() > 3) {
            int i2;
            ArrayList<Integer> apposChunks = new ArrayList<Integer>();
            for (i2 = 1; i2 < depparsePath.size() - 1; ++i2) {
                if ("-appos->".equals(depparsePath.get(i2))) {
                    if (i2 != 1) {
                        apposChunks.add(i2 - 1);
                    }
                    apposChunks.add(i2);
                    continue;
                }
                if (!"<-appos-".equals(depparsePath.get(i2))) continue;
                if (i2 < depparsePath.size() - 1) {
                    apposChunks.add(i2 + 1);
                }
                apposChunks.add(i2);
            }
            Collections.sort(apposChunks);
            for (i2 = apposChunks.size() - 1; i2 >= 0; --i2) {
                depparsePath.remove(i2);
            }
        }
        String distanceBucket = ">10";
        if (depparsePath.size() == 3) {
            distanceBucket = "<=3";
        } else if (depparsePath.size() <= 5) {
            distanceBucket = "<=5";
        } else if (depparsePath.size() <= 7) {
            distanceBucket = "<=7";
        } else if (depparsePath.size() <= 9) {
            distanceBucket = "<=9";
        } else if (depparsePath.size() <= 13) {
            distanceBucket = "<=13";
        } else if (depparsePath.size() <= 17) {
            distanceBucket = "<=17";
        }
        KBPStatisticalExtractor.indicator(feats, "parse_distance_between_entities_bucket", distanceBucket);
        if (depparsePath.size() > 2 && depparsePath.size() <= 7) {
            KBPStatisticalExtractor.indicator(feats, "deppath_w/tag", sentence.posTag(subjectHead) + StringUtils.join(depparsePath.subList(1, depparsePath.size() - 1), "") + sentence.posTag(objectHead));
            KBPStatisticalExtractor.indicator(feats, "deppath_w/ner", (Object)((Object)input.subjectType) + StringUtils.join(depparsePath.subList(1, depparsePath.size() - 1), "") + (Object)((Object)input.objectType));
        }
        for (String node : depparsePath) {
            if (node.startsWith("-") || node.startsWith("<-")) continue;
            KBPStatisticalExtractor.indicator(feats, "deppath_word", node);
        }
        for (i = 0; i < depparsePath.size() - 1; ++i) {
            KBPStatisticalExtractor.indicator(feats, "deppath_edge", depparsePath.get(i) + depparsePath.get(i + 1));
        }
        for (i = 0; i < depparsePath.size() - 2; ++i) {
            KBPStatisticalExtractor.indicator(feats, "deppath_chunk", depparsePath.get(i) + depparsePath.get(i + 1) + depparsePath.get(i + 2));
        }
    }

    private static void relationSpecificFeatures(KBPRelationExtractor.KBPInput input, Sentence sentence, ClassicCounter<String> feats) {
        if (input.objectType.equals((Object)KBPRelationExtractor.NERTag.NUMBER)) {
            try {
                Number number = NumberNormalizer.wordToNumber(input.getObjectText());
                if (number != null) {
                    KBPStatisticalExtractor.indicator(feats, "obj_parsed_as_num", "t");
                    if (number.equals(number.intValue())) {
                        KBPStatisticalExtractor.indicator(feats, "obj_isint", "t");
                        int numAsInt = number.intValue();
                        String bucket = "<0";
                        if (numAsInt == 0) {
                            bucket = "0";
                        } else if (numAsInt == 1) {
                            bucket = "1";
                        } else if (numAsInt < 5) {
                            bucket = "<5";
                        } else if (numAsInt < 18) {
                            bucket = "<18";
                        } else if (numAsInt < 25) {
                            bucket = "<25";
                        } else if (numAsInt < 50) {
                            bucket = "<50";
                        } else if (numAsInt < 80) {
                            bucket = "<80";
                        } else if (numAsInt < 125) {
                            bucket = "<125";
                        } else if (numAsInt >= 100) {
                            bucket = ">125";
                        }
                        KBPStatisticalExtractor.indicator(feats, "obj_number_bucket", bucket);
                    } else {
                        KBPStatisticalExtractor.indicator(feats, "obj_isint", "f");
                    }
                    if (input.getObjectText().replace(",", "").equalsIgnoreCase(number.toString())) {
                        KBPStatisticalExtractor.indicator(feats, "obj_spelledout_num", "f");
                    } else {
                        KBPStatisticalExtractor.indicator(feats, "obj_spelledout_num", "t");
                    }
                } else {
                    KBPStatisticalExtractor.indicator(feats, "obj_parsed_as_num", "f");
                }
            }
            catch (NumberFormatException e) {
                KBPStatisticalExtractor.indicator(feats, "obj_parsed_as_num", "f");
            }
            if (input.getObjectText().contains("-")) {
                KBPStatisticalExtractor.indicator(feats, "obj_num_has_dash", "t");
            } else {
                KBPStatisticalExtractor.indicator(feats, "obj_num_has_dash", "f");
            }
            if (input.getObjectText().equalsIgnoreCase("one")) {
                KBPStatisticalExtractor.indicator(feats, "obj_num_is_one", "t");
            } else {
                KBPStatisticalExtractor.indicator(feats, "obj_num_is_one", "f");
            }
        }
        if (input.subjectType == KBPRelationExtractor.NERTag.PERSON && input.objectType.equals((Object)KBPRelationExtractor.NERTag.ORGANIZATION) || input.subjectType == KBPRelationExtractor.NERTag.ORGANIZATION && input.objectType.equals((Object)KBPRelationExtractor.NERTag.PERSON)) {
            int i;
            Span relationSpan = Span.union(input.subjectSpan, input.objectSpan);
            for (i = Math.max(0, relationSpan.start() - 5); i < relationSpan.start(); ++i) {
                if ("TITLE".equals(sentence.nerTag(i))) {
                    KBPStatisticalExtractor.indicator(feats, "title_before", "t");
                }
                if (!TOP_EMPLOYEE_TRIGGERS.contains(sentence.word(i).toLowerCase())) continue;
                KBPStatisticalExtractor.indicator(feats, "top_employee_trigger_before", "t");
            }
            for (i = relationSpan.end(); i < Math.min(sentence.length(), relationSpan.end()); ++i) {
                if ("TITLE".equals(sentence.nerTag(i))) {
                    KBPStatisticalExtractor.indicator(feats, "title_after", "t");
                }
                if (!TOP_EMPLOYEE_TRIGGERS.contains(sentence.word(i).toLowerCase())) continue;
                KBPStatisticalExtractor.indicator(feats, "top_employee_trigger_after", "t");
            }
            for (int i2 : relationSpan) {
                if ("TITLE".equals(sentence.nerTag(i2))) {
                    KBPStatisticalExtractor.indicator(feats, "title_inside", "t");
                }
                if (!TOP_EMPLOYEE_TRIGGERS.contains(sentence.word(i2).toLowerCase())) continue;
                KBPStatisticalExtractor.indicator(feats, "top_employee_trigger_inside", "t");
            }
        }
    }

    public static Counter<String> features(KBPRelationExtractor.KBPInput input) {
        ClassicCounter<String> feats = new ClassicCounter<String>();
        if (Span.overlaps(input.subjectSpan, input.objectSpan) || input.subjectSpan.size() == 0 || input.objectSpan.size() == 0) {
            return new ClassicCounter<String>();
        }
        KBPStatisticalExtractor.denseFeatures(input, input.sentence, feats);
        KBPStatisticalExtractor.surfaceFeatures(input, input.sentence, feats);
        KBPStatisticalExtractor.dependencyFeatures(input, input.sentence, feats);
        KBPStatisticalExtractor.relationSpecificFeatures(input, input.sentence, feats);
        return feats;
    }

    private static <L> LinearClassifierFactory<L, String> initFactory(double sigma) {
        Factory<Minimizer<DiffFunction>> minimizerFactory;
        LinearClassifierFactory factory = new LinearClassifierFactory();
        switch (minimizer) {
            case QN: {
                minimizerFactory = () -> new QNMinimizer(15);
                break;
            }
            case SGD: {
                minimizerFactory = () -> new SGDMinimizer(sigma, 100, 1000);
                break;
            }
            case HYBRID: {
                factory.useHybridMinimizerWithInPlaceSGD(100, 1000, sigma);
                minimizerFactory = () -> {
                    SGDMinimizer<DiffFunction> firstMinimizer = new SGDMinimizer<DiffFunction>(sigma, 50, 1000);
                    QNMinimizer secondMinimizer = new QNMinimizer(15);
                    return new HybridMinimizer(firstMinimizer, secondMinimizer, 50);
                };
                break;
            }
            case L1: {
                minimizerFactory = () -> {
                    try {
                        return (Minimizer)MetaClass.create("edu.stanford.nlp.optimization.OWLQNMinimizer").createInstance(sigma);
                    }
                    catch (Exception e) {
                        log.err("Could not create l1 minimizer! Reverting to l2.");
                        return new QNMinimizer(15);
                    }
                };
                break;
            }
            default: {
                throw new IllegalStateException("Unknown minimizer: " + (Object)((Object)minimizer));
            }
        }
        factory.setMinimizerCreator(minimizerFactory);
        return factory;
    }

    public static Classifier<String, String> trainMultinomialClassifier(GeneralDataset<String, String> dataset, int featureThreshold, double sigma) {
        log.info("Applying feature threshold (" + featureThreshold + ")...");
        dataset.applyFeatureCountThreshold(featureThreshold);
        log.info("Randomizing dataset...");
        dataset.randomize(42L);
        log.info("Creating factory...");
        LinearClassifierFactory factory = KBPStatisticalExtractor.initFactory(sigma);
        log.info("BEGIN training");
        Classifier classifier = factory.trainClassifier((GeneralDataset)dataset);
        log.info("END training");
        KBPRelationExtractor.Accuracy trainAccuracy = new KBPRelationExtractor.Accuracy();
        for (Datum datum : dataset) {
            String guess = (String)((LinearClassifier)classifier).classOf(datum);
            trainAccuracy.predict(Collections.singleton(guess), Collections.singleton(datum.label()));
        }
        log.info("Training accuracy:");
        log.info(trainAccuracy.toString());
        log.info("");
        return classifier;
    }

    public KBPStatisticalExtractor(Classifier<String, String> classifier) {
        this.classifier = classifier;
    }

    @Override
    public Pair<String, Double> classify(KBPRelationExtractor.KBPInput input) {
        RVFDatum datum = new RVFDatum(KBPStatisticalExtractor.features(input));
        Counter<String> scores = this.classifier.scoresOf(datum);
        Counters.expInPlace(scores);
        Counters.normalize(scores);
        String best = Counters.argmax(scores);
        while (!("no_relation".equals(best) || scores.size() <= 1 || KBPRelationExtractor.RelationType.fromString((String)best).get().validNamedEntityLabels.contains((Object)input.objectType) && KBPRelationExtractor.RelationType.fromString((String)best).get().entityType == input.subjectType)) {
            scores.remove(best);
            Counters.normalize(scores);
            best = Counters.argmax(scores);
        }
        return Pair.makePair(best, scores.getCount(best));
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        Object model;
        RedwoodConfiguration.standard().apply();
        ArgumentParser.fillOptions(KBPStatisticalExtractor.class, args);
        Redwood.Util.forceTrack("Test data");
        List<Pair<KBPRelationExtractor.KBPInput, String>> testExamples = KBPRelationExtractor.readDataset(TEST_FILE);
        log.info("Read " + testExamples.size() + " examples");
        Redwood.Util.endTrack("Test data");
        if (!IOUtils.existsInClasspathOrFileSystem(MODEL_FILE)) {
            Redwood.Util.forceTrack("Training data");
            List<Pair<KBPRelationExtractor.KBPInput, String>> trainExamples = KBPRelationExtractor.readDataset(TRAIN_FILE);
            log.info("Read " + trainExamples.size() + " examples");
            log.info("" + trainExamples.stream().map(Pair::second).filter("no_relation"::equals).count() + " are " + "no_relation");
            Redwood.Util.endTrack("Training data");
            Redwood.Util.forceTrack("Creating dataset");
            RVFDataset<String, String> dataset = new RVFDataset<String, String>();
            AtomicInteger i = new AtomicInteger(0);
            long beginTime = System.currentTimeMillis();
            ((Stream)trainExamples.stream().parallel()).forEach(example -> {
                if (i.incrementAndGet() % 1000 == 0) {
                    log.info("[" + Redwood.formatTimeDifference(System.currentTimeMillis() - beginTime) + "] Featurized " + i.get() + " / " + trainExamples.size() + " examples");
                }
                Counter<String> features = KBPStatisticalExtractor.features((KBPRelationExtractor.KBPInput)example.first);
                RVFDataset rVFDataset = dataset;
                synchronized (rVFDataset) {
                    dataset.add(new RVFDatum(features, example.second));
                }
            });
            trainExamples.clear();
            Redwood.Util.endTrack("Creating dataset");
            log.info("Training classifier:");
            Classifier<String, String> classifier = KBPStatisticalExtractor.trainMultinomialClassifier(dataset, FEATURE_THRESHOLD, SIGMA);
            dataset.clear();
            IOUtils.writeObjectToFile((Object)new KBPStatisticalExtractor(classifier), MODEL_FILE);
        }
        KBPStatisticalExtractor classifier = (model = IOUtils.readObjectFromURLOrClasspathOrFileSystem(MODEL_FILE)) instanceof Classifier ? new KBPStatisticalExtractor((Classifier)model) : (KBPStatisticalExtractor)model;
        classifier.computeAccuracy(testExamples.stream(), PREDICTIONS.map(x -> {
            try {
                return "stdout".equalsIgnoreCase((String)x) ? System.out : new PrintStream(new FileOutputStream((String)x));
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }));
    }

    private static enum MinimizerType {
        QN,
        SGD,
        HYBRID,
        L1;

    }
}

