/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.machinereading.common;

import edu.stanford.nlp.util.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DomReader {
    protected static Node getChildByName(Node node, String name) {
        NodeList children = node.getChildNodes();
        if (node.getNodeName().equals(name)) {
            return node;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node found = DomReader.getChildByName(children.item(i), name);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    protected static List<Node> getChildrenByName(Node node, String name) {
        ArrayList<Node> matches = new ArrayList<Node>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals(name)) continue;
            matches.add(child);
        }
        return matches;
    }

    protected static Node getChildByAttribute(Node node, String attributeName, String attributeValue) {
        NodeList children = node.getChildNodes();
        NamedNodeMap attribs = node.getAttributes();
        Node attribute = null;
        if (attribs != null && (attribute = attribs.getNamedItem(attributeName)) != null && attribute.getNodeValue().equals(attributeValue)) {
            return node;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node found = DomReader.getChildByAttribute(children.item(i), attributeName, attributeValue);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    protected static Node getChildByNameAndAttribute(Node node, String name, String attributeName, String attributeValue) {
        NodeList children = node.getChildNodes();
        NamedNodeMap attribs = node.getAttributes();
        Node attribute = null;
        if (node.getNodeName().equals(name) && attribs != null && (attribute = attribs.getNamedItem(attributeName)) != null && attribute.getNodeValue().equals(attributeValue)) {
            return node;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node found = DomReader.getChildByAttribute(children.item(i), attributeName, attributeValue);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static String getAttributeValue(Node node, String attributeName) {
        try {
            return node.getAttributes().getNamedItem(attributeName).getNodeValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Document readDocument(File f) throws IOException, SAXException, ParserConfigurationException {
        Document document = null;
        DocumentBuilderFactory factory = XMLUtils.safeDocumentBuilderFactory();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(f);
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
            throw sxe;
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            throw pce;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw ioe;
        }
        return document;
    }
}

