/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international;

import edu.stanford.nlp.parser.lexparser.ArabicTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.ChineseTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.EnglishTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.FrenchTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.HebrewTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.HungarianTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.ItalianTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.NegraPennTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.SpanishTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public enum Language {
    Any(new EnglishTreebankParserParams()),
    Afrikaans(Language.treebankForLanguage("Afrikaans")),
    AncientGreek(Language.treebankForLanguage("AncientGreek")),
    Arabic(new ArabicTreebankParserParams()),
    Armenian(Language.treebankForLanguage("Armenian")),
    Basque(Language.treebankForLanguage("Basque")),
    Breton(Language.treebankForLanguage("Breton")),
    Bulgarian(Language.treebankForLanguage("Bulgarian")),
    Buryat(Language.treebankForLanguage("Buryat")),
    Catalan(Language.treebankForLanguage("Catalan")),
    Croatian(Language.treebankForLanguage("Croatian")),
    Chinese(new ChineseTreebankParserParams()),
    Czech(Language.treebankForLanguage("Czech")),
    Danish(Language.treebankForLanguage("Danish")),
    Dutch(Language.treebankForLanguage("Dutch")),
    English(new EnglishTreebankParserParams(){
        {
            this.setGenerateOriginalDependencies(true);
        }
    }),
    Estonian(Language.treebankForLanguage("Estonian")),
    Faroese(Language.treebankForLanguage("Faroese")),
    Finnish(Language.treebankForLanguage("Finnish")),
    Galician(Language.treebankForLanguage("Galician")),
    German(new NegraPennTreebankParserParams()),
    Gothic(Language.treebankForLanguage("Gothic")),
    Greek(Language.treebankForLanguage("Greek")),
    French(new FrenchTreebankParserParams()),
    Hebrew(new HebrewTreebankParserParams()),
    Hindi(Language.treebankForLanguage("Hindi")),
    Hungarian(new HungarianTreebankParserParams()),
    Indonesian(Language.treebankForLanguage("Indonesian")),
    Italian(new ItalianTreebankParserParams()),
    Irish(Language.treebankForLanguage("Irish")),
    Kazakh(Language.treebankForLanguage("Kazakh")),
    Korean(Language.treebankForLanguage("Korean")),
    Kurmanji(Language.treebankForLanguage("Kurmanji")),
    Latin(Language.treebankForLanguage("Latin")),
    Latvian(Language.treebankForLanguage("Latvian")),
    Naija(Language.treebankForLanguage("Naija")),
    NorthSami(Language.treebankForLanguage("NorthSami")),
    Norwegian(Language.treebankForLanguage("Norwegian")),
    OldChurchSlavonic(Language.treebankForLanguage("OldChurchSlavonic")),
    OldFrench(Language.treebankForLanguage("OldFrench")),
    Persian(Language.treebankForLanguage("Persian")),
    Polish(Language.treebankForLanguage("Polish")),
    Portuguese(Language.treebankForLanguage("Portuguese")),
    Romanian(Language.treebankForLanguage("Romanian")),
    Russian(Language.treebankForLanguage("Russian")),
    Serbian(Language.treebankForLanguage("Serbian")),
    Slovak(Language.treebankForLanguage("Slovak")),
    Slovenian(Language.treebankForLanguage("Slovenian")),
    Spanish(new SpanishTreebankParserParams()),
    Swedish(Language.treebankForLanguage("Swedish")),
    Japanese(Language.treebankForLanguage("Japanese")),
    Thai(Language.treebankForLanguage("Thai")),
    Turkish(Language.treebankForLanguage("Turkish")),
    Ukrainian(Language.treebankForLanguage("Ukrainian")),
    UniversalChinese(new ChineseTreebankParserParams()),
    UniversalEnglish(new EnglishTreebankParserParams()),
    Unknown(new EnglishTreebankParserParams()),
    UpperSorbian(Language.treebankForLanguage("UpperSorbian")),
    Urdu(Language.treebankForLanguage("Urdu")),
    Uyghur(Language.treebankForLanguage("Uyghur")),
    Vietnamese(Language.treebankForLanguage("Vietnamese"));

    public static final String langList;
    public final TreebankLangParserParams params;

    private Language(TreebankLangParserParams params) {
        this.params = params;
    }

    public static TreebankLangParserParams treebankForLanguage(String languageName) {
        try {
            Class<?> clazz = Class.forName("edu.stanford.nlp.parser.lexparser." + languageName + "TreebankParserParams");
            return (TreebankLangParserParams)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoClassDefFoundError | NoSuchMethodException | InvocationTargetException ex) {
            return null;
        }
    }

    public boolean compatibleWith(Language other) {
        return this == other || this == Any || other == Any;
    }

    static {
        langList = StringUtils.join(Arrays.asList(Language.values()), " ");
    }
}

