/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class ByteArrayUtils {
    public static short readShort(ByteArrayInputStream bin) {
        int high = (bin.read() & 0xFF) << 8;
        int low = bin.read() & 0xFF;
        return (short)((high | low) & 0xFFFF);
    }

    public static void writeShort(ByteArrayOutputStream bout, short val) {
        bout.write((byte)(val >> 8 & 0xFF));
        bout.write((byte)(val & 0xFF));
    }

    public static int readInt(ByteArrayInputStream bin) {
        int b24 = (bin.read() & 0xFF) << 24;
        int b16 = (bin.read() & 0xFF) << 16;
        int b8 = (bin.read() & 0xFF) << 8;
        int b0 = bin.read() & 0xFF;
        return b24 | b16 | b8 | b0;
    }

    public static void writeInt(ByteArrayOutputStream bout, int val) {
        bout.write((byte)(val >> 24 & 0xFF));
        bout.write((byte)(val >> 16 & 0xFF));
        bout.write((byte)(val >> 8 & 0xFF));
        bout.write((byte)(val & 0xFF));
    }

    public static long readLong(ByteArrayInputStream bin) {
        long b56 = (long)(bin.read() & 0xFF) << 56;
        long b48 = (long)(bin.read() & 0xFF) << 48;
        long b40 = (long)(bin.read() & 0xFF) << 40;
        long b32 = (long)(bin.read() & 0xFF) << 32;
        long b24 = (long)(bin.read() & 0xFF) << 24;
        long b16 = (long)(bin.read() & 0xFF) << 16;
        long b8 = (long)(bin.read() & 0xFF) << 8;
        long b0 = bin.read() & 0xFF;
        return b56 | b48 | b40 | b32 | b24 | b16 | b8 | b0;
    }

    public static void writeLong(ByteArrayOutputStream bout, long val) {
        bout.write((byte)(val >> 56 & 0xFFL));
        bout.write((byte)(val >> 48 & 0xFFL));
        bout.write((byte)(val >> 40 & 0xFFL));
        bout.write((byte)(val >> 32 & 0xFFL));
        bout.write((byte)(val >> 24 & 0xFFL));
        bout.write((byte)(val >> 16 & 0xFFL));
        bout.write((byte)(val >> 8 & 0xFFL));
        bout.write((byte)(val & 0xFFL));
    }
}

