/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.AbstractCoreLabel;
import edu.stanford.nlp.ling.AnnotationLookup;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.HasCategory;
import edu.stanford.nlp.ling.HasIndex;
import edu.stanford.nlp.ling.HasOffset;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.TypesafeMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;

public class CoreLabel
extends ArrayCoreMap
implements AbstractCoreLabel,
HasCategory {
    private static final long serialVersionUID = 2L;
    public static final Map<String, Class<? extends GenericAnnotation<String>>> genericKeys = Generics.newHashMap();
    public static final Map<Class<? extends GenericAnnotation<String>>, String> genericValues = Generics.newHashMap();
    public static final String TAG_SEPARATOR = "/";
    public static final OutputFormat DEFAULT_FORMAT = OutputFormat.VALUE_INDEX;
    private static final Comparator<Class<?>> asClassComparator = Comparator.comparing(Class::getName);

    public CoreLabel() {
    }

    public CoreLabel(int capacity) {
        super(capacity);
    }

    public CoreLabel(CoreLabel label) {
        this((CoreMap)label);
    }

    public CoreLabel(CoreMap label) {
        super(label.size());
        Consumer<Class<TypesafeMap.Key<?>>> savedListener = ArrayCoreMap.listener;
        ArrayCoreMap.listener = null;
        for (Class<?> key : label.keySet()) {
            this.set(key, label.get(key));
        }
        ArrayCoreMap.listener = savedListener;
    }

    public CoreLabel(Label label) {
        super(0);
        if (label instanceof CoreMap) {
            CoreMap cl = (CoreMap)((Object)label);
            this.setCapacity(cl.size());
            for (Class<?> key : cl.keySet()) {
                this.set(key, cl.get(key));
            }
        } else if (label instanceof IndexedWord) {
            CoreLabel cl = ((IndexedWord)label).backingLabel();
            this.setCapacity(cl.size());
            for (Class<?> key : cl.keySet()) {
                this.set(key, cl.get(key));
            }
        } else {
            if (label instanceof HasWord) {
                this.setWord(((HasWord)((Object)label)).word());
            }
            this.setValue(label.value());
        }
    }

    public CoreLabel(String[] keys, String[] values) {
        super(keys.length);
        this.initFromStrings(keys, values);
    }

    public CoreLabel(Class[] keys, String[] values) {
        super(keys.length);
        this.initFromStrings(keys, values);
    }

    public static CoreLabel wordFromString(String word) {
        CoreLabel cl = new CoreLabel();
        cl.setWord(word);
        cl.setOriginalText(word);
        cl.setValue(word);
        return cl;
    }

    private void initFromStrings(String[] keys, String[] values) {
        if (keys.length != values.length) {
            throw new UnsupportedOperationException("Argument array lengths differ: " + Arrays.toString(keys) + " vs. " + Arrays.toString(values));
        }
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            String value = values[i];
            Class<? extends CoreAnnotation<?>> coreKeyClass = AnnotationLookup.toCoreKey(key);
            if (coreKeyClass == null) {
                if (key == null) continue;
                throw new UnsupportedOperationException("Unknown key " + key);
            }
            try {
                Class<?> valueClass = AnnotationLookup.getValueType(coreKeyClass);
                if (valueClass.equals(String.class)) {
                    this.set(coreKeyClass, values[i]);
                    continue;
                }
                if (valueClass == Integer.class) {
                    this.set(coreKeyClass, Integer.parseInt(values[i]));
                    continue;
                }
                if (valueClass == Double.class) {
                    this.set(coreKeyClass, Double.parseDouble(values[i]));
                    continue;
                }
                if (valueClass == Long.class) {
                    this.set(coreKeyClass, Long.parseLong(values[i]));
                    continue;
                }
                throw new RuntimeException("Can't handle " + valueClass);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("CORE: CoreLabel.initFromStrings: Bad type for " + key + ". Value was: " + value + "; expected " + AnnotationLookup.getValueType(coreKeyClass), e);
            }
        }
    }

    public static Class[] parseStringKeys(String[] keys) {
        Class[] classes = new Class[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            classes[i] = AnnotationLookup.toCoreKey(key);
            if (classes[i] != null) continue;
            throw new UnsupportedOperationException("Unknown key " + key);
        }
        return classes;
    }

    private void initFromStrings(Class[] keys, String[] values) {
        if (keys.length != values.length) {
            throw new UnsupportedOperationException("Argument array lengths differ: " + Arrays.toString(keys) + " vs. " + Arrays.toString(values));
        }
        for (int i = 0; i < keys.length; ++i) {
            Class coreKeyClass = keys[i];
            String value = values[i];
            try {
                Class<?> valueClass = AnnotationLookup.getValueType(coreKeyClass);
                if (valueClass.equals(String.class)) {
                    this.set(coreKeyClass, values[i]);
                    continue;
                }
                if (valueClass == Integer.class) {
                    this.set(coreKeyClass, Integer.parseInt(values[i]));
                    continue;
                }
                if (valueClass == Double.class) {
                    this.set(coreKeyClass, Double.parseDouble(values[i]));
                    continue;
                }
                if (valueClass == Long.class) {
                    this.set(coreKeyClass, Long.parseLong(values[i]));
                    continue;
                }
                throw new RuntimeException("Can't handle " + valueClass);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("CORE: CoreLabel.initFromStrings: Bad type for " + coreKeyClass.getSimpleName() + ". Value was: " + value + "; expected " + AnnotationLookup.getValueType(coreKeyClass), e);
            }
        }
    }

    public static LabelFactory factory() {
        return new CoreLabelFactory();
    }

    @Override
    public LabelFactory labelFactory() {
        return CoreLabel.factory();
    }

    @Override
    public <KEY extends TypesafeMap.Key<String>> String getString(Class<KEY> key) {
        return this.getString(key, "");
    }

    @Override
    public <KEY extends TypesafeMap.Key<String>> String getString(Class<KEY> key, String def) {
        String value = (String)this.get(key);
        if (value == null) {
            return def;
        }
        return value;
    }

    @Override
    public void setFromString(String labelStr) {
        throw new UnsupportedOperationException("Cannot set from string");
    }

    @Override
    public final void setValue(String value) {
        this.set(CoreAnnotations.ValueAnnotation.class, value);
    }

    @Override
    public final String value() {
        return (String)this.get(CoreAnnotations.ValueAnnotation.class);
    }

    @Override
    public void setWord(String word) {
        String originalWord = (String)this.get(CoreAnnotations.TextAnnotation.class);
        this.set(CoreAnnotations.TextAnnotation.class, word);
        if (word != null && !word.equals(originalWord) && this.containsKey(CoreAnnotations.LemmaAnnotation.class)) {
            this.remove(CoreAnnotations.LemmaAnnotation.class);
        }
    }

    @Override
    public String word() {
        return (String)this.get(CoreAnnotations.TextAnnotation.class);
    }

    @Override
    public void setTag(String tag) {
        this.set(CoreAnnotations.PartOfSpeechAnnotation.class, tag);
    }

    @Override
    public String tag() {
        return (String)this.get(CoreAnnotations.PartOfSpeechAnnotation.class);
    }

    @Override
    public void setCategory(String category) {
        this.set(CoreAnnotations.CategoryAnnotation.class, category);
    }

    @Override
    public String category() {
        return (String)this.get(CoreAnnotations.CategoryAnnotation.class);
    }

    @Override
    public void setAfter(String after) {
        this.set(CoreAnnotations.AfterAnnotation.class, after);
    }

    @Override
    public String after() {
        return this.getString(CoreAnnotations.AfterAnnotation.class);
    }

    @Override
    public void setBefore(String before) {
        this.set(CoreAnnotations.BeforeAnnotation.class, before);
    }

    @Override
    public String before() {
        return this.getString(CoreAnnotations.BeforeAnnotation.class);
    }

    @Override
    public void setOriginalText(String originalText) {
        this.set(CoreAnnotations.OriginalTextAnnotation.class, originalText);
    }

    @Override
    public String originalText() {
        return this.getString(CoreAnnotations.OriginalTextAnnotation.class);
    }

    @Override
    public String docID() {
        return (String)this.get(CoreAnnotations.DocIDAnnotation.class);
    }

    @Override
    public void setDocID(String docID) {
        this.set(CoreAnnotations.DocIDAnnotation.class, docID);
    }

    @Override
    public String ner() {
        return (String)this.get(CoreAnnotations.NamedEntityTagAnnotation.class);
    }

    @Override
    public void setNER(String ner) {
        this.set(CoreAnnotations.NamedEntityTagAnnotation.class, ner);
    }

    public Map<String, Double> nerConfidence() {
        return (Map)this.get(CoreAnnotations.NamedEntityTagProbsAnnotation.class);
    }

    @Override
    public String lemma() {
        return (String)this.get(CoreAnnotations.LemmaAnnotation.class);
    }

    @Override
    public void setLemma(String lemma) {
        this.set(CoreAnnotations.LemmaAnnotation.class, lemma);
    }

    public Boolean isNewline() {
        return (Boolean)this.get(CoreAnnotations.IsNewlineAnnotation.class);
    }

    public void setIsNewline(boolean isNewline) {
        this.set(CoreAnnotations.IsNewlineAnnotation.class, isNewline);
    }

    public Boolean isMWT() {
        return (Boolean)this.get(CoreAnnotations.IsMultiWordTokenAnnotation.class);
    }

    public Boolean isMWTFirst() {
        return (Boolean)this.get(CoreAnnotations.IsFirstWordOfMWTAnnotation.class);
    }

    public void setIsMWT(boolean isMWT) {
        this.set(CoreAnnotations.IsMultiWordTokenAnnotation.class, isMWT);
    }

    public void setIsMWTFirst(boolean isFirstMWT) {
        this.set(CoreAnnotations.IsFirstWordOfMWTAnnotation.class, isFirstMWT);
    }

    @Override
    public int index() {
        Integer n = (Integer)this.get(CoreAnnotations.IndexAnnotation.class);
        if (n == null) {
            return -1;
        }
        return n;
    }

    @Override
    public void setIndex(int index) {
        this.set(CoreAnnotations.IndexAnnotation.class, index);
    }

    @Override
    public int sentIndex() {
        Integer n = (Integer)this.get(CoreAnnotations.SentenceIndexAnnotation.class);
        if (n == null) {
            return -1;
        }
        return n;
    }

    @Override
    public void setSentIndex(int sentIndex) {
        this.set(CoreAnnotations.SentenceIndexAnnotation.class, sentIndex);
    }

    @Override
    public int beginPosition() {
        Integer i = (Integer)this.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        if (i != null) {
            return i;
        }
        return -1;
    }

    @Override
    public int endPosition() {
        Integer i = (Integer)this.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
        if (i != null) {
            return i;
        }
        return -1;
    }

    @Override
    public void setBeginPosition(int beginPos) {
        this.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, beginPos);
    }

    @Override
    public void setEndPosition(int endPos) {
        this.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, endPos);
    }

    @Override
    public String toString() {
        return this.toString(DEFAULT_FORMAT);
    }

    public String toString(OutputFormat format) {
        StringBuilder buf = new StringBuilder();
        switch (format) {
            case VALUE: {
                buf.append(this.value());
                break;
            }
            case MAP: {
                TreeMap map2 = new TreeMap();
                for (Class<?> key : this.keySet()) {
                    map2.put(key.getName(), this.get(key));
                }
                buf.append(map2);
                break;
            }
            case VALUE_MAP: {
                buf.append(this.value());
                TreeMap map2 = new TreeMap(asClassComparator);
                for (Class<?> key : this.keySet()) {
                    map2.put(key, this.get(key));
                }
                map2.remove(CoreAnnotations.ValueAnnotation.class);
                buf.append(map2);
                break;
            }
            case VALUE_INDEX: {
                buf.append(this.value());
                Integer index = (Integer)this.get(CoreAnnotations.IndexAnnotation.class);
                if (index == null) break;
                buf.append('-').append(index);
                break;
            }
            case VALUE_TAG: {
                buf.append(this.value());
                String tag = this.tag();
                if (tag == null) break;
                buf.append(TAG_SEPARATOR).append(tag);
                break;
            }
            case VALUE_TAG_INDEX: {
                Integer index;
                buf.append(this.value());
                String tag = this.tag();
                if (tag != null) {
                    buf.append(TAG_SEPARATOR).append(tag);
                }
                if ((index = (Integer)this.get(CoreAnnotations.IndexAnnotation.class)) == null) break;
                buf.append('-').append(index);
                break;
            }
            case VALUE_INDEX_MAP: {
                buf.append(this.value());
                Integer index = (Integer)this.get(CoreAnnotations.IndexAnnotation.class);
                if (index != null) {
                    buf.append('-').append(index);
                }
                TreeMap map2 = new TreeMap();
                for (Class<?> key : this.keySet()) {
                    String cls = key.getName();
                    int idx = cls.indexOf(36);
                    if (idx >= 0) {
                        cls = cls.substring(idx + 1);
                    }
                    map2.put(cls, this.get(key));
                }
                map2.remove("IndexAnnotation");
                map2.remove("ValueAnnotation");
                if (map2.isEmpty()) break;
                buf.append(map2);
                break;
            }
            case WORD: {
                buf.append(this.word());
                break;
            }
            case WORD_INDEX: {
                buf.append((String)this.get(CoreAnnotations.TextAnnotation.class));
                Integer index = (Integer)this.get(CoreAnnotations.IndexAnnotation.class);
                if (index == null) break;
                buf.append('-').append(index);
                break;
            }
            case VALUE_TAG_NER: {
                buf.append(this.value());
                String tag = this.tag();
                if (tag != null) {
                    buf.append(TAG_SEPARATOR).append(tag);
                }
                if (this.ner() == null) break;
                buf.append(TAG_SEPARATOR).append(this.ner());
                break;
            }
            case LEMMA_INDEX: {
                buf.append(this.lemma());
                Integer index = (Integer)this.get(CoreAnnotations.IndexAnnotation.class);
                if (index == null) break;
                buf.append('-').append(index);
                break;
            }
            case ALL: {
                for (Class<?> en : this.keySet()) {
                    buf.append(';').append(en).append(':').append(this.get(en));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown format " + (Object)((Object)format));
            }
        }
        return buf.toString();
    }

    public static enum OutputFormat {
        VALUE_INDEX,
        VALUE,
        VALUE_TAG,
        VALUE_TAG_INDEX,
        MAP,
        VALUE_MAP,
        VALUE_INDEX_MAP,
        WORD,
        WORD_INDEX,
        VALUE_TAG_NER,
        LEMMA_INDEX,
        ALL;

    }

    private static class CoreLabelFactory
    implements LabelFactory {
        private CoreLabelFactory() {
        }

        @Override
        public Label newLabel(String labelStr) {
            CoreLabel label = new CoreLabel();
            label.setValue(labelStr);
            return label;
        }

        @Override
        public Label newLabel(String labelStr, int options) {
            return this.newLabel(labelStr);
        }

        @Override
        public Label newLabel(Label oldLabel) {
            if (oldLabel instanceof CoreLabel) {
                return new CoreLabel((CoreLabel)oldLabel);
            }
            CoreLabel label = new CoreLabel();
            if (oldLabel instanceof HasWord) {
                label.setWord(((HasWord)((Object)oldLabel)).word());
            }
            if (oldLabel instanceof HasTag) {
                label.setTag(((HasTag)((Object)oldLabel)).tag());
            }
            if (oldLabel instanceof HasOffset) {
                label.setBeginPosition(((HasOffset)((Object)oldLabel)).beginPosition());
                label.setEndPosition(((HasOffset)((Object)oldLabel)).endPosition());
            }
            if (oldLabel instanceof HasCategory) {
                label.setCategory(((HasCategory)((Object)oldLabel)).category());
            }
            if (oldLabel instanceof HasIndex) {
                label.setIndex(((HasIndex)((Object)oldLabel)).index());
            }
            label.setValue(oldLabel.value());
            return label;
        }

        @Override
        public Label newLabelFromString(String encodedLabelStr) {
            throw new UnsupportedOperationException("This code branch left blank because we do not understand what this method should do.");
        }
    }

    public static interface GenericAnnotation<T>
    extends CoreAnnotation<T> {
    }
}

