/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.neural.rnn;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.Tree;
import java.util.ArrayList;
import java.util.List;
import org.ejml.simple.SimpleMatrix;

public class RNNCoreAnnotations {
    private RNNCoreAnnotations() {
    }

    public static SimpleMatrix getNodeVector(Tree tree) {
        Label label = tree.label();
        if (!(label instanceof CoreLabel)) {
            throw new IllegalArgumentException("CoreLabels required to get the attached node vector");
        }
        return (SimpleMatrix)((CoreLabel)label).get(NodeVector.class);
    }

    public static SimpleMatrix getPredictions(Tree tree) {
        Label label = tree.label();
        if (!(label instanceof CoreLabel)) {
            throw new IllegalArgumentException("CoreLabels required to get the attached predictions");
        }
        return (SimpleMatrix)((CoreLabel)label).get(Predictions.class);
    }

    public static List<Double> getPredictionsAsStringList(Tree tree) {
        SimpleMatrix predictions = RNNCoreAnnotations.getPredictions(tree);
        ArrayList<Double> listOfPredictions = new ArrayList<Double>();
        for (int i = 0; i < predictions.numRows(); ++i) {
            listOfPredictions.add(predictions.get(i));
        }
        return listOfPredictions;
    }

    public static int getPredictedClass(Tree tree) {
        return RNNCoreAnnotations.getPredictedClass(tree.label());
    }

    public static int getPredictedClass(Label label) {
        if (!(label instanceof CoreLabel)) {
            throw new IllegalArgumentException("CoreLabels required to get the attached predicted class");
        }
        Integer val = (Integer)((CoreLabel)label).get(PredictedClass.class);
        return val == null ? -1 : val;
    }

    public static double getPredictedClassProb(Label label) {
        if (!(label instanceof CoreLabel)) {
            throw new IllegalArgumentException("CoreLabels required to get the attached predicted class probability");
        }
        Integer val = (Integer)((CoreLabel)label).get(PredictedClass.class);
        SimpleMatrix predictions = (SimpleMatrix)((CoreLabel)label).get(Predictions.class);
        if (val != null) {
            return predictions.get(val.intValue());
        }
        return -1.0;
    }

    public static int getGoldClass(Tree tree) {
        Label label = tree.label();
        if (!(label instanceof CoreLabel)) {
            throw new IllegalArgumentException("CoreLabels required to get the attached gold class");
        }
        return (Integer)((CoreLabel)label).get(GoldClass.class);
    }

    public static void setGoldClass(Tree tree, int goldClass) {
        Label label = tree.label();
        if (!(label instanceof CoreLabel)) {
            throw new IllegalArgumentException("CoreLabels required to set the attached gold class");
        }
        ((CoreLabel)label).set(GoldClass.class, goldClass);
    }

    public static double getPredictionError(Tree tree) {
        Label label = tree.label();
        if (!(label instanceof CoreLabel)) {
            throw new IllegalArgumentException("CoreLabels required to get the attached prediction error");
        }
        return (Double)((CoreLabel)label).get(PredictionError.class);
    }

    public static void setPredictionError(Tree tree, double error) {
        Label label = tree.label();
        if (!(label instanceof CoreLabel)) {
            throw new IllegalArgumentException("CoreLabels required to set the attached prediction error");
        }
        ((CoreLabel)label).set(PredictionError.class, error);
    }

    public static class PredictionError
    implements CoreAnnotation<Double> {
        @Override
        public Class<Double> getType() {
            return Double.class;
        }
    }

    public static class GoldClass
    implements CoreAnnotation<Integer> {
        @Override
        public Class<Integer> getType() {
            return Integer.class;
        }
    }

    public static class PredictedClass
    implements CoreAnnotation<Integer> {
        @Override
        public Class<Integer> getType() {
            return Integer.class;
        }
    }

    public static class Predictions
    implements CoreAnnotation<SimpleMatrix> {
        @Override
        public Class<SimpleMatrix> getType() {
            return SimpleMatrix.class;
        }
    }

    public static class NodeVector
    implements CoreAnnotation<SimpleMatrix> {
        @Override
        public Class<SimpleMatrix> getType() {
            return SimpleMatrix.class;
        }
    }
}

