/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.ling.HasContext;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.parser.KBestViterbiParser;
import edu.stanford.nlp.parser.lexparser.DependencyGrammar;
import edu.stanford.nlp.parser.lexparser.Edge;
import edu.stanford.nlp.parser.lexparser.Hook;
import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.Scorer;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.ScoredObject;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ExhaustiveDependencyParser
implements Scorer,
KBestViterbiParser {
    private static Redwood.RedwoodChannels log = Redwood.channels(ExhaustiveDependencyParser.class);
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_MORE = false;
    private final Index<String> tagIndex;
    private final Index<String> wordIndex;
    private TreeFactory tf;
    private DependencyGrammar dg;
    private Lexicon lex;
    private Options op;
    private TreebankLanguagePack tlp;
    private List sentence;
    private int[] words;
    private float[][][] iScoreH;
    private float[][][] oScoreH;
    private float[][][] iScoreHSum;
    private static final boolean doiScoreHSum = false;
    private int[][] rawDistance;
    int[][] binDistance;
    float[][][][][] headScore;
    float[][][] headStop;
    private boolean[][][] oPossibleByL;
    private boolean[][][] oPossibleByR;
    private boolean[][][] iPossibleByL;
    private boolean[][][] iPossibleByR;
    private int arraySize = 0;
    private int myMaxLength = 559038737;
    private static final double TOL = 1.0E-5;

    float oScore(int start, int end, int head, int tag) {
        return this.oScoreH[head][this.dg.tagBin(tag)][start] + this.oScoreH[head][this.dg.tagBin(tag)][end];
    }

    float iScore(int start, int end, int head, int tag) {
        return this.iScoreH[head][this.dg.tagBin(tag)][start] + this.iScoreH[head][this.dg.tagBin(tag)][end];
    }

    float iScoreTotal(int start, int end, int head, int tag) {
        throw new RuntimeException("Summed inner scores not computed");
    }

    @Override
    public double oScore(Edge edge) {
        return this.oScore(edge.start, edge.end, edge.head, edge.tag);
    }

    @Override
    public double iScore(Edge edge) {
        return this.iScore(edge.start, edge.end, edge.head, edge.tag);
    }

    @Override
    public boolean oPossible(Hook hook) {
        return hook.isPreHook() ? this.oPossibleByR[hook.end][hook.head][this.dg.tagBin(hook.tag)] : this.oPossibleByL[hook.start][hook.head][this.dg.tagBin(hook.tag)];
    }

    @Override
    public boolean iPossible(Hook hook) {
        return hook.isPreHook() ? this.iPossibleByR[hook.start][hook.head][this.dg.tagBin(hook.tag)] : this.iPossibleByL[hook.end][hook.head][this.dg.tagBin(hook.tag)];
    }

    @Override
    public boolean parse(List<? extends HasWord> sentence) {
        int argHead;
        int argTag;
        int hWord;
        int head;
        if (this.op.testOptions.verbose) {
            Timing.tick("Starting dependency parse.");
        }
        this.sentence = sentence;
        int length = sentence.size();
        if (length > this.arraySize) {
            if (length > this.op.testOptions.maxLength + 1 || length >= this.myMaxLength) {
                throw new OutOfMemoryError("Refusal to create such large arrays.");
            }
            try {
                this.createArrays(length + 1);
            }
            catch (OutOfMemoryError e) {
                this.myMaxLength = length;
                if (this.arraySize > 0) {
                    try {
                        this.createArrays(this.arraySize);
                    }
                    catch (OutOfMemoryError e2) {
                        throw new RuntimeException("CANNOT EVEN CREATE ARRAYS OF ORIGINAL SIZE!!! " + this.arraySize);
                    }
                }
                throw e;
            }
            this.arraySize = length + 1;
            if (this.op.testOptions.verbose) {
                log.info("Created dparser arrays of size " + this.arraySize);
            }
        }
        if (this.op.testOptions.verbose) {
            log.info("Initializing...");
        }
        this.words = new int[length];
        int numTags = this.dg.numTagBins();
        boolean[][] hasTag = new boolean[length][numTags];
        for (int i = 0; i < length; ++i) {
            this.words[i] = this.wordIndex.addToIndex(sentence.get(i).word());
        }
        for (head = 0; head < length; ++head) {
            for (int tag = 0; tag < numTags; ++tag) {
                Arrays.fill(this.iScoreH[head][tag], Float.NEGATIVE_INFINITY);
                Arrays.fill(this.oScoreH[head][tag], Float.NEGATIVE_INFINITY);
            }
        }
        for (head = 0; head < length; ++head) {
            for (int loc = 0; loc <= length; ++loc) {
                this.rawDistance[head][loc] = head >= loc ? head - loc : loc - head - 1;
                this.binDistance[head][loc] = this.dg.distanceBin(this.rawDistance[head][loc]);
            }
        }
        if (Thread.interrupted()) {
            throw new RuntimeInterruptedException();
        }
        int start = 0;
        while (start + 1 <= length) {
            String trueTagStr = null;
            if (sentence.get(start) instanceof HasTag && "".equals(trueTagStr = ((HasTag)((Object)sentence.get(start))).tag())) {
                trueTagStr = null;
            }
            String wordContextStr = null;
            if (sentence.get(start) instanceof HasContext && "".equals(wordContextStr = ((HasContext)((Object)sentence.get(start))).originalText())) {
                wordContextStr = null;
            }
            int word = this.words[start];
            Iterator<IntTaggedWord> taggingI = this.lex.ruleIteratorByWord(word, start, wordContextStr);
            while (taggingI.hasNext()) {
                float score;
                IntTaggedWord tagging = taggingI.next();
                if (trueTagStr != null && !this.tlp.basicCategory(tagging.tagString(this.tagIndex)).equals(trueTagStr) || !((score = this.lex.score(tagging, start, this.wordIndex.get(tagging.word), wordContextStr)) > Float.NEGATIVE_INFINITY)) continue;
                short tag = tagging.tag;
                this.iScoreH[start][this.dg.tagBin((int)tag)][start] = 0.0f;
                this.iScoreH[start][this.dg.tagBin((int)tag)][start + 1] = 0.0f;
            }
            ++start;
        }
        for (hWord = 0; hWord < length; ++hWord) {
            for (int hTag = 0; hTag < numTags; ++hTag) {
                hasTag[hWord][hTag] = this.iScoreH[hWord][hTag][hWord] + this.iScoreH[hWord][hTag][hWord + 1] > Float.NEGATIVE_INFINITY;
                Arrays.fill(this.headStop[hWord][hTag], Float.NEGATIVE_INFINITY);
                for (int aWord = 0; aWord < length; ++aWord) {
                    for (int dist = 0; dist < this.dg.numDistBins(); ++dist) {
                        Arrays.fill(this.headScore[dist][hWord][hTag][aWord], Float.NEGATIVE_INFINITY);
                    }
                }
            }
        }
        for (hWord = 0; hWord < length; ++hWord) {
            for (int hTag = 0; hTag < numTags; ++hTag) {
                if (!hasTag[hWord][hTag]) continue;
                for (int split = 0; split <= length; ++split) {
                    this.headStop[hWord][hTag][split] = split <= hWord ? (float)this.dg.scoreTB(this.words[hWord], hTag, -2, -2, false, hWord - split) : (float)this.dg.scoreTB(this.words[hWord], hTag, -2, -2, true, split - hWord - 1);
                }
                for (int aWord = 0; aWord < length; ++aWord) {
                    int end;
                    int start2;
                    boolean leftHeaded;
                    if (aWord == hWord) continue;
                    boolean bl = leftHeaded = hWord < aWord;
                    if (leftHeaded) {
                        start2 = hWord + 1;
                        end = aWord + 1;
                    } else {
                        start2 = aWord + 1;
                        end = hWord + 1;
                    }
                    for (int aTag = 0; aTag < numTags; ++aTag) {
                        if (!hasTag[aWord][aTag]) continue;
                        for (int split = start2; split < end; ++split) {
                            int headDistance = this.rawDistance[hWord][split];
                            int binDist = this.binDistance[hWord][split];
                            this.headScore[binDist][hWord][hTag][aWord][aTag] = (float)this.dg.scoreTB(this.words[hWord], hTag, this.words[aWord], aTag, leftHeaded, headDistance);
                            while (split + 1 < end && this.binDistance[hWord][split + 1] == binDist) {
                                ++split;
                            }
                        }
                    }
                }
            }
        }
        if (this.op.testOptions.verbose) {
            Timing.tick("done.");
            log.info("Starting insides...");
        }
        for (int diff = 2; diff <= length; ++diff) {
            if (Thread.interrupted()) {
                throw new RuntimeInterruptedException();
            }
            int start3 = 0;
            while (start3 + diff <= length) {
                int end = start3 + diff;
                int endHead = end - 1;
                for (int endTag = 0; endTag < numTags; ++endTag) {
                    if (!hasTag[endHead][endTag]) continue;
                    float bestScore = Float.NEGATIVE_INFINITY;
                    for (int argHead2 = start3; argHead2 < endHead; ++argHead2) {
                        for (argTag = 0; argTag < numTags; ++argTag) {
                            float stopLeftScore;
                            float argLeftScore;
                            if (!hasTag[argHead2][argTag] || (argLeftScore = this.iScoreH[argHead2][argTag][start3]) == Float.NEGATIVE_INFINITY || (stopLeftScore = this.headStop[argHead2][argTag][start3]) == Float.NEGATIVE_INFINITY) continue;
                            for (int split = argHead2 + 1; split < end; ++split) {
                                float score;
                                float depScore = this.headScore[this.binDistance[endHead][split]][endHead][endTag][argHead2][argTag];
                                if (depScore == Float.NEGATIVE_INFINITY || !((score = this.iScoreH[endHead][endTag][split] + argLeftScore + this.iScoreH[argHead2][argTag][split] + depScore + stopLeftScore + this.headStop[argHead2][argTag][split]) > bestScore)) continue;
                                bestScore = score;
                            }
                        }
                    }
                    this.iScoreH[endHead][endTag][start3] = bestScore;
                }
                int startHead = start3;
                for (int startTag = 0; startTag < numTags; ++startTag) {
                    if (!hasTag[startHead][startTag]) continue;
                    float bestScore = Float.NEGATIVE_INFINITY;
                    for (argHead = start3 + 1; argHead < end; ++argHead) {
                        for (int argTag2 = 0; argTag2 < numTags; ++argTag2) {
                            float stopRightScore;
                            float argRightScore;
                            if (!hasTag[argHead][argTag2] || (argRightScore = this.iScoreH[argHead][argTag2][end]) == Float.NEGATIVE_INFINITY || (stopRightScore = this.headStop[argHead][argTag2][end]) == Float.NEGATIVE_INFINITY) continue;
                            for (int split = start3 + 1; split <= argHead; ++split) {
                                float score;
                                float depScore = this.headScore[this.binDistance[startHead][split]][startHead][startTag][argHead][argTag2];
                                if (depScore == Float.NEGATIVE_INFINITY || !((score = this.iScoreH[startHead][startTag][split] + this.iScoreH[argHead][argTag2][split] + argRightScore + depScore + stopRightScore + this.headStop[argHead][argTag2][split]) > bestScore)) continue;
                                bestScore = score;
                            }
                        }
                    }
                    this.iScoreH[startHead][startTag][end] = bestScore;
                }
                ++start3;
            }
        }
        int goalTag = this.dg.tagBin(this.tagIndex.indexOf(".$$."));
        if (this.op.testOptions.verbose) {
            Timing.tick("done.");
            log.info("Dep  parsing " + length + " words (incl. stop): insideScore " + (this.iScoreH[length - 1][goalTag][0] + this.iScoreH[length - 1][goalTag][length]));
        }
        if (!this.op.doPCFG) {
            return this.hasParse();
        }
        if (this.op.testOptions.verbose) {
            log.info("Starting outsides...");
        }
        this.oScoreH[length - 1][goalTag][0] = 0.0f;
        this.oScoreH[length - 1][goalTag][length] = 0.0f;
        for (int diff = length; diff > 1; --diff) {
            if (Thread.interrupted()) {
                throw new RuntimeInterruptedException();
            }
            int start4 = 0;
            while (start4 + diff <= length) {
                int end = start4 + diff;
                int endHead = end - 1;
                for (int endTag = 0; endTag < numTags; ++endTag) {
                    if (!hasTag[endHead][endTag]) continue;
                    for (int argHead3 = start4; argHead3 < endHead; ++argHead3) {
                        for (argTag = 0; argTag < numTags; ++argTag) {
                            if (!hasTag[argHead3][argTag]) continue;
                            for (int split = argHead3; split <= endHead; ++split) {
                                float subScore = this.oScoreH[endHead][endTag][start4] + this.headScore[this.binDistance[endHead][split]][endHead][endTag][argHead3][argTag] + this.headStop[argHead3][argTag][start4] + this.headStop[argHead3][argTag][split];
                                float scoreRight = subScore + this.iScoreH[argHead3][argTag][start4] + this.iScoreH[argHead3][argTag][split];
                                float scoreMid = subScore + this.iScoreH[argHead3][argTag][start4] + this.iScoreH[endHead][endTag][split];
                                float scoreLeft = subScore + this.iScoreH[argHead3][argTag][split] + this.iScoreH[endHead][endTag][split];
                                if (scoreRight > this.oScoreH[endHead][endTag][split]) {
                                    this.oScoreH[endHead][endTag][split] = scoreRight;
                                }
                                if (scoreMid > this.oScoreH[argHead3][argTag][split]) {
                                    this.oScoreH[argHead3][argTag][split] = scoreMid;
                                }
                                if (!(scoreLeft > this.oScoreH[argHead3][argTag][start4])) continue;
                                this.oScoreH[argHead3][argTag][start4] = scoreLeft;
                            }
                        }
                    }
                }
                int startHead = start4;
                for (int startTag = 0; startTag < numTags; ++startTag) {
                    if (!hasTag[startHead][startTag]) continue;
                    for (argHead = startHead + 1; argHead < end; ++argHead) {
                        for (int argTag3 = 0; argTag3 < numTags; ++argTag3) {
                            if (!hasTag[argHead][argTag3]) continue;
                            for (int split = startHead + 1; split <= argHead; ++split) {
                                float subScore = this.oScoreH[startHead][startTag][end] + this.headScore[this.binDistance[startHead][split]][startHead][startTag][argHead][argTag3] + this.headStop[argHead][argTag3][split] + this.headStop[argHead][argTag3][end];
                                float scoreLeft = subScore + this.iScoreH[argHead][argTag3][split] + this.iScoreH[argHead][argTag3][end];
                                float scoreMid = subScore + this.iScoreH[startHead][startTag][split] + this.iScoreH[argHead][argTag3][end];
                                float scoreRight = subScore + this.iScoreH[startHead][startTag][split] + this.iScoreH[argHead][argTag3][split];
                                if (scoreLeft > this.oScoreH[startHead][startTag][split]) {
                                    this.oScoreH[startHead][startTag][split] = scoreLeft;
                                }
                                if (scoreMid > this.oScoreH[argHead][argTag3][split]) {
                                    this.oScoreH[argHead][argTag3][split] = scoreMid;
                                }
                                if (!(scoreRight > this.oScoreH[argHead][argTag3][end])) continue;
                                this.oScoreH[argHead][argTag3][end] = scoreRight;
                            }
                        }
                    }
                }
                ++start4;
            }
        }
        if (this.op.testOptions.verbose) {
            Timing.tick("done.");
            log.info("Starting half-filters...");
        }
        for (int loc = 0; loc <= length; ++loc) {
            for (int head2 = 0; head2 < length; ++head2) {
                Arrays.fill(this.iPossibleByL[loc][head2], false);
                Arrays.fill(this.iPossibleByR[loc][head2], false);
                Arrays.fill(this.oPossibleByL[loc][head2], false);
                Arrays.fill(this.oPossibleByR[loc][head2], false);
            }
        }
        if (Thread.interrupted()) {
            throw new RuntimeInterruptedException();
        }
        for (int head3 = 0; head3 < length; ++head3) {
            for (int tag = 0; tag < numTags; ++tag) {
                if (!hasTag[head3][tag]) continue;
                for (int start5 = 0; start5 <= head3; ++start5) {
                    for (int end = head3 + 1; end <= length; ++end) {
                        if (!(this.iScoreH[head3][tag][start5] + this.iScoreH[head3][tag][end] > Float.NEGATIVE_INFINITY) || !(this.oScoreH[head3][tag][start5] + this.oScoreH[head3][tag][end] > Float.NEGATIVE_INFINITY)) continue;
                        this.iPossibleByR[end][head3][tag] = true;
                        this.iPossibleByL[start5][head3][tag] = true;
                        this.oPossibleByR[end][head3][tag] = true;
                        this.oPossibleByL[start5][head3][tag] = true;
                    }
                }
            }
        }
        if (this.op.testOptions.verbose) {
            Timing.tick("done.");
        }
        return this.hasParse();
    }

    @Override
    public boolean hasParse() {
        return this.getBestScore() > Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getBestScore() {
        if (this.sentence == null) {
            return Double.NEGATIVE_INFINITY;
        }
        int length = this.sentence.size();
        if (length > this.arraySize) {
            return Double.NEGATIVE_INFINITY;
        }
        int goalTag = this.tagIndex.indexOf(".$$.");
        return this.iScore(0, length, length - 1, goalTag);
    }

    public void displayHeadScores() {
        int numTags = this.tagIndex.size();
        System.out.println("---- headScore matrix (head x dep, best tags) ----");
        System.out.print(StringUtils.padOrTrim("", 6));
        for (int word : this.words) {
            System.out.print(" " + StringUtils.padOrTrim(this.wordIndex.get(word), 2));
        }
        System.out.println();
        for (int hWord = 0; hWord < this.words.length; ++hWord) {
            System.out.print(StringUtils.padOrTrim(this.wordIndex.get(this.words[hWord]), 6));
            int bigBD = -1;
            int bigHTag = -1;
            int bigATag = -1;
            for (int aWord = 0; aWord < this.words.length; ++aWord) {
                float biggest = Float.NEGATIVE_INFINITY;
                for (int bd = 0; bd < this.dg.numDistBins(); ++bd) {
                    for (int hTag = 0; hTag < numTags; ++hTag) {
                        for (int aTag = 0; aTag < numTags; ++aTag) {
                            if (!(this.headScore[bd][hWord][this.dg.tagBin(hTag)][aWord][this.dg.tagBin(aTag)] > biggest)) continue;
                            biggest = this.headScore[bd][hWord][this.dg.tagBin(hTag)][aWord][this.dg.tagBin(aTag)];
                            bigBD = bd;
                            bigHTag = hTag;
                            bigATag = aTag;
                        }
                    }
                }
                if (Float.isInfinite(biggest)) {
                    System.out.print(" " + StringUtils.padOrTrim("in", 2));
                    continue;
                }
                int score = Math.round(Math.abs(this.headScore[bigBD][hWord][this.dg.tagBin(bigHTag)][aWord][this.dg.tagBin(bigATag)]));
                System.out.print(" " + StringUtils.padOrTrim(Integer.toString(score), 2));
            }
            System.out.println();
        }
    }

    private static boolean matches(double x, double y) {
        return Math.abs(x - y) / (Math.abs(x) + Math.abs(y) + 1.0E-10) < 1.0E-5;
    }

    private Tree extractBestParse(int start, int end, int hWord, int hTag) {
        String headWordStr = this.wordIndex.get(this.words[hWord]);
        String headTagStr = this.tagIndex.get(hTag);
        CategoryWordTag headLabel = new CategoryWordTag(headWordStr, headWordStr, headTagStr);
        int numTags = this.tagIndex.size();
        if (end - start == 1) {
            Tree leaf = this.tf.newLeaf(new Word(headWordStr));
            return this.tf.newTreeNode(headLabel, Collections.singletonList(leaf));
        }
        ArrayList<Tree> children = new ArrayList<Tree>();
        double bestScore = this.iScore(start, end, hWord, hTag);
        for (int split = start + 1; split < end; ++split) {
            int aTag;
            int aWord;
            int binD = this.binDistance[hWord][split];
            if (hWord < split) {
                for (aWord = split; aWord < end; ++aWord) {
                    for (aTag = 0; aTag < numTags; ++aTag) {
                        if (!ExhaustiveDependencyParser.matches(this.iScore(start, split, hWord, hTag) + this.iScore(split, end, aWord, aTag) + this.headScore[binD][hWord][this.dg.tagBin(hTag)][aWord][this.dg.tagBin(aTag)] + this.headStop[aWord][this.dg.tagBin(aTag)][split] + this.headStop[aWord][this.dg.tagBin(aTag)][end], bestScore)) continue;
                        children.add(this.extractBestParse(start, split, hWord, hTag));
                        children.add(this.extractBestParse(split, end, aWord, aTag));
                        return this.tf.newTreeNode(headLabel, children);
                    }
                }
                continue;
            }
            for (aWord = start; aWord < split; ++aWord) {
                for (aTag = 0; aTag < numTags; ++aTag) {
                    if (!ExhaustiveDependencyParser.matches(this.iScore(start, split, aWord, aTag) + this.iScore(split, end, hWord, hTag) + this.headScore[binD][hWord][this.dg.tagBin(hTag)][aWord][this.dg.tagBin(aTag)] + this.headStop[aWord][this.dg.tagBin(aTag)][start] + this.headStop[aWord][this.dg.tagBin(aTag)][split], bestScore)) continue;
                    children.add(this.extractBestParse(start, split, aWord, aTag));
                    children.add(this.extractBestParse(split, end, hWord, hTag));
                    return this.tf.newTreeNode(headLabel, children);
                }
            }
        }
        log.info("Problem in ExhaustiveDependencyParser::extractBestParse");
        return null;
    }

    private Tree flatten(Tree tree) {
        Tree[] children;
        if (tree.isLeaf() || tree.isPreTerminal()) {
            return tree;
        }
        ArrayList<Tree> newChildren = new ArrayList<Tree>();
        for (Tree child : children = tree.children()) {
            Tree newChild = this.flatten(child);
            if (!newChild.isPreTerminal() && newChild.label().toString().equals(tree.label().toString())) {
                newChildren.addAll(newChild.getChildrenAsList());
                continue;
            }
            newChildren.add(newChild);
        }
        return this.tf.newTreeNode(tree.label(), newChildren);
    }

    @Override
    public Tree getBestParse() {
        if (!this.hasParse()) {
            return null;
        }
        return this.flatten(this.extractBestParse(0, this.words.length, this.words.length - 1, this.tagIndex.indexOf(".$$.")));
    }

    public ExhaustiveDependencyParser(DependencyGrammar dg, Lexicon lex, Options op, Index<String> wordIndex, Index<String> tagIndex) {
        this.dg = dg;
        this.lex = lex;
        this.op = op;
        this.tlp = op.langpack();
        this.wordIndex = wordIndex;
        this.tagIndex = tagIndex;
        this.tf = new LabeledScoredTreeFactory();
    }

    private void createArrays(int length) {
        this.iScoreHSum = null;
        this.headStop = this.iScoreHSum;
        this.oScoreH = this.iScoreHSum;
        this.iScoreH = this.iScoreHSum;
        this.oPossibleByR = null;
        this.oPossibleByL = this.oPossibleByR;
        this.iPossibleByR = this.oPossibleByR;
        this.iPossibleByL = this.oPossibleByR;
        this.headScore = null;
        this.binDistance = null;
        this.rawDistance = this.binDistance;
        int tagNum = this.dg.numTagBins();
        this.iScoreH = new float[length + 1][tagNum][length + 1];
        this.oScoreH = new float[length + 1][tagNum][length + 1];
        this.iPossibleByL = new boolean[length + 1][length + 1][tagNum];
        this.iPossibleByR = new boolean[length + 1][length + 1][tagNum];
        this.oPossibleByL = new boolean[length + 1][length + 1][tagNum];
        this.oPossibleByR = new boolean[length + 1][length + 1][tagNum];
        this.headScore = new float[this.dg.numDistBins()][length][tagNum][length][tagNum];
        this.headStop = new float[length + 1][tagNum][length + 1];
        this.rawDistance = new int[length + 1][length + 1];
        this.binDistance = new int[length + 1][length + 1];
    }

    @Override
    public List<ScoredObject<Tree>> getKBestParses(int k) {
        throw new UnsupportedOperationException("Doesn't do k best yet");
    }

    @Override
    public List<ScoredObject<Tree>> getBestParses() {
        throw new UnsupportedOperationException("Doesn't do best parses yet");
    }

    @Override
    public List<ScoredObject<Tree>> getKGoodParses(int k) {
        throw new UnsupportedOperationException("Doesn't do k good yet");
    }

    @Override
    public List<ScoredObject<Tree>> getKSampledParses(int k) {
        throw new UnsupportedOperationException("Doesn't do k sampled yet");
    }
}

