/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.parser.lexparser.AbstractTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.TreeCollinizer;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.PennTreeReaderFactory;
import edu.stanford.nlp.trees.RightHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.international.hungarian.HungarianTreebankLanguagePack;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.List;

public class HungarianTreebankParserParams
extends AbstractTreebankParserParams {
    private static final Redwood.RedwoodChannels log = Redwood.channels(HungarianTreebankParserParams.class);
    private HeadFinder headFinder = new RightHeadFinder();
    private TreeNormalizer normalizer = null;
    static final String[] EMPTY_SISTERS = new String[0];
    private static final long serialVersionUID = 5652324513L;

    public HungarianTreebankParserParams() {
        super(new HungarianTreebankLanguagePack());
    }

    @Override
    public HeadFinder headFinder() {
        return this.headFinder;
    }

    @Override
    public HeadFinder typedDependencyHeadFinder() {
        return this.headFinder;
    }

    @Override
    public TreeTransformer collinizer() {
        return new TreeCollinizer(this.tlp, true, false, 0);
    }

    @Override
    public TreeTransformer collinizerEvalb() {
        return this.collinizer();
    }

    @Override
    public String[] sisterSplitters() {
        return EMPTY_SISTERS;
    }

    @Override
    public Tree transformTree(Tree t, Tree root) {
        return t;
    }

    TreeNormalizer buildNormalizer() {
        return new HungarianSubcategoryStripper();
    }

    @Override
    public TreeReaderFactory treeReaderFactory() {
        if (this.normalizer == null) {
            this.normalizer = this.buildNormalizer();
        }
        return new PennTreeReaderFactory(this.normalizer);
    }

    @Override
    public void display() {
        String hungarianParams = "Using HungarianTreebankParserParams";
        log.info(hungarianParams);
    }

    @Override
    public List<? extends HasWord> defaultTestSentence() {
        String[] sent;
        ArrayList<Word> ret = new ArrayList<Word>();
        for (String str : sent = new String[]{"Ez", "egy", "teszt", "."}) {
            ret.add(new Word(str));
        }
        return ret;
    }

    public static class HungarianSubcategoryStripper
    extends TreeNormalizer {
        @Override
        public String normalizeNonterminal(String category) {
            List<String> pieces = StringUtils.split(category, ":");
            if ((category = pieces.get(0)).equals("PP-locy")) {
                category = "PP-LOCY";
            }
            pieces = StringUtils.split(category, "-");
            category = pieces.get(0);
            return pieces.get(0);
        }
    }
}

