/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.parser.common.ParserConstraint;
import edu.stanford.nlp.parser.shiftreduce.BinaryTransition;
import edu.stanford.nlp.parser.shiftreduce.State;
import edu.stanford.nlp.parser.shiftreduce.Transition;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.ErasureUtils;
import java.util.Collection;

class ShiftReduceUtils {
    static final String TRANSITION = "Transition";

    private ShiftReduceUtils() {
    }

    static BinaryTransition.Side getBinarySide(Tree tree) {
        if (tree.children().length != 2) {
            throw new AssertionError();
        }
        CoreLabel label = (CoreLabel)ErasureUtils.uncheckedCast(tree.label());
        CoreLabel childLabel = (CoreLabel)ErasureUtils.uncheckedCast(tree.children()[0].label());
        if (label.get(TreeCoreAnnotations.HeadWordLabelAnnotation.class) == childLabel.get(TreeCoreAnnotations.HeadWordLabelAnnotation.class)) {
            return BinaryTransition.Side.LEFT;
        }
        return BinaryTransition.Side.RIGHT;
    }

    static boolean isTemporary(Tree tree) {
        String label = tree.value();
        return label.startsWith("@");
    }

    static boolean isEquivalentCategory(String l1, String l2) {
        if (l1.startsWith("@")) {
            l1 = l1.substring(1);
        }
        if (l2.startsWith("@")) {
            l2 = l2.substring(1);
        }
        return l1.equals(l2);
    }

    static int headIndex(Tree tree) {
        CoreLabel label = (CoreLabel)ErasureUtils.uncheckedCast(tree.label());
        CoreLabel headLabel = (CoreLabel)label.get(TreeCoreAnnotations.HeadWordLabelAnnotation.class);
        return headLabel.index() - 1;
    }

    static int leftIndex(Tree tree) {
        if (tree.isLeaf()) {
            CoreLabel label = (CoreLabel)ErasureUtils.uncheckedCast(tree.label());
            return label.index() - 1;
        }
        return ShiftReduceUtils.leftIndex(tree.children()[0]);
    }

    static int rightIndex(Tree tree) {
        if (tree.isLeaf()) {
            CoreLabel label = (CoreLabel)ErasureUtils.uncheckedCast(tree.label());
            return label.index() - 1;
        }
        return ShiftReduceUtils.rightIndex(tree.children()[tree.children().length - 1]);
    }

    static boolean constraintMatchesTreeTop(Tree top, ParserConstraint constraint) {
        while (true) {
            if (constraint.state.matcher(top.value()).matches()) {
                return true;
            }
            if (top.children().length != 1) break;
            top = top.children()[0];
        }
        return false;
    }

    static boolean findStateOnAgenda(Collection<State> agenda, State state) {
        for (State other : agenda) {
            if (!other.areTransitionsEqual(state)) continue;
            return true;
        }
        return false;
    }

    static String transitionShortName(Class<? extends Transition> t) {
        String className = t.toString();
        String[] pieces = className.split("[.]");
        if ((className = pieces[pieces.length - 1]).endsWith(TRANSITION) && className.length() > TRANSITION.length()) {
            return className.substring(0, className.length() - TRANSITION.length());
        }
        return className;
    }
}

