/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns;

import edu.stanford.nlp.patterns.CandidatePhrase;
import edu.stanford.nlp.patterns.ConstantsAndVariables;
import edu.stanford.nlp.patterns.Data;
import edu.stanford.nlp.patterns.GetPatternsFromDataMultiClass;
import edu.stanford.nlp.patterns.PhraseScorer;
import edu.stanford.nlp.patterns.ScorePatterns;
import edu.stanford.nlp.patterns.ScorePhrases;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.Pair;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.ToDoubleFunction;

public class ScorePatternsRatioModifiedFreq<E>
extends ScorePatterns<E> {
    private TwoDimensionalCounter<CandidatePhrase, ConstantsAndVariables.ScorePhraseMeasures> phInPatScores;
    private ScorePhrases scorePhrases;

    public ScorePatternsRatioModifiedFreq(ConstantsAndVariables constVars, GetPatternsFromDataMultiClass.PatternScoring patternScoring, String label, Set<CandidatePhrase> allCandidatePhrases, TwoDimensionalCounter<E, CandidatePhrase> patternsandWords4Label, TwoDimensionalCounter<E, CandidatePhrase> negPatternsandWords4Label, TwoDimensionalCounter<E, CandidatePhrase> unLabeledPatternsandWords4Label, TwoDimensionalCounter<CandidatePhrase, ConstantsAndVariables.ScorePhraseMeasures> phInPatScores, ScorePhrases scorePhrases, Properties props) {
        super(constVars, patternScoring, label, allCandidatePhrases, patternsandWords4Label, negPatternsandWords4Label, unLabeledPatternsandWords4Label, props);
        this.phInPatScores = phInPatScores;
        this.scorePhrases = scorePhrases;
    }

    @Override
    public void setUp(Properties props) {
    }

    @Override
    public Counter<E> score() throws IOException, ClassNotFoundException {
        ToDoubleFunction<Pair<E, CandidatePhrase>> denoScore;
        Counter<CandidatePhrase> externalWordWeightsNormalized = null;
        if (this.constVars.dictOddsWeights.containsKey(this.label)) {
            externalWordWeightsNormalized = GetPatternsFromDataMultiClass.normalizeSoftMaxMinMaxScores(this.constVars.dictOddsWeights.get(this.label), true, true, false);
        }
        Counter currentPatternWeights4Label = new ClassicCounter();
        boolean useFreqPhraseExtractedByPat = false;
        if (this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.SqrtAllRatio)) {
            useFreqPhraseExtractedByPat = true;
        }
        ToDoubleFunction<Pair<E, CandidatePhrase>> numeratorScore = x -> this.patternsandWords4Label.getCount(x.first(), x.second());
        Counter<E> numeratorPatWt = this.convert2OneDim(this.label, numeratorScore, this.allCandidatePhrases, this.patternsandWords4Label, this.constVars.sqrtPatScore, false, null, useFreqPhraseExtractedByPat);
        Counter<E> denominatorPatWt = null;
        if (this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.PosNegUnlabOdds)) {
            denoScore = x -> this.negPatternsandWords4Label.getCount(x.first(), x.second()) + this.unLabeledPatternsandWords4Label.getCount(x.first(), x.second());
            denominatorPatWt = this.convert2OneDim(this.label, denoScore, this.allCandidatePhrases, this.patternsandWords4Label, this.constVars.sqrtPatScore, false, externalWordWeightsNormalized, useFreqPhraseExtractedByPat);
        } else if (this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.RatioAll)) {
            denoScore = x -> this.negPatternsandWords4Label.getCount(x.first(), x.second()) + this.unLabeledPatternsandWords4Label.getCount(x.first(), x.second()) + this.patternsandWords4Label.getCount(x.first(), x.second());
            denominatorPatWt = this.convert2OneDim(this.label, denoScore, this.allCandidatePhrases, this.patternsandWords4Label, this.constVars.sqrtPatScore, false, externalWordWeightsNormalized, useFreqPhraseExtractedByPat);
        } else if (this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.PosNegOdds)) {
            denoScore = x -> this.negPatternsandWords4Label.getCount(x.first(), x.second());
            denominatorPatWt = this.convert2OneDim(this.label, denoScore, this.allCandidatePhrases, this.patternsandWords4Label, this.constVars.sqrtPatScore, false, externalWordWeightsNormalized, useFreqPhraseExtractedByPat);
        } else if (this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.PhEvalInPat) || this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.PhEvalInPatLogP) || this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.LOGREG) || this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.LOGREGlogP)) {
            denoScore = x -> this.negPatternsandWords4Label.getCount(x.first(), x.second()) + this.unLabeledPatternsandWords4Label.getCount(x.first(), x.second());
            denominatorPatWt = this.convert2OneDim(this.label, denoScore, this.allCandidatePhrases, this.patternsandWords4Label, this.constVars.sqrtPatScore, true, externalWordWeightsNormalized, useFreqPhraseExtractedByPat);
        } else if (this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.SqrtAllRatio)) {
            denoScore = x -> this.negPatternsandWords4Label.getCount(x.first(), x.second()) + this.unLabeledPatternsandWords4Label.getCount(x.first(), x.second());
            denominatorPatWt = this.convert2OneDim(this.label, denoScore, this.allCandidatePhrases, this.patternsandWords4Label, true, false, externalWordWeightsNormalized, useFreqPhraseExtractedByPat);
        } else {
            throw new RuntimeException("Cannot understand patterns scoring");
        }
        currentPatternWeights4Label = Counters.divisionNonNaN(numeratorPatWt, denominatorPatWt);
        if (this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.PhEvalInPatLogP) || this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.LOGREGlogP)) {
            ClassicCounter logpos_i = new ClassicCounter();
            for (Map.Entry en : this.patternsandWords4Label.entrySet()) {
                logpos_i.setCount(en.getKey(), Math.log(en.getValue().size()));
            }
            Counters.multiplyInPlace(currentPatternWeights4Label, logpos_i);
        }
        Counters.retainNonZeros(currentPatternWeights4Label);
        return currentPatternWeights4Label;
    }

    Counter<E> convert2OneDim(String label, ToDoubleFunction<Pair<E, CandidatePhrase>> scoringFunction, Set<CandidatePhrase> allCandidatePhrases, TwoDimensionalCounter<E, CandidatePhrase> positivePatternsAndWords, boolean sqrtPatScore, boolean scorePhrasesInPatSelection, Counter<CandidatePhrase> dictOddsWordWeights, boolean useFreqPhraseExtractedByPat) throws IOException, ClassNotFoundException {
        ClassicCounter<E> patterns = new ClassicCounter<E>();
        Counter<CandidatePhrase> googleNgramNormScores = new ClassicCounter();
        Counter<CandidatePhrase> domainNgramNormScores = new ClassicCounter();
        Counter<CandidatePhrase> externalFeatWtsNormalized = new ClassicCounter();
        ClassicCounter<CandidatePhrase> editDistanceFromOtherSemanticBinaryScores = new ClassicCounter<CandidatePhrase>();
        ClassicCounter<CandidatePhrase> editDistanceFromAlreadyExtractedBinaryScores = new ClassicCounter<CandidatePhrase>();
        double externalWtsDefault = 0.5;
        Counter<CandidatePhrase> classifierScores = null;
        if ((this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.PhEvalInPat) || this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.PhEvalInPatLogP)) && scorePhrasesInPatSelection) {
            for (CandidatePhrase gc : allCandidatePhrases) {
                String g = gc.getPhrase();
                if (this.constVars.usePatternEvalEditDistOther) {
                    editDistanceFromOtherSemanticBinaryScores.setCount(gc, this.constVars.getEditDistanceScoresOtherClassThreshold(label, g));
                }
                if (this.constVars.usePatternEvalEditDistSame) {
                    editDistanceFromAlreadyExtractedBinaryScores.setCount(gc, 1.0 - this.constVars.getEditDistanceScoresThisClassThreshold(label, g));
                }
                if (this.constVars.usePatternEvalGoogleNgram) {
                    googleNgramNormScores.setCount(gc, PhraseScorer.getGoogleNgramScore(gc));
                }
                if (this.constVars.usePatternEvalDomainNgram && Data.domainNGramRawFreq.containsKey(g)) {
                    assert (Data.rawFreq.containsKey(gc));
                    domainNgramNormScores.setCount(gc, this.scorePhrases.phraseScorer.getDomainNgramScore(g));
                }
                if (!this.constVars.usePatternEvalWordClass) continue;
                Integer num = this.constVars.getWordClassClusters().get(g);
                if (num == null) {
                    num = this.constVars.getWordClassClusters().get(g.toLowerCase());
                }
                if (num != null && this.constVars.distSimWeights.get(label).containsKey(num)) {
                    externalFeatWtsNormalized.setCount(gc, this.constVars.distSimWeights.get(label).getCount(num));
                    continue;
                }
                externalFeatWtsNormalized.setCount(gc, externalWtsDefault);
            }
            if (this.constVars.usePatternEvalGoogleNgram) {
                googleNgramNormScores = GetPatternsFromDataMultiClass.normalizeSoftMaxMinMaxScores(googleNgramNormScores, true, true, false);
            }
            if (this.constVars.usePatternEvalDomainNgram) {
                domainNgramNormScores = GetPatternsFromDataMultiClass.normalizeSoftMaxMinMaxScores(domainNgramNormScores, true, true, false);
            }
            if (this.constVars.usePatternEvalWordClass) {
                externalFeatWtsNormalized = GetPatternsFromDataMultiClass.normalizeSoftMaxMinMaxScores(externalFeatWtsNormalized, true, true, false);
            }
        } else if ((this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.LOGREG) || this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.LOGREGlogP)) && scorePhrasesInPatSelection) {
            Properties props2 = new Properties();
            props2.putAll((Map<?, ?>)this.props);
            props2.setProperty("phraseScorerClass", "edu.stanford.nlp.patterns.ScorePhrasesLearnFeatWt");
            ScorePhrases scoreclassifier = new ScorePhrases(props2, this.constVars);
            System.out.println("file is " + this.props.getProperty("domainNGramsFile"));
            ArgumentParser.fillOptions(Data.class, props2);
            classifierScores = scoreclassifier.phraseScorer.scorePhrases(label, allCandidatePhrases, true);
        }
        ClassicCounter<CandidatePhrase> cachedScoresForThisIter = new ClassicCounter<CandidatePhrase>();
        for (Map.Entry<E, ClassicCounter<CandidatePhrase>> en : positivePatternsAndWords.entrySet()) {
            for (Map.Entry<CandidatePhrase, Double> en2 : en.getValue().entrySet()) {
                CandidatePhrase word = en2.getKey();
                ClassicCounter<ConstantsAndVariables.ScorePhraseMeasures> scoreslist = new ClassicCounter<ConstantsAndVariables.ScorePhraseMeasures>();
                double score = 1.0;
                if ((this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.PhEvalInPat) || this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.PhEvalInPatLogP)) && scorePhrasesInPatSelection) {
                    if (cachedScoresForThisIter.containsKey(word)) {
                        score = cachedScoresForThisIter.getCount(word);
                    } else {
                        if (this.constVars.getOtherSemanticClassesWords().contains(word) || this.constVars.getCommonEngWords().contains(word)) {
                            score = 1.0;
                        } else {
                            if (this.constVars.usePatternEvalSemanticOdds) {
                                double semanticClassOdds = 1.0;
                                if (dictOddsWordWeights.containsKey(word)) {
                                    semanticClassOdds = 1.0 - dictOddsWordWeights.getCount(word);
                                }
                                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.SEMANTICODDS, semanticClassOdds);
                            }
                            if (this.constVars.usePatternEvalGoogleNgram) {
                                double gscore = 0.0;
                                if (googleNgramNormScores.containsKey(word)) {
                                    gscore = 1.0 - googleNgramNormScores.getCount(word);
                                }
                                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.GOOGLENGRAM, gscore);
                            }
                            if (this.constVars.usePatternEvalDomainNgram) {
                                double domainscore = domainNgramNormScores.containsKey(word) ? 1.0 - domainNgramNormScores.getCount(word) : 1.0 - this.scorePhrases.phraseScorer.getPhraseWeightFromWords(domainNgramNormScores, word, this.scorePhrases.phraseScorer.OOVDomainNgramScore);
                                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.DOMAINNGRAM, domainscore);
                            }
                            if (this.constVars.usePatternEvalWordClass) {
                                double externalFeatureWt = externalWtsDefault;
                                if (externalFeatWtsNormalized.containsKey(word)) {
                                    externalFeatureWt = 1.0 - externalFeatWtsNormalized.getCount(word);
                                }
                                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.DISTSIM, externalFeatureWt);
                            }
                            if (this.constVars.usePatternEvalEditDistOther) {
                                assert (editDistanceFromOtherSemanticBinaryScores.containsKey(word)) : "How come no edit distance info for word " + word + "";
                                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.EDITDISTOTHER, editDistanceFromOtherSemanticBinaryScores.getCount(word));
                            }
                            if (this.constVars.usePatternEvalEditDistSame) {
                                scoreslist.setCount(ConstantsAndVariables.ScorePhraseMeasures.EDITDISTSAME, editDistanceFromAlreadyExtractedBinaryScores.getCount(word));
                            }
                            score = Counters.mean(scoreslist);
                            this.phInPatScores.setCounter(word, scoreslist);
                        }
                        cachedScoresForThisIter.setCount(word, score);
                    }
                } else if ((this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.LOGREG) || this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.LOGREGlogP)) && scorePhrasesInPatSelection) {
                    score = 1.0 - classifierScores.getCount(word);
                }
                if (useFreqPhraseExtractedByPat) {
                    score *= scoringFunction.applyAsDouble(new Pair<E, CandidatePhrase>(en.getKey(), word));
                }
                if (this.constVars.sqrtPatScore) {
                    patterns.incrementCount(en.getKey(), Math.sqrt(score));
                    continue;
                }
                patterns.incrementCount(en.getKey(), score);
            }
        }
        return patterns;
    }
}

