/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.AnnotationLookup;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.trees.TreePrint;
import edu.stanford.nlp.util.PropertiesUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class AnnotationOutputter {
    static final TreePrint DEFAULT_CONSTITUENCY_TREE_PRINTER = new TreePrint("penn");
    private static final TreePrint DEFAULT_DEPENDENCY_TREE_PRINTER = new TreePrint("typedDependenciesCollapsed");
    private static final String DEFAULT_KEYS = "idx,word,lemma,pos,ner,headidx,deprel";
    private static final Options DEFAULT_OPTIONS = new Options();

    public abstract void print(Annotation var1, OutputStream var2, Options var3) throws IOException;

    public void print(Annotation annotation, OutputStream os) throws IOException {
        this.print(annotation, os, DEFAULT_OPTIONS);
    }

    public void print(Annotation annotation, OutputStream os, StanfordCoreNLP pipeline) throws IOException {
        this.print(annotation, os, AnnotationOutputter.getOptions(pipeline.getProperties()));
    }

    public String print(Annotation ann, Options options) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.print(ann, (OutputStream)os, options);
        os.close();
        return new String(os.toByteArray());
    }

    public String print(Annotation ann) throws IOException {
        return this.print(ann, DEFAULT_OPTIONS);
    }

    public String print(Annotation ann, StanfordCoreNLP pipeline) throws IOException {
        return this.print(ann, AnnotationOutputter.getOptions(pipeline.getProperties()));
    }

    public static Options getOptions(Properties properties) {
        return new Options(properties);
    }

    public static class Options {
        public final boolean includeText;
        public final String encoding;
        public final boolean pretty;
        public final TreePrint constituencyTreePrinter;
        public final TreePrint dependencyTreePrinter;
        public final int coreferenceContextSize;
        public final boolean printSingletons;
        public final double relationsBeam;
        public final List<Class<? extends CoreAnnotation<?>>> keysToPrint;
        public final boolean printFakeDeps;

        public Options() {
            this(true);
        }

        public Options(boolean pretty) {
            this.includeText = false;
            this.encoding = "UTF-8";
            this.pretty = pretty;
            this.constituencyTreePrinter = DEFAULT_CONSTITUENCY_TREE_PRINTER;
            this.dependencyTreePrinter = DEFAULT_DEPENDENCY_TREE_PRINTER;
            this.coreferenceContextSize = 0;
            this.printSingletons = false;
            this.relationsBeam = 0.0;
            this.keysToPrint = Options.getKeysToPrint(AnnotationOutputter.DEFAULT_KEYS);
            this.printFakeDeps = false;
        }

        public Options(Properties properties) {
            this.includeText = PropertiesUtils.getBool(properties, "output.includeText", false);
            this.encoding = properties.getProperty("encoding", "UTF-8");
            this.pretty = PropertiesUtils.getBool(properties, "output.prettyPrint", true);
            String constituencyTreeStyle = properties.getProperty("output.constituencyTree", "penn");
            this.constituencyTreePrinter = new TreePrint(constituencyTreeStyle);
            String dependencyTreeStyle = properties.getProperty("output.dependencyTree", "typedDependenciesCollapsed");
            this.dependencyTreePrinter = new TreePrint(dependencyTreeStyle);
            this.coreferenceContextSize = PropertiesUtils.getInt(properties, "output.coreferenceContextSize", 0);
            this.printSingletons = PropertiesUtils.getBool(properties, "output.printSingletonEntities", false);
            this.relationsBeam = PropertiesUtils.getDouble(properties, "output.relation.beam", 0.0);
            this.keysToPrint = Options.getKeysToPrint(properties.getProperty("output.columns", AnnotationOutputter.DEFAULT_KEYS));
            this.printFakeDeps = PropertiesUtils.getBool(properties, "output.printFakeDeps", false);
        }

        private static List<Class<? extends CoreAnnotation<?>>> getKeysToPrint(String columns) {
            if (columns == null) {
                columns = AnnotationOutputter.DEFAULT_KEYS;
            }
            String[] keyArray = columns.split(" *, *");
            ArrayList keyList = new ArrayList();
            for (String key : keyArray) {
                keyList.add(AnnotationLookup.toCoreKey(key));
            }
            return keyList;
        }
    }
}

