/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.parser.charniak.CharniakParser;
import edu.stanford.nlp.parser.common.ParserUtils;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.ParserAnnotatorUtils;
import edu.stanford.nlp.trees.EnglishGrammaticalStructureFactory;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class CharniakParserAnnotator
implements Annotator {
    private static Redwood.RedwoodChannels log = Redwood.channels(CharniakParserAnnotator.class);
    private static final boolean BUILD_GRAPHS = true;
    private final GrammaticalStructureFactory gsf = new EnglishGrammaticalStructureFactory();
    private final boolean VERBOSE;
    private final CharniakParser parser;

    public CharniakParserAnnotator(String parserModel, String parserExecutable, boolean verbose, int maxSentenceLength) {
        this.VERBOSE = verbose;
        this.parser = new CharniakParser(parserExecutable, parserModel);
        this.parser.setMaxSentenceLength(maxSentenceLength);
    }

    public CharniakParserAnnotator() {
        this.VERBOSE = false;
        this.parser = new CharniakParser();
    }

    @Override
    public void annotate(Annotation annotation) {
        if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                int maxSentenceLength;
                List words = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                if (this.VERBOSE) {
                    log.info("Parsing: " + words);
                }
                Tree tree = (maxSentenceLength = this.parser.getMaxSentenceLength()) <= 0 || words.size() < maxSentenceLength ? this.parser.getBestParse(words) : ParserUtils.xTree(words);
                ArrayList<Tree> trees = Generics.newArrayList(1);
                trees.add(tree);
                ParserAnnotatorUtils.fillInParseAnnotations(this.VERBOSE, true, this.gsf, sentence, trees, GrammaticalStructure.Extras.NONE);
            }
        } else {
            throw new RuntimeException("unable to find sentences in: " + annotation);
        }
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.SentencesAnnotation.class)));
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.PartOfSpeechAnnotation.class, TreeCoreAnnotations.TreeAnnotation.class, CoreAnnotations.CategoryAnnotation.class)));
    }
}

