/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationOutputter;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CoNLLOutputter
extends AnnotationOutputter {
    private static final String NULL_PLACEHOLDER = "_";

    private static String orNeg(int in) {
        if (in < 0) {
            return NULL_PLACEHOLDER;
        }
        return Integer.toString(in);
    }

    private static String orNull(Object in) {
        if (in == null) {
            return NULL_PLACEHOLDER;
        }
        return in.toString();
    }

    private static String line(int index, CoreLabel token, int head, String deprel, AnnotationOutputter.Options options) {
        List<Class<CoreAnnotation<?>>> keysToPrint = options.keysToPrint;
        ArrayList<String> fields = new ArrayList<String>(keysToPrint.size());
        for (Class<CoreAnnotation<?>> keyClass : keysToPrint) {
            if (keyClass.equals(CoreAnnotations.IndexAnnotation.class)) {
                fields.add(CoNLLOutputter.orNull(index));
                continue;
            }
            if (keyClass.equals(CoreAnnotations.CoNLLDepTypeAnnotation.class)) {
                fields.add(CoNLLOutputter.orNull(deprel));
                continue;
            }
            if (keyClass.equals(CoreAnnotations.CoNLLDepParentIndexAnnotation.class)) {
                fields.add(CoNLLOutputter.orNeg(head));
                continue;
            }
            fields.add(CoNLLOutputter.orNull(token.get(keyClass)));
        }
        if (options.pretty) {
            return StringUtils.join(fields, "\t");
        }
        return StringUtils.join(fields, "/");
    }

    @Override
    public void print(Annotation doc, OutputStream target, AnnotationOutputter.Options options) throws IOException {
        PrintWriter writer = new PrintWriter(IOUtils.encodedOutputStreamWriter(target, options.encoding));
        if (doc.get(CoreAnnotations.SentencesAnnotation.class) != null) {
            for (CoreMap sentence : (List)doc.get(CoreAnnotations.SentencesAnnotation.class)) {
                if (sentence.get(CoreAnnotations.TokensAnnotation.class) != null) {
                    List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                    SemanticGraph depTree = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
                    for (int i = 0; i < tokens.size(); ++i) {
                        int head = -1;
                        String deprel = null;
                        if (depTree != null) {
                            Set rootSet = depTree.getRoots().stream().map(IndexedWord::index).collect(Collectors.toSet());
                            IndexedWord node = depTree.getNodeByIndexSafe(i + 1);
                            if (node != null) {
                                List<SemanticGraphEdge> edgeList = depTree.getIncomingEdgesSorted(node);
                                if (!edgeList.isEmpty()) {
                                    assert (edgeList.size() == 1);
                                    head = edgeList.get(0).getGovernor().index();
                                    deprel = edgeList.get(0).getRelation().toString();
                                } else if (rootSet.contains(i + 1)) {
                                    head = 0;
                                    deprel = "ROOT";
                                }
                            }
                        }
                        writer.print(CoNLLOutputter.line(i + 1, (CoreLabel)tokens.get(i), head, deprel, options));
                        if (options.pretty) {
                            writer.println();
                            continue;
                        }
                        if (i >= tokens.size() - 1) continue;
                        writer.print(' ');
                    }
                }
                writer.println();
            }
        }
        writer.flush();
    }

    public static void conllPrint(Annotation annotation, OutputStream os) throws IOException {
        new CoNLLOutputter().print(annotation, os);
    }

    public static void conllPrint(Annotation annotation, OutputStream os, StanfordCoreNLP pipeline) throws IOException {
        new CoNLLOutputter().print(annotation, os, pipeline);
    }

    public static void conllPrint(Annotation annotation, OutputStream os, AnnotationOutputter.Options options) throws IOException {
        new CoNLLOutputter().print(annotation, os, options);
    }
}

