/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DocDateAnnotator
implements Annotator {
    private static final Redwood.RedwoodChannels log = Redwood.channels(DocDateAnnotator.class);
    public static final String DOC_DATE_FIXED_PROPERTY = "useFixedDate";
    public static final String DOC_DATE_MAPPING_FILE_PROPERTY = "useMappingFile";
    public static final String DOC_DATE_PRESENT_PROPERTY = "usePresent";
    public static final String DOC_DATE_REGEX_PROPERTY = "useRegex";
    public static final Pattern DATE_PROPER_FORMAT = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");
    public static final Pattern DATE_NO_HYPHENS_PATTERN = Pattern.compile("[0-9]{8}");
    private final boolean useFixedDate;
    private final boolean useMappingFile;
    private final boolean usePresentDate;
    private final boolean useRegex;
    private String fixedDate;
    private HashMap<String, String> docIDToDocDate;
    private Pattern fileDocDatePattern;
    private final String description;

    public DocDateAnnotator(String name, Properties props) {
        StringBuilder sb = new StringBuilder("DocDateAnnotator[");
        this.useFixedDate = props.containsKey(name + "." + DOC_DATE_FIXED_PROPERTY);
        this.useMappingFile = props.containsKey(name + "." + DOC_DATE_MAPPING_FILE_PROPERTY);
        this.usePresentDate = PropertiesUtils.getBool(props, name + "." + DOC_DATE_PRESENT_PROPERTY, false);
        this.useRegex = props.containsKey(name + "." + DOC_DATE_REGEX_PROPERTY);
        if (this.useMappingFile) {
            String mappingFilePath = props.getProperty(name + "." + DOC_DATE_MAPPING_FILE_PROPERTY);
            sb.append("mappingFile=");
            sb.append(mappingFilePath);
            this.docIDToDocDate = new HashMap();
            List<String> mappingEntries = IOUtils.linesFromFile(mappingFilePath);
            for (String fileNameAndDocDate : mappingEntries) {
                String[] keyAndValue = fileNameAndDocDate.split("\t");
                this.docIDToDocDate.put(keyAndValue[0], keyAndValue[1]);
            }
        } else if (this.useFixedDate) {
            this.fixedDate = props.getProperty(name + "." + DOC_DATE_FIXED_PROPERTY);
            sb.append("fixedDate=");
            sb.append(this.fixedDate);
        } else if (this.usePresentDate) {
            this.fixedDate = this.currentDate();
            sb.append("presentDate=");
            sb.append(this.fixedDate);
        } else if (this.useRegex) {
            String regex = props.getProperty(name + "." + DOC_DATE_REGEX_PROPERTY);
            this.fileDocDatePattern = Pattern.compile(regex);
            sb.append("regex=");
            sb.append(regex);
        } else {
            sb.append("no docDate finder");
        }
        sb.append(']');
        this.description = sb.toString();
    }

    @Override
    public void annotate(Annotation annotation) {
        Matcher properDateFormat;
        String foundDocDate;
        String docID = (String)annotation.get(CoreAnnotations.DocIDAnnotation.class);
        if (docID == null) {
            docID = "";
        }
        if (this.useMappingFile) {
            foundDocDate = this.docIDToDocDate.get(docID);
            if (foundDocDate == null) {
                log.warn("DocDate mapping file failed to match against " + docID);
                foundDocDate = "";
            }
        } else if (this.useFixedDate || this.usePresentDate) {
            foundDocDate = this.fixedDate;
        } else if (this.useRegex) {
            Matcher m = this.fileDocDatePattern.matcher(docID);
            if (m.matches()) {
                foundDocDate = m.group(1);
                if (foundDocDate.length() == 8 && DATE_NO_HYPHENS_PATTERN.matcher(foundDocDate).matches()) {
                    foundDocDate = DocDateAnnotator.addHyphensToDate(foundDocDate);
                }
            } else {
                log.warn("DocDate regex failed to match against " + docID);
                foundDocDate = "";
            }
        } else {
            foundDocDate = "";
        }
        if ((properDateFormat = DATE_PROPER_FORMAT.matcher(foundDocDate)).matches()) {
            annotation.set(CoreAnnotations.DocDateAnnotation.class, foundDocDate);
        }
    }

    public String currentDate() {
        return new SimpleDateFormat("yyyy-MM-dd").format(Calendar.getInstance().getTime());
    }

    private static String addHyphensToDate(String compactDateString) {
        String yyyy = compactDateString.substring(0, 4);
        String mm = compactDateString.substring(4, 6);
        String dd = compactDateString.substring(6, 8);
        return yyyy + '-' + mm + '-' + dd;
    }

    public String toString() {
        return this.description;
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.emptySet();
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.emptySet();
    }
}

