/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationOutputter;
import edu.stanford.nlp.pipeline.CoreDocument;
import edu.stanford.nlp.pipeline.CoreEntityMention;
import edu.stanford.nlp.pipeline.CoreSentence;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;

public class InlineXMLOutputter
extends AnnotationOutputter {
    @Override
    public void print(Annotation annotation, OutputStream stream, AnnotationOutputter.Options options) throws IOException {
        PrintWriter os = new PrintWriter(IOUtils.encodedOutputStreamWriter(stream, options.encoding));
        InlineXMLOutputter.print(annotation, os, options);
    }

    private static void print(Annotation annotation, PrintWriter pw, AnnotationOutputter.Options options) {
        CoreDocument doc = new CoreDocument(annotation);
        for (CoreSentence sentence : doc.sentences()) {
            int entityIdx = 0;
            int tokenIdx = 0;
            List<CoreEntityMention> entities = sentence.entityMentions();
            int numEntities = entities.size();
            for (CoreLabel token : sentence.tokens()) {
                if (tokenIdx != 0) {
                    pw.printf(" ", new Object[0]);
                }
                if (numEntities > entityIdx) {
                    if (entities.get(entityIdx).charOffsets().first().intValue() == token.beginPosition()) {
                        pw.printf("<%s>%s", entities.get(entityIdx).entityType(), token.word());
                        if (entities.get(entityIdx).charOffsets().second().intValue() == token.endPosition()) {
                            pw.printf("</%s>", entities.get(entityIdx).entityType());
                            ++entityIdx;
                        }
                    } else if (entities.get(entityIdx).charOffsets().second().intValue() == token.endPosition()) {
                        pw.printf("%s</%s>", token.word(), entities.get(entityIdx).entityType());
                        ++entityIdx;
                    } else {
                        pw.printf("%s", token.word());
                    }
                } else {
                    pw.printf("%s", token.word());
                }
                ++tokenIdx;
            }
            pw.print("\n");
        }
        pw.flush();
    }
}

