/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.ie.util.RelationTriple;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.QuoteAttributionAnnotator;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.Timex;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.IntTuple;
import edu.stanford.nlp.util.Pair;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;

public class JSONAnnotationReader {
    private static final CoreLabelTokenFactory tokenFactory = new CoreLabelTokenFactory(true);

    public Annotation read(String text) {
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(text));
        JsonObject json = jsonReader.readObject();
        return this.toAnnotation(json);
    }

    public static <T> List<T> toList(JsonArray array, Function<JsonObject, T> f) {
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < array.size(); ++i) {
            result.add(f.apply(array.getJsonObject(i)));
        }
        return result;
    }

    public static <T1, T2> Map<T1, T2> toMap(JsonArray array, Function<JsonObject, T1> keyf, Function<JsonObject, T2> valuef) {
        HashMap<T1, T2> result = new HashMap<T1, T2>();
        for (int i = 0; i < array.size(); ++i) {
            JsonObject obj = array.getJsonObject(i);
            result.put(keyf.apply(obj), valuef.apply(obj));
        }
        return result;
    }

    public static <T1, T2> Map<T1, T2> toMap(JsonObject m, Function<String, T1> keyf, Function<JsonObject, T2> valuef) {
        HashMap<T1, T2> result = new HashMap<T1, T2>();
        Set keys = m.keySet();
        for (String key : keys) {
            JsonObject obj = m.getJsonObject(key);
            result.put(keyf.apply(key), valuef.apply(obj));
        }
        return result;
    }

    public static <T1, T2> Map<T1, T2> toMap(JsonObject m, Function<Pair<JsonObject, String>, Pair<T1, T2>> pairf) {
        HashMap result = new HashMap();
        Set keys = m.keySet();
        for (String key : keys) {
            Pair<T1, T2> p = pairf.apply(Pair.makePair(m, key));
            result.put(p.first, p.second);
        }
        return result;
    }

    public static <T1, T2> T2 toNullable(T1 obj, Function<T1, T2> f) {
        if (obj == null) {
            return null;
        }
        return f.apply(obj);
    }

    public static <T> List<T> toNullableList(JsonArray array, Function<JsonObject, T> f) {
        if (array == null) {
            return null;
        }
        return JSONAnnotationReader.toList(array, f);
    }

    public static <T1, T2> Map<T1, T2> toNullableMap(JsonObject json, Function<Pair<JsonObject, String>, Pair<T1, T2>> pairf) {
        if (json == null) {
            return null;
        }
        return JSONAnnotationReader.toMap(json, pairf);
    }

    public SemanticGraph toDependencyParse(JsonArray array) {
        return null;
    }

    public CorefChain.CorefMention toCorefMention(JsonObject json, int cid) {
        JsonArray position = json.getJsonArray("position");
        IntTuple tuple = null;
        if (position != null) {
            tuple = new IntTuple(position.size());
            for (int i = 0; i < position.size(); ++i) {
                tuple.set(i, position.getInt(i));
            }
        }
        String type = json.getString("type", null);
        String number = json.getString("number", null);
        String gender = json.getString("gender", null);
        String animacy = json.getString("animacy", null);
        CorefChain.CorefMention mention = new CorefChain.CorefMention(type != null ? Dictionaries.MentionType.valueOf(type) : null, number != null ? Dictionaries.Number.valueOf(number) : null, gender != null ? Dictionaries.Gender.valueOf(gender) : null, animacy != null ? Dictionaries.Animacy.valueOf(animacy) : null, json.getInt("startIndex"), json.getInt("endIndex"), json.getInt("headIndex", -1), cid, json.getInt("id"), json.getInt("sentNum"), tuple, json.getString("text", null));
        return mention;
    }

    public CorefChain toCorefChain(JsonArray array, int cid) {
        List<Pair> mentions = JSONAnnotationReader.toList(array, item -> Pair.makePair(this.toCorefMention((JsonObject)item, cid), item.getBoolean("isRepresentativeMention", false)));
        HashMap<IntPair, Set<CorefChain.CorefMention>> mentionMap = new HashMap<IntPair, Set<CorefChain.CorefMention>>();
        CorefChain.CorefMention representative = null;
        for (Pair pair : mentions) {
            CorefChain.CorefMention mention = (CorefChain.CorefMention)pair.first;
            if (((Boolean)pair.second).booleanValue()) {
                representative = mention;
            }
            IntPair key = new IntPair(mention.sentNum, mention.headIndex);
            mentionMap.putIfAbsent(key, new ArraySet());
            Set set = (Set)mentionMap.get(key);
            set.add(mention);
        }
        CorefChain corefChain = new CorefChain(cid, mentionMap, representative);
        return corefChain;
    }

    public CoreMap toSection(JsonObject json, List<CoreMap> sentences) {
        ArrayCoreMap coremap = new ArrayCoreMap();
        coremap.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, json.getInt("charBegin"));
        coremap.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, json.getInt("charEnd"));
        coremap.set(CoreAnnotations.AuthorAnnotation.class, json.getString("author", null));
        coremap.set(CoreAnnotations.SectionDateAnnotation.class, json.getString("dateTime", null));
        coremap.set(CoreAnnotations.SentencesAnnotation.class, JSONAnnotationReader.toList(json.getJsonArray("sentenceIndexes"), item -> (CoreMap)sentences.get(item.getInt("index"))));
        return coremap;
    }

    public CoreMap toQuotation(JsonObject json) {
        String canonicalSpeaker;
        ArrayCoreMap coremap = new ArrayCoreMap();
        coremap.set(CoreAnnotations.QuotationIndexAnnotation.class, json.getInt("id"));
        coremap.set(CoreAnnotations.TextAnnotation.class, json.getString("text", null));
        coremap.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, json.getInt("beginIndex"));
        coremap.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, json.getInt("endIndex"));
        coremap.set(CoreAnnotations.TokenBeginAnnotation.class, json.getInt("beginToken"));
        coremap.set(CoreAnnotations.TokenEndAnnotation.class, json.getInt("endToken"));
        coremap.set(CoreAnnotations.SentenceBeginAnnotation.class, json.getInt("beginSentence"));
        coremap.set(CoreAnnotations.SentenceEndAnnotation.class, json.getInt("endSentence"));
        String speaker = json.getString("speaker", null);
        if (speaker != null && !"Unknown".equals(speaker)) {
            coremap.set(QuoteAttributionAnnotator.SpeakerAnnotation.class, speaker);
        }
        if ((canonicalSpeaker = json.getString("canonicalSpeaker", null)) != null && !"Unknown".equals(canonicalSpeaker)) {
            coremap.set(QuoteAttributionAnnotator.CanonicalMentionAnnotation.class, canonicalSpeaker);
        }
        return coremap;
    }

    public <T> List<T> extractSubList(JsonArray array, List<T> list) {
        return list.subList(array.getInt(0), array.getInt(1));
    }

    public RelationTriple toRelationTriple(JsonObject json, List<CoreLabel> tokens) {
        List<CoreLabel> subject = this.extractSubList(json.getJsonArray("subjectSpan"), tokens);
        List<CoreLabel> relation = this.extractSubList(json.getJsonArray("relationSpan"), tokens);
        List<CoreLabel> object = this.extractSubList(json.getJsonArray("objectSpan"), tokens);
        RelationTriple triple = new RelationTriple(subject, relation, object);
        return triple;
    }

    public Timex toTimex(JsonObject json) {
        return null;
    }

    public CoreMap toEntityMention(JsonObject json) {
        ArrayCoreMap mention = new ArrayCoreMap();
        mention.set(CoreAnnotations.TokenBeginAnnotation.class, json.getInt("docTokenBegin"));
        mention.set(CoreAnnotations.TokenEndAnnotation.class, json.getInt("docTokenEnd"));
        mention.set(CoreAnnotations.TextAnnotation.class, json.getString("text", null));
        mention.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, json.getInt("characterOffsetBegin"));
        mention.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, json.getInt("characterOffsetEnd"));
        mention.set(CoreAnnotations.NamedEntityTagAnnotation.class, json.getString("ner", null));
        mention.set(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, json.getString("normalizedNER", null));
        mention.set(CoreAnnotations.WikipediaEntityAnnotation.class, json.getString("entitylink", null));
        mention.set(TimeAnnotations.TimexAnnotation.class, JSONAnnotationReader.toNullable(json.getJsonObject("timex"), obj -> this.toTimex((JsonObject)obj)));
        return mention;
    }

    public CoreLabel toToken(JsonObject json) {
        CoreLabel token = tokenFactory.makeToken();
        token.setIndex(json.getInt("index"));
        token.setValue(json.getString("word", null));
        token.setWord(json.getString("word", null));
        token.setOriginalText(json.getString("originalText", null));
        token.setLemma(json.getString("lemma", null));
        token.setBeginPosition(json.getInt("characterOffsetBegin"));
        token.setEndPosition(json.getInt("characterOffsetEnd"));
        token.setTag(json.getString("pos", null));
        token.setNER(json.getString("ner", null));
        token.set(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, json.getString("normalizedNER", null));
        token.set(CoreAnnotations.SpeakerAnnotation.class, json.getString("speaker", null));
        token.set(CoreAnnotations.TrueCaseAnnotation.class, json.getString("truecase", null));
        token.set(CoreAnnotations.TrueCaseTextAnnotation.class, json.getString("truecaseText", null));
        token.set(CoreAnnotations.BeforeAnnotation.class, json.getString("before", null));
        token.set(CoreAnnotations.AfterAnnotation.class, json.getString("after", null));
        token.set(CoreAnnotations.WikipediaEntityAnnotation.class, json.getString("entitylink", null));
        token.set(TimeAnnotations.TimexAnnotation.class, JSONAnnotationReader.toNullable(json.getJsonObject("timex"), obj -> this.toTimex((JsonObject)obj)));
        return token;
    }

    public CoreMap toSentence(JsonObject json) {
        ArrayCoreMap sentence = new ArrayCoreMap();
        sentence.set(CoreAnnotations.SentenceIDAnnotation.class, json.getString("id", null));
        if (json.get((Object)"index") != null) {
            sentence.set(CoreAnnotations.SentenceIndexAnnotation.class, json.getInt("index"));
        }
        if (json.get((Object)"line") != null) {
            sentence.set(CoreAnnotations.LineNumberAnnotation.class, json.getInt("line"));
        }
        if (json.get((Object)"paragraph") != null) {
            sentence.set(CoreAnnotations.ParagraphIndexAnnotation.class, json.getInt("paragraph"));
        }
        sentence.set(CoreAnnotations.SpeakerAnnotation.class, json.getString("speaker", null));
        sentence.set(CoreAnnotations.SpeakerTypeAnnotation.class, json.getString("speakerType", null));
        List<CoreLabel> tokens = JSONAnnotationReader.toNullableList(json.getJsonArray("tokens"), item -> this.toToken((JsonObject)item));
        sentence.set(CoreAnnotations.TokensAnnotation.class, tokens);
        String treeParse = json.getString("parse", null);
        if (treeParse != null) {
            sentence.set(TreeCoreAnnotations.TreeAnnotation.class, Trees.readTree(treeParse));
        }
        sentence.set(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, JSONAnnotationReader.toNullable(json.getJsonArray("basicDependencies"), item -> this.toDependencyParse((JsonArray)item)));
        sentence.set(SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class, JSONAnnotationReader.toNullable(json.getJsonArray("enhancedDependencies"), item -> this.toDependencyParse((JsonArray)item)));
        sentence.set(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class, JSONAnnotationReader.toNullable(json.getJsonArray("enhancedPlusPlusDependencies"), item -> this.toDependencyParse((JsonArray)item)));
        sentence.set(NaturalLogicAnnotations.RelationTriplesAnnotation.class, JSONAnnotationReader.toNullableList(json.getJsonArray("openie"), item -> this.toRelationTriple((JsonObject)item, tokens)));
        sentence.set(CoreAnnotations.KBPTriplesAnnotation.class, JSONAnnotationReader.toNullableList(json.getJsonArray("kbp"), item -> this.toRelationTriple((JsonObject)item, tokens)));
        sentence.set(CoreAnnotations.MentionsAnnotation.class, JSONAnnotationReader.toNullableList(json.getJsonArray("entitymentions"), item -> this.toEntityMention((JsonObject)item)));
        return sentence;
    }

    private static boolean hasSpeakerAnnotations(Annotation annotation) {
        for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreLabel t : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                if (t.get(CoreAnnotations.SpeakerAnnotation.class) == null) continue;
                return true;
            }
        }
        return false;
    }

    public Annotation toAnnotation(JsonObject json) {
        Annotation annotation = new Annotation(json.getString("text", null));
        annotation.set(CoreAnnotations.DocIDAnnotation.class, json.getString("docId", null));
        annotation.set(CoreAnnotations.DocDateAnnotation.class, json.getString("docDate", null));
        annotation.set(CoreAnnotations.DocSourceTypeAnnotation.class, json.getString("docSourceType", null));
        annotation.set(CoreAnnotations.DocTypeAnnotation.class, json.getString("docType", null));
        annotation.set(CoreAnnotations.AuthorAnnotation.class, json.getString("author", null));
        annotation.set(CoreAnnotations.LocationAnnotation.class, json.getString("location", null));
        List<CoreMap> sentences = JSONAnnotationReader.toNullableList(json.getJsonArray("sentences"), item -> this.toSentence((JsonObject)item));
        annotation.set(CoreAnnotations.SentencesAnnotation.class, sentences);
        annotation.set(CorefCoreAnnotations.CorefChainAnnotation.class, JSONAnnotationReader.toNullableMap(json.getJsonObject("corefs"), pair -> {
            int cid = Integer.valueOf((String)pair.second);
            CorefChain chain = this.toCorefChain(((JsonObject)pair.first).getJsonArray((String)pair.second), cid);
            return Pair.makePair(cid, chain);
        }));
        annotation.set(CoreAnnotations.QuotationsAnnotation.class, JSONAnnotationReader.toNullableList(json.getJsonArray("quotes"), item -> this.toQuotation((JsonObject)item)));
        annotation.set(CoreAnnotations.SectionsAnnotation.class, JSONAnnotationReader.toNullableList(json.getJsonArray("sections"), item -> this.toSection((JsonObject)item, (List)annotation.get(CoreAnnotations.SentencesAnnotation.class))));
        if (annotation.get(CoreAnnotations.TokensAnnotation.class) == null) {
            List allTokens = sentences.stream().flatMap(sentence -> ((List)sentence.get(CoreAnnotations.TokensAnnotation.class)).stream()).collect(Collectors.toList());
            annotation.set(CoreAnnotations.TokensAnnotation.class, allTokens);
        }
        if (JSONAnnotationReader.hasSpeakerAnnotations(annotation)) {
            annotation.set(CoreAnnotations.UseMarkedDiscourseAnnotation.class, true);
        }
        return annotation;
    }
}

