/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.io.FileSequentialCollection;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationOutputter;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.AnnotationSerializer;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.AnnotatorImplementations;
import edu.stanford.nlp.pipeline.AnnotatorPool;
import edu.stanford.nlp.pipeline.CoNLLOutputter;
import edu.stanford.nlp.pipeline.CoNLLUOutputter;
import edu.stanford.nlp.pipeline.CoreDocument;
import edu.stanford.nlp.pipeline.GenericAnnotationSerializer;
import edu.stanford.nlp.pipeline.InlineXMLOutputter;
import edu.stanford.nlp.pipeline.JSONOutputter;
import edu.stanford.nlp.pipeline.LanguageInfo;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializer;
import edu.stanford.nlp.pipeline.TaggedTextOutputter;
import edu.stanford.nlp.pipeline.TextOutputter;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.ArrayUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Lazy;
import edu.stanford.nlp.util.MetaClass;
import edu.stanford.nlp.util.MutableInteger;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.ReflectionLoading;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.SystemUtils;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.logging.Redwood;
import edu.stanford.nlp.util.logging.StanfordRedwoodConfiguration;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.regex.Pattern;

public class StanfordCoreNLP
extends AnnotationPipeline {
    public static final Map<AnnotatorSignature, Lazy<Annotator>> GLOBAL_ANNOTATOR_CACHE = new ConcurrentHashMap<AnnotatorSignature, Lazy<Annotator>>();
    public static final String CUSTOM_ANNOTATOR_PREFIX = "customAnnotatorClass.";
    private static final String PROPS_SUFFIX = ".properties";
    public static final String NEWLINE_SPLITTER_PROPERTY = "ssplit.eolonly";
    public static final String NEWLINE_IS_SENTENCE_BREAK_PROPERTY = "ssplit.newlineIsSentenceBreak";
    public static final String DEFAULT_NEWLINE_IS_SENTENCE_BREAK = "never";
    public static final String DEFAULT_OUTPUT_FORMAT = "text";
    private static final Redwood.RedwoodChannels logger = Redwood.channels(StanfordCoreNLP.class);
    private int numWords;
    private final long pipelineSetupTime;
    private final Properties properties;
    private final Semaphore availableProcessors;
    public final AnnotatorPool pool;

    private static String getDefaultExtension(OutputFormat outputFormat) {
        switch (outputFormat) {
            case XML: {
                return ".xml";
            }
            case JSON: {
                return ".json";
            }
            case CONLL: {
                return ".conll";
            }
            case CONLLU: {
                return ".conllu";
            }
            case TEXT: {
                return ".out";
            }
            case TAGGED: {
                return ".tag";
            }
            case INLINEXML: {
                return ".inxml";
            }
            case SERIALIZED: {
                return ".ser.gz";
            }
            case CUSTOM: {
                return ".out";
            }
        }
        throw new IllegalArgumentException("Unknown output format " + (Object)((Object)outputFormat));
    }

    public StanfordCoreNLP() {
        this((Properties)null);
    }

    public StanfordCoreNLP(Properties props) {
        this(props, props == null || PropertiesUtils.getBool(props, "enforceRequirements", true));
    }

    public StanfordCoreNLP(Properties props, boolean enforceRequirements) {
        this(props, enforceRequirements, null);
    }

    public StanfordCoreNLP(String propsFileNamePrefix) {
        this(propsFileNamePrefix, true);
    }

    public StanfordCoreNLP(String propsFileNamePrefix, boolean enforceRequirements) {
        this(StanfordCoreNLP.loadPropertiesOrException(propsFileNamePrefix), enforceRequirements);
    }

    public StanfordCoreNLP(Properties props, boolean enforceRequirements, AnnotatorPool annotatorPool) {
        Timing tim = new Timing();
        this.numWords = 0;
        if (props == null) {
            props = StanfordCoreNLP.loadPropertiesFromClasspath();
        } else if (props.getProperty("annotators") == null) {
            Properties fromClassPath = StanfordCoreNLP.loadPropertiesFromClasspath();
            fromClassPath.putAll((Map<?, ?>)props);
            props = fromClassPath;
        }
        if (props.containsKey("fileList")) {
            props.setProperty("filelist", props.getProperty("fileList"));
        }
        this.properties = props;
        if (PropertiesUtils.getBool(this.properties, "preTokenized")) {
            String oldAnnotators;
            this.properties.setProperty("tokenize.whitespace", "true");
            this.properties.setProperty(NEWLINE_SPLITTER_PROPERTY, "true");
            String newAnnotators = oldAnnotators = this.properties.getProperty("annotators").replaceAll("\\s+", "");
            if (oldAnnotators != null && oldAnnotators.startsWith("cdc_tokenize")) {
                newAnnotators = "tokenize,ssplit" + oldAnnotators.substring(12, oldAnnotators.length());
                logger.info("preTokenized option set: Changing annotators cdc_tokenize to tokenize,ssplit");
            } else if (oldAnnotators != null && oldAnnotators.startsWith("tokenize,ssplit,mwt")) {
                newAnnotators = "tokenize,ssplit" + oldAnnotators.substring(19, oldAnnotators.length());
                logger.info("preTokenized option set: Changing annotators tokenize,ssplit,mwt to tokenize,ssplit");
            } else if (oldAnnotators != null && oldAnnotators.startsWith("tokenize,ssplit")) {
                logger.info("preTokenized option set: Annotators list starts with tokenize,ssplit, no change needed.");
            } else if (!(oldAnnotators == null || oldAnnotators.contains("tokenize") || oldAnnotators.contains("mwt") || oldAnnotators.contains("ssplit") || oldAnnotators.contains("cdc_tokenize"))) {
                logger.info("preTokenized option set: Adding tokenize,ssplit to beginning.");
                newAnnotators = "tokenize,ssplit," + oldAnnotators;
            } else {
                logger.warn("preTokenized option set: Non-standard annotators list, preTokenized may not work in this case.");
            }
            this.properties.setProperty("annotators", newAnnotators);
        }
        StanfordCoreNLP.normalizeAnnotators(this.properties);
        AnnotatorPool annotatorPool2 = this.pool = annotatorPool != null ? annotatorPool : StanfordCoreNLP.constructAnnotatorPool(props, this.getAnnotatorImplementations());
        if (this.properties.containsKey("threads")) {
            ArgumentParser.threads = PropertiesUtils.getInt(this.properties, "threads");
            this.availableProcessors = new Semaphore(ArgumentParser.threads);
        } else {
            this.availableProcessors = new Semaphore(1);
        }
        String[] annoNames = StanfordCoreNLP.getRequiredProperty(this.properties, "annotators").split("[, \t]+");
        Set<String> alreadyAddedAnnoNames = Generics.newHashSet();
        Set<Class<? extends CoreAnnotation>> requirementsSatisfied = Generics.newHashSet();
        for (String name : annoNames) {
            if ((name = name.trim()).isEmpty()) continue;
            logger.info("Adding annotator " + name);
            Annotator an = this.pool.get(name);
            this.addAnnotator(an);
            if (enforceRequirements) {
                Set<Class<? extends CoreAnnotation>> allRequirements = an.requires();
                for (Class<? extends CoreAnnotation> requirement : allRequirements) {
                    if (requirementsSatisfied.contains(requirement)) continue;
                    String fmt = "annotator \"%s\" requires annotation \"%s\". The usual requirements for this annotator are: %s";
                    Collection defaultRequirements = an.exactRequirements();
                    if (defaultRequirements == null) {
                        defaultRequirements = Annotator.DEFAULT_REQUIREMENTS.getOrDefault(name, Collections.singleton("unknown"));
                    }
                    throw new IllegalArgumentException(String.format(fmt, name, requirement.getSimpleName(), StringUtils.join(defaultRequirements, ",")));
                }
                requirementsSatisfied.addAll(an.requirementsSatisfied());
            }
            alreadyAddedAnnoNames.add(name);
        }
        if (!alreadyAddedAnnoNames.contains("ssplit")) {
            System.setProperty(NEWLINE_SPLITTER_PROPERTY, "false");
        }
        this.pipelineSetupTime = tim.report();
    }

    static void normalizeAnnotators(Properties properties) {
        StanfordCoreNLP.unifyTokenizeProperty(properties, "cleanxml", "tokenize.cleanxml");
        StanfordCoreNLP.unifyTokenizeProperty(properties, "ssplit", null);
        StanfordCoreNLP.replaceAnnotator(properties, "cdc_tokenize", "tokenize");
    }

    static void replaceAnnotator(Properties properties, String oldAnnotator, String newAnnotator) {
        String annotators = properties.getProperty("annotators", "");
        String replaced = annotators.replace(oldAnnotator, newAnnotator);
        if (!replaced.equals(annotators)) {
            logger.debug("|" + oldAnnotator + "| is now part of |" + newAnnotator + "|.  Annotators updated to |" + replaced + "|");
            properties.setProperty("annotators", replaced);
        }
    }

    static void unifyTokenizeProperty(Properties properties, String property, String option) {
        String annotators = properties.getProperty("annotators", "");
        int tokenize = annotators.indexOf("tokenize");
        int unwanted = annotators.indexOf(property);
        if (unwanted >= 0 && tokenize >= 0) {
            int comma;
            if (option != null) {
                properties.setProperty(option, "true");
            }
            if ((comma = annotators.indexOf(",", unwanted)) >= 0) {
                annotators = annotators.substring(0, unwanted) + annotators.substring(comma + 1);
            } else {
                comma = annotators.lastIndexOf(",");
                if (comma < 0) {
                    throw new IllegalArgumentException("Unable to process annotators " + annotators);
                }
                annotators = annotators.substring(0, comma);
            }
            if (option != null) {
                logger.debug(property + " can now be triggered as an option to tokenize rather than a separate annotator via " + option + "=true");
            } else {
                logger.debug(property + " is now included as part of the tokenize annotator by default");
            }
            logger.debug("Updating annotators from " + properties.getProperty("annotators") + " to " + annotators);
            properties.setProperty("annotators", annotators);
        }
    }

    protected AnnotatorImplementations getAnnotatorImplementations() {
        return new AnnotatorImplementations();
    }

    private static String getRequiredProperty(Properties props, String name) {
        String val = props.getProperty(name);
        if (val == null) {
            logger.error("Missing property \"" + name + "\"!");
            StanfordCoreNLP.printRequiredProperties(System.err);
            throw new RuntimeException("Missing property: \"" + name + '\"');
        }
        return val;
    }

    private static Properties loadPropertiesFromClasspath() {
        List<String> validNames = Arrays.asList("StanfordCoreNLP", "edu.stanford.nlp.pipeline.StanfordCoreNLP");
        for (String name : validNames) {
            Properties props = StanfordCoreNLP.loadProperties(name);
            if (props == null) continue;
            return props;
        }
        throw new RuntimeException("ERROR: Could not find properties file in the classpath!");
    }

    private static Properties loadPropertiesOrException(String propsFileNamePrefix) {
        Properties props = StanfordCoreNLP.loadProperties(propsFileNamePrefix);
        if (props == null) {
            throw new RuntimeIOException("ERROR: cannot find properties file \"" + propsFileNamePrefix + "\" in the classpath!");
        }
        return props;
    }

    private static Properties loadProperties(String name) {
        return StanfordCoreNLP.loadProperties(name, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String name, ClassLoader loader) {
        if (LanguageInfo.isStanfordCoreNLPSupportedLang(name)) {
            name = LanguageInfo.getLanguagePropertiesFile(name);
        }
        if (name.endsWith(PROPS_SUFFIX)) {
            name = name.substring(0, name.length() - PROPS_SUFFIX.length());
        }
        name = name.replace('.', '/');
        name = name + PROPS_SUFFIX;
        Properties result = null;
        InputStream in = loader.getResourceAsStream(name);
        try {
            if (in != null) {
                InputStreamReader reader = new InputStreamReader(in, "utf-8");
                result = new Properties();
                result.load(reader);
            }
        }
        catch (IOException e) {
            result = null;
        }
        finally {
            IOUtils.closeIgnoringExceptions(in);
        }
        if (result != null) {
            logger.info("Searching for resource: " + name + " ... found.");
        } else {
            logger.info("Searching for resource: " + name + " ... not found.");
        }
        return result;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getEncoding() {
        return this.properties.getProperty("encoding", "UTF-8");
    }

    public static String ensurePrerequisiteAnnotators(String[] annotators, Properties props) {
        int posIndex = ArrayUtils.indexOf(annotators, "pos");
        int parseIndex = ArrayUtils.indexOf(annotators, "parse");
        boolean useParseForPos = parseIndex >= 0 && posIndex < 0;
        LinkedHashSet<String> unorderedAnnotators = new LinkedHashSet<String>();
        Collections.addAll(unorderedAnnotators, annotators);
        for (String annotator : annotators) {
            if (!StanfordCoreNLP.getNamedAnnotators().containsKey(annotator.toLowerCase())) {
                throw new IllegalArgumentException("Unknown annotator: " + annotator);
            }
            unorderedAnnotators.add(annotator.toLowerCase());
            if (!Annotator.DEFAULT_REQUIREMENTS.containsKey(annotator.toLowerCase())) {
                throw new IllegalArgumentException("Cannot infer requirements for annotator: " + annotator);
            }
            LinkedList fringe = new LinkedList(Annotator.DEFAULT_REQUIREMENTS.get(annotator.toLowerCase()));
            int ticks = 0;
            while (!fringe.isEmpty()) {
                if (++ticks == 1000000) {
                    throw new IllegalStateException("[INTERNAL ERROR] Annotators have a circular dependency.");
                }
                String prereq = (String)fringe.poll();
                unorderedAnnotators.add(prereq);
                fringe.addAll(Annotator.DEFAULT_REQUIREMENTS.get(prereq.toLowerCase()));
            }
        }
        if (useParseForPos) {
            unorderedAnnotators.remove("pos");
        }
        ArrayList<String> orderedAnnotators = new ArrayList<String>();
        while (!unorderedAnnotators.isEmpty()) {
            boolean somethingAdded = false;
            Iterator iter = unorderedAnnotators.iterator();
            while (iter.hasNext()) {
                String candidate = (String)iter.next();
                boolean canAdd = true;
                for (String prereq : Annotator.DEFAULT_REQUIREMENTS.get(candidate.toLowerCase())) {
                    if (useParseForPos && "pos".equals(prereq)) {
                        prereq = "parse";
                    }
                    if (prereq.equals(candidate) || orderedAnnotators.contains(prereq)) continue;
                    canAdd = false;
                    break;
                }
                if (!canAdd) continue;
                orderedAnnotators.add(candidate);
                iter.remove();
                somethingAdded = true;
            }
            if (somethingAdded) continue;
            throw new IllegalArgumentException("Unsatisfiable annotator list: " + StringUtils.join(annotators, ","));
        }
        if (orderedAnnotators.contains("parse") && !ArrayUtils.contains(annotators, "depparse")) {
            orderedAnnotators.remove("depparse");
        }
        if ((orderedAnnotators.contains("coref.mention") || orderedAnnotators.contains("coref")) && !orderedAnnotators.contains("parse") && !props.containsKey("coref.md.type")) {
            props.setProperty("coref.md.type", "dep");
        }
        if (orderedAnnotators.contains("ner") && orderedAnnotators.contains("regexner")) {
            orderedAnnotators.remove("regexner");
            int nerIndex = orderedAnnotators.indexOf("ner");
            orderedAnnotators.add(nerIndex + 1, "regexner");
        }
        if (orderedAnnotators.contains("coref") && orderedAnnotators.contains("openie")) {
            int maxIndex = Math.max(orderedAnnotators.indexOf("openie"), orderedAnnotators.indexOf("coref"));
            if (Objects.equals(orderedAnnotators.get(maxIndex), "openie")) {
                orderedAnnotators.add(maxIndex, "coref");
                orderedAnnotators.remove("coref");
            } else {
                orderedAnnotators.add(maxIndex + 1, "openie");
                orderedAnnotators.remove("openie");
            }
        }
        return StringUtils.join(orderedAnnotators, ",");
    }

    private static boolean isXMLOutputPresent() {
        try {
            Class.forName("edu.stanford.nlp.pipeline.XMLOutputter");
        }
        catch (ClassNotFoundException | NoClassDefFoundError ex) {
            return false;
        }
        return true;
    }

    public static synchronized void clearAnnotatorPool() {
        logger.warn("Clearing CoreNLP annotation pool; this should be unnecessary in production");
        GLOBAL_ANNOTATOR_CACHE.clear();
    }

    private static Map<String, BiFunction<Properties, AnnotatorImplementations, Annotator>> getNamedAnnotators() {
        HashMap<String, BiFunction<Properties, AnnotatorImplementations, Annotator>> pool = new HashMap<String, BiFunction<Properties, AnnotatorImplementations, Annotator>>();
        pool.put("tokenize", (props, impl) -> impl.tokenizer((Properties)props));
        pool.put("cdc_tokenize", (props, impl) -> impl.cdcTokenizer((Properties)props));
        pool.put("cleanxml", (props, impl) -> impl.cleanXML((Properties)props));
        pool.put("ssplit", (props, impl) -> impl.wordToSentences((Properties)props));
        pool.put("mwt", (props, impl) -> impl.multiWordToken((Properties)props));
        pool.put("docdate", (props, impl) -> impl.docDate((Properties)props));
        pool.put("pos", (props, impl) -> impl.posTagger((Properties)props));
        pool.put("lemma", (props, impl) -> impl.morpha((Properties)props, false));
        pool.put("ner", (props, impl) -> impl.ner((Properties)props));
        pool.put("tokensregex", (props, impl) -> impl.tokensregex((Properties)props, "tokensregex"));
        pool.put("regexner", (props, impl) -> impl.tokensRegexNER((Properties)props, "regexner"));
        pool.put("entitymentions", (props, impl) -> impl.entityMentions((Properties)props, "entitymentions"));
        pool.put("gender", (props, impl) -> impl.gender((Properties)props, "gender"));
        pool.put("truecase", (props, impl) -> impl.trueCase((Properties)props));
        pool.put("parse", (props, impl) -> impl.parse((Properties)props));
        pool.put("coref.mention", (props, impl) -> impl.corefMention((Properties)props));
        pool.put("dcoref", (props, impl) -> impl.dcoref((Properties)props));
        pool.put("coref", (props, impl) -> impl.coref((Properties)props));
        pool.put("relation", (props, impl) -> impl.relations((Properties)props));
        pool.put("sentiment", (props, impl) -> impl.sentiment((Properties)props, "sentiment"));
        pool.put("cdc", (props, impl) -> impl.columnData((Properties)props));
        pool.put("depparse", (props, impl) -> impl.dependencies((Properties)props));
        pool.put("natlog", (props, impl) -> impl.natlog((Properties)props));
        pool.put("openie", (props, impl) -> impl.openie((Properties)props));
        pool.put("quote", (props, impl) -> impl.quote((Properties)props));
        pool.put("quote.attribution", (props, impl) -> impl.quoteattribution((Properties)props));
        pool.put("udfeats", (props, impl) -> impl.udfeats((Properties)props));
        pool.put("entitylink", (props, impl) -> impl.link((Properties)props));
        pool.put("kbp", (props, impl) -> impl.kbp((Properties)props));
        return pool;
    }

    public static synchronized AnnotatorPool getDefaultAnnotatorPool(Properties inputProps, AnnotatorImplementations annotatorImplementation) {
        AnnotatorPool pool = AnnotatorPool.SINGLETON;
        for (Map.Entry<String, BiFunction<Properties, AnnotatorImplementations, Annotator>> entry : StanfordCoreNLP.getNamedAnnotators().entrySet()) {
            AnnotatorSignature key = new AnnotatorSignature(entry.getKey(), PropertiesUtils.getSignature(entry.getKey(), inputProps));
            pool.register(entry.getKey(), inputProps, GLOBAL_ANNOTATOR_CACHE.computeIfAbsent(key, sig -> Lazy.cache(() -> (Annotator)((BiFunction)entry.getValue()).apply(inputProps, annotatorImplementation))));
        }
        StanfordCoreNLP.registerCustomAnnotators(pool, annotatorImplementation, inputProps);
        return pool;
    }

    private static void registerCustomAnnotators(AnnotatorPool pool, AnnotatorImplementations annotatorImplementation, Properties inputProps) {
        for (String property : inputProps.stringPropertyNames()) {
            if (!property.startsWith(CUSTOM_ANNOTATOR_PREFIX)) continue;
            String customName = property.substring(CUSTOM_ANNOTATOR_PREFIX.length());
            String customClassName = inputProps.getProperty(property);
            logger.info("Registering annotator " + customName + " with class " + customClassName);
            AnnotatorSignature key = new AnnotatorSignature(customName, PropertiesUtils.getSignature(customName, inputProps));
            pool.register(customName, inputProps, GLOBAL_ANNOTATOR_CACHE.computeIfAbsent(key, sig -> Lazy.cache(() -> annotatorImplementation.custom(inputProps, property))));
        }
    }

    private static AnnotatorPool constructAnnotatorPool(Properties inputProps, AnnotatorImplementations annotatorImplementation) {
        AnnotatorPool pool = new AnnotatorPool();
        for (Map.Entry<String, BiFunction<Properties, AnnotatorImplementations, Annotator>> entry : StanfordCoreNLP.getNamedAnnotators().entrySet()) {
            AnnotatorSignature key = new AnnotatorSignature(entry.getKey(), PropertiesUtils.getSignature(entry.getKey(), inputProps));
            pool.register(entry.getKey(), inputProps, GLOBAL_ANNOTATOR_CACHE.computeIfAbsent(key, sig -> Lazy.cache(() -> (Annotator)((BiFunction)entry.getValue()).apply(inputProps, annotatorImplementation))));
        }
        StanfordCoreNLP.registerCustomAnnotators(pool, annotatorImplementation, inputProps);
        return pool;
    }

    public static synchronized Annotator getExistingAnnotator(String name) {
        Optional<Annotator> annotator = GLOBAL_ANNOTATOR_CACHE.entrySet().stream().filter(entry -> name.equals(((AnnotatorSignature)entry.getKey()).name)).map(entry -> Optional.ofNullable(((Lazy)entry.getValue()).getIfDefined())).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (annotator.isPresent()) {
            return annotator.get();
        }
        logger.error("Attempted to fetch annotator \"" + name + "\" but the annotator pool does not store any such type!");
        return null;
    }

    public void annotate(CoreDocument document) {
        this.annotate(document.annotationDocument);
        document.wrapAnnotations();
    }

    @Override
    public void annotate(Annotation annotation) {
        super.annotate(annotation);
        List words = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
        if (words != null) {
            this.numWords += words.size();
        }
    }

    public void annotate(Annotation annotation, Consumer<Annotation> callback) {
        if (PropertiesUtils.getInt(this.properties, "threads", 1) == 1) {
            this.annotate(annotation);
            callback.accept(annotation);
        } else {
            try {
                this.availableProcessors.acquire();
            }
            catch (InterruptedException e) {
                throw new RuntimeInterruptedException(e);
            }
            new Thread(() -> {
                try {
                    this.annotate(annotation);
                }
                catch (Throwable t) {
                    annotation.set(CoreAnnotations.ExceptionAnnotation.class, t);
                }
                callback.accept(annotation);
                this.availableProcessors.release();
            }).start();
        }
    }

    public static boolean usesBinaryTrees(Properties props) {
        Set<String> annoNames = Generics.newHashSet(Arrays.asList(props.getProperty("annotators", "").split("[, \t]+")));
        return annoNames.contains("sentiment");
    }

    public Annotation process(String text) {
        Annotation annotation = new Annotation(text);
        this.annotate(annotation);
        return annotation;
    }

    public CoreDocument processToCoreDocument(String text) {
        return new CoreDocument(this.process(text));
    }

    public void prettyPrint(Annotation annotation, OutputStream os) {
        TextOutputter.prettyPrint(annotation, os, this);
    }

    public void prettyPrint(Annotation annotation, PrintWriter os) {
        TextOutputter.prettyPrint(annotation, os, this);
    }

    public void xmlPrint(Annotation annotation, Writer w) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.xmlPrint(annotation, os);
        w.write(new String(os.toByteArray(), this.getEncoding()));
        w.flush();
    }

    public void xmlPrint(Annotation annotation, OutputStream os) throws IOException {
        try {
            Class<?> clazz = Class.forName("edu.stanford.nlp.pipeline.XMLOutputter");
            Method method = clazz.getMethod("xmlPrint", Annotation.class, OutputStream.class, StanfordCoreNLP.class);
            method.invoke(null, annotation, os, this);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void jsonPrint(Annotation annotation, Writer w) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        JSONOutputter.jsonPrint(annotation, (OutputStream)os, this);
        w.write(new String(os.toByteArray(), this.getEncoding()));
        w.flush();
    }

    public void conllPrint(Annotation annotation, Writer w) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        CoNLLOutputter.conllPrint(annotation, (OutputStream)os, this);
        w.write(new String(os.toByteArray(), this.getEncoding()));
        w.flush();
    }

    protected static void printHelp(PrintStream os, String helpTopic) {
        if (helpTopic.toLowerCase().startsWith("pars")) {
            os.println("StanfordCoreNLP currently supports the following parsers:");
            os.println("\tstanford - Stanford lexicalized parser (default)");
            os.println("\tcharniak - Charniak and Johnson reranking parser (sold separately)");
            os.println();
            os.println("General options: (all parsers)");
            os.println("\tparse.type - selects the parser to use");
            os.println("\tparse.model - path to model file for parser");
            os.println("\tparse.maxlen - maximum sentence length");
            os.println();
            os.println("Stanford Parser-specific options:");
            os.println("(In general, you shouldn't need to set this flags)");
            os.println("\tparse.flags - extra flags to the parser (default: -retainTmpSubcategories)");
            os.println("\tparse.debug - set to true to make the parser slightly more verbose");
            os.println();
            os.println("Charniak and Johnson parser-specific options:");
            os.println("\tparse.executable - path to the parseIt binary or parse.sh script");
        } else if (!helpTopic.equalsIgnoreCase("true")) {
            os.println("Unknown help topic: " + helpTopic);
            os.println("See -help for a list of all help topics.");
        } else {
            StanfordCoreNLP.printRequiredProperties(os);
        }
    }

    private static void printRequiredProperties(PrintStream os) {
        os.println("The following properties can be defined:");
        os.println("(if -props or -annotators is not passed in, default properties will be loaded via the classpath)");
        os.println("\t\"props\" - path to file with configuration properties");
        os.println("\t\"annotators\" - comma separated list of annotators");
        os.println("\tThe following annotators are supported: cleanxml, tokenize, quote, ssplit, pos, lemma, ner, truecase, parse, hcoref, relation");
        os.println();
        os.println("\tIf annotator \"tokenize\" is defined:");
        os.println("\t\"tokenize.options\" - PTBTokenizer options (see edu.stanford.nlp.process.PTBTokenizer for details)");
        os.println("\t\"tokenize.whitespace\" - If true, just use whitespace tokenization");
        os.println("\t\"tokenize.codepoint\" - If true, add codepoint offsets for counting non-BMP characters");
        os.println();
        os.println("\tIf annotator \"cleanxml\" is defined:");
        os.println("\t\"clean.xmltags\" - regex of tags to extract text from");
        os.println("\t\"clean.sentenceendingtags\" - regex of tags which mark sentence endings");
        os.println("\t\"clean.allowflawedxml\" - if set to true, don't complain about XML errors");
        os.println();
        os.println("\tIf annotator \"pos\" is defined:");
        os.println("\t\"pos.maxlen\" - maximum length of sentence to POS tag");
        os.println("\t\"pos.model\" - path towards the POS tagger model");
        os.println();
        os.println("\tIf annotator \"ner\" is defined:");
        os.println("\t\"ner.model\" - paths for the ner models.  By default, the English 3 class, 7 class, and 4 class models are used.");
        os.println("\t\"ner.useSUTime\" - Whether or not to use sutime (English specific)");
        os.println("\t\"ner.applyNumericClassifiers\" - whether or not to use any numeric classifiers (English specific)");
        os.println("\t\"ner.applyFineGrained\" - whether or not to apply fine grained regex NER annotation (English specific)");
        os.println("\t\"ner.additional.tokensregex.rules\" - additional tokensregex rules to use for NER recognition");
        os.println("\t\"ner.additional.regexner.mapping\" - additional regex rules to use for NER recognition");
        os.println();
        os.println("\tIf annotator \"truecase\" is defined:");
        os.println("\t\"truecase.model\" - path towards the true-casing model; default: edu/stanford/nlp/models/truecase/truecasing.fast.caseless.qn.ser.gz");
        os.println("\t\"truecase.bias\" - class bias of the true case model; default: INIT_UPPER:-0.7,UPPER:-0.7,O:0");
        os.println("\t\"truecase.mixedcasefile\" - path towards the mixed case file; default: edu/stanford/nlp/models/truecase/MixDisambiguation.list");
        os.println();
        os.println("\tIf annotator \"relation\" is defined:");
        os.println("\t\"sup.relation.verbose\" - whether verbose or not");
        os.println("\t\"sup.relation.model\" - path towards the relation extraction model");
        os.println();
        os.println("\tIf annotator \"parse\" is defined:");
        os.println("\t\"parse.model\" - path towards the PCFG parser model");
        os.println();
        os.println("Command line properties:");
        os.println("\t\"file\" - run the pipeline on the content of this file, or on the content of the files in this directory");
        os.println("\t         XML output is generated for every input file \"file\" as file.xml");
        os.println("\t\"extension\" - if -file used with a directory, process only the files with this extension");
        os.println("\t\"fileList\" - run the pipeline on the list of files given in this file");
        os.println("\t             output is generated for every input file as file.outputExtension");
        os.println("\t\"outputDirectory\" - where to put output (defaults to the current directory)");
        os.println("\t\"outputExtension\" - extension to use for the output file (defaults to \".xml\" for XML, \".ser.gz\" for serialized).  Don't forget the dot!");
        os.println("\t\"outputFormat\" - \"text\"  (default), \"tagged\", \"json\", \"conll\", \"conllu\", \"serialized\", \"xml\" or \"custom\"");
        os.println("\t\"customOutputter\" - specify a class to a custom outputter instead of a pre-defined output format");
        os.println("\t\"serializer\" - Class of annotation serializer to use when outputFormat is \"serialized\".  By default, uses ProtobufAnnotationSerializer.");
        os.println("\t\"replaceExtension\" - flag to chop off the last extension before adding outputExtension to file");
        os.println("\t\"noClobber\" - don't automatically override (clobber) output files that already exist");
        os.println("\t\"isOneDocument\" - (for piped input only) treat the text till eof as one document rather than one document per line");
        os.println("\t\"threads\" - multithread on this number of threads");
        os.println();
        os.println("If none of the above are present, run the pipeline in an interactive shell (default properties will be loaded from the classpath).");
        os.println("The shell accepts input from stdin and displays the output at stdout.");
        os.println();
        os.println("Run with -help [topic] for more help on a specific topic.");
        os.println("Current topics include: parser");
        os.println();
    }

    @Override
    public String timingInformation() {
        StringBuilder sb = new StringBuilder(super.timingInformation());
        if (this.numWords >= 0) {
            long total = this.getTotalTime();
            sb.append(" for ").append(this.numWords).append(" tokens at ");
            sb.append(String.format("%.1f", (double)this.numWords / ((double)total / 1000.0)));
            sb.append(" tokens/sec.");
        }
        return sb.toString();
    }

    private void shell() throws IOException {
        AnnotationOutputter.Options options = AnnotationOutputter.getOptions(this.properties);
        String encoding = this.getEncoding();
        BufferedReader r = new BufferedReader(IOUtils.encodedInputStreamReader(System.in, encoding));
        boolean isTty = System.console() != null;
        boolean oneDocument = Boolean.parseBoolean(this.properties.getProperty("isOneDocument"));
        if (isTty) {
            System.err.println("Entering interactive shell. Type q RETURN or EOF to quit.");
        }
        do {
            String line;
            if (isTty) {
                System.err.print("NLP> ");
            }
            if ((line = oneDocument ? IOUtils.slurpReader(r) : r.readLine()) == null || isTty && line.equalsIgnoreCase("q")) break;
            if (line.isEmpty()) continue;
            Annotation anno = this.process(line);
            StanfordCoreNLP.outputAnnotation(System.out, anno, this.properties, options);
        } while (!oneDocument);
    }

    protected static Collection<File> readFileList(String fileName) {
        return ObjectBank.getLineIterator(fileName, new ObjectBank.PathToFileFunction());
    }

    private static AnnotationSerializer loadSerializer(String serializerClass, String name, Properties properties) {
        AnnotationSerializer serializer;
        try {
            serializer = (AnnotationSerializer)ReflectionLoading.loadByReflection(serializerClass, name, properties);
        }
        catch (ReflectionLoading.ReflectionLoadingException ex) {
            serializer = (AnnotationSerializer)ReflectionLoading.loadByReflection(serializerClass, new Object[0]);
        }
        return serializer;
    }

    public static BiConsumer<Annotation, OutputStream> createOutputter(Properties properties, AnnotationOutputter.Options options) {
        return (annotation, fos) -> {
            try {
                StanfordCoreNLP.outputAnnotation(fos, annotation, properties, options);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        };
    }

    private static void outputAnnotation(OutputStream fos, Annotation annotation, Properties properties, AnnotationOutputter.Options outputOptions) throws IOException {
        OutputFormat outputFormat = OutputFormat.valueOf(properties.getProperty("outputFormat", DEFAULT_OUTPUT_FORMAT).toUpperCase(Locale.ROOT));
        switch (outputFormat) {
            case XML: {
                AnnotationOutputter outputter = (AnnotationOutputter)MetaClass.create("edu.stanford.nlp.pipeline.XMLOutputter").createInstance(new Object[0]);
                outputter.print(annotation, fos, outputOptions);
                break;
            }
            case JSON: {
                new JSONOutputter().print(annotation, fos, outputOptions);
                break;
            }
            case CONLL: {
                new CoNLLOutputter().print(annotation, fos, outputOptions);
                break;
            }
            case TEXT: {
                new TextOutputter().print(annotation, fos, outputOptions);
                break;
            }
            case TAGGED: {
                new TaggedTextOutputter().print(annotation, fos, outputOptions);
                break;
            }
            case SERIALIZED: {
                String outputSerializerName;
                String serializerClass = properties.getProperty("serializer", ProtobufAnnotationSerializer.class.getName());
                String outputSerializerClass = properties.getProperty("outputSerializer", serializerClass);
                String string = outputSerializerName = serializerClass.equals(outputSerializerClass) ? "serializer" : "outputSerializer";
                if (outputSerializerClass == null) break;
                AnnotationSerializer outputSerializer = StanfordCoreNLP.loadSerializer(outputSerializerClass, outputSerializerName, properties);
                outputSerializer.write(annotation, fos);
                break;
            }
            case CONLLU: {
                new CoNLLUOutputter(properties).print(annotation, fos, outputOptions);
                break;
            }
            case INLINEXML: {
                new InlineXMLOutputter().print(annotation, fos, outputOptions);
                break;
            }
            case CUSTOM: {
                AnnotationOutputter customOutputter = (AnnotationOutputter)ReflectionLoading.loadByReflection(properties.getProperty("customOutputter"), new Object[0]);
                customOutputter.print(annotation, fos, outputOptions);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown output format " + (Object)((Object)outputFormat));
            }
        }
    }

    private static void logTimingInfo(StanfordCoreNLP pipeline, Timing tim) {
        logger.info("");
        logger.info(pipeline.timingInformation());
        logger.info("Pipeline setup: " + Timing.toSecondsString(pipeline.pipelineSetupTime) + " sec.");
        logger.info("Total time for StanfordCoreNLP pipeline: " + Timing.toSecondsString(pipeline.pipelineSetupTime + tim.report()) + " sec.");
    }

    public void processFiles(String base, Collection<File> files, int numThreads, boolean clearPool, Optional<Timing> tim) throws IOException {
        AnnotationOutputter.Options options = AnnotationOutputter.getOptions(this.properties);
        OutputFormat outputFormat = OutputFormat.valueOf(this.properties.getProperty("outputFormat", DEFAULT_OUTPUT_FORMAT).toUpperCase(Locale.ROOT));
        StanfordCoreNLP.processFiles(base, files, numThreads, this.properties, this::annotate, StanfordCoreNLP.createOutputter(this.properties, options), outputFormat, clearPool, Optional.of(this), tim);
    }

    protected static void processFiles(String base, Collection<File> files, int numThreads, Properties properties, BiConsumer<Annotation, Consumer<Annotation>> annotate, BiConsumer<Annotation, OutputStream> print, OutputFormat outputFormat, boolean clearPool) throws IOException {
        StanfordCoreNLP.processFiles(base, files, numThreads, properties, annotate, print, outputFormat, clearPool, Optional.empty(), Optional.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void processFiles(String base, Collection<File> files, int numThreads, Properties properties, BiConsumer<Annotation, Consumer<Annotation>> annotate, BiConsumer<Annotation, OutputStream> print, OutputFormat outputFormat, boolean clearPool, Optional<StanfordCoreNLP> pipeline, Optional<Timing> tim) throws IOException {
        String inputSerializerClass;
        String serializerClass;
        String baseOutputDir = properties.getProperty("outputDirectory", ".");
        String baseInputDir = properties.getProperty("inputDirectory", base);
        String excludeFilesParam = properties.getProperty("excludeFiles");
        HashSet<String> excludeFiles = new HashSet<String>();
        if (excludeFilesParam != null) {
            Iterable<String> lines = IOUtils.readLines(excludeFilesParam);
            for (String line : lines) {
                String name = line.trim();
                if (name.isEmpty()) continue;
                excludeFiles.add(name);
            }
        }
        String inputSerializerName = (serializerClass = properties.getProperty("serializer", GenericAnnotationSerializer.class.getName())).equals(inputSerializerClass = properties.getProperty("inputSerializer", serializerClass)) ? "serializer" : "inputSerializer";
        String extension = properties.getProperty("outputExtension", StanfordCoreNLP.getDefaultExtension(outputFormat));
        boolean replaceExtension = Boolean.parseBoolean(properties.getProperty("replaceExtension", "false"));
        boolean continueOnAnnotateError = Boolean.parseBoolean(properties.getProperty("continueOnAnnotateError", "false"));
        boolean noClobber = Boolean.parseBoolean(properties.getProperty("noClobber", "false"));
        MutableInteger totalProcessed = new MutableInteger(0);
        MutableInteger totalSkipped = new MutableInteger(0);
        MutableInteger totalErrorAnnotating = new MutableInteger(0);
        for (File file : files) {
            int lastDot;
            if (excludeFiles.contains(file.getName())) {
                logger.err("Skipping excluded file " + file.getName());
                totalSkipped.incValue(1);
                continue;
            }
            String outputDir = baseOutputDir;
            if (baseInputDir != null) {
                String relDir = file.getParent().replaceFirst(Pattern.quote(baseInputDir), "");
                outputDir = outputDir + File.separator + relDir;
            }
            new File(outputDir).mkdirs();
            String outputFilename = new File(outputDir, file.getName()).getPath();
            if (replaceExtension && (lastDot = outputFilename.lastIndexOf(46)) > 0) {
                outputFilename = outputFilename.substring(0, lastDot);
            }
            if (!outputFilename.endsWith(extension)) {
                outputFilename = outputFilename + extension;
            }
            if ((outputFilename = new File(outputFilename).getCanonicalPath()).equals(file.getCanonicalPath())) {
                logger.err("Skipping " + file.getName() + ": output file " + outputFilename + " has the same filename as the input file -- assuming you don't actually want to do this.");
                totalSkipped.incValue(1);
                continue;
            }
            if (noClobber && new File(outputFilename).exists()) {
                logger.err("Skipping " + file.getName() + ": output file " + outputFilename + " as it already exists.  Don't use the noClobber option to override this.");
                totalSkipped.incValue(1);
                continue;
            }
            String finalOutputFilename = outputFilename;
            try {
                if (noClobber && new File(finalOutputFilename).exists()) {
                    logger.err("Skipping " + file.getName() + ": output file " + finalOutputFilename + " as it already exists.  Don't use the noClobber option to override this.");
                    MutableInteger mutableInteger = totalSkipped;
                    synchronized (mutableInteger) {
                        totalSkipped.incValue(1);
                    }
                    return;
                }
                logger.info("Processing file " + file.getAbsolutePath() + " ... writing to " + finalOutputFilename);
                Annotation annotation = null;
                if (file.getAbsolutePath().endsWith(".ser.gz")) {
                    try {
                        if (inputSerializerClass != null) {
                            AnnotationSerializer inputSerializer = StanfordCoreNLP.loadSerializer(inputSerializerClass, inputSerializerName, properties);
                            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                            Pair<Annotation, InputStream> pair = inputSerializer.read(is);
                            ((InputStream)pair.second).close();
                            annotation = (Annotation)pair.first;
                            IOUtils.closeIgnoringExceptions(is);
                        } else {
                            annotation = (Annotation)IOUtils.readObjectFromFile(file);
                        }
                    }
                    catch (IOException inputSerializer) {
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (annotation == null) {
                    String encoding = properties.getProperty("encoding", "UTF-8");
                    String text = IOUtils.slurpFile(file.getAbsoluteFile(), encoding);
                    annotation = new Annotation(text);
                    annotation.set(CoreAnnotations.DocIDAnnotation.class, file.getName());
                }
                Timing timing = new Timing();
                annotate.accept(annotation, finishedAnnotation -> {
                    timing.done(logger, "Annotating file " + file.getAbsoluteFile());
                    Throwable ex = (Throwable)finishedAnnotation.get(CoreAnnotations.ExceptionAnnotation.class);
                    if (ex == null) {
                        try {
                            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(finalOutputFilename));
                            print.accept((Annotation)finishedAnnotation, fos);
                            ((OutputStream)fos).close();
                        }
                        catch (IOException e) {
                            throw new RuntimeIOException(e);
                        }
                        MutableInteger mutableInteger = totalProcessed;
                        synchronized (mutableInteger) {
                            totalProcessed.incValue(1);
                            if (totalProcessed.intValue() % 1000 == 0) {
                                logger.info("Processed " + totalProcessed + " documents");
                            }
                            if (totalProcessed.intValue() + totalErrorAnnotating.intValue() == files.size()) {
                                if (clearPool) {
                                    GLOBAL_ANNOTATOR_CACHE.clear();
                                }
                                if (pipeline.isPresent() && tim.isPresent()) {
                                    StanfordCoreNLP.logTimingInfo((StanfordCoreNLP)pipeline.get(), (Timing)tim.get());
                                }
                            }
                        }
                    }
                    if (continueOnAnnotateError) {
                        logger.err("Error annotating " + file.getAbsoluteFile() + ": " + ex);
                        MutableInteger mutableInteger = totalErrorAnnotating;
                        synchronized (mutableInteger) {
                            totalErrorAnnotating.incValue(1);
                            if (totalProcessed.intValue() + totalErrorAnnotating.intValue() == files.size()) {
                                if (clearPool) {
                                    GLOBAL_ANNOTATOR_CACHE.clear();
                                }
                                if (pipeline.isPresent() && tim.isPresent()) {
                                    StanfordCoreNLP.logTimingInfo((StanfordCoreNLP)pipeline.get(), (Timing)tim.get());
                                }
                            }
                        }
                    } else {
                        if (clearPool) {
                            GLOBAL_ANNOTATOR_CACHE.clear();
                        }
                        throw new RuntimeException("Error annotating " + file.getAbsoluteFile(), ex);
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
    }

    public void processFiles(Collection<File> files, int numThreads, boolean clearPool, Optional<Timing> tim) throws IOException {
        this.processFiles(null, files, numThreads, clearPool, tim);
    }

    public void processFiles(Collection<File> files, boolean clearPool, Optional<Timing> tim) throws IOException {
        this.processFiles(files, 1, clearPool, tim);
    }

    public void run() throws IOException {
        this.run(false);
    }

    public void run(boolean clearPool) throws IOException {
        Timing tim = new Timing();
        StanfordRedwoodConfiguration.minimalSetup();
        String numThreadsString = this.properties.getProperty("threads");
        int numThreads = 1;
        try {
            if (numThreadsString != null) {
                numThreads = Integer.parseInt(numThreadsString);
            }
        }
        catch (NumberFormatException e) {
            logger.err("-threads [number]: was not given a valid number: " + numThreadsString);
        }
        logger.info("");
        if (this.properties.containsKey("file") || this.properties.containsKey("textFile")) {
            String fileName = this.properties.getProperty("file");
            if (fileName == null) {
                fileName = this.properties.getProperty("textFile");
            }
            FileSequentialCollection files = new FileSequentialCollection(new File(fileName), this.properties.getProperty("extension"), true);
            this.processFiles(null, files, numThreads, clearPool, Optional.of(tim));
        } else if (this.properties.containsKey("filelist")) {
            String fileName = this.properties.getProperty("filelist");
            Collection<File> inputFiles = StanfordCoreNLP.readFileList(fileName);
            ArrayList<File> files = new ArrayList<File>(inputFiles.size());
            for (File file : inputFiles) {
                if (file.isDirectory()) {
                    files.addAll(new FileSequentialCollection(new File(fileName), this.properties.getProperty("extension"), true));
                    continue;
                }
                files.add(file);
            }
            this.processFiles(null, files, numThreads, clearPool, Optional.of(tim));
        } else {
            this.shell();
        }
        if (clearPool && numThreads == 1) {
            this.pool.clear();
        }
    }

    public static void main(String[] args) throws IOException {
        String helpValue;
        Properties props = new Properties();
        if (args.length > 0 && (helpValue = (props = StringUtils.argsToProperties(args)).getProperty("h", props.getProperty("help"))) != null) {
            StanfordCoreNLP.printHelp(System.err, helpValue);
            return;
        }
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        if (PropertiesUtils.getBool(props, "memoryUsage", false)) {
            System.gc();
            System.gc();
            logger.info("Finished loading pipeline.  Current memory usage: " + SystemUtils.getMemoryInUse() + "mb");
        }
        pipeline.run(true);
    }

    public static class AnnotatorSignature {
        public final String name;
        public final String signature;

        public AnnotatorSignature(String name, String signature) {
            this.name = name;
            this.signature = signature;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotatorSignature that = (AnnotatorSignature)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.signature, that.signature);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.signature);
        }

        public String toString() {
            return "AnnotatorSignature{name='" + this.name + "', signature='" + this.signature + "'}";
        }
    }

    public static enum OutputFormat {
        TEXT,
        TAGGED,
        XML,
        JSON,
        CONLL,
        CONLLU,
        INLINEXML,
        SERIALIZED,
        CUSTOM;

    }
}

