/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.process.stattok.StatTokSent;
import edu.stanford.nlp.util.ArrayCoreMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class StatTokSentAnnotator
implements Annotator {
    StatTokSent statTokSent;

    public StatTokSentAnnotator(Properties props) {
        this("cdc_tokenize", props);
    }

    public StatTokSentAnnotator(String name, Properties props) {
        String modelFile = props.getProperty(name + ".model", null);
        String multiWordRulesFile = props.getProperty(name + ".multiWordRules", null);
        if (modelFile == null) {
            throw new IllegalArgumentException("Tokenization model was not specified in " + props);
        }
        this.statTokSent = multiWordRulesFile != null ? new StatTokSent(modelFile, multiWordRulesFile) : new StatTokSent(modelFile);
    }

    private static void setNewlineStatus(List<CoreLabel> tokensList) {
        for (CoreLabel token : tokensList) {
            if (token.word().equals("*NL*") && token.endPosition() - token.beginPosition() == 1) {
                token.set(CoreAnnotations.IsNewlineAnnotation.class, true);
                continue;
            }
            token.set(CoreAnnotations.IsNewlineAnnotation.class, false);
        }
    }

    @Override
    public void annotate(Annotation annotation) {
        String text = (String)annotation.get(CoreAnnotations.TextAnnotation.class);
        ArrayList chars = new ArrayList();
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(text.split("\n")));
        lines.replaceAll(line -> line.trim());
        lines.removeAll(Arrays.asList("", null));
        String textPreproc = String.join((CharSequence)"\n", lines);
        String multipleLineBreaks = "(?:\\r\\n\\r\\n|\\r\\r|\\n\\n)[\\r\\n]*";
        String lineBreak = "[\\r|\\n]+";
        String oneOrMoreSpace = "[ ]+";
        textPreproc = textPreproc.replaceAll(multipleLineBreaks, "\u00a7");
        textPreproc = textPreproc.replaceAll(lineBreak, " ");
        textPreproc = textPreproc.replaceAll(oneOrMoreSpace, " ");
        if (textPreproc.substring(0, 1).equals("\u00a7")) {
            textPreproc = textPreproc.substring(1);
        }
        List<List<CoreLabel>> sTokens = this.statTokSent.tokenize(textPreproc);
        ArrayList<ArrayCoreMap> sentences = new ArrayList<ArrayCoreMap>();
        ArrayList<CoreLabel> tokens = new ArrayList<CoreLabel>();
        int sIndex = 0;
        for (List<CoreLabel> sentence : sTokens) {
            int tokenIndex = 1;
            if (sentence.size() == 0) continue;
            ArrayCoreMap sent = new ArrayCoreMap(1);
            int begin = sentence.get(0).beginPosition();
            int end = sentence.get(sentence.size() - 1).endPosition();
            sent.set(CoreAnnotations.TokensAnnotation.class, sentence);
            sent.set(CoreAnnotations.SentenceIndexAnnotation.class, sIndex++);
            sent.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, begin);
            sent.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, end);
            sent.set(CoreAnnotations.TokenBeginAnnotation.class, tokenIndex);
            sent.set(CoreAnnotations.TokenEndAnnotation.class, tokenIndex += sentence.size());
            sent.set(CoreAnnotations.TextAnnotation.class, text.substring(begin, end + 1));
            sentences.add(sent);
            tokens.addAll(sentence);
        }
        annotation.set(CoreAnnotations.TokensAnnotation.class, tokens);
        annotation.set(CoreAnnotations.SentencesAnnotation.class, sentences);
        StatTokSentAnnotator.setNewlineStatus(tokens);
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.emptySet();
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return new HashSet<Class<? extends CoreAnnotation>>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.BeforeAnnotation.class, CoreAnnotations.AfterAnnotation.class, CoreAnnotations.TokenBeginAnnotation.class, CoreAnnotations.TokenEndAnnotation.class, CoreAnnotations.PositionAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.OriginalTextAnnotation.class, CoreAnnotations.ValueAnnotation.class, CoreAnnotations.SentenceIndexAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.IsNewlineAnnotation.class));
    }
}

